<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Data_komponen_m extends CI_Model
{
    protected $master     = "payroll_komponen_m";
    protected $gapok      = "payroll_gapok_m";
    protected $pendapatan = "payroll_tunj_kehadiran_m";
    protected $karyawan   = "data_karyawan";
    protected $jabatan    = "master_jabatan";

    function get_datatables($id_karyawan, $id_cabang, $id_departemen)
    {
        $this->_get_datatables_query($id_karyawan, $id_cabang, $id_departemen);
        if ($_GET['length'] != -1) {
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered($id_karyawan, $id_cabang, $id_departemen)
    {
        $this->_get_datatables_query($id_karyawan, $id_cabang, $id_departemen);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all($id_karyawan, $id_cabang, $id_departemen)
    {
        $this->_get_datatables_query($id_karyawan, $id_cabang, $id_departemen);
        return $this->db->count_all_results();
    }

    private function _get_datatables_query($id_karyawan = 'all', $id_cabang = 'all', $id_departemen = 'all')
    {
        if ($id_karyawan != 'all') {
            $this->db->where('md5(dk.id_karyawan)', $id_karyawan);
        } else {
            if ($id_cabang != 'all') {
                $this->db->where('dk.id_cabang', $id_cabang);
            }

            if ($id_departemen != 'all') {
                $this->db->where('dk.id_departemen', $id_departemen);
            }
        }

        $this->db->select('
            dk.id_karyawan,
            dk.nama_lengkap,
            dk.nik,
            master_cabang.id_cabang,
            master_cabang.kode as kode_cabang,
            master_cabang.nama as nama_cabang,
            master_departemen.kode as kode_departemen,
            master_departemen.nama as nama_departemen,
            master_jabatan.kode_jabatan,
            master_jabatan.nama as nama_jabatan,
            IF(pg.nominal, pg.nominal, 0) as nominal
        ')
            ->from($this->karyawan . ' AS dk')
            ->join("master_cabang", "master_cabang.id_cabang = dk.id_cabang")
            ->join("master_departemen", "master_departemen.id_departemen = dk.id_departemen", "LEFT")
            ->join("master_jabatan", "master_jabatan.id_jabatan = dk.id_jabatan")
            ->join($this->gapok . ' AS pg', 'pg.id_karyawan = dk.id_karyawan', 'left')
            ->where('dk.id_company', $this->id_company)
            ->where_in('dk.status', ['1', '2', '3', '4'])
            ->where_not_in("master_jabatan.level_user", ["1", "6"]);

        $column_search = array('');
        $i = 0;

        foreach ($column_search as $item) {  // looping awal
            if ($_GET['search']['value']) { // jika datatable mengirimkan pencarian dengan metode POST

                if ($i === 0) { // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                } else {
                    $this->db->or_like($item, $_GET['search']['value']);
                }

                if (count($column_search) - 1 == $i) {
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array('');

        if (isset($_GET['order'])) {
            $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        } else {
            $this->db->order_by("dk.nama_lengkap ASC", "dk.nik ASC");
        }
    }

    public function master_komponen()
    {
        $select = $this->db->select('
            jenis_master,
            nm_komponen,
            flag_persentase_gapok,
            gapok_persen
        ')
            ->from($this->master)
            ->where('jenis_komponen', 'tetap')
            ->where('jenis_master', 'kehadiran')
            ->where('id_company', $this->id_company)
            ->order_by('no_urut', 'ASC')
            ->get()
            ->result();

        $data = [];
        foreach ($select as $key) {
            $data[$key->jenis_master][] = [
                'jenis_master'          => $key->jenis_master,
                'nm_komponen'           => $key->nm_komponen,
                'flag_persentase_gapok' => $key->flag_persentase_gapok,
                'gapok_persen'          => $key->gapok_persen
            ];
        }
        return json_encode($data);
    }

    public function tambah_pendapatan()
    {
        $select = $this->db->select('
            pend.id_karyawan,
            pend.id_item,
            pend.nm_tunjangan,
            pend.flag_persentase_gapok,
            pend.gapok_persen,
            pend.gapok_rp,
            pend.nominal_tunjangan,
            pend.flag_bpjs,
            pend.flag_pph21,
            pend.flag_pot_absensi,
            pend.flag_cuti,
            pend.flag_izin,
            pend.flag_sakit
        ')
            ->from($this->pendapatan . ' as pend')
            ->join($this->master . ' as master', 'master.id_item = pend.id_item')
            ->where('master.jenis_master', 'kehadiran')
            ->where('pend.id_company', $this->id_company)
            ->order_by('master.no_urut', 'ASC')
            ->get()
            ->result();

        $data = [];
        foreach ($select as $key) {
            $data[$key->id_karyawan][] = [
                'id_item'               => $key->id_item,
                'nm_tunjangan'          => $key->nm_tunjangan,
                'flag_persentase_gapok' => $key->flag_persentase_gapok,
                'gapok_persen'          => $key->gapok_persen,
                'nominal_tunjangan'     => $key->nominal_tunjangan
            ];
        }
        return json_encode($data);
    }

    public function update($data, $id_item)
    {
        $this->db->trans_start();

        $this->db->where('md5(concat(id_karyawan,id_item,id_company))', $id_item);
        $this->db->update($this->pendapatan, $data);
        $this->logger->create_log('payroll_data_komponen_tetap', 'edit', $this->db->last_query());

        $this->db->trans_complete();

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            return __response_update(false);
        } else {
            $this->db->trans_commit();
            $message = ["message" => '<font color="#009900"><i class="fa fa-check-square">&nbsp;</i>Data berhasil disimpan</font>'];
            return __response_update(true, $message);
        }
    }
}
