<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Pph21_uu24_m extends CI_Model
{
    /**
     * Perhitungan pph21 uu24 aturan terbaru yang berlaku per januari 2024
     *
     * @param object $row => data karyawan
     * @param string $periode => format YYYY-MM
     * @param array $nominal => meliputi gapok, tunj_lain, dan iuran_pensiun
     * @param object $pengaturan_pph => data pengaturan umum pph21
     * @param object $objek_pajak => data pph21 objek pajak
     *
     * @return array
     */
    public function get_pph21($row, $periode, $nominal, $pengaturan_pph, $objek_pajak): array
    {
        $gaji_bruto = $nominal['gapok'] + $nominal['tunj_lain'] + $nominal["premi_asuransi"];
        $kd_ptkp    = $row->tanggungan ?: 'TK/0';
        $pph21      = 0;
        if (!empty($row->npwp)) {
            $penerima_penghasilan = 'NPWP';
        } else if (!empty($row->no_ktp)) {
            $penerima_penghasilan = 'NPWP';
        } else {
            $penerima_penghasilan = 'NIK';
        }

        // get data objek pajak
        $data_objek_pajak = '';
        foreach ($objek_pajak as $value) {
            if ($row->status == $value->status_karyawan) {
                $data_objek_pajak = $value->kode;
                break;
            }
        }

        // get data nominal ptkp
        $data_nominal_ptkp = $this->db->get_where('ptkp', ['kode' => $kd_ptkp])->row()->nominal;

        // pengurangan
        $max_biaya_jabatan = 500000;
        $biaya_jabatan     = min(floor($gaji_bruto * 0.05), $max_biaya_jabatan);

        // setiap masa, kecuali masa pajak terakhir (bulan 1 - 11)
        if (substr($periode, -2) < 12) {
            $data_tarif = [];
            // get data TER berdasarkan PTKP
            $getTER = $this->db->select('ter_jenis, min, max, ter_persen')
                ->where('find_in_set("' . $kd_ptkp . '", ptkp)')
                ->order_by('min', 'ASC')
                ->get('payroll_pph21_tarif')
                ->result();
            // pph21
            foreach ($getTER as $tarif) {
                if ($gaji_bruto >= $tarif->min && ($gaji_bruto <= $tarif->max || $tarif->max == 0)) {
                    $pph21 = $gaji_bruto * $tarif->ter_persen / 100;
                    $data_tarif = $tarif;
                    break;
                }
            }
        } else {
            // masa pajak terakhir (bulan 12)
            // get data payroll karyawan sesuai periode saat ini
            $data_payroll = $this->db->select('
                    periode,
                    gaji_bruto,
                    biaya_jabatan,
                    pph21
                ')
                ->from('payroll_pph21_trx_uu24')
                ->where('id_company', $row->id_company)
                ->where('id_karyawan', $row->id_karyawan)
                ->where_not_in('periode', $periode)
                ->where('LEFT(periode, 4) = ' . substr($periode, 0, 4))
                ->get()
                ->result();
            $data_iuran_pensiun = $this->db->select('SUM(IF(pot_jht_kry_rp IS NOT NULL, pot_jht_kry_rp, 0)) + SUM(IF(pot_jp_kry_rp IS NOT NULL, pot_jp_kry_rp, 0)) as iuran_pensiun')
                ->from('payroll_bpjs_tk_trx')
                ->where('id_company', $row->id_company)
                ->where('id_karyawan', $row->id_karyawan)
                ->where_not_in('periode', $periode)
                ->where('LEFT(periode, 4) = ' . substr($periode, 0, 4))
                ->get()
                ->row()
                ->iuran_pensiun;

            // penghasilan bruto setahun
            $gaji_bruto_setahun = $gaji_bruto + array_sum(array_column((array)$data_payroll, 'gaji_bruto'));

            // pengurangan
            $biaya_jabatan_setahun = $biaya_jabatan + array_sum(array_column((array)$data_payroll, 'biaya_jabatan'));
            $iuran_pensiun         = ($nominal['iuran_pensiun'] + ($data_iuran_pensiun ?: 0));

            $ph_neto_setahun = $gaji_bruto_setahun - $biaya_jabatan_setahun - $iuran_pensiun;
            $pkp_setahun     = $this->pkp_setahun($ph_neto_setahun, $data_nominal_ptkp);

            // pajak penghasilan Pasal 21 terutang setahun
            $pkp_terutang_setahun = array_sum(array_column($this->pkp_terutang_setahun($pkp_setahun), 'result'));

            // pajak penghasilan Pasal 21 yang telah dipotong sampai bulan november
            $pph21_sebelumnya = array_sum(array_column((array)$data_payroll, 'pph21'));

            // pph21 yang harus dipotong
            $pph21 = $pkp_terutang_setahun - $pph21_sebelumnya;
        }

        $data = [
            'id_karyawan'           => $row->id_karyawan,
            'nik'                   => $row->nik,
            'nm_karyawan'           => $row->nm_karyawan,
            'no_ktp'                => $row->no_ktp ?: '',
            'alamat_ktp'            => $row->alamat_ktp ?: '',
            'npwp'                  => $row->npwp ?: '',
            'id_jabatan'            => $row->id_jabatan,
            'kd_jabatan'            => $row->kd_jabatan,
            'nm_jabatan'            => $row->nm_jabatan,
            'id_cabang'             => $row->id_cabang,
            'kd_cabang'             => $row->kd_cabang,
            'nm_cabang'             => $row->nm_cabang,
            'id_departemen'         => $row->id_departemen ?: '',
            'kd_departemen'         => $row->kd_departemen ?: '',
            'nm_departemen'         => $row->nm_departemen ?: '',
            'periode'               => $periode,
            'gapok'                 => $nominal['gapok'],
            'ttl_tunjangan'         => $nominal['tunj_lain'],
            'gaji_bruto'            => $gaji_bruto,
            'gaji_bruto_setahun'    => $gaji_bruto_setahun ?: 0,
            'biaya_jabatan'         => $biaya_jabatan ?: 0,
            'biaya_jabatan_setahun' => $biaya_jabatan_setahun ?: 0,
            'iuran_pensiun'         => $iuran_pensiun ?: 0,
            'ptkp'                  => $data_nominal_ptkp ?: 0,
            'penerima_penghasilan'  => $penerima_penghasilan,
            'kd_objek_pajak'        => $data_objek_pajak,
            'penandatangan_jenis'   => $pengaturan_pph->jenis_pemotong,
            'penandatangan_npwp'    => $pengaturan_pph->npwp,
            'penandatangan_nik'     => $pengaturan_pph->no_ktp,
            'kd_ptkp'               => $kd_ptkp,
            'pegawai_harian'        => 'TIDAK',
            'gross_up'              => ($pengaturan_pph->jenis == 'gross') ? 'YA' : 'TIDAK',
            'fasilitas'             => 'N',
            'no_skb_dtp'            => '',
            'ter_jenis'             => $data_tarif->ter_jenis ?: '',
            'ter_persen'            => $data_tarif->ter_persen ?: 0,
            'min_bruto'             => $data_tarif->min ?: 0,
            'max_bruto'             => $data_tarif->max ?: 0,
            'pph21_setahun'         => $pkp_terutang_setahun ?: 0,
            'pph21_terpotong'       => $pph21_sebelumnya ?: 0,
            'pph21'                 => $pph21,
            'id_company'            => $this->id_company,
            'user_input'            => $this->nik_karyawan . '-' . $this->nm_karyawan
        ];

        return $data;
    }

    public function get_pengaturan_pph()
    {
        $this->db->where('id_company', $this->id_company);
        return $this->db->get('payroll_pph21_p')->row();
    }

    public function get_objek_pajak()
    {
        return $this->db->select('kode, nama, kap, kjs, keterangan, status_karyawan')->get('payroll_pph21_objek_pajak')->result();
    }

    public function delete_pph($periode, $id_cabang, $id_departemen, $id_karyawan)
    {
        if ($id_cabang != "all") {
            $this->db->where("id_cabang", $id_cabang);
        }
        if ($id_departemen != "all") {
            $this->db->where("id_departemen", $id_departemen);
        }
        if ($id_karyawan != "all") {
            $this->db->where("md5(id_karyawan)", $id_karyawan);
        }
        $this->db->where('id_company', $this->id_company);
        $this->db->where('periode', $periode);
        $this->db->delete('payroll_pph21_trx_uu24');
    }

    public function update_gaji($data)
    {
        $this->db->update_batch('payroll_gaji_trx', $data, 'concat(id_company,id_karyawan,periode)');
    }

    public function pkp_setahun($jml_ph_neto_disetahunkan, $ptkp)
    {
        $potongan = round($jml_ph_neto_disetahunkan - $ptkp);
        if ($potongan <= 0) {
            return 0;
        } else {
            $pembulatan = substr($potongan, -3);
            if ($pembulatan != "000") {
                return substr($potongan, 0, strlen($potongan) - 3) . "000";
            } else {
                return $potongan;
            }
        }
    }

    public function pkp_terutang_setahun($pkp_setahun)
    {
        $variable_pkp = [
            '5'  => ['max' => 60000000],
            '15' => ['max' => 250000000],
            '25' => ['max' => 500000000],
            '30' => ['max' => 5000000000],
            '35' => ['max' => PHP_INT_MAX] // tak hingga untuk batas atas
        ];

        $deduction = [0];
        $result    = [];
        foreach ($variable_pkp as $key => $value) {
            if ($pkp_setahun > $value['max'] && $value['max'] !== PHP_INT_MAX) {
                $multiplier = $value['max'] - array_sum($deduction);
                $result[] = [
                    'result'     => $multiplier * ((int)$key / 100),
                    'persentase' => $key,
                    'multiplier' => $multiplier
                ];
                $deduction[] = $multiplier;
            } else {
                $multiplier = $pkp_setahun - array_sum($deduction);
                $result[] = [
                    'result'     => $multiplier * ((int)$key / 100),
                    'persentase' => $key,
                    'multiplier' => $multiplier
                ];
                break;
            }
        }
        return $result;
    }
}
