<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Pengalaman_kerja_histori_m extends CI_Model {
  public $table = 'riwayat_pekerjaan_h';

  function get_datatables(){
      $this->_get_datatables_query();
      if($_POST['length'] != -1){
          $this->db->limit($_POST['length'], $_POST['start']);
      }
      $query = $this->db->get();
      return $query->result();
  }

  function count_filtered(){
      $this->_get_datatables_query();
      $query = $this->db->get();
      return $query->num_rows();
  }

  public function count_all(){
      $this->db->select("id")->from($this->table);
      $this->db->where("id_company",$this->session->userdata('id_company'));
      return $this->db->count_all_results();
  }
  private function _get_datatables_query(){
      $this->db->select("id, nama_perusahaan, jenis_perusahaan, jabatan, action, tgl_input")->from($this->table);
      $this->db->where('md5(id_karyawan)', $this->input->get('id_karyawan'));
      $column_search = array('tgl_input');
      $i = 0;

      foreach ($column_search as $item){  // looping awal
          if($_POST['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST

              if($i===0){ // looping awal
                  $this->db->group_start();
                  $this->db->like($item, $_POST['search']['value']);
              }else{
                  $this->db->or_like($item, $_POST['search']['value']);
              }

              if(count($column_search) - 1 == $i){
                  $this->db->group_end();
              }
          }
          $i++;
      }

      $column_order = array('','action', 'nama_perusahaan','jenis_perusahaan','jabatan', 'tgl_input', 'id');

      if(isset($_POST['order'])){
          $this->db->order_by($column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
      }
      else{
          $order_by = array("tgl_input"=>"DESC");
          $this->db->order_by(key($order_by), $order_by[key($order_by)]);
      }
  }

  function get_data($id_md5) {
    $this->db->select('*, kota.nama as nama_kota, provinsi.nama as nama_provinsi');
    $this->db->join('master_kota kota', 'kota.id_kota = riwayat_pekerjaan_h.kota', 'left');
    $this->db->join('master_provinsi provinsi', 'provinsi.id_prov = riwayat_pekerjaan_h.provinsi', 'left');
    $this->db->where('md5(id)', $id_md5);
    return $this->db->get($this->table)->row();
  }
}
