<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Quick_setup_staff_m extends CI_Model{
  var $table = 'data_karyawan';
  public function __construct(){
  parent::__construct();

      $this->level_user           = $this->session->userdata('level_user');
      $this->id_company           = $this->session->userdata('id_company');
      $this->multi_cabang         = $this->session->userdata('multi_cabang');
      $this->id_cabang            = $this->session->userdata('id_cabang');
      $this->id_cabang_arr        = $this->session->userdata('id_cabang_arr');
      $this->multi_departemen     = $this->session->userdata('multi_departemen');
      $this->id_departemen        = $this->session->userdata('id_departemen');
      $this->id_departemen_arr    = $this->session->userdata('id_departemen_arr');
      $this->id_karyawan          = $this->session->userdata('id_karyawan');
}

  function get_datatables(){
      $this->_get_datatables_query();
      if($_POST['length'] != -1){
          $this->db->limit($_POST['length'], $_POST['start']);
      }
      $query = $this->db->get();
      return $query->result();
  }

  function count_filtered(){
      $this->_get_datatables_query();
      $query = $this->db->get();
      return $query->num_rows();
  }

  public function count_all(){
      $this->db->select("nik")->from($this->table);
      $this->db->join("master_cabang", "data_karyawan.id_cabang = master_cabang.id_cabang");
      $this->db->join("master_jabatan", "master_jabatan.id_jabatan = data_karyawan.id_jabatan");
      $this->db->where("data_karyawan.status", "2");
      $this->db->where("master_jabatan.level_user", 3);
      $this->db->where("master_cabang.id_company",$this->id_company);
      return $this->db->count_all_results();
  }
  private function _get_datatables_query(){
      $this->db->select("nik, id_karyawan, nama_lengkap, master_cabang.nama as cabang, master_cabang.kode as kode_cabang,
        master_departemen.nama as departemen, master_departemen.kode as kode_departemen")->from($this->table);
      $this->db->join("master_departemen", "master_departemen.id_departemen = data_karyawan.id_departemen");
      $this->db->join("master_cabang", "data_karyawan.id_cabang = master_cabang.id_cabang");
      $this->db->join("master_jabatan", "master_jabatan.id_jabatan = data_karyawan.id_jabatan");
      $this->db->where("data_karyawan.status", "2");
      $this->db->where("master_jabatan.level_user", 3);
      $this->db->where("master_cabang.id_company",$this->id_company);

      $column_search = array('nik','nama_lengkap','master_cabang.nama','master_departemen.nama');
      $i = 0;

      foreach ($column_search as $item){  // looping awal
          if($_POST['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST

              if($i===0){ // looping awal
                  $this->db->group_start();
                  $this->db->like($item, $_POST['search']['value']);
              }else{
                  $this->db->or_like($item, $_POST['search']['value']);
              }

              if(count($column_search) - 1 == $i){
                  $this->db->group_end();
              }
          }
          $i++;
      }

      $column_order = array('nik','nama_lengkap','master_cabang.nama','master_departemen.nama');

      if(isset($_POST['order'])){
          $this->db->order_by($column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
      }
      else{
          $order_by = array("data_karyawan.tgl_input"=>"DESC");
          $this->db->order_by(key($order_by), $order_by[key($order_by)]);
      }
  }

  function cek_jabatan_staff() {
    $this->db->order_by('id_jabatan', 'asc');
    return $this->db->get_where('master_jabatan', array('level_user' => 3, 'id_company' => $this->id_company));
  }

  function create_jabatan_staff() {
    $id_jabatan = $this->fungsi->getNextId('master_jabatan','id_jabatan',$this->id_company,3);
    $data = array(
      'id_jabatan'    => $id_jabatan,
      'kode_jabatan'  => 'STAFF',
      'nama'          => 'Staff',
      'level_user'    => 3,
      'id_company'    => $this->id_company
    );
    $this->db->insert('master_jabatan', $data);
    return $id_jabatan;
  }

  function update($data, $data_user, $id_karyawan) {
    $this->db->trans_start();
    $this->db->update($this->table, $data, array('id_karyawan' => $id_karyawan));
    $this->db->update('users', $data_user, array('id_karyawan' => $id_karyawan));
    $this->db->trans_complete();

    if($this->db->trans_status() === FALSE) {
        $this->db->trans_rollback();
        return __response_update(false);
    }else{
        $this->db->trans_commit();
        return __response_update(true);
    }
  }

  function delete($id_karyawan) {
    $this->db->trans_start();

    $this->db->where(array('id_karyawan'=>$id_karyawan));
    $this->db->delete('data_karyawan');

    $this->db->where(array('id_karyawan'=>$id_karyawan));
    $this->db->delete('users');

    $this->db->trans_complete();

    if($this->db->trans_status() === FALSE) {
        $this->db->trans_rollback();
        return __response_delete(false);
    }else{
        $this->db->trans_commit();
        return __response_delete(true);
    }
  }

  function cek_limit_max_karyawan()
  {
    $max_karyawan = $this->db->select("SUM(master_company.custom_jumlah_karyawan + tb_paket.max_karyawan) AS max_jml_karyawan")
            ->from("master_company")
            ->join("tb_paket", "tb_paket.id_tb_paket = master_company.id_tb_paket")
            ->where("master_company.id_company", $this->id_company)
            ->get()
            ->row()->max_jml_karyawan;

    $max_karyawan_aktif = $this->db->select("data_karyawan.id_karyawan")
            ->from("data_karyawan")
            ->join("master_jabatan", "master_jabatan.id_jabatan = data_karyawan.id_jabatan")
            ->where_in("data_karyawan.status", ["1", "2", "3", "4"])
            ->where_not_in("master_jabatan.level_user", ["1", "6"])
            ->where("data_karyawan.id_company", $this->id_company)
            ->count_all_results();
    if($max_karyawan_aktif >= $max_karyawan) {
        // melebihi limit
        return true;
    } else {
        // tidak melebihi limit
        return false;
    }
  }
}
