<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Draft_pkwt extends MY_Controller {

	public function __construct(){
        parent::__construct();
        $this->load->model('pkwt/baru/Draft_pkwt_m');
    }

    public function list_data($tanggal_mulai="0000-00-00", $tanggal_selesai="0000-00-00", $id_cabang="", $id_departemen="", $id_karyawan=""){
		$list = $this->Draft_pkwt_m->get_datatables($tanggal_mulai, $tanggal_selesai, $id_cabang, $id_departemen, $id_karyawan);
		$data = array();
		$no = $_GET['start'];
		foreach ($list as $field) {
			$no++;
			$row = array();
			$row[] = $no;
			$row[] = $field->nm_karyawan. "<br><b>". $field->nik.'</b>';
			$row[] = $field->nm_jabatan. "<br><b>". $field->nm_lvl_user.'</b>';
			$row[] = $field->nm_cabang. "<br>". $field->nm_departemen;
			$row[] = indo_date(strtotime($field->tgl_pkwt_mulai), "d F Y"). " <br>s/d<br>". indo_date(strtotime($field->tgl_pkwt_selesai), "d F Y");

			$row[] = '<a href="'.site_url('pkwt/baru/download/pdf/'.md5($field->id_pkwt)).'" title="Detail" class="text-primary" target="_blank">
							<i class="btn_detail fa fa-info-circle (alias) "> </i>
						</a>&nbsp;
						<a href="#" class="text-warning" title="EDIT">
							<i id="' . md5($field->id_pkwt) . '" class="btn_edit_pkwt fa fa-edit (alias) "> </i></a>&nbsp;
						<a href="#" class="text-danger" title="HAPUS">
							<i id="' . md5($field->id_pkwt) . '" class="btn_delete_pkwt fa fa-trash"></i>
						</a>';
			$row[] 	= '<input class="cek_pkwt_kirim" type="checkbox" name="checkbox_kirim" value="' . $field->id_pkwt . '"  data-tglpkwt="'.$field->tgl_pkwt.'" >';

			$data[] = $row;
		}

		$output = array("draw"            => $_GET['draw'],
						"recordsTotal"    => $this->Draft_pkwt_m->count_all($tanggal_mulai, $tanggal_selesai, $id_cabang, $id_departemen, $id_karyawan),
						"recordsFiltered" => $this->Draft_pkwt_m->count_filtered($tanggal_mulai, $tanggal_selesai, $id_cabang, $id_departemen, $id_karyawan),
						"data"            => $data);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

	public function edit_pkwt($id=null){
		$this->load->model('pkwt/master/template_m');

		$data['data']     = $this->Draft_pkwt_m->getDataById($id);
		$data['template'] = $this->template_m->getDataById(md5($data['data']->id_template));
		$this->load->view('pkwt/baru/form',$data);
	}

	public function delete(){
		$id_pkwt = $this->input->post('id_pkwt');
		$this->db->trans_start();

		$this->db->where('id_company', $this->id_company);
		$this->db->where('MD5(id_pkwt)', $id_pkwt);
		$this->db->delete('pkwt_data');

		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			$message = '<font color="#FFFFF"><i class="fa fa-exclamation-triangle">&nbsp;</i>Data gagal dihapus</font>';
			return __response_delete(false,["message"=>$message]);
		}else{
			$this->db->trans_commit();
			$message = '<font color="#FFFFF"><i class="fa fa-check-square">&nbsp;</i>Data berhasil dihapus</font>';
			return __response_delete(true,["message"=>$message]);
		}
	}

	public function kirim_draft(){
		$array_kirim = $this->input->post("array_kirim");
		
		// GENERATE NAMA SURAT
		$nama_surat = 'PKWT/';
		$tahun  	= date('Y');
		$bulan 		= date('m');
		$bulan_rom 	= $this->_konversi_romawi($bulan);
		$no_urut	= $this->_get_no_urut($tahun);

		$pkwt_update = array();
		foreach($array_kirim as $value){
			$no_pkwt 	= "";
			$no_pkwt = $nama_surat.$no_urut.'/'.$bulan_rom.'/'.$tahun;

			$data = array(
				'id_pkwt' => $value['id_pkwt'],
				'no_pkwt' => $no_pkwt,
				"status" => '1',
				"apv_karyawan" => '1',
				"apv_direksi" => '5'
			);

			$no_urut++;
			$no_urut = sprintf("%03d", $no_urut);
			$pkwt_update[] = $data;
		}

		$this->db->trans_start();

		$this->db->where('id_company', $this->id_company);		
		$this->db->update_batch('pkwt_data', $pkwt_update, 'id_pkwt');

		$this->db->trans_complete();

		if ($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			$message = '<font color="#FFFFF"><i class="fa fa-exclamation-triangle">&nbsp;</i>Data gagal dikirim</font>';
			return __response_update(false,["message"=>$message]);
		}else{
			$this->db->trans_commit();
			
			foreach($pkwt_update as $value){
				$this->__approve_to_service($value['id_pkwt'], $value['no_pkwt']);
			}

			$message = '<font color="#FFFFF"><i class="fa fa-check-square">&nbsp;</i>Data berhasil dikirim</font>';
			return __response_update(true,["message"=>$message]);
		}
	}

	private function __approve_to_service($id_pkwt, $no_pkwt){
		$data_pkwt = $this->db->select('id_pkwt,token_fcm')
							->from('pkwt_data')
							->join('users', 'users.id_karyawan = pkwt_data.id_karyawan')
							->where('id_pkwt', $id_pkwt)
							->get()
							->row();

		$id_pkwt = $data_pkwt->id_pkwt;
		$token_fcm = $data_pkwt->token_fcm;

		$base = $this->config->item('url_api');

		$params_fcm = [
            'token_fcm' => $token_fcm,
            'route'     => '/detail_pkwt_saya',
            'title'     => 'PKWT '.$no_pkwt,
            'body'      => "Anda mendapatkan PKWT baru",
            'id_ref' 	=> $id_pkwt
        ];

        $params = [
            'params_fcm'   => json_encode($params_fcm),
            'url_consumer' => $base."/notifikasi/fcm/send",
            'nm_aplikasi' => 'fcm'
        ];

		$ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://mb-producer.absenku.com/fcm?".http_build_query($params)); 
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'authentication: absenku123**'
        ]);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $output = curl_exec($ch); 

        curl_close($ch);
	}

	private function _konversi_romawi($angka){
		switch ($angka) {
			case 1 : return 'I';
				break;
			case 2 : return 'II';
				break;
			case 3 : return 'III';
				break;
			case 4 : return 'IV';
				break;
			case 5 : return 'V';
				break;
			case 6 : return 'VI';
				break;
			case 7 : return 'VII';
				break;
			case 8 : return 'VIII';
				break;
			case 9 : return 'IX';
				break;
			case 10 : return 'X';
				break;
			case 11 : return 'XI';
				break;
			case 12 : return 'XII';
				break;
			default : return '-';
				break;
			}
	}

	private function _get_no_urut($tahun="2024"){
		$getId = $this->db->query("SELECT MAX(SUBSTRING_INDEX(SUBSTRING_INDEX(no_pkwt, '/', -3), '/', 1)) AS no_urut
									FROM pkwt_data
									WHERE SUBSTRING_INDEX(SUBSTRING_INDEX(no_pkwt, '/', -1), '/', 1) = ?", array($tahun));
	
		if ($getId->num_rows() > 0) {
			$current_id = $getId->row()->no_urut;
			$no_urut 	= $current_id + 1;
		} else {
			$no_urut = 1;
		}
	
		return sprintf("%03d", $no_urut);
	}
}