<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Master_lembur_karyawan extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('payroll/master_lembur/Master_lembur_karyawan_m', 'model');
    }

    public function view_data()
    {
        $data['judul'] = 'Master Lembur Karyawan';
        $this->load->view('payroll/master_lembur/karyawan/index', $data);
    }

    public function form_delete($encrypt_id = null)
    {
        // get data
        $data['data'] = $this->model->getDataById($encrypt_id);
        return $this->load->view('payroll/master_lembur/karyawan/modal_detail', $data);
    }

    public function save()
    {
        $id_karyawan = $this->input->post('id');
        $lembur_p    = $this->input->post('lembur_p');

        // validasi
        $id_exist = $this->db->select('id_lembur_m')
            ->from('payroll_lembur_m')
            ->where('id_company', $this->id_company)
            ->where('id_karyawan', $id_karyawan)
            ->get()
            ->num_rows();

        $for = 'insert';
        if ($id_exist > 0) $for = 'update';

        $data = [
            'id_karyawan'           => $id_karyawan,
            'lembur_hari_kerja'     => $lembur_p[0],
            'lembur_libur_off'      => $lembur_p[1],
            'lembur_libur_nasional' => $lembur_p[2],
            'lembur_libur_khusus'   => $lembur_p[3],
        ];

        $this->model->save($data, $for);
    }

    public function delete()
    {
        $encrypt_id = $this->input->post('id');

        // validasi
        $id_exist = $this->db->select('id_lembur_m')
            ->from('payroll_lembur_m')
            ->where('id_company', $this->id_company)
            ->where('md5(id_lembur_m)', $encrypt_id)
            ->get();
        if ($id_exist->num_rows() == 0) {
            return __response_delete(false, ['message' => '<font><i class="fa fa-exclamation-triangle"></i> Data tidak ditemukan</font>']);
        }

        $id_lembur = $id_exist->row()->id_lembur_m;
        $this->model->delete($id_lembur);
    }

    public function download($params)
    {
        $data["filename"]      = 'Master Lembur Karyawan';
        $data["master_lembur"] = $this->model->getMasterLembur();
        $data["data"]          = $this->model->get_datatables($params);
        $sb_view               = $this->load->view('payroll/master_lembur/karyawan/download', $data, true);
        // print_r($sb_view);
        // exit;
        $column_settings = [
            'A' => ['width' => 5, 'align' => 'center', 'valign' => 'middle'],
            'B' => ['align' => 'center', 'format' => 'text', 'valign' => 'middle'],
            'C'    => ['width' => 40],
            'D'    => ['width' => 20],
            'E'    => ['width' => 20],
            'F' => ['align' => 'center', 'format' => 'text', 'valign' => 'middle'],
            'G' => ['align' => 'center', 'format' => 'text', 'valign' => 'middle'],
            'H' => ['align' => 'center', 'format' => 'text', 'valign' => 'middle'],
            'I' => ['align' => 'center', 'format' => 'text', 'valign' => 'middle'],
        ];
        $param = [
            'download'   => true,
            'cLength'    => 8,
            'file_name'  => $data["filename"],
            'paper_size' => 'A4',
            'font-size'  => 9,
            // 'pagebreak'   => true,
            'page_margin' => ['top' => 0, 'right' => 0.75, 'left' => 0.75, 'botom' => 0],
            'orientation' => 'potrait',
            'header'      => [
                '1' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '2' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
            ],
            'freezecolumn' => ['A5'],
            'thead'        => ['3', '4'],
            'thead_styles' => ['row' => 4, 'height' => 30],
            'tbody'        => [
                'start'  => '3',
                'height' => 15,
                'column' => $column_settings
            ],
        ];

        $this->load->library('PHPExcel/Excel');
        $this->excel->generateExcel($sb_view, $param);
    }
}
