/*
SQLyog Professional v13.1.1 (64 bit)
MySQL - 10.11.8-MariaDB-deb12-log : Database - absenku_v3_250801_custom
*********************************************************************
*/

/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
CREATE DATABASE /*!32312 IF NOT EXISTS*/`absenku_v3_250801_custom` /*!40100 DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci */;

USE `absenku_v3_250801_custom`;

/*Table structure for table `absensi_masuk` */

DROP TABLE IF EXISTS `absensi_masuk`;

CREATE TABLE `absensi_masuk` (
  `id_absensi_masuk` varchar(50) NOT NULL DEFAULT '' COMMENT 'id_company + YYYYMM + 5 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `tgl_absen` date NOT NULL DEFAULT '0000-00-00',
  `jenis_absen` enum('reguler','shift','libur','cuti','izin','sakit') NOT NULL DEFAULT 'reguler',
  `jam_kerja` time NOT NULL DEFAULT '00:00:00',
  `jam_absen` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `terlambat` int(4) NOT NULL DEFAULT 0,
  `kode_absen` varchar(255) NOT NULL DEFAULT '',
  `ket_kode` varchar(255) NOT NULL DEFAULT '',
  `lokasi_absen` varchar(255) NOT NULL DEFAULT '',
  `timezone` varchar(255) NOT NULL DEFAULT '',
  `gmt` varchar(6) NOT NULL DEFAULT '',
  `latitude` varchar(30) NOT NULL DEFAULT '',
  `longitude` varchar(30) NOT NULL DEFAULT '',
  `keterangan` varchar(150) NOT NULL DEFAULT '',
  `foto` varchar(255) NOT NULL DEFAULT '',
  `cron_status` enum('0','1') NOT NULL DEFAULT '0',
  `id_company` varchar(20) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_absensi_masuk`),
  KEY `KEY` (`id_company`,`tgl_absen`,`id_karyawan`,`kode_absen`,`jenis_absen`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `absensi_masuk` */

insert  into `absensi_masuk`(`id_absensi_masuk`,`id_karyawan`,`tgl_absen`,`jenis_absen`,`jam_kerja`,`jam_absen`,`terlambat`,`kode_absen`,`ket_kode`,`lokasi_absen`,`timezone`,`gmt`,`latitude`,`longitude`,`keterangan`,`foto`,`cron_status`,`id_company`,`tgl_input`) values 
('C20250800120250800001','C20250800100003','2025-08-15','reguler','08:00:00','2025-08-15 08:00:00',0,'H','Reguler','','','','','','','','0','C202508001','2025-08-19 14:29:22');

/*Table structure for table `absensi_pulang` */

DROP TABLE IF EXISTS `absensi_pulang`;

CREATE TABLE `absensi_pulang` (
  `id_absensi_pulang` varchar(50) NOT NULL DEFAULT '' COMMENT 'id_company + yyyymm + 5 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `id_masuk` varchar(50) NOT NULL DEFAULT '0' COMMENT 'absensi_masuk',
  `tgl_absen` date NOT NULL DEFAULT '0000-00-00',
  `jam_kerja` time NOT NULL DEFAULT '00:00:00',
  `jam_absen` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `pulang_cepat` int(4) NOT NULL DEFAULT 0 COMMENT 'menit',
  `keterangan` varchar(150) NOT NULL DEFAULT '',
  `lokasi_absen` varchar(255) NOT NULL DEFAULT '',
  `timezone` varchar(255) NOT NULL DEFAULT '',
  `gmt` varchar(6) NOT NULL DEFAULT '',
  `latitude` varchar(30) NOT NULL DEFAULT '',
  `longitude` varchar(30) NOT NULL DEFAULT '',
  `foto` varchar(255) NOT NULL DEFAULT '',
  `id_company` varchar(20) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_absensi_pulang`,`id_karyawan`,`id_masuk`,`tgl_absen`,`id_company`),
  KEY `KEY` (`id_karyawan`,`tgl_absen`,`id_company`,`jam_absen`,`id_masuk`),
  KEY `filter_1` (`id_masuk`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `absensi_pulang` */

insert  into `absensi_pulang`(`id_absensi_pulang`,`id_karyawan`,`id_masuk`,`tgl_absen`,`jam_kerja`,`jam_absen`,`pulang_cepat`,`keterangan`,`lokasi_absen`,`timezone`,`gmt`,`latitude`,`longitude`,`foto`,`id_company`,`tgl_input`) values 
('C20250800120250800001','C20250800100003','C20250800120250800001','2025-08-15','17:00:00','2025-08-15 17:00:00',0,'','','','','','','','C202508001','2025-08-19 14:29:22');

/*Table structure for table `captcha` */

DROP TABLE IF EXISTS `captcha`;

CREATE TABLE `captcha` (
  `captcha_id` bigint(13) unsigned NOT NULL AUTO_INCREMENT,
  `captcha_time` int(10) unsigned NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `word` varchar(20) NOT NULL,
  PRIMARY KEY (`captcha_id`),
  KEY `word` (`word`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `captcha` */

/*Table structure for table `ci_sessions` */

DROP TABLE IF EXISTS `ci_sessions`;

CREATE TABLE `ci_sessions` (
  `id` varchar(128) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `timestamp` int(10) unsigned NOT NULL DEFAULT 0,
  `data` blob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ci_sessions_timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `ci_sessions` */

/*Table structure for table `cuti_history` */

DROP TABLE IF EXISTS `cuti_history`;

CREATE TABLE `cuti_history` (
  `id_cuti_history` varchar(50) NOT NULL DEFAULT '' COMMENT 'id_company + yyyymm + 3 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `tgl_trx` date NOT NULL DEFAULT '0000-00-00',
  `keterangan` text NOT NULL DEFAULT '',
  `tambah` int(2) NOT NULL DEFAULT 0,
  `kurang` int(2) NOT NULL DEFAULT 0,
  `saldo` int(2) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_cuti_history`),
  KEY `filter_1` (`id_company`,`id_karyawan`,`tgl_trx`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `cuti_history` */

/*Table structure for table `cuti_p` */

DROP TABLE IF EXISTS `cuti_p`;

CREATE TABLE `cuti_p` (
  `id_cuti_p` varchar(50) NOT NULL DEFAULT '' COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `reset_jenis` enum('bulan','join_date') NOT NULL DEFAULT 'bulan',
  `reset_saldo` int(2) NOT NULL DEFAULT 0 COMMENT 'di reset jadi berapa?',
  `jenis_karyawan` varchar(50) NOT NULL DEFAULT '' COMMENT 'karyawan yang mendapatkan cuti',
  `periode_cuti` int(2) NOT NULL DEFAULT 1 COMMENT 'kapan karyawan mendapatkan saldo cuti, satuan bulan',
  `join_date_bulan` int(2) NOT NULL DEFAULT 0 COMMENT 'Karyawan mendapatkan saldo cuti berapa bulan setelah join date?',
  `carry_forward_maks_saldo` int(2) NOT NULL DEFAULT 0,
  `carry_forward_maks_bulan` int(2) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_cuti_p`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `cuti_p` */

/*Table structure for table `dashboard_rekap_detail` */

DROP TABLE IF EXISTS `dashboard_rekap_detail`;

CREATE TABLE `dashboard_rekap_detail` (
  `id_company` varchar(20) NOT NULL,
  `minggu` enum('1','2','3','4','5','6') NOT NULL DEFAULT '1',
  `tgl_absen` date NOT NULL DEFAULT '0000-00-00',
  `rata2` tinyint(3) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id_company`,`minggu`,`tgl_absen`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `dashboard_rekap_detail` */

/*Table structure for table `dashboard_rekap_detail_dibwh_50` */

DROP TABLE IF EXISTS `dashboard_rekap_detail_dibwh_50`;

CREATE TABLE `dashboard_rekap_detail_dibwh_50` (
  `id_company` varchar(20) NOT NULL,
  `periode` char(7) NOT NULL,
  `id_paket` tinyint(4) NOT NULL,
  PRIMARY KEY (`id_company`,`periode`,`id_paket`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `dashboard_rekap_detail_dibwh_50` */

/*Table structure for table `dashboard_rekap_paket` */

DROP TABLE IF EXISTS `dashboard_rekap_paket`;

CREATE TABLE `dashboard_rekap_paket` (
  `id_paket` tinyint(4) NOT NULL,
  `periode` char(7) NOT NULL,
  `filter_persen` enum('100','50') NOT NULL DEFAULT '100',
  `total` tinyint(3) unsigned DEFAULT 0,
  PRIMARY KEY (`id_paket`,`periode`,`filter_persen`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `dashboard_rekap_paket` */

/*Table structure for table `data_aktivitas` */

DROP TABLE IF EXISTS `data_aktivitas`;

CREATE TABLE `data_aktivitas` (
  `id_aktivitas` varchar(50) NOT NULL DEFAULT '' COMMENT 'id_company + yyyymmdd + 4 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `waktu` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `keterangan` varchar(250) NOT NULL DEFAULT '',
  `lokasi` varchar(225) NOT NULL DEFAULT '',
  `timezone` varchar(150) NOT NULL DEFAULT '',
  `gmt` varchar(10) NOT NULL DEFAULT '',
  `latitude` varchar(50) NOT NULL DEFAULT '',
  `longitude` varchar(50) NOT NULL DEFAULT '',
  `image` varchar(225) NOT NULL DEFAULT '',
  `id_company` varchar(20) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_aktivitas`),
  KEY `filter_1` (`id_company`,`waktu`),
  KEY `data_aktifitas` (`id_aktivitas`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `data_aktivitas` */

insert  into `data_aktivitas`(`id_aktivitas`,`id_karyawan`,`waktu`,`keterangan`,`lokasi`,`timezone`,`gmt`,`latitude`,`longitude`,`image`,`id_company`,`tgl_input`) values 
('D20250800120250800001','D20250800100003','2025-08-19 14:50:10','ccc','TKI','Asia/Jakarta','+07:00','-7.0765706','110.4164341','D202508001/aktivitas/202508/D2025080010000320250819145010.jpg','D202508001','2025-08-19 14:50:10'),
('D20250800120250800002','D20250800100003','2025-08-19 14:57:49','cvc','TKI','Asia/Jakarta','+07:00','-7.0766226','110.416423','D202508001/aktivitas/202508/D2025080010000320250819145749.jpg','D202508001','2025-08-19 14:57:49');

/*Table structure for table `data_berita` */

DROP TABLE IF EXISTS `data_berita`;

CREATE TABLE `data_berita` (
  `id_berita` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit urutan angka',
  `judul` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `creator` varchar(100) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT current_timestamp(),
  `gambar` varchar(255) NOT NULL,
  `posting` enum('0','1') NOT NULL DEFAULT '0',
  `tgl_posting` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  `id_company` varchar(20) NOT NULL DEFAULT '1',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  PRIMARY KEY (`id_berita`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `data_berita` */

insert  into `data_berita`(`id_berita`,`judul`,`content`,`creator`,`date_created`,`gambar`,`posting`,`tgl_posting`,`id_company`,`tgl_input`,`user_input`,`tgl_update`,`user_update`) values 
('D202508001202508001','tes','<p>coba berita</p>\n','D20250800100001','2025-08-19 15:39:22','D202508001/berita/202508/d7733658-1498-4e69-ade4-289c8cce5723.png','1',NULL,'D202508001','2025-08-19 15:39:22','00001 - Administrator','0000-00-00 00:00:00','');

/*Table structure for table `data_comment_berita` */

DROP TABLE IF EXISTS `data_comment_berita`;

CREATE TABLE `data_comment_berita` (
  `id_comment` int(11) NOT NULL AUTO_INCREMENT,
  `id_berita` int(11) NOT NULL,
  `sender` varchar(50) NOT NULL,
  `waktu` datetime NOT NULL,
  `content` text NOT NULL,
  `id_company` varchar(20) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id_comment`),
  KEY `data_comment_berita` (`id_comment`,`id_berita`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `data_comment_berita` */

/*Table structure for table `data_comment_pengumuman` */

DROP TABLE IF EXISTS `data_comment_pengumuman`;

CREATE TABLE `data_comment_pengumuman` (
  `id_comment` int(11) NOT NULL AUTO_INCREMENT,
  `id_pengumuman` int(11) NOT NULL,
  `sender` varchar(50) NOT NULL,
  `waktu` datetime NOT NULL,
  `content` text NOT NULL,
  `id_company` varchar(20) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id_comment`),
  KEY `data_comment_pengumuman` (`id_comment`,`id_pengumuman`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `data_comment_pengumuman` */

/*Table structure for table `data_fingerprint` */

DROP TABLE IF EXISTS `data_fingerprint`;

CREATE TABLE `data_fingerprint` (
  `uid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `role` varchar(20) NOT NULL,
  `password` varchar(50) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `divisi` varchar(100) NOT NULL,
  `device_id` int(11) NOT NULL,
  `id_company` varchar(20) NOT NULL DEFAULT '1',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`uid`),
  KEY `device_id` (`device_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `data_fingerprint` */

/*Table structure for table `data_fingerscanner` */

DROP TABLE IF EXISTS `data_fingerscanner`;

CREATE TABLE `data_fingerscanner` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `ip` varchar(15) NOT NULL,
  `port` varchar(10) NOT NULL,
  `last_row` datetime NOT NULL,
  `id_company` varchar(20) NOT NULL DEFAULT '1',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `data_fingerscanner` */

/*Table structure for table `data_izin` */

DROP TABLE IF EXISTS `data_izin`;

CREATE TABLE `data_izin` (
  `id_izin` varchar(50) NOT NULL DEFAULT '' COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `id_karyawan` varchar(255) NOT NULL DEFAULT '',
  `id_cabang` varchar(50) NOT NULL DEFAULT '',
  `id_departemen` varchar(50) NOT NULL DEFAULT '',
  `tgl_pengajuan` timestamp NOT NULL DEFAULT current_timestamp(),
  `tgl_mulai_izin` date NOT NULL DEFAULT '0000-00-00',
  `tgl_selesai_izin` date NOT NULL DEFAULT '0000-00-00',
  `jml_izin` int(11) NOT NULL DEFAULT 0,
  `saldo_ct_tahunan` int(3) NOT NULL DEFAULT 0 COMMENT 'jumlah saldo cuti tahunan yang di ambil',
  `saldo_ct_cf` int(3) NOT NULL DEFAULT 0 COMMENT 'jumlah saldo cuti carry forward yang di ambil',
  `kode_izin` varchar(10) NOT NULL DEFAULT '',
  `nama_izin` varchar(255) NOT NULL DEFAULT '',
  `jenis_izin` varchar(50) NOT NULL DEFAULT '',
  `flag` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0=tidak mengurangi cuti tahunan, 1=mengurangi cuti tahunan',
  `ket_izin` varchar(255) NOT NULL DEFAULT '',
  `approval_spv` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `approval_kedep` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `approval_kacab` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `approval_direksi` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `approval_hrd` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `file` varchar(255) NOT NULL DEFAULT '' COMMENT 'full url',
  `status` enum('1','2','3','4') NOT NULL DEFAULT '1' COMMENT '1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui',
  `user_spv` varchar(255) NOT NULL DEFAULT '',
  `user_kedep` varchar(255) NOT NULL DEFAULT '',
  `user_kacab` varchar(255) NOT NULL DEFAULT '',
  `user_direksi` varchar(255) NOT NULL DEFAULT '',
  `user_hrd` varchar(255) NOT NULL DEFAULT '',
  `tgl_apv_spv` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `tgl_apv_kedep` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `tgl_apv_kacab` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `tgl_apv_direksi` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `tgl_apv_hrd` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `id_company` varchar(20) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tgl_update` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_izin`) USING BTREE,
  KEY `KEY` (`id_company`,`id_karyawan`,`tgl_pengajuan`,`tgl_mulai_izin`,`tgl_selesai_izin`,`jenis_izin`,`approval_spv`,`approval_kedep`,`approval_kacab`,`approval_hrd`,`approval_direksi`,`id_izin`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `data_izin` */

/*Table structure for table `data_izin_temp` */

DROP TABLE IF EXISTS `data_izin_temp`;

CREATE TABLE `data_izin_temp` (
  `id_temp` varchar(50) NOT NULL DEFAULT '' COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `id_karyawan` varchar(255) NOT NULL DEFAULT '',
  `nik` varchar(50) DEFAULT '',
  `nm_karyawan` varchar(100) DEFAULT '',
  `id_cabang` varchar(50) NOT NULL DEFAULT '',
  `id_departemen` varchar(50) NOT NULL DEFAULT '',
  `tgl_pengajuan` timestamp NOT NULL DEFAULT current_timestamp(),
  `tgl_mulai` date NOT NULL DEFAULT '0000-00-00',
  `tgl_selesai` date NOT NULL DEFAULT '0000-00-00',
  `jml_cuti` int(11) NOT NULL DEFAULT 0,
  `kode_cuti` varchar(10) NOT NULL DEFAULT '',
  `nama_cuti` varchar(255) NOT NULL DEFAULT '',
  `jenis_cuti` varchar(50) NOT NULL DEFAULT '',
  `ket_cuti` varchar(255) NOT NULL DEFAULT '',
  `approval_spv` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `approval_kedep` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `approval_kacab` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `approval_direksi` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `approval_hrd` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `file` varchar(255) NOT NULL DEFAULT '' COMMENT 'full url',
  `status` enum('1','2','3','4') NOT NULL DEFAULT '1' COMMENT '1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui',
  `user_spv` varchar(255) NOT NULL DEFAULT '',
  `user_kedep` varchar(255) NOT NULL DEFAULT '',
  `user_kacab` varchar(255) NOT NULL DEFAULT '',
  `user_direksi` varchar(255) NOT NULL DEFAULT '',
  `user_hrd` varchar(255) NOT NULL DEFAULT '',
  `tgl_apv_spv` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `tgl_apv_kedep` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `tgl_apv_kacab` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `tgl_apv_direksi` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `tgl_apv_hrd` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `flag` enum('1','2') DEFAULT NULL COMMENT '1=data valid; 2=data tidak valid',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(255) NOT NULL DEFAULT '',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_temp`),
  KEY `KEY` (`id_karyawan`,`id_company`,`tgl_pengajuan`,`tgl_mulai`,`tgl_selesai`,`jenis_cuti`,`approval_spv`,`approval_kedep`,`approval_kacab`,`approval_hrd`,`approval_direksi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `data_izin_temp` */

/*Table structure for table `data_karyawan` */

DROP TABLE IF EXISTS `data_karyawan`;

CREATE TABLE `data_karyawan` (
  `id_karyawan` varchar(50) NOT NULL DEFAULT '' COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `nik` varchar(100) NOT NULL DEFAULT '',
  `nama_lengkap` varchar(100) NOT NULL DEFAULT '',
  `gelar_depan` varchar(50) NOT NULL DEFAULT '',
  `gelar_belakang` varchar(50) NOT NULL DEFAULT '',
  `no_ktp` varchar(20) NOT NULL DEFAULT '',
  `npwp` varchar(20) NOT NULL DEFAULT '',
  `jenis_kelamin` enum('L','P','uknown') NOT NULL DEFAULT 'uknown' COMMENT 'L:laki-laki;perempuan',
  `golongan_darah` varchar(20) NOT NULL DEFAULT '',
  `agama` varchar(50) NOT NULL DEFAULT '',
  `tempat_lahir` varchar(50) NOT NULL DEFAULT '',
  `tgl_lahir` date NOT NULL DEFAULT '0000-00-00',
  `alamat_ktp` varchar(255) NOT NULL DEFAULT '',
  `alamat_domisili` varchar(255) NOT NULL DEFAULT '',
  `rt` varchar(10) NOT NULL DEFAULT '',
  `rw` varchar(10) NOT NULL DEFAULT '',
  `id_kel` varchar(11) NOT NULL DEFAULT '',
  `id_kec` varchar(11) NOT NULL DEFAULT '',
  `id_kab` varchar(11) NOT NULL DEFAULT '',
  `id_prov` varchar(11) NOT NULL DEFAULT '',
  `kode_pos` varchar(20) NOT NULL DEFAULT '',
  `telepon` varchar(15) NOT NULL DEFAULT '',
  `email` varchar(50) NOT NULL DEFAULT '',
  `tgl_aktif_bekerja` date NOT NULL DEFAULT '0000-00-00',
  `join_date` date NOT NULL DEFAULT '0000-00-00',
  `tgl_berhenti_bekerja` date NOT NULL DEFAULT '0000-00-00',
  `id_departemen` varchar(50) NOT NULL DEFAULT '',
  `id_cabang` varchar(50) NOT NULL DEFAULT '',
  `id_jabatan` varchar(50) NOT NULL DEFAULT '',
  `supervisi` varchar(50) NOT NULL DEFAULT '',
  `jatah_cuti` int(11) NOT NULL DEFAULT 12,
  `flag_sales` enum('0','1') NOT NULL DEFAULT '0',
  `carry_forward` int(2) NOT NULL DEFAULT 0,
  `pendidikan_terakhir` varchar(50) NOT NULL DEFAULT '',
  `grade` int(11) NOT NULL,
  `status` enum('1','2','3','4','5','6','7') NOT NULL DEFAULT '1' COMMENT '1=Kontrak(Aktif);2=Tetap(Aktif) 3=Izin Belajar(Aktif), 4=Tugas Belajar(Aktif Tidak Wajib Absen), 5=Resign, 6=Dikeluarkan (PHK), 7=Pensiun',
  `lock_lokasi` enum('0','1') NOT NULL DEFAULT '1' COMMENT '1 = Ya, 0 = Tidak',
  `id_lokasi` varchar(225) NOT NULL DEFAULT '',
  `foto` varchar(255) NOT NULL DEFAULT '',
  `no_bpjs_kes` char(13) NOT NULL DEFAULT '',
  `no_bpjs_tk` char(11) NOT NULL DEFAULT '',
  `status_perkawinan` enum('Belum Kawin','Kawin','Cerai Hidup','Cerai Mati') NOT NULL DEFAULT 'Belum Kawin',
  `jml_anak` tinyint(1) NOT NULL DEFAULT 0,
  `tanggungan` varchar(5) NOT NULL DEFAULT '' COMMENT 'relasi tabel ptkp',
  `bank_atas_nama` varchar(255) NOT NULL DEFAULT '',
  `bank_rek` varchar(30) NOT NULL DEFAULT '',
  `bank_nama` varchar(30) NOT NULL DEFAULT '',
  `id_company` varchar(20) NOT NULL DEFAULT '1',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_karyawan`),
  KEY `filter_1` (`id_company`,`id_cabang`,`id_departemen`,`id_jabatan`),
  KEY `filter_2` (`id_company`,`id_jabatan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `data_karyawan` */

insert  into `data_karyawan`(`id_karyawan`,`nik`,`nama_lengkap`,`gelar_depan`,`gelar_belakang`,`no_ktp`,`npwp`,`jenis_kelamin`,`golongan_darah`,`agama`,`tempat_lahir`,`tgl_lahir`,`alamat_ktp`,`alamat_domisili`,`rt`,`rw`,`id_kel`,`id_kec`,`id_kab`,`id_prov`,`kode_pos`,`telepon`,`email`,`tgl_aktif_bekerja`,`join_date`,`tgl_berhenti_bekerja`,`id_departemen`,`id_cabang`,`id_jabatan`,`supervisi`,`jatah_cuti`,`flag_sales`,`carry_forward`,`pendidikan_terakhir`,`grade`,`status`,`lock_lokasi`,`id_lokasi`,`foto`,`no_bpjs_kes`,`no_bpjs_tk`,`status_perkawinan`,`jml_anak`,`tanggungan`,`bank_atas_nama`,`bank_rek`,`bank_nama`,`id_company`,`tgl_input`,`user_update`,`tgl_update`) values 
('C20250800100001','00001','Administrator','','','','','uknown','','','','0000-00-00','','','','','','','','','','','','0000-00-00','0000-00-00','0000-00-00','','C202508001202403001','C202508001202403001','',12,'0',0,'',0,'1','1','','','','','Belum Kawin',0,'','','','','C202508001','2024-03-13 09:22:45','','0000-00-00 00:00:00'),
('C20250800100002','00002','Example Kepala Departemen','','','','','uknown','','','','1970-01-01','','','','','','','','','','','','2024-03-01','2024-03-01','2024-08-31','C202508001202403001','C202508001202403001','C202508001202403002','',0,'0',0,'',0,'1','1','','','','','Belum Kawin',0,'','','','','C202508001','2024-03-14 06:11:36','','0000-00-00 00:00:00'),
('C20250800100003','00003','Example Staff','','','','','uknown','','','','1970-01-01','','','','','','','','','','','','2024-03-01','2024-03-01','2024-08-31','C202508001202403001','C202508001202403001','C202508001202403003','',0,'0',0,'',0,'1','1','','','','','Belum Kawin',0,'','','','','C202508001','2024-03-14 06:12:31','','0000-00-00 00:00:00'),
('C20250800100004','00004','Example Direksi','','','','','uknown','','','','1970-01-01','','','','','','','','','','','','2024-03-01','2024-03-01','1970-01-01','','C202508001202403001','C202508001202403004','',0,'0',0,'',0,'2','1','','','','','Belum Kawin',0,'','','','','C202508001','2024-03-14 06:13:09','','0000-00-00 00:00:00'),
('C20250800100005','00005','Example Kepala Cabang','','','','','uknown','','','','1970-01-01','','','','','','','','','','','','2024-03-01','2024-03-01','2024-08-31','','C202508001202403001','C202508001202403005','',0,'0',0,'',0,'1','1','','','','','Belum Kawin',0,'','','','','C202508001','2024-03-14 06:13:50','','0000-00-00 00:00:00'),
('C20250800100006','00006','Admin Finance','','','','','uknown','','','','1970-01-01','','','','','','','','','','','','2025-03-07','2025-03-07','1970-01-01','','C202508001202403001','C202508001202503001','',0,'0',0,'',0,'2','1','','','','','Belum Kawin',0,'','','','','C202508001','2025-03-07 09:46:50','','0000-00-00 00:00:00'),
('C20250800100007','00007','Example Supervisi','','','','','uknown','','','','1970-01-01','','','','','','','','','','','','2024-03-01','2024-03-01','2024-08-14','C202508001202403001','C202508001202403001','C202508001202403007','',0,'0',0,'',0,'1','1','','','','','Belum Kawin',0,'','','','','C202508001','2024-03-14 06:15:18','','0000-00-00 00:00:00'),
('D202508001000006','000006','Admin Finance','','','','','uknown','','','','1970-01-01','','','','','','','','','','','','2025-03-07','2025-03-07','1970-01-01','','D202508001202403001','D202508001202503001','',0,'0',0,'',0,'2','1','','','','','Belum Kawin',0,'','','','','D202508001','2025-03-07 09:44:46','','0000-00-00 00:00:00'),
('D20250800100001','00001','Administrator','','','','','uknown','','','','0000-00-00','','','','','','','','','','','','0000-00-00','0000-00-00','0000-00-00','','D202508001202403001','D202508001202403001','',12,'0',0,'',0,'1','1','','','','','Belum Kawin',0,'','','','','D202508001','2024-03-13 09:22:45','','0000-00-00 00:00:00'),
('D20250800100002','00002','Example Kepala Departemen','','','','','uknown','','','','1970-01-01','','','','','','','','','','','','2024-03-01','2024-03-01','2024-05-31','D202508001202403001','D202508001202403001','D202508001202403002','',0,'0',0,'',0,'1','1','','','','','Belum Kawin',0,'','','','','D202508001','2024-03-13 10:21:50','','0000-00-00 00:00:00'),
('D20250800100003','00003','Example Staff','','','','','uknown','','','','1970-01-01','','','','','','','','','','','','2024-03-01','2024-03-01','2024-05-31','D202508001202403001','D202508001202403001','D202508001202403003','',12,'0',0,'',0,'1','1','','D202508001/foto_profil/202508/D2025080010000320250819150424.jpg','','','Belum Kawin',0,'','','','','D202508001','2024-03-13 10:23:35','','0000-00-00 00:00:00'),
('D20250800100004','00004','Example Direksi','','','','','uknown','','','','1970-01-01','','','','','','','','','','','','2024-03-01','2024-03-01','1970-01-01','','D202508001202403001','D202508001202403004','',12,'0',0,'',0,'2','1','','','','','Belum Kawin',0,'','','','','D202508001','2024-03-13 10:24:55','','0000-00-00 00:00:00'),
('D20250800100005','00005','Example Kepala Cabang','','','','','uknown','','','','1970-01-01','','','','','','','','','','','','2024-03-01','2024-03-01','1970-01-01','','D202508001202403001','D202508001202403005','',12,'0',0,'',0,'2','1','','','','','Belum Kawin',0,'','','','','D202508001','2024-03-13 10:25:50','','0000-00-00 00:00:00'),
('D20250800100007','00007','Example Supervisi','','','','','uknown','','','','1970-01-01','','','','','','','','','','','','2024-03-01','2024-03-01','2024-05-31','D202508001202403001','D202508001202403001','D202508001202403007','',0,'0',0,'',0,'1','1','','D202508001/karyawan/D20250800100007/profil/00007-2cdb56d2-7a36-4aca-8b69-5eaaae4523c5.png','','','Belum Kawin',0,'','','','','D202508001','2024-03-13 10:27:57','','0000-00-00 00:00:00'),
('D20250800100009','00009','Slamet Baharudin','','','','','uknown','','','','1970-01-01','','','','','','','','','','','','2024-07-01','2024-07-29','2024-11-30','D202508001202403001','D202508001202403001','D202508001202403003','',0,'0',0,'',0,'1','1','','D202508001/karyawan/D20250800100009/profil/00009-23cbd522-3cd1-484f-b49c-a30b5db94988.png','','','Belum Kawin',0,'','','','','D202508001','2024-08-09 14:11:51','','0000-00-00 00:00:00');

/*Table structure for table `data_karyawan_h` */

DROP TABLE IF EXISTS `data_karyawan_h`;

CREATE TABLE `data_karyawan_h` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_karyawan` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `nik` varchar(100) NOT NULL,
  `nama_lengkap` varchar(100) NOT NULL,
  `gelar_depan` varchar(50) NOT NULL,
  `gelar_belakang` varchar(50) NOT NULL,
  `jenis_kelamin` enum('L','P') NOT NULL COMMENT 'L:laki-laki; perempuan',
  `golongan_darah` varchar(20) NOT NULL,
  `agama` varchar(50) NOT NULL,
  `tempat_lahir` varchar(50) NOT NULL,
  `tgl_lahir` date NOT NULL,
  `alamat_domisili` varchar(255) NOT NULL,
  `rt` varchar(10) NOT NULL,
  `rw` varchar(10) NOT NULL,
  `id_kel` varchar(11) NOT NULL,
  `id_kec` varchar(11) NOT NULL,
  `id_kab` varchar(11) NOT NULL,
  `id_prov` varchar(11) NOT NULL,
  `kode_pos` varchar(20) NOT NULL,
  `no_ktp` varchar(20) NOT NULL DEFAULT '',
  `no_bpjs_kes` char(13) NOT NULL DEFAULT '',
  `no_bpjs_tk` char(11) NOT NULL DEFAULT '',
  `telepon` varchar(15) NOT NULL,
  `email` varchar(50) NOT NULL,
  `pendidikan_terakhir` varchar(50) DEFAULT NULL,
  `action` enum('1','2','3') NOT NULL DEFAULT '1' COMMENT '1=INSERT; 2=EDIT; 3=DELETE;',
  `id_company` varchar(20) NOT NULL DEFAULT '1',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `id_company` (`id_company`)
) ENGINE=InnoDB AUTO_INCREMENT=6722 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `data_karyawan_h` */

/*Table structure for table `data_karyawan_p` */

DROP TABLE IF EXISTS `data_karyawan_p`;

CREATE TABLE `data_karyawan_p` (
  `id_karyawan` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `nik` varchar(100) NOT NULL,
  `nama_lengkap` varchar(100) NOT NULL,
  `gelar_depan` varchar(50) NOT NULL,
  `gelar_belakang` varchar(50) NOT NULL,
  `jenis_kelamin` enum('L','P') NOT NULL COMMENT 'L:laki-laki; perempuan',
  `golongan_darah` varchar(20) NOT NULL,
  `agama` varchar(50) NOT NULL,
  `tempat_lahir` varchar(50) NOT NULL,
  `tgl_lahir` date NOT NULL,
  `alamat_domisili` varchar(255) NOT NULL,
  `rt` varchar(10) NOT NULL,
  `rw` varchar(10) NOT NULL,
  `id_kel` varchar(11) NOT NULL,
  `id_kec` varchar(11) NOT NULL,
  `id_kab` varchar(11) NOT NULL,
  `id_prov` varchar(11) NOT NULL,
  `kode_pos` varchar(20) NOT NULL,
  `no_ktp` varchar(20) NOT NULL DEFAULT '',
  `no_bpjs_kes` char(13) NOT NULL DEFAULT '',
  `no_bpjs_tk` char(11) NOT NULL DEFAULT '',
  `telepon` varchar(15) NOT NULL,
  `email` varchar(50) NOT NULL,
  `pendidikan_terakhir` varchar(50) DEFAULT NULL,
  `status` enum('1','2','3') DEFAULT NULL,
  `ket_revisi` text NOT NULL,
  `action` enum('1','2','3') NOT NULL DEFAULT '1' COMMENT '1=INSERT; 2=EDIT; 3=DELETE;',
  `id_company` varchar(20) NOT NULL DEFAULT '1',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_karyawan`),
  KEY `id_company` (`id_company`),
  KEY `THIRD` (`id_karyawan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `data_karyawan_p` */

/*Table structure for table `data_karyawan_temp` */

DROP TABLE IF EXISTS `data_karyawan_temp`;

CREATE TABLE `data_karyawan_temp` (
  `id_temp` varchar(50) NOT NULL,
  `id_user` int(11) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `id_karyawan` varchar(100) NOT NULL,
  `nik` varchar(100) DEFAULT NULL,
  `nama_lengkap` varchar(50) NOT NULL,
  `gelar_belakang` varchar(50) DEFAULT NULL,
  `gelar_depan` varchar(50) DEFAULT NULL,
  `no_ktp` varchar(50) DEFAULT NULL,
  `jenis_kelamin` varchar(20) DEFAULT NULL,
  `golongan_darah` varchar(20) DEFAULT NULL,
  `agama` varchar(50) DEFAULT NULL,
  `tempat_lahir` varchar(50) DEFAULT NULL,
  `tgl_lahir` date DEFAULT NULL,
  `alamat_domisili` varchar(255) DEFAULT NULL,
  `telepon` varchar(50) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `tgl_aktif_bekerja` date DEFAULT NULL,
  `join_date` date DEFAULT NULL,
  `tgl_berhenti_bekerja` date DEFAULT NULL,
  `id_departemen` varchar(50) DEFAULT NULL,
  `id_cabang` varchar(50) DEFAULT NULL,
  `id_jabatan` varchar(50) DEFAULT NULL,
  `supervisi` varchar(50) DEFAULT NULL,
  `jatah_cuti` varchar(11) DEFAULT NULL,
  `pendidikan_terakhir` varchar(50) DEFAULT NULL,
  `status` varchar(2) DEFAULT NULL,
  `lock_lokasi` int(11) NOT NULL DEFAULT 0,
  `id_lokasi` varchar(255) DEFAULT NULL,
  `username` varchar(200) DEFAULT NULL,
  `password` varchar(200) DEFAULT NULL,
  `id_company` varchar(50) DEFAULT NULL,
  `flag` enum('1','2') NOT NULL DEFAULT '2' COMMENT '1:data valid, 2:data tidak valid',
  `user_input` varchar(100) NOT NULL,
  PRIMARY KEY (`id_temp`),
  KEY `id` (`id_karyawan`),
  KEY `id_2` (`id_karyawan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `data_karyawan_temp` */

/*Table structure for table `data_karyawan_temp_help` */

DROP TABLE IF EXISTS `data_karyawan_temp_help`;

CREATE TABLE `data_karyawan_temp_help` (
  `id` int(11) NOT NULL,
  `nik` varchar(50) NOT NULL DEFAULT '',
  `nama` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `data_karyawan_temp_help` */

/*Table structure for table `data_kelengkapan_file` */

DROP TABLE IF EXISTS `data_kelengkapan_file`;

CREATE TABLE `data_kelengkapan_file` (
  `id_kelengkapan_file` varchar(50) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `nama_dokumen` text NOT NULL,
  `file` text NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tanggal_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tanggal_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_kelengkapan_file`),
  KEY `SECOND` (`id_karyawan`,`id_company`),
  KEY `THIRD` (`id_karyawan`,`id_company`,`id_kelengkapan_file`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `data_kelengkapan_file` */

/*Table structure for table `data_kelengkapan_file_h` */

DROP TABLE IF EXISTS `data_kelengkapan_file_h`;

CREATE TABLE `data_kelengkapan_file_h` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_kelengkapan_file` varchar(50) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `nama_dokumen` text NOT NULL,
  `file` text NOT NULL,
  `action` enum('1','2','3') NOT NULL DEFAULT '1' COMMENT '1=INSERT; 2=EDIT; 3=DELETE;',
  `id_company` varchar(50) NOT NULL,
  `tanggal_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tanggal_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1829 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `data_kelengkapan_file_h` */

/*Table structure for table `data_kelengkapan_file_p` */

DROP TABLE IF EXISTS `data_kelengkapan_file_p`;

CREATE TABLE `data_kelengkapan_file_p` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_kelengkapan_file` varchar(50) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `nama_dokumen` text NOT NULL,
  `file` text NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `status_pengajuan` enum('1','2','3','4') NOT NULL DEFAULT '1' COMMENT '1=Pengajuan; 2=Approve; 3=Revisi; 4=Delete',
  `ket_revisi` text NOT NULL,
  `action` enum('1','2','3') NOT NULL DEFAULT '1' COMMENT '1=INSERT; 2=EDIT; 3=DELETE;',
  `tanggal_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tanggal_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2400 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `data_kelengkapan_file_p` */

/*Table structure for table `data_keluarga` */

DROP TABLE IF EXISTS `data_keluarga`;

CREATE TABLE `data_keluarga` (
  `id_keluarga` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL,
  `nama` varchar(250) NOT NULL,
  `tempat_lahir` varchar(250) NOT NULL,
  `tanggal_lahir` date NOT NULL,
  `jenis_kelamin` enum('L','P') DEFAULT NULL,
  `agama` varchar(50) DEFAULT NULL,
  `telepon` varchar(15) NOT NULL,
  `pekerjaan` varchar(100) NOT NULL,
  `hub_keluarga` varchar(100) DEFAULT NULL,
  `status_perkawinan` varchar(100) NOT NULL,
  `nik` varchar(50) NOT NULL,
  `no_bpjs` int(11) NOT NULL,
  `pendidikan_terakhir` varchar(20) NOT NULL,
  `tanggal_perkawinan` date DEFAULT NULL,
  `status` varchar(100) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_keluarga`),
  KEY `SECOND` (`id_karyawan`,`id_company`),
  KEY `THIRD` (`id_keluarga`,`id_karyawan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `data_keluarga` */

/*Table structure for table `data_keluarga_h` */

DROP TABLE IF EXISTS `data_keluarga_h`;

CREATE TABLE `data_keluarga_h` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_keluarga` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL,
  `nama` varchar(250) NOT NULL,
  `tempat_lahir` varchar(250) NOT NULL,
  `tanggal_lahir` date NOT NULL,
  `jenis_kelamin` enum('L','P') DEFAULT NULL,
  `agama` varchar(50) DEFAULT NULL,
  `telepon` varchar(15) NOT NULL,
  `pekerjaan` varchar(100) NOT NULL,
  `hub_keluarga` varchar(100) DEFAULT NULL,
  `status_perkawinan` varchar(100) NOT NULL,
  `nik` varchar(50) NOT NULL,
  `no_bpjs` int(11) NOT NULL,
  `pendidikan_terakhir` varchar(20) NOT NULL,
  `tanggal_perkawinan` date DEFAULT NULL,
  `status` varchar(100) NOT NULL,
  `action` enum('1','2','3') NOT NULL COMMENT '1=INSERT; 2=EDIT; 3=DELETE;',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `id_karyawan` (`id_karyawan`,`id_company`)
) ENGINE=InnoDB AUTO_INCREMENT=3203 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `data_keluarga_h` */

/*Table structure for table `data_keluarga_p` */

DROP TABLE IF EXISTS `data_keluarga_p`;

CREATE TABLE `data_keluarga_p` (
  `id_keluarga` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL,
  `nama` varchar(250) NOT NULL,
  `tempat_lahir` varchar(250) NOT NULL,
  `tanggal_lahir` date NOT NULL DEFAULT '0000-00-00',
  `jenis_kelamin` enum('L','P') DEFAULT NULL,
  `agama` varchar(50) DEFAULT NULL,
  `telepon` varchar(15) NOT NULL,
  `pekerjaan` varchar(100) NOT NULL,
  `hub_keluarga` varchar(100) DEFAULT NULL,
  `status_perkawinan` varchar(100) NOT NULL,
  `nik` varchar(50) NOT NULL,
  `no_bpjs` int(11) NOT NULL,
  `pendidikan_terakhir` varchar(20) NOT NULL,
  `tanggal_perkawinan` date NOT NULL DEFAULT '0000-00-00',
  `status` varchar(100) NOT NULL,
  `status_pengajuan` enum('1','2','3','4') DEFAULT NULL COMMENT '1: pengajuan, 2: approve, 3: revisi, 4: Delete',
  `ket_revisi` text DEFAULT NULL,
  `action` enum('1','2','3') NOT NULL DEFAULT '1' COMMENT '1=INSERT; 2=EDIT; 3=DELETE;',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_keluarga`),
  KEY `id_karyawan` (`id_karyawan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `data_keluarga_p` */

/*Table structure for table `data_lokasi_kantor` */

DROP TABLE IF EXISTS `data_lokasi_kantor`;

CREATE TABLE `data_lokasi_kantor` (
  `id_lokasi_kantor` varchar(25) NOT NULL COMMENT 'id_company + yyyymm + 3 digit nomor urut',
  `nama_kantor` varchar(250) NOT NULL,
  `lat_asli` varchar(250) NOT NULL,
  `lat_min` varchar(250) NOT NULL,
  `lat_max` varchar(250) NOT NULL,
  `long_asli` varchar(250) NOT NULL,
  `long_min` varchar(250) NOT NULL,
  `long_max` varchar(250) NOT NULL,
  `jarak` int(11) NOT NULL,
  `id_cabang` varchar(25) NOT NULL,
  `id_company` varchar(25) NOT NULL,
  `flag` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0 = pusat; 1 = cabang',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  PRIMARY KEY (`id_lokasi_kantor`),
  KEY `data_lok_kantor` (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `data_lokasi_kantor` */

insert  into `data_lokasi_kantor`(`id_lokasi_kantor`,`nama_kantor`,`lat_asli`,`lat_min`,`lat_max`,`long_asli`,`long_min`,`long_max`,`jarak`,`id_cabang`,`id_company`,`flag`,`tgl_input`,`user_input`,`tgl_update`,`user_update`) values 
('C202508001202403001','TKI','-7.0766098','-7.0775091216059','-7.0757104783941','110.4163773','110.41728352494','110.41547107506',100,'C202508001202403001','C202508001','1','2024-06-25 15:36:14','','0000-00-00 00:00:00',''),
('D202508001202403001','TKI','-7.0766098','-7.0775091216059','-7.0757104783941','110.4163773','110.41728352494','110.41547107506',100,'D202508001202403001','D202508001','1','2024-06-25 15:36:15','','0000-00-00 00:00:00','');

/*Table structure for table `data_lokasi_kantor_temp` */

DROP TABLE IF EXISTS `data_lokasi_kantor_temp`;

CREATE TABLE `data_lokasi_kantor_temp` (
  `id_lokasi_kantor` varchar(25) NOT NULL COMMENT 'id_company + yyyymm + 3 digit nomor urut',
  `nama_lokasi` varchar(255) NOT NULL DEFAULT '',
  `lat_asli` varchar(255) NOT NULL DEFAULT '',
  `lat_min` varchar(255) NOT NULL DEFAULT '',
  `lat_max` varchar(255) NOT NULL DEFAULT '',
  `long_asli` varchar(255) NOT NULL DEFAULT '',
  `long_min` varchar(255) NOT NULL DEFAULT '',
  `long_max` varchar(255) NOT NULL DEFAULT '',
  `radius` int(11) NOT NULL DEFAULT 50,
  `id_cabang` varchar(50) NOT NULL DEFAULT '',
  `id_company` varchar(25) NOT NULL DEFAULT '',
  `flag` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0 = pusat; 1 = cabang',
  `user_input` varchar(25) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(25) NOT NULL DEFAULT '',
  `tgl_update` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_lokasi_kantor`),
  KEY `data_lok_kantor` (`id_company`,`id_cabang`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `data_lokasi_kantor_temp` */

/*Table structure for table `data_marketing` */

DROP TABLE IF EXISTS `data_marketing`;

CREATE TABLE `data_marketing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(50) NOT NULL,
  `flag_urutan` enum('ya','tidak') NOT NULL DEFAULT 'ya' COMMENT 'Ya : urutan aktif, tidak : urutan tidak aktif',
  `urutan` enum('ya','tidak') NOT NULL DEFAULT 'tidak' COMMENT 'Ya : marketing terakhir yang mendapatkan jatah calon pelanggan, tidak : belum mendapat jatah calon pelanggan',
  `status` enum('aktif','nonaktif') DEFAULT 'aktif' COMMENT 'aktif: marketing aktif; nonaktif: marketing tidak aktif',
  `email` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `data_marketing` */

/*Table structure for table `data_pengumuman` */

DROP TABLE IF EXISTS `data_pengumuman`;

CREATE TABLE `data_pengumuman` (
  `id_pengumuman` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `target` enum('1','2','3','4') NOT NULL DEFAULT '1' COMMENT '1: Semua Karyawan, 2:Per Cabang: 3: Per Departemen, 4: Per Karyawan',
  `target_id` text NOT NULL,
  `id_cabang` varchar(255) NOT NULL,
  `judul` varchar(100) NOT NULL,
  `content` text NOT NULL,
  `creator` varchar(100) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT current_timestamp(),
  `posting` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0:Belum Posting, 1:Sudah diposting',
  `tgl_posting` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  PRIMARY KEY (`id_pengumuman`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `data_pengumuman` */

/*Table structure for table `data_sertifikat` */

DROP TABLE IF EXISTS `data_sertifikat`;

CREATE TABLE `data_sertifikat` (
  `id_sertifikat` varchar(50) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `nama_sertifikat` varchar(255) NOT NULL,
  `penyelenggara` varchar(255) NOT NULL,
  `tgl_berlaku` date NOT NULL,
  `tgl_berakhir` date NOT NULL,
  `deskripsi` text NOT NULL,
  `file` varchar(250) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_sertifikat`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `data_sertifikat` */

/*Table structure for table `data_sertifikat_h` */

DROP TABLE IF EXISTS `data_sertifikat_h`;

CREATE TABLE `data_sertifikat_h` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_sertifikat` varchar(50) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `nama_sertifikat` varchar(255) NOT NULL,
  `penyelenggara` varchar(255) NOT NULL,
  `tgl_berlaku` date NOT NULL,
  `tgl_berakhir` date NOT NULL,
  `deskripsi` text NOT NULL,
  `file` varchar(250) NOT NULL,
  `action` enum('1','2','3') NOT NULL DEFAULT '1' COMMENT '1=INSERT; 2=EDIT; 3=DELETE;',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `id_karyawan` (`id_karyawan`,`id_company`)
) ENGINE=InnoDB AUTO_INCREMENT=80 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `data_sertifikat_h` */

/*Table structure for table `data_sertifikat_p` */

DROP TABLE IF EXISTS `data_sertifikat_p`;

CREATE TABLE `data_sertifikat_p` (
  `id_sertifikat` varchar(50) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `nama_sertifikat` varchar(255) NOT NULL,
  `penyelenggara` varchar(255) NOT NULL,
  `tgl_berlaku` date NOT NULL,
  `tgl_berakhir` date NOT NULL,
  `deskripsi` text NOT NULL,
  `file` varchar(250) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `status_pengajuan` enum('1','2','3','4') NOT NULL DEFAULT '1' COMMENT '1=Pengajuan; 2=Approve; 3=Revisi; 4=Delete',
  `ket_revisi` text NOT NULL,
  `action` enum('1','2','3') NOT NULL DEFAULT '1' COMMENT '1=INSERT; 2=EDIT; 3=DELETE;',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_sertifikat`),
  KEY `id_karyawan` (`id_karyawan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `data_sertifikat_p` */

/*Table structure for table `data_shift_karyawan` */

DROP TABLE IF EXISTS `data_shift_karyawan`;

CREATE TABLE `data_shift_karyawan` (
  `id_shift_karyawan` varchar(100) NOT NULL DEFAULT '',
  `tanggal` date NOT NULL,
  `id_karyawan` varchar(255) NOT NULL DEFAULT '',
  `id_master_shift` varchar(50) NOT NULL DEFAULT '',
  `id_cabang` varchar(50) CHARACTER SET latin1 COLLATE latin1_bin NOT NULL DEFAULT '',
  `id_departemen` varchar(50) NOT NULL DEFAULT '',
  `shift_sebelumnya` varchar(255) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tgl_update` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_shift_karyawan`),
  KEY `Filter_1` (`id_master_shift`,`id_karyawan`,`tanggal`,`id_company`),
  KEY `Filter_2` (`id_karyawan`,`tanggal`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `data_shift_karyawan` */

/*Table structure for table `data_shift_karyawan_temp` */

DROP TABLE IF EXISTS `data_shift_karyawan_temp`;

CREATE TABLE `data_shift_karyawan_temp` (
  `id` varchar(255) NOT NULL,
  `tanggal` date NOT NULL,
  `id_karyawan` varchar(255) NOT NULL,
  `id_master_shift` varchar(50) NOT NULL,
  `flag` enum('1','2','3','4') NOT NULL DEFAULT '2' COMMENT '1:data valid, 2:data tidak valid, 3=tgl shift kadaluarsa, 4=data berhasil di simpan',
  `user_input` varchar(255) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `data_shift_karyawan` (`id_master_shift`,`id_karyawan`,`tanggal`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `data_shift_karyawan_temp` */

/*Table structure for table `file_izin` */

DROP TABLE IF EXISTS `file_izin`;

CREATE TABLE `file_izin` (
  `id_izin` varchar(50) DEFAULT NULL,
  `file` text DEFAULT NULL COMMENT 'full url',
  `id_company` varchar(20) DEFAULT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tgl_update` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `file_izin` */

/*Table structure for table `h_cuti` */

DROP TABLE IF EXISTS `h_cuti`;

CREATE TABLE `h_cuti` (
  `tahun` varchar(4) NOT NULL,
  `id_karyawan` varchar(255) NOT NULL,
  `nama_karyawan` varchar(100) NOT NULL,
  `jml_cuti` int(3) NOT NULL,
  `kode_reset` varchar(255) NOT NULL DEFAULT '1',
  `user_reset` varchar(255) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `h_cuti` */

/*Table structure for table `harga_per_user_m` */

DROP TABLE IF EXISTS `harga_per_user_m`;

CREATE TABLE `harga_per_user_m` (
  `min` smallint(5) unsigned NOT NULL,
  `max` smallint(5) unsigned NOT NULL,
  `harga` smallint(5) unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `harga_per_user_m` */

/*Table structure for table `hari` */

DROP TABLE IF EXISTS `hari`;

CREATE TABLE `hari` (
  `id` int(11) NOT NULL,
  `nama` varchar(10) NOT NULL,
  `nama_english` varchar(10) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `hari` */

insert  into `hari`(`id`,`nama`,`nama_english`) values 
(7,'Minggu','Sunday'),
(1,'Senin','Monday'),
(2,'Selasa','Tuesday'),
(3,'Rabu','Wednesday'),
(4,'Kamis','Thursday'),
(5,'Jumat','Friday'),
(6,'Sabtu','Saturday');

/*Table structure for table `history_jabatan` */

DROP TABLE IF EXISTS `history_jabatan`;

CREATE TABLE `history_jabatan` (
  `id_history_jabatan` int(11) NOT NULL AUTO_INCREMENT,
  `id_karyawan` varchar(11) NOT NULL,
  `id_jabatan` int(11) NOT NULL,
  `id_divisi` int(11) NOT NULL,
  `tanggal` date NOT NULL,
  `id_company` varchar(20) NOT NULL,
  PRIMARY KEY (`id_history_jabatan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `history_jabatan` */

/*Table structure for table `holidays` */

DROP TABLE IF EXISTS `holidays`;

CREATE TABLE `holidays` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `keterangan` varchar(255) NOT NULL,
  `jenis` enum('nasional','khusus') NOT NULL DEFAULT 'nasional',
  `id_company` varchar(20) NOT NULL,
  `color` varchar(11) DEFAULT '#8A2BE2',
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `holidays` (`tanggal`,`id_company`)
) ENGINE=InnoDB AUTO_INCREMENT=28298 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `holidays` */

/*Table structure for table `informasi_gaji` */

DROP TABLE IF EXISTS `informasi_gaji`;

CREATE TABLE `informasi_gaji` (
  `id` varchar(50) NOT NULL,
  `periode` varchar(8) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `nik` varchar(50) NOT NULL,
  `nama_karyawan` varchar(150) NOT NULL,
  `kode_cabang` varchar(10) NOT NULL,
  `nama_cabang` varchar(150) NOT NULL,
  `kode_departemen` varchar(10) NOT NULL,
  `nama_departemen` varchar(150) NOT NULL,
  `kode_jabatan` varchar(10) NOT NULL,
  `nama_jabatan` varchar(150) NOT NULL,
  `gaji_pokok` int(11) NOT NULL DEFAULT 0,
  `t_jabatan` int(11) NOT NULL DEFAULT 0,
  `t_transport` int(11) NOT NULL DEFAULT 0,
  `t_makan` int(11) NOT NULL DEFAULT 0,
  `t_istri` int(11) NOT NULL DEFAULT 0,
  `t_anak` int(11) NOT NULL DEFAULT 0,
  `lembur` int(11) NOT NULL DEFAULT 0,
  `komisi` int(11) NOT NULL DEFAULT 0,
  `t_lain` int(11) NOT NULL DEFAULT 0,
  `ttl_tunjangan` int(11) NOT NULL DEFAULT 0,
  `ttl_penerimaan` int(11) NOT NULL DEFAULT 0,
  `tbp_bpjs_tk` int(11) NOT NULL DEFAULT 0,
  `tbp_bpjs_kesehatan` int(11) NOT NULL DEFAULT 0,
  `tbp_lain` int(11) NOT NULL DEFAULT 0,
  `ttl_tbp` int(11) NOT NULL DEFAULT 0,
  `p_absensi` int(11) NOT NULL DEFAULT 0,
  `p_keterlambatan` int(11) NOT NULL DEFAULT 0,
  `p_koperasi` int(11) NOT NULL DEFAULT 0,
  `p_asuransi_kesehatan` int(11) NOT NULL DEFAULT 0,
  `p_bpjs_tk` int(11) NOT NULL DEFAULT 0,
  `p_bpjs_kesehatan` int(11) NOT NULL DEFAULT 0,
  `p_lain` int(11) NOT NULL DEFAULT 0,
  `ttl_potongan` int(11) NOT NULL DEFAULT 0,
  `gaji_diterima` int(11) NOT NULL DEFAULT 0,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `user_input` varchar(50) NOT NULL,
  `publish` enum('0','1') NOT NULL DEFAULT '0',
  `tgl_publish` datetime DEFAULT NULL,
  `user_publish` varchar(50) DEFAULT NULL,
  `id_company` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `informasi_gaji` */

/*Table structure for table `informasi_gaji_temp` */

DROP TABLE IF EXISTS `informasi_gaji_temp`;

CREATE TABLE `informasi_gaji_temp` (
  `id` varchar(50) NOT NULL,
  `periode` varchar(8) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `nik` varchar(50) NOT NULL,
  `nama_karyawan` varchar(150) NOT NULL,
  `kode_cabang` varchar(10) NOT NULL,
  `nama_cabang` varchar(150) NOT NULL,
  `kode_departemen` varchar(10) NOT NULL,
  `nama_departemen` varchar(150) NOT NULL,
  `kode_jabatan` varchar(10) NOT NULL,
  `nama_jabatan` varchar(150) NOT NULL,
  `gaji_pokok` int(11) NOT NULL DEFAULT 0,
  `t_jabatan` int(11) NOT NULL DEFAULT 0,
  `t_transport` int(11) NOT NULL DEFAULT 0,
  `t_makan` int(11) NOT NULL DEFAULT 0,
  `t_istri` int(11) NOT NULL DEFAULT 0,
  `t_anak` int(11) NOT NULL DEFAULT 0,
  `lembur` int(11) NOT NULL DEFAULT 0,
  `komisi` int(11) NOT NULL DEFAULT 0,
  `t_lain` int(11) NOT NULL DEFAULT 0,
  `ttl_tunjangan` int(11) NOT NULL DEFAULT 0,
  `ttl_penerimaan` int(11) NOT NULL DEFAULT 0,
  `tbp_bpjs_tk` int(11) NOT NULL DEFAULT 0,
  `tbp_bpjs_kesehatan` int(11) NOT NULL DEFAULT 0,
  `tbp_lain` int(11) NOT NULL DEFAULT 0,
  `ttl_tbp` int(11) NOT NULL DEFAULT 0,
  `p_absensi` int(11) NOT NULL DEFAULT 0,
  `p_keterlambatan` int(11) NOT NULL DEFAULT 0,
  `p_koperasi` int(11) NOT NULL DEFAULT 0,
  `p_asuransi_kesehatan` int(11) NOT NULL DEFAULT 0,
  `p_bpjs_tk` int(11) NOT NULL DEFAULT 0,
  `p_bpjs_kesehatan` int(11) NOT NULL DEFAULT 0,
  `p_lain` int(11) NOT NULL DEFAULT 0,
  `ttl_potongan` int(11) NOT NULL DEFAULT 0,
  `gaji_diterima` int(11) NOT NULL DEFAULT 0,
  `flag` enum('1','2','3') NOT NULL DEFAULT '2' COMMENT '1: Data Valid, 2: Data tidak lengkap, 3:Data sudah ada',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `user_input` varchar(50) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `informasi_gaji_temp` */

/*Table structure for table `istirahat_mulai` */

DROP TABLE IF EXISTS `istirahat_mulai`;

CREATE TABLE `istirahat_mulai` (
  `id_istmulai` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 5 digit nomor urut',
  `id_absensi_masuk` varchar(50) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `tgl_absen` date NOT NULL,
  `jam_absen` datetime NOT NULL,
  `lokasi_absen` varchar(255) NOT NULL,
  `timezone` varchar(255) NOT NULL,
  `gmt` varchar(6) NOT NULL,
  `latitude` varchar(30) NOT NULL,
  `longitude` varchar(30) NOT NULL,
  `keterangan` text NOT NULL,
  `foto` text NOT NULL,
  `id_company` varchar(20) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_istmulai`),
  KEY `KEY` (`id_karyawan`,`tgl_absen`,`id_company`,`jam_absen`,`id_absensi_masuk`),
  KEY `filter_1` (`id_absensi_masuk`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `istirahat_mulai` */

/*Table structure for table `istirahat_selesai` */

DROP TABLE IF EXISTS `istirahat_selesai`;

CREATE TABLE `istirahat_selesai` (
  `id_istselesai` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 5 digit nomor urut',
  `id_absensi_masuk` varchar(50) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `tgl_absen` date NOT NULL,
  `jam_absen` datetime NOT NULL,
  `lokasi_absen` varchar(255) NOT NULL,
  `timezone` varchar(255) NOT NULL,
  `gmt` varchar(6) NOT NULL,
  `latitude` varchar(30) NOT NULL,
  `longitude` varchar(30) NOT NULL,
  `keterangan` text NOT NULL,
  `foto` text NOT NULL,
  `id_company` varchar(20) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_istselesai`),
  KEY `KEY` (`id_karyawan`,`tgl_absen`,`id_company`,`jam_absen`,`id_absensi_masuk`),
  KEY `filter_1` (`id_absensi_masuk`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `istirahat_selesai` */

/*Table structure for table `jam_kerja` */

DROP TABLE IF EXISTS `jam_kerja`;

CREATE TABLE `jam_kerja` (
  `id_jam_kerja` varchar(20) NOT NULL COMMENT 'id_company + yyyymm + 3 digit nomor urut',
  `libur` int(11) NOT NULL DEFAULT 0 COMMENT '0=masuk; 1=libur',
  `hari` int(11) NOT NULL COMMENT '1=senin; 7=minggu',
  `masuk` time NOT NULL,
  `pulang` time NOT NULL,
  `start_absen_masuk` time NOT NULL,
  `batas_absen_pulang` time NOT NULL,
  `fleksitime` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0:true; 1:false',
  `min_masuk` time NOT NULL DEFAULT '00:00:00',
  `max_masuk` time NOT NULL DEFAULT '00:00:00',
  `jml_jamkerja` smallint(2) NOT NULL DEFAULT 8,
  `id_cabang` varchar(20) NOT NULL,
  `id_company` varchar(20) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  PRIMARY KEY (`id_jam_kerja`),
  KEY `jadwal_kerja` (`hari`,`id_company`,`id_cabang`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `jam_kerja` */

insert  into `jam_kerja`(`id_jam_kerja`,`libur`,`hari`,`masuk`,`pulang`,`start_absen_masuk`,`batas_absen_pulang`,`fleksitime`,`min_masuk`,`max_masuk`,`jml_jamkerja`,`id_cabang`,`id_company`,`tgl_input`,`user_input`,`tgl_update`,`user_update`) values 
('C202508001202403001',0,1,'08:00:00','17:00:00','07:00:00','23:59:59','0','00:00:00','00:00:00',8,'C202508001202403001','C202508001','2025-08-19 09:19:17','','0000-00-00 00:00:00',''),
('C202508001202403002',0,2,'08:00:00','17:00:00','07:00:00','23:59:59','0','00:00:00','00:00:00',8,'C202508001202403001','C202508001','2025-08-19 09:19:17','','0000-00-00 00:00:00',''),
('C202508001202403003',0,3,'08:00:00','17:00:00','07:00:00','23:59:59','0','00:00:00','00:00:00',8,'C202508001202403001','C202508001','2025-08-19 09:19:17','','0000-00-00 00:00:00',''),
('C202508001202403004',0,4,'08:00:00','17:00:00','07:00:00','23:59:59','0','00:00:00','00:00:00',8,'C202508001202403001','C202508001','2025-08-19 09:19:17','','0000-00-00 00:00:00',''),
('C202508001202403005',0,5,'08:00:00','17:00:00','07:00:00','23:59:59','0','00:00:00','00:00:00',8,'C202508001202403001','C202508001','2025-08-19 09:19:17','','0000-00-00 00:00:00',''),
('C202508001202403006',1,6,'00:00:00','00:00:00','00:00:00','00:00:00','0','00:00:00','00:00:00',0,'C202508001202403001','C202508001','2025-08-19 09:19:17','','0000-00-00 00:00:00',''),
('C202508001202403007',1,7,'00:00:00','00:00:00','00:00:00','00:00:00','0','00:00:00','00:00:00',0,'C202508001202403001','C202508001','2025-08-19 09:19:17','','0000-00-00 00:00:00',''),
('D202508001202403001',0,1,'08:00:00','17:00:00','07:00:00','23:59:59','0','00:00:00','00:00:00',8,'D202508001202403001','D202508001','2025-08-19 09:19:17','','0000-00-00 00:00:00',''),
('D202508001202403002',0,2,'08:00:00','17:00:00','07:00:00','23:59:59','0','00:00:00','00:00:00',8,'D202508001202403001','D202508001','2025-08-19 09:19:17','','0000-00-00 00:00:00',''),
('D202508001202403003',0,3,'08:00:00','17:00:00','07:00:00','23:59:59','0','00:00:00','00:00:00',8,'D202508001202403001','D202508001','2025-08-19 09:19:17','','0000-00-00 00:00:00',''),
('D202508001202403004',0,4,'08:00:00','17:00:00','07:00:00','23:59:59','0','00:00:00','00:00:00',8,'D202508001202403001','D202508001','2025-08-19 09:19:17','','0000-00-00 00:00:00',''),
('D202508001202403005',1,5,'00:00:00','00:00:00','00:00:00','00:00:00','0','00:00:00','00:00:00',-1,'D202508001202403001','D202508001','2025-08-19 09:19:17','','0000-00-00 00:00:00',''),
('D202508001202403006',1,6,'00:00:00','00:00:00','00:00:00','00:00:00','0','00:00:00','00:00:00',0,'D202508001202403001','D202508001','2025-08-19 09:19:17','','0000-00-00 00:00:00',''),
('D202508001202403007',1,7,'00:00:00','00:00:00','00:00:00','00:00:00','0','00:00:00','00:00:00',0,'D202508001202403001','D202508001','2025-08-19 09:19:17','','0000-00-00 00:00:00','');

/*Table structure for table `jenis_pelanggan` */

DROP TABLE IF EXISTS `jenis_pelanggan`;

CREATE TABLE `jenis_pelanggan` (
  `id` tinyint(4) NOT NULL AUTO_INCREMENT,
  `nama` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `jenis_pelanggan` */

/*Table structure for table `karir_pekerjaan` */

DROP TABLE IF EXISTS `karir_pekerjaan`;

CREATE TABLE `karir_pekerjaan` (
  `id_karir_pekerjaan` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `nomor_surat_keputusan` varchar(250) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `kode_jabatan` varchar(50) NOT NULL,
  `nama_jabatan` varchar(255) NOT NULL,
  `kode_cabang` varchar(50) NOT NULL,
  `nama_cabang` varchar(255) NOT NULL,
  `kode_departemen` varchar(50) NOT NULL,
  `nama_departemen` varchar(255) NOT NULL,
  `tgl_mulai` date NOT NULL,
  `tgl_berakhir` date NOT NULL,
  `status` enum('1','2','3','') NOT NULL COMMENT '1: Kontrak; 2: Tetap; 3: Promosi',
  `keterangan_status` text NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `karir_pekerjaan` */

/*Table structure for table `kep_departemen` */

DROP TABLE IF EXISTS `kep_departemen`;

CREATE TABLE `kep_departemen` (
  `id_kep_departemen` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 3 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL,
  `id_departemen` varchar(50) NOT NULL,
  `id_cabang` varchar(50) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_kep_departemen`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `kep_departemen` */

/*Table structure for table `kpi_approver_p` */

DROP TABLE IF EXISTS `kpi_approver_p`;

CREATE TABLE `kpi_approver_p` (
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `id_atasan` varchar(50) NOT NULL DEFAULT '',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_karyawan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `kpi_approver_p` */

/*Table structure for table `kpi_aspek_bobot_p` */

DROP TABLE IF EXISTS `kpi_aspek_bobot_p`;

CREATE TABLE `kpi_aspek_bobot_p` (
  `id_jabatan` varchar(50) NOT NULL DEFAULT '',
  `bobot_aspek_kinerja` tinyint(50) NOT NULL DEFAULT 0,
  `bobot_aspek_kepribadian` tinyint(2) NOT NULL DEFAULT 0,
  `bobot_aspek_kedisiplinan` tinyint(2) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_jabatan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `kpi_aspek_bobot_p` */

/*Table structure for table `kpi_aspek_kedisiplinan_trx` */

DROP TABLE IF EXISTS `kpi_aspek_kedisiplinan_trx`;

CREATE TABLE `kpi_aspek_kedisiplinan_trx` (
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `tahun` smallint(4) NOT NULL DEFAULT 0,
  `bulan` tinyint(2) NOT NULL DEFAULT 0,
  `jenis` varchar(255) NOT NULL DEFAULT '' COMMENT 'jenis absensi(T, PC, IT, IPC, TAP, A)',
  `jumlah` tinyint(2) NOT NULL DEFAULT 0,
  `bobot` tinyint(2) NOT NULL DEFAULT 0,
  `poin` tinyint(2) NOT NULL DEFAULT 0,
  `skor` decimal(3,2) NOT NULL DEFAULT 0.00,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_karyawan`,`tahun`,`bulan`,`jenis`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `kpi_aspek_kedisiplinan_trx` */

/*Table structure for table `kpi_aspek_kepribadian_m` */

DROP TABLE IF EXISTS `kpi_aspek_kepribadian_m`;

CREATE TABLE `kpi_aspek_kepribadian_m` (
  `id_aspek_kepribadian_m` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '' COMMENT 'id_company + yyyy+mm+3digit',
  `personal_aspek` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '',
  `keterangan` varchar(512) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '',
  `bobot` tinyint(2) NOT NULL DEFAULT 0,
  `id_jabatan` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '0',
  `poin_1` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '',
  `poin_2` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '',
  `poin_3` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '',
  `poin_4` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '',
  `poin_5` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '',
  `no_urut` smallint(3) NOT NULL DEFAULT 0,
  `id_company` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '',
  `user_input` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_aspek_kepribadian_m`)
) ENGINE=InnoDB DEFAULT CHARSET=hp8 COLLATE=hp8_english_ci;

/*Data for the table `kpi_aspek_kepribadian_m` */

/*Table structure for table `kpi_aspek_kepribadian_trx` */

DROP TABLE IF EXISTS `kpi_aspek_kepribadian_trx`;

CREATE TABLE `kpi_aspek_kepribadian_trx` (
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `tahun` smallint(4) NOT NULL DEFAULT 0,
  `bulan` tinyint(2) NOT NULL DEFAULT 0,
  `id_aspek_kepribadian` varchar(50) NOT NULL DEFAULT '',
  `personal_aspek` varchar(255) NOT NULL DEFAULT '',
  `keterangan` varchar(255) NOT NULL DEFAULT '',
  `bobot` tinyint(2) NOT NULL DEFAULT 0,
  `id_jabatan` varchar(50) NOT NULL DEFAULT '',
  `poin_1` varchar(255) NOT NULL DEFAULT '',
  `poin_2` varchar(255) NOT NULL DEFAULT '',
  `poin_3` varchar(255) NOT NULL DEFAULT '',
  `poin_4` varchar(255) NOT NULL DEFAULT '',
  `poin_5` varchar(255) NOT NULL DEFAULT '',
  `no_urut` smallint(3) NOT NULL DEFAULT 0,
  `actual_poin_approval` tinyint(1) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_karyawan`,`tahun`,`bulan`,`id_aspek_kepribadian`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `kpi_aspek_kepribadian_trx` */

/*Table structure for table `kpi_aspek_kinerja_trx` */

DROP TABLE IF EXISTS `kpi_aspek_kinerja_trx`;

CREATE TABLE `kpi_aspek_kinerja_trx` (
  `id_pi_trx` varchar(50) NOT NULL DEFAULT '' COMMENT 'id_company+yyyy+mm+5digit',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `tahun` smallint(4) NOT NULL DEFAULT 0,
  `bulan` tinyint(2) NOT NULL DEFAULT 0,
  `id_object` varchar(50) NOT NULL DEFAULT '',
  `nm_object` varchar(50) NOT NULL DEFAULT '',
  `no_urut_object` smallint(3) NOT NULL DEFAULT 0,
  `nm_aspek_kinerja` text NOT NULL,
  `target` varchar(255) NOT NULL DEFAULT '',
  `bobot` tinyint(3) NOT NULL DEFAULT 0,
  `poin_1` varchar(255) NOT NULL DEFAULT '',
  `poin_2` varchar(255) NOT NULL DEFAULT '',
  `poin_3` varchar(255) NOT NULL DEFAULT '',
  `poin_4` varchar(255) NOT NULL DEFAULT '',
  `poin_5` varchar(255) NOT NULL DEFAULT '',
  `no_urut_aspek_kinerja` smallint(3) NOT NULL DEFAULT 0,
  `actual_poin` tinyint(1) NOT NULL DEFAULT 0,
  `actual_bukti` varchar(255) NOT NULL DEFAULT '',
  `actual_poin_approval` tinyint(1) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_pi_trx`),
  KEY `filter_1` (`id_karyawan`,`tahun`,`bulan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `kpi_aspek_kinerja_trx` */

/*Table structure for table `kpi_kedisiplinan_bobot_m` */

DROP TABLE IF EXISTS `kpi_kedisiplinan_bobot_m`;

CREATE TABLE `kpi_kedisiplinan_bobot_m` (
  `id` varchar(20) NOT NULL DEFAULT '',
  `jenis` enum('T','PC','TAP','A') NOT NULL,
  `bobot` int(3) NOT NULL DEFAULT 0,
  `id_company` varchar(20) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama lengkap',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama lengkap',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `kpi_kedisiplinan_bobot_m` */

/*Table structure for table `kpi_kedisiplinan_poin_m` */

DROP TABLE IF EXISTS `kpi_kedisiplinan_poin_m`;

CREATE TABLE `kpi_kedisiplinan_poin_m` (
  `id_kedisiplinan_poin_m` varchar(50) NOT NULL DEFAULT '0' COMMENT 'id_company+yyyy+mm+4digit_nomor_urut',
  `jenis` enum('T','PC','TAP','A') NOT NULL,
  `batas_bawah` int(11) NOT NULL DEFAULT 0,
  `batas_atas` int(11) NOT NULL DEFAULT 0,
  `poin` int(2) NOT NULL DEFAULT 0,
  `id_company` varchar(20) NOT NULL DEFAULT '',
  `user_input` varchar(150) NOT NULL DEFAULT '' COMMENT 'NIK - Nama Karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(150) NOT NULL DEFAULT '' COMMENT 'NIK - Nama Karyawan',
  `tgl_update` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_kedisiplinan_poin_m`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `kpi_kedisiplinan_poin_m` */

/*Table structure for table `kpi_object_m` */

DROP TABLE IF EXISTS `kpi_object_m`;

CREATE TABLE `kpi_object_m` (
  `id_object_m` varchar(50) NOT NULL DEFAULT '' COMMENT 'id_company + yyyy+mm+3digit',
  `nm_object` varchar(50) NOT NULL DEFAULT '',
  `no_urut` tinyint(4) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_object_m`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `kpi_object_m` */

/*Table structure for table `kpi_performance_grade_m` */

DROP TABLE IF EXISTS `kpi_performance_grade_m`;

CREATE TABLE `kpi_performance_grade_m` (
  `poin` varchar(20) NOT NULL DEFAULT '',
  `grade` enum('A','B','C','D') NOT NULL DEFAULT 'A',
  `remark` varchar(20) NOT NULL DEFAULT '',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`grade`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `kpi_performance_grade_m` */

/*Table structure for table `kpi_periode_actual_p` */

DROP TABLE IF EXISTS `kpi_periode_actual_p`;

CREATE TABLE `kpi_periode_actual_p` (
  `tahun` smallint(4) NOT NULL DEFAULT 0,
  `bulan` tinyint(2) NOT NULL DEFAULT 0,
  `periode_mulai` date NOT NULL DEFAULT '0000-00-00',
  `periode_selesai` date NOT NULL DEFAULT '0000-00-00',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`tahun`,`bulan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `kpi_periode_actual_p` */

/*Table structure for table `kpi_periode_approval_p` */

DROP TABLE IF EXISTS `kpi_periode_approval_p`;

CREATE TABLE `kpi_periode_approval_p` (
  `tahun` smallint(4) NOT NULL DEFAULT 0,
  `bulan` tinyint(2) NOT NULL DEFAULT 0,
  `periode_mulai` date NOT NULL DEFAULT '0000-00-00',
  `periode_selesai` date NOT NULL DEFAULT '0000-00-00',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`tahun`,`bulan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `kpi_periode_approval_p` */

/*Table structure for table `kpi_periode_target_p` */

DROP TABLE IF EXISTS `kpi_periode_target_p`;

CREATE TABLE `kpi_periode_target_p` (
  `tahun` smallint(4) NOT NULL DEFAULT 0,
  `bulan` tinyint(2) NOT NULL DEFAULT 0,
  `periode_mulai` date NOT NULL DEFAULT '0000-00-00',
  `periode_selesai` date NOT NULL DEFAULT '0000-00-00',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`tahun`,`bulan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `kpi_periode_target_p` */

/*Table structure for table `kpi_personal_score_trx` */

DROP TABLE IF EXISTS `kpi_personal_score_trx`;

CREATE TABLE `kpi_personal_score_trx` (
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `tahun` smallint(4) NOT NULL DEFAULT 0,
  `bulan` tinyint(2) NOT NULL DEFAULT 0,
  `aspek_kinerja_nm` varchar(255) NOT NULL DEFAULT '',
  `aspek_kinerja_bobot` tinyint(2) NOT NULL DEFAULT 0,
  `aspek_kinerja_aktual` decimal(3,2) NOT NULL DEFAULT 0.00,
  `aspek_kinerja_skor` decimal(3,2) NOT NULL DEFAULT 0.00,
  `aspek_kepribadian_nm` varchar(255) NOT NULL DEFAULT '',
  `aspek_kepribadian_bobot` tinyint(2) NOT NULL DEFAULT 0,
  `aspek_kepribadian_aktual` decimal(3,2) NOT NULL DEFAULT 0.00,
  `aspek_kepribadian_skor` decimal(3,2) NOT NULL DEFAULT 0.00,
  `aspek_kedisiplinan_nm` varchar(255) NOT NULL DEFAULT '',
  `aspek_kedisiplinan_bobot` tinyint(2) NOT NULL DEFAULT 0,
  `aspek_kedisiplinan_aktual` decimal(3,2) NOT NULL DEFAULT 0.00,
  `aspek_kedisiplinan_skor` decimal(3,2) NOT NULL DEFAULT 0.00,
  `skor_ttl` decimal(3,2) NOT NULL DEFAULT 0.00,
  `skor_predikat` varchar(255) NOT NULL DEFAULT '',
  `grade` text NOT NULL DEFAULT '',
  `remark` varchar(20) NOT NULL DEFAULT '',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_karyawan`,`tahun`,`bulan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `kpi_personal_score_trx` */

/*Table structure for table `kpi_predikat_p` */

DROP TABLE IF EXISTS `kpi_predikat_p`;

CREATE TABLE `kpi_predikat_p` (
  `grade` enum('A','B','C','D') NOT NULL DEFAULT 'A',
  `keterangan` varchar(50) NOT NULL DEFAULT '',
  `batas_bawah` decimal(3,2) NOT NULL DEFAULT 0.00,
  `batas_atas` decimal(3,2) NOT NULL DEFAULT 0.00,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`grade`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `kpi_predikat_p` */

/*Table structure for table `kpi_trx` */

DROP TABLE IF EXISTS `kpi_trx`;

CREATE TABLE `kpi_trx` (
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `tahun` smallint(4) NOT NULL DEFAULT 0,
  `bulan` tinyint(2) NOT NULL DEFAULT 0,
  `status` enum('1','2','3','4','5','6','7','8','9') DEFAULT '5' COMMENT '1=Pengajuan actual, 2=ditolak, 3=cancel, 4=approve actual, 5=draft target, 6=publish target, 7=draft actual, 8=draft approval, 9=diterima bawahan',
  `id_atasan` varchar(50) NOT NULL DEFAULT '',
  `ctt_exiting_role` varchar(255) NOT NULL DEFAULT '',
  `ctt_career_development` varchar(255) NOT NULL DEFAULT '',
  `ctt_diterima` varchar(255) NOT NULL DEFAULT '',
  `tgl_pengajuan` date NOT NULL DEFAULT '0000-00-00',
  `time_pengajuan` time NOT NULL DEFAULT '00:00:00',
  `tgl_approval` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_approval` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_karyawan`,`tahun`,`bulan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `kpi_trx` */

/*Table structure for table `lembur_mulai` */

DROP TABLE IF EXISTS `lembur_mulai`;

CREATE TABLE `lembur_mulai` (
  `id_lemmulai` varchar(50) NOT NULL DEFAULT '' COMMENT 'id_company + yyyymm + 5 digit nomor urut',
  `id_karyawan` varchar(255) NOT NULL DEFAULT '',
  `tgl_absen` date NOT NULL DEFAULT '0000-00-00',
  `jam_absen` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lokasi_absen` varchar(255) NOT NULL DEFAULT '',
  `timezone` varchar(150) NOT NULL DEFAULT '',
  `gmt` varchar(100) NOT NULL DEFAULT '',
  `latitude` varchar(30) NOT NULL DEFAULT '',
  `longitude` varchar(30) NOT NULL DEFAULT '',
  `keterangan` varchar(150) NOT NULL DEFAULT '',
  `foto` varchar(255) NOT NULL DEFAULT '',
  `id_company` varchar(255) NOT NULL DEFAULT '',
  `approve` enum('1','2','3') NOT NULL DEFAULT '1' COMMENT '1=Pengajuan Lembur, 2=Ditolak, 3=Disetujui',
  `status` enum('1','2','3','4') NOT NULL DEFAULT '1' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `approval_spv` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `approval_kedep` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `approval_kacab` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `approval_hrd` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `approval_direksi` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `user_spv` varchar(255) NOT NULL DEFAULT '',
  `user_kedep` varchar(255) NOT NULL DEFAULT '',
  `user_kacab` varchar(255) NOT NULL DEFAULT '',
  `user_hrd` varchar(255) NOT NULL DEFAULT '',
  `user_direksi` varchar(255) NOT NULL DEFAULT '',
  `tgl_apv_spv` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `tgl_apv_kedep` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `tgl_apv_kacab` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `tgl_apv_hrd` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `tgl_apv_direksi` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_lemmulai`,`user_spv`),
  KEY `KEY` (`id_karyawan`,`tgl_absen`,`id_company`,`jam_absen`,`approve`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `lembur_mulai` */

insert  into `lembur_mulai`(`id_lemmulai`,`id_karyawan`,`tgl_absen`,`jam_absen`,`lokasi_absen`,`timezone`,`gmt`,`latitude`,`longitude`,`keterangan`,`foto`,`id_company`,`approve`,`status`,`approval_spv`,`approval_kedep`,`approval_kacab`,`approval_hrd`,`approval_direksi`,`user_spv`,`user_kedep`,`user_kacab`,`user_hrd`,`user_direksi`,`tgl_apv_spv`,`tgl_apv_kedep`,`tgl_apv_kacab`,`tgl_apv_hrd`,`tgl_apv_direksi`,`tgl_input`) values 
('D20250800120250800001','D20250800100003','2025-08-19','2025-08-19 14:35:43','TKI','Asia/Jakarta','+07:00','-7.0765991','110.4164377','','D202508001/absen/lembur_mulai/202508/D2025080010000320250819143543.jpg','D202508001','1','1','0','1','0','0','0','','','','','','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','2025-08-19 14:35:43');

/*Table structure for table `lembur_selesai` */

DROP TABLE IF EXISTS `lembur_selesai`;

CREATE TABLE `lembur_selesai` (
  `id_lemselesai` varchar(50) NOT NULL DEFAULT '' COMMENT 'id_company + yyyymm + 5 digit nomor urut',
  `id_lemmulai` varchar(50) NOT NULL DEFAULT '',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `tgl_absen` date NOT NULL DEFAULT '0000-00-00',
  `jam_absen` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lokasi_absen` varchar(250) NOT NULL DEFAULT '',
  `timezone` varchar(150) NOT NULL DEFAULT '',
  `gmt` varchar(100) NOT NULL DEFAULT '',
  `latitude` varchar(30) NOT NULL DEFAULT '',
  `longitude` varchar(30) NOT NULL DEFAULT '',
  `keterangan` varchar(150) NOT NULL DEFAULT '',
  `foto` varchar(255) NOT NULL DEFAULT '',
  `id_company` varchar(20) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_lemselesai`),
  KEY `lembur_selesai` (`id_karyawan`,`tgl_absen`,`id_company`,`id_lemmulai`),
  KEY `lembur_mulai` (`id_lemmulai`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `lembur_selesai` */

insert  into `lembur_selesai`(`id_lemselesai`,`id_lemmulai`,`id_karyawan`,`tgl_absen`,`jam_absen`,`lokasi_absen`,`timezone`,`gmt`,`latitude`,`longitude`,`keterangan`,`foto`,`id_company`,`tgl_input`) values 
('D20250800120250800001','D20250800120250800001','D20250800100003','2025-08-19','2025-08-19 14:35:56','TKI','Asia/Jakarta','+07:00','-7.0766089','110.4164176','','D202508001/absen/lembur_selesai/202508/D2025080010000320250819143556.jpg','D202508001','2025-08-19 14:35:56');

/*Table structure for table `log_aktivitas` */

DROP TABLE IF EXISTS `log_aktivitas`;

CREATE TABLE `log_aktivitas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `waktu` datetime NOT NULL DEFAULT current_timestamp(),
  `modul` varchar(150) NOT NULL,
  `action` varchar(150) NOT NULL,
  `query` text NOT NULL,
  `id_company` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1396886 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `log_aktivitas` */

insert  into `log_aktivitas`(`id`,`username`,`waktu`,`modul`,`action`,`query`,`id_company`) values 
(1396881,'e_admin','2025-08-19 02:58:19','master_cabang','delete','DELETE FROM `master_cabang`\nWHERE md5(id_cabang) = \'06a459be00830342b1796e7ebded948b\'','C202508001'),
(1396882,'de_admin','2025-08-19 03:34:14','master_karyawan','edit','UPDATE `data_karyawan` SET `nik` = \'00009\', `nama_lengkap` = \'Slamet Baharudin\', `gelar_depan` = \'\', `gelar_belakang` = \'\', `golongan_darah` = \'\', `jenis_kelamin` = \'uknown\', `agama` = \'\', `tempat_lahir` = \'\', `tgl_lahir` = \'1970-01-01\', `alamat_ktp` = \'\', `alamat_domisili` = \'\', `rt` = \'\', `rw` = \'\', `id_kel` = \'\', `id_kec` = \'\', `id_kab` = \'\', `id_prov` = \'\', `kode_pos` = \'\', `telepon` = \'\', `no_ktp` = \'\', `no_bpjs_kes` = \'\', `no_bpjs_tk` = \'\', `jml_anak` = 0, `email` = \'\', `join_date` = \'2024-07-29\', `tgl_aktif_bekerja` = \'2024-07-01\', `tgl_berhenti_bekerja` = \'2024-11-30\', `id_departemen` = \'D202508001202403001\', `id_cabang` = \'D202508001202403001\', `id_jabatan` = \'D202508001202403003\', `supervisi` = \'\', `jatah_cuti` = \'0\', `pendidikan_terakhir` = \'\', `status` = \'1\', `id_company` = \'D202508001\', `foto` = \'D202508001/karyawan/D20250800100009/profil/00009-23cbd522-3cd1-484f-b49c-a30b5db94988.png\'\nWHERE `id_karyawan` = \'D20250800100009\'\nAND `id_company` = \'D202508001\'','D202508001'),
(1396885,'de_admin','2025-08-19 03:34:24','export_karyawan','export','SELECT * FROM data_keluarga WHERE id_karyawan = \'7a75bd9a6b0300636304309a494862e5\' ORDER BY (\n                                                    CASE hub_keluarga\n\n                                                    WHEN \'Ayah\'\n                                                    THEN 1\n\n                                                    WHEN \'Ibu\'\n                                                    THEN 2\n\n                                                    WHEN \'Suami\'\n                                                    THEN 3\n\n                                                    WHEN \'Istri\'\n                                                    THEN 4\n\n                                                    WHEN \'Anak\'\n                                                    THEN 5\n\n                                                    WHEN \'Saudara Kandung\'\n                                                    THEN 6\n\n                                                    END\n							) ASC','D202508001');

/*Table structure for table `log_notifikasi` */

DROP TABLE IF EXISTS `log_notifikasi`;

CREATE TABLE `log_notifikasi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `waktu` datetime NOT NULL,
  `modul` varchar(50) NOT NULL,
  `query` text NOT NULL,
  `id_karyawan` varchar(20) NOT NULL,
  `status` int(11) NOT NULL,
  `id_company` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `log_notifikasi` (`id`,`id_karyawan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `log_notifikasi` */

/*Table structure for table `log_notifikasi_trial` */

DROP TABLE IF EXISTS `log_notifikasi_trial`;

CREATE TABLE `log_notifikasi_trial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_company` varchar(20) NOT NULL COMMENT 'master_company.id_company',
  `id_paket` varchar(2) NOT NULL DEFAULT '2',
  `nama_company` varchar(100) NOT NULL COMMENT 'master_company.nama',
  `nama_customer` varchar(100) NOT NULL COMMENT 'master_customer.nama',
  `email` varchar(100) NOT NULL COMMENT 'master_customer.email',
  `telepon` varchar(50) NOT NULL COMMENT 'master_customer.telp',
  `feedback` enum('-','extend','positif','negatif') NOT NULL DEFAULT '-',
  `feedback_hplus8` enum('-','extend','positif','negatif') DEFAULT '-',
  `catatan` varchar(300) DEFAULT '-',
  `waktu` datetime NOT NULL COMMENT 'YYYY-mm-dd HH:ii:ss',
  `waktu_hplus8` date DEFAULT NULL,
  `id_wablas` char(50) NOT NULL COMMENT 'id dari hasil pengirima pesan pada API wablas',
  `id_wablas_hplus8` char(50) DEFAULT NULL,
  `status` enum('-','0','1','2','3','4','5') NOT NULL DEFAULT '-' COMMENT '-: belum ada action, 0: gagal terkirim ke dewa, 1: terkirim ke dewa, 2: sent(centang 1), 3: delivered(centang 2), 4: read(centang 2 biru), 5: failed',
  `status_hplus8` enum('-','0','1','2','3','4','5') NOT NULL DEFAULT '-' COMMENT '-: belum ada action, 0: gagal terkirim ke dewa, 1: terkirim ke dewa, 2: sent(centang 1), 3: delivered(centang 2), 4: read(centang 2 biru), 5: failed',
  `tanggal_update` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14829 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci COMMENT='menyimpan list perusahaan pengguna paket absenku trial yang sudah dikirim notifikasi wablas h-2 masa layanan berakhir';

/*Data for the table `log_notifikasi_trial` */

/*Table structure for table `log_otp` */

DROP TABLE IF EXISTS `log_otp`;

CREATE TABLE `log_otp` (
  `message_id` varchar(20) NOT NULL,
  `device_id` varchar(40) NOT NULL,
  `phone_number` varchar(15) DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `response` text DEFAULT NULL,
  `tgl_input` datetime NOT NULL DEFAULT current_timestamp(),
  `last_row` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`message_id`,`status`,`tgl_input`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `log_otp` */

/*Table structure for table `m_pengaduan` */

DROP TABLE IF EXISTS `m_pengaduan`;

CREATE TABLE `m_pengaduan` (
  `id_pengaduan` int(11) NOT NULL AUTO_INCREMENT,
  `id_kategori` int(11) NOT NULL,
  `id_topik` int(11) NOT NULL,
  `id_wali` varchar(50) NOT NULL,
  `content` text NOT NULL,
  `date` datetime NOT NULL,
  `id_company` varchar(20) DEFAULT '1',
  `flag` enum('0','1') NOT NULL DEFAULT '1' COMMENT '0 = karyawan; 1 = admin',
  `cek` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0 = belum di buka; 1 = sudah di buka',
  PRIMARY KEY (`id_pengaduan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `m_pengaduan` */

/*Table structure for table `m_version` */

DROP TABLE IF EXISTS `m_version`;

CREATE TABLE `m_version` (
  `current_version` varchar(10) NOT NULL,
  `descr` text NOT NULL,
  `cons_apps` enum('1','0') DEFAULT NULL COMMENT '0:skip update; 1: wajib update',
  KEY `current_version` (`current_version`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `m_version` */

/*Table structure for table `master_cabang` */

DROP TABLE IF EXISTS `master_cabang`;

CREATE TABLE `master_cabang` (
  `id_cabang` varchar(50) NOT NULL COMMENT 'id_company + yyyymmm + 3 digit nomor urut',
  `kode` varchar(50) NOT NULL,
  `nama` varchar(50) NOT NULL,
  `flag` enum('1','2') NOT NULL DEFAULT '1' COMMENT '1 = pusat, 2 = cabang',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  PRIMARY KEY (`id_cabang`),
  KEY `id` (`id_company`,`kode`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `master_cabang` */

insert  into `master_cabang`(`id_cabang`,`kode`,`nama`,`flag`,`id_company`,`tgl_input`,`user_input`,`tgl_update`,`user_update`) values 
('C202508001202403001','PST','PUSAT','1','C202508001','2024-06-25 15:26:58','','0000-00-00 00:00:00',''),
('D202508001202403001','PST','PUSAT','1','D202508001','2024-06-25 15:27:03','','0000-00-00 00:00:00','');

/*Table structure for table `master_company` */

DROP TABLE IF EXISTS `master_company`;

CREATE TABLE `master_company` (
  `id_company` varchar(20) NOT NULL COMMENT 'tahun + 5 digit nomor urut',
  `nama` varchar(100) NOT NULL,
  `deskripsi` text NOT NULL,
  `alamat` varchar(255) NOT NULL,
  `negara` varchar(50) NOT NULL DEFAULT 'indonesia',
  `url_logo` varchar(255) NOT NULL,
  `url_icon` varchar(255) NOT NULL,
  `themes` int(11) NOT NULL,
  `id_customer` int(11) NOT NULL,
  `id_tb_paket` int(11) NOT NULL DEFAULT 5,
  `zona_waktu` int(11) NOT NULL DEFAULT 1,
  `flag` int(11) NOT NULL DEFAULT 0 COMMENT '0:Tidak Aktif, 1;Aktif',
  `payroll` int(11) NOT NULL DEFAULT 0,
  `flag1` enum('0','1') NOT NULL DEFAULT '0',
  `id_induk` bigint(20) unsigned DEFAULT NULL,
  `custom_jumlah_karyawan` int(11) NOT NULL DEFAULT 0,
  `lock_device` enum('0','1') NOT NULL DEFAULT '0',
  `lock_lokasi` enum('0','1') NOT NULL DEFAULT '1',
  `lock_facerecognition` enum('0','1') NOT NULL DEFAULT '0',
  `jenis_perusahaan` tinyint(4) NOT NULL COMMENT '1 = Perusahaan;2 = Hotel;3 = Warnet/Game Center;4 = Sekolah / Perguruan Tinggi;5 = Dinas / Pemerintahan;6 = Personal;7 = Lainnya;',
  `npwp` varchar(20) NOT NULL,
  `jenis_registrasi` enum('generik','custom') NOT NULL DEFAULT 'generik',
  `skema_pembayaran` enum('reguler','bayar_langsung','bonus_+1','per_user') NOT NULL DEFAULT 'reguler',
  `source` varchar(255) DEFAULT NULL,
  `landingpage` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `id_marketing` int(11) DEFAULT NULL,
  `id_mitra_marketing` tinyint(4) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id_company`),
  KEY `KEY` (`nama`,`id_tb_paket`,`id_customer`,`id_company`),
  KEY `filter 1` (`id_customer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `master_company` */

insert  into `master_company`(`id_company`,`nama`,`deskripsi`,`alamat`,`negara`,`url_logo`,`url_icon`,`themes`,`id_customer`,`id_tb_paket`,`zona_waktu`,`flag`,`payroll`,`flag1`,`id_induk`,`custom_jumlah_karyawan`,`lock_device`,`lock_lokasi`,`lock_facerecognition`,`jenis_perusahaan`,`npwp`,`jenis_registrasi`,`skema_pembayaran`,`source`,`landingpage`,`url`,`id_marketing`,`id_mitra_marketing`) values 
('C202508001','developer','','','indonesia','','',0,202403002,202403002,1,1,0,'0',0,0,'0','1','0',0,'','generik','reguler','','','',0,0),
('D202508001','Absen Multi','ya','disini','indonesia','D202508001/logo-perusahaan/D202508001-69cd8fe1-5a39-4d08-86a2-76adf7c4b99b.png','',0,202403002,202403002,1,1,0,'0',0,0,'0','1','0',0,'','generik','reguler','','','',0,0);

/*Table structure for table `master_customer` */

DROP TABLE IF EXISTS `master_customer`;

CREATE TABLE `master_customer` (
  `id_customer` varchar(15) NOT NULL COMMENT 'tahun + 5 digit nomor urut',
  `nama` varchar(100) NOT NULL,
  `propinsi` varchar(255) DEFAULT NULL,
  `kota` varchar(255) DEFAULT NULL,
  `alamat` varchar(255) NOT NULL,
  `tgl_lahir` date NOT NULL,
  `email` varchar(100) NOT NULL,
  `telp` varchar(50) NOT NULL,
  `jml_kry_regist` mediumint(5) NOT NULL DEFAULT 0 COMMENT 'jumlah karyawan dalam perusahaan saat isi form registrasi',
  `id_tujuan` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'relasi tabel tujuan_menggunakan',
  `login` int(11) NOT NULL DEFAULT 1,
  `hash` varchar(11) NOT NULL,
  PRIMARY KEY (`id_customer`),
  KEY `filter 1` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `master_customer` */

insert  into `master_customer`(`id_customer`,`nama`,`propinsi`,`kota`,`alamat`,`tgl_lahir`,`email`,`telp`,`jml_kry_regist`,`id_tujuan`,`login`,`hash`) values 
('202403002','Panggah','','','','2018-01-01','','',0,0,1,'561Q8T');

/*Table structure for table `master_departemen` */

DROP TABLE IF EXISTS `master_departemen`;

CREATE TABLE `master_departemen` (
  `id_departemen` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 3 digit number',
  `kode` varchar(50) NOT NULL,
  `nama` varchar(225) NOT NULL,
  `jenis` enum('HR','Finance','','') DEFAULT NULL,
  `id_company` varchar(20) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_update` varchar(100) DEFAULT '' COMMENT 'nik - nama karyawan',
  PRIMARY KEY (`id_departemen`),
  KEY `KEY` (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `master_departemen` */

insert  into `master_departemen`(`id_departemen`,`kode`,`nama`,`jenis`,`id_company`,`tgl_input`,`user_input`,`tgl_update`,`user_update`) values 
('C202508001202403001','OFC','Office','','C202508001','2023-03-29 15:32:50','','0000-00-00 00:00:00',''),
('D202508001202403001','OFC','Office','','D202508001','2023-03-29 15:32:50','','0000-00-00 00:00:00','');

/*Table structure for table `master_grade` */

DROP TABLE IF EXISTS `master_grade`;

CREATE TABLE `master_grade` (
  `id_grade` int(11) NOT NULL AUTO_INCREMENT,
  `grade` varchar(100) DEFAULT NULL,
  `gaji` varchar(9) DEFAULT NULL,
  `id_company` varchar(20) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id_grade`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `master_grade` */

/*Table structure for table `master_jabatan` */

DROP TABLE IF EXISTS `master_jabatan`;

CREATE TABLE `master_jabatan` (
  `id_jabatan` varchar(20) NOT NULL COMMENT 'id_company + yyyymm + 3 digit nomor urut',
  `kode_jabatan` varchar(15) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `level_user` smallint(2) NOT NULL,
  `id_company` varchar(20) NOT NULL DEFAULT '1',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  PRIMARY KEY (`id_jabatan`),
  KEY `indexy` (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `master_jabatan` */

insert  into `master_jabatan`(`id_jabatan`,`kode_jabatan`,`nama`,`level_user`,`id_company`,`tgl_input`,`user_input`,`tgl_update`,`user_update`) values 
('C202508001202403001','HR','Admin HR',1,'C202508001','2023-03-29 15:32:50','','0000-00-00 00:00:00',''),
('C202508001202403002','KEDEP','KEPALA DEPARTEMEN',2,'C202508001','2023-03-31 15:05:40','','0000-00-00 00:00:00',''),
('C202508001202403003','STAFF','Staff',3,'C202508001','2023-03-29 15:32:50','','0000-00-00 00:00:00',''),
('C202508001202403004','DIR','Direksi',4,'C202508001','2023-10-27 14:28:18','','0000-00-00 00:00:00',''),
('C202508001202403005','KACAB','Kepala Klien',5,'C202508001','2023-10-27 14:28:18','','2025-08-19 03:19:46','00001 - Administrator'),
('C202508001202403007','SPV','Supervisi',7,'C202508001','2023-10-27 14:28:18','','0000-00-00 00:00:00',''),
('C202508001202503001','ADM-FNC','Finance',6,'C202508001','2025-03-07 09:46:05','','2025-08-19 03:33:22','00001 - Administrator'),
('D202508001202403001','HR','Admin HR',1,'D202508001','2023-03-29 15:32:50','','0000-00-00 00:00:00',''),
('D202508001202403002','KEDEP','KEPALA DEPARTEMEN',2,'D202508001','2023-03-31 15:05:40','','0000-00-00 00:00:00',''),
('D202508001202403003','STAFF','Staff',3,'D202508001','2023-03-29 15:32:50','','0000-00-00 00:00:00',''),
('D202508001202403004','DIR','Direksi',4,'D202508001','2023-10-27 14:28:18','','0000-00-00 00:00:00',''),
('D202508001202403005','KACAB','Kepala Cabang',5,'D202508001','2023-10-27 14:28:18','','0000-00-00 00:00:00',''),
('D202508001202403007','SPV','Supervisi',7,'D202508001','2023-10-27 14:28:18','','0000-00-00 00:00:00',''),
('D202508001202503001','ADM-FNC','Finance',6,'D202508001','2025-03-07 09:44:21','','0000-00-00 00:00:00','');

/*Table structure for table `master_jenis_izin` */

DROP TABLE IF EXISTS `master_jenis_izin`;

CREATE TABLE `master_jenis_izin` (
  `id_jenis_izin` varchar(20) NOT NULL COMMENT 'id_company + yyyymm + 3 digit nomor urut',
  `kode_izin` varchar(5) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `jenis_izin` enum('sakit','izin','cuti') NOT NULL DEFAULT 'cuti',
  `max_izin` varchar(3) NOT NULL COMMENT 'satuan hari',
  `back_date` int(3) NOT NULL DEFAULT 0 COMMENT 'minimal pengajuan izin, satuan hari',
  `flag` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0; tidak mengurangi cuti tahunan, 1; mengurangi cuti tahunan',
  `flag_kalender` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0: berdasarkan hari kerja; 1: berdasarkan kalender',
  `flag_file` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0: tidak wajib upload file; 1: wajib upload file',
  `id_company` varchar(9) NOT NULL DEFAULT '1',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  PRIMARY KEY (`id_jenis_izin`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `master_jenis_izin` */

insert  into `master_jenis_izin`(`id_jenis_izin`,`kode_izin`,`nama`,`jenis_izin`,`max_izin`,`back_date`,`flag`,`flag_kalender`,`flag_file`,`id_company`,`tgl_input`,`user_input`,`tgl_update`,`user_update`) values 
('C202508001202403001','C','Cuti','cuti','3',0,'1','0','0','C20250700','2024-03-14 06:10:04','','0000-00-00 00:00:00',''),
('C202508001202403002','I','Izin','izin','3',0,'0','0','0','C20250700','2024-03-14 06:10:27','','0000-00-00 00:00:00',''),
('C202508001202403003','S','Sakit','sakit','',0,'0','0','0','C20250700','2024-03-14 06:10:36','','0000-00-00 00:00:00',''),
('D202401001202402001','C','Cuti','cuti','3',0,'1','0','0','D20250700','2024-02-19 06:04:53','','0000-00-00 00:00:00',''),
('D202401001202402002','I','Izin','izin','2',0,'0','0','1','D20250700','2024-02-19 06:10:09','','0000-00-00 00:00:00',''),
('D202401001202402003','S','Sakit','sakit','3',0,'0','0','1','D20250700','2024-02-19 06:10:20','','0000-00-00 00:00:00','');

/*Table structure for table `master_kecamatan` */

DROP TABLE IF EXISTS `master_kecamatan`;

CREATE TABLE `master_kecamatan` (
  `id_kecamatan` int(6) NOT NULL,
  `nama` varchar(150) DEFAULT NULL,
  `id_kota` int(4) DEFAULT NULL,
  PRIMARY KEY (`id_kecamatan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `master_kecamatan` */

/*Table structure for table `master_kelurahan` */

DROP TABLE IF EXISTS `master_kelurahan`;

CREATE TABLE `master_kelurahan` (
  `id_kelurahan` varchar(10) NOT NULL,
  `nama` varchar(150) DEFAULT NULL,
  `id_kecamatan` int(6) DEFAULT NULL,
  PRIMARY KEY (`id_kelurahan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `master_kelurahan` */

/*Table structure for table `master_komponen_paket` */

DROP TABLE IF EXISTS `master_komponen_paket`;

CREATE TABLE `master_komponen_paket` (
  `id_komponen_paket` varchar(50) NOT NULL COMMENT 'id_company + 5 digit nomor urut',
  `kode_komponen` varchar(50) NOT NULL,
  `nama_komponen` varchar(255) NOT NULL,
  `flag` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0:tidak aktfi; 1:aktif',
  `id_company` varchar(20) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_komponen_paket`),
  KEY `KEY` (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `master_komponen_paket` */

/*Table structure for table `master_kota` */

DROP TABLE IF EXISTS `master_kota`;

CREATE TABLE `master_kota` (
  `id_kota` int(4) NOT NULL,
  `nama` varchar(150) DEFAULT NULL,
  `id_prov` int(2) DEFAULT NULL,
  PRIMARY KEY (`id_kota`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `master_kota` */

/*Table structure for table `master_paket` */

DROP TABLE IF EXISTS `master_paket`;

CREATE TABLE `master_paket` (
  `id_paket` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(100) NOT NULL,
  `tarif` float NOT NULL,
  `komponen` text NOT NULL,
  `komponen_web` varchar(255) NOT NULL COMMENT '1= Master Cabang, 2= Master Departemen, 3= Master jabatan, 4= Master lokasi, 5= Shift (master shift dan jadwal shift), 6= Izin (master izin, p aproval izin, laporan izin), 7= Lembur (master lembur, p aproval lembur, laporan lembur), 8= Aktivitas, 9= Informasi Gaji, 10= Reimbursement, 11= Payroll',
  `komponen_mobile` varchar(255) NOT NULL COMMENT '1=izin, 2=lembur, 3=shift, 4=remburse, 5=info gaji, 6=aktivitas, 7=berita, 8=payroll',
  `max_karyawan` int(11) NOT NULL DEFAULT 0,
  `max_sales` int(11) NOT NULL DEFAULT 0,
  `max_cabang` varchar(250) NOT NULL DEFAULT '-',
  `urutan` tinyint(3) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id_paket`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `master_paket` */

/*Table structure for table `master_plan` */

DROP TABLE IF EXISTS `master_plan`;

CREATE TABLE `master_plan` (
  `id_plan` int(11) NOT NULL AUTO_INCREMENT,
  `id_customer` int(11) NOT NULL,
  `status` int(11) NOT NULL COMMENT '2=trial;3=lunas/aktif;4=request aktivasi;5=perpanjangan;6=request upgrade;',
  `tgl_aktif` date NOT NULL,
  `tgl_berakhir` date NOT NULL,
  `tgl_daftar` date DEFAULT NULL,
  `masa_layanan` int(11) NOT NULL DEFAULT 1 COMMENT '1=lifetime;2=30hari;3=6bulan;4=12bulan, 5+bulan = per bulan',
  `max_cabang` varchar(10) NOT NULL DEFAULT '~',
  `max_karyawan` varchar(10) NOT NULL DEFAULT '~',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_plan`),
  KEY `master_plan` (`id_company`,`id_customer`,`tgl_daftar`),
  KEY `filter 1` (`id_company`)
) ENGINE=InnoDB AUTO_INCREMENT=120487 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `master_plan` */

insert  into `master_plan`(`id_plan`,`id_customer`,`status`,`tgl_aktif`,`tgl_berakhir`,`tgl_daftar`,`masa_layanan`,`max_cabang`,`max_karyawan`,`id_company`,`tgl_input`) values 
(1,202403002,3,'2026-08-19','2025-09-30','2025-08-19',2,'~','~','C202508001','2024-03-13 09:16:01'),
(2,202403002,3,'2026-08-19','2025-09-30','2025-08-19',2,'~','~','D202508001','2024-03-13 09:16:04');

/*Table structure for table `master_provinsi` */

DROP TABLE IF EXISTS `master_provinsi`;

CREATE TABLE `master_provinsi` (
  `id_prov` int(2) NOT NULL,
  `nama` varchar(150) DEFAULT NULL,
  PRIMARY KEY (`id_prov`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `master_provinsi` */

/*Table structure for table `master_shift` */

DROP TABLE IF EXISTS `master_shift`;

CREATE TABLE `master_shift` (
  `id_master_shift` varchar(20) NOT NULL COMMENT 'id_company + yyyymm + 2 digit nomor urut',
  `kode_shift` varchar(50) NOT NULL,
  `nama_shift` varchar(20) NOT NULL,
  `jam_masuk` time NOT NULL,
  `jam_pulang` time NOT NULL,
  `flag_jam_pulang` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0=hari yang sama, 1=lewat hari',
  `start_absen_masuk` time DEFAULT NULL,
  `batas_absen_pulang` time DEFAULT NULL,
  `flag_batas_absen_pulang` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0=hari yang sama, 1=lewat hari',
  `libur` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0=Masuk Kerja; 1=Libur',
  `id_cabang` varchar(20) NOT NULL,
  `id_company` varchar(20) NOT NULL DEFAULT '1',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_update` varchar(100) DEFAULT '' COMMENT 'nik - nama karyawan',
  PRIMARY KEY (`id_master_shift`),
  KEY `KEY` (`kode_shift`,`id_company`,`jam_masuk`,`id_cabang`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `master_shift` */

insert  into `master_shift`(`id_master_shift`,`kode_shift`,`nama_shift`,`jam_masuk`,`jam_pulang`,`flag_jam_pulang`,`start_absen_masuk`,`batas_absen_pulang`,`flag_batas_absen_pulang`,`libur`,`id_cabang`,`id_company`,`tgl_input`,`user_input`,`tgl_update`,`user_update`) values 
('D202508001202403001','S1','Shift 1 Pagi','10:00:00','18:00:00','0','09:00:00','23:59:00','0','0','D202508001202403001','D202508001','2025-04-29 14:21:00','','0000-00-00 00:00:00',''),
('D202508001202504002','S2','Shift 2 Siang','14:00:00','22:00:00','0','13:30:00','23:59:00','0','0','D202508001202403001','D202508001','2025-04-29 14:21:24','','0000-00-00 00:00:00',''),
('D202508001202504003','SM','Shift Marketing','11:00:00','19:00:00','0','10:00:00','23:59:00','0','0','D202508001202403001','D202508001','2025-04-29 14:22:28','','0000-00-00 00:00:00',''),
('D202508001202504004','OFF','OFF','00:00:00','00:00:00','0','00:00:00','00:00:00','0','1','D202508001202403001','D202508001','2025-04-29 14:44:28','','0000-00-00 00:00:00',''),
('D202508001202504005','SF','Shift Full','10:00:00','22:00:00','0','09:00:00','23:59:00','0','0','D202508001202403001','D202508001','2025-04-30 16:34:28','','0000-00-00 00:00:00',''),
('D202508001202504006','T34','Teknisi 34','14:00:00','22:00:00','0','12:00:00','23:59:00','0','0','D202508001202403001','D202508001','2025-04-30 19:03:21','','0000-00-00 00:00:00',''),
('D202508001202505001','SM2','Shift Marketing 2','12:00:00','20:00:00','0','11:00:00','23:59:00','0','0','D202508001202403001','D202508001','2025-05-01 13:49:14','','0000-00-00 00:00:00',''),
('D202508001202505002','OB','Office Boy','09:00:00','18:00:00','0','08:00:00','23:59:00','0','0','D202508001202403001','D202508001','2025-05-29 15:39:47','','0000-00-00 00:00:00','');

/*Table structure for table `monev_aktif` */

DROP TABLE IF EXISTS `monev_aktif`;

CREATE TABLE `monev_aktif` (
  `id_plan` int(11) NOT NULL,
  `id_customer` int(11) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `status` int(11) NOT NULL COMMENT '2=trial; 3=lunas/aktif; 4=request aktivasi; 5=perpanjangan',
  `flag` enum('0','1') NOT NULL DEFAULT '1' COMMENT '1=ON, 0=OFF',
  `tgl_aktif` date NOT NULL,
  `tgl_berakhir` date NOT NULL,
  `id_company` bigint(20) NOT NULL,
  `tgl_daftar` date DEFAULT NULL,
  `masa_layanan` int(11) NOT NULL DEFAULT 1 COMMENT '1=lifetime;2=30hari;3=6bulan;4=12bulan'
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `monev_aktif` */

/*Table structure for table `mutasi_karyawan` */

DROP TABLE IF EXISTS `mutasi_karyawan`;

CREATE TABLE `mutasi_karyawan` (
  `id_mutasi` int(11) NOT NULL AUTO_INCREMENT,
  `id_karyawan` int(11) DEFAULT NULL,
  `tgl_mutasi` date DEFAULT NULL,
  `dari_departemen` varchar(225) DEFAULT NULL,
  `dari_jabatan` varchar(225) DEFAULT NULL,
  `ke_departemen` varchar(225) DEFAULT NULL,
  `ke_jabatan` varchar(225) DEFAULT NULL,
  PRIMARY KEY (`id_mutasi`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `mutasi_karyawan` */

/*Table structure for table `nonaktif` */

DROP TABLE IF EXISTS `nonaktif`;

CREATE TABLE `nonaktif` (
  `nik` varchar(9) DEFAULT NULL,
  `status` enum('7') NOT NULL DEFAULT '7',
  `id_company` varchar(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

/*Data for the table `nonaktif` */

/*Table structure for table `notif_absensi_p` */

DROP TABLE IF EXISTS `notif_absensi_p`;

CREATE TABLE `notif_absensi_p` (
  `absensi_masuk_sebelum_flag` enum('0','1') NOT NULL DEFAULT '0',
  `absensi_masuk_sebelum_menit` int(2) NOT NULL DEFAULT 0,
  `absensi_masuk_setelah_flag` enum('0','1') NOT NULL DEFAULT '0',
  `absensi_masuk_setelah_menit` int(2) NOT NULL DEFAULT 0,
  `absensi_pulang_setelah_flag` enum('0','1') NOT NULL DEFAULT '0',
  `absensi_pulang_setelah_menit` int(2) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `notif_absensi_p` */

/*Table structure for table `notif_berita` */

DROP TABLE IF EXISTS `notif_berita`;

CREATE TABLE `notif_berita` (
  `jenis` enum('berita','pengumuman') NOT NULL DEFAULT 'berita',
  `id_ref` varchar(50) NOT NULL DEFAULT '',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `tgl_baca` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `id_company` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`jenis`,`id_ref`,`id_karyawan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `notif_berita` */

/*Table structure for table `notif_data` */

DROP TABLE IF EXISTS `notif_data`;

CREATE TABLE `notif_data` (
  `id_notif` varchar(50) NOT NULL DEFAULT '',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '' COMMENT 'id karyawan yang menerima notif',
  `jenis` enum('izin','lembur','shift','slip gaji') NOT NULL DEFAULT 'izin',
  `id_ref` varchar(50) NOT NULL DEFAULT '',
  `rute` enum('detail_izin_saya','detail_izin_pegawai','detail_lembur_saya','detail_lembur_pegawai','detail_shift','slip_gaji') NOT NULL DEFAULT 'detail_izin_saya',
  `ket_notif` varchar(255) NOT NULL DEFAULT '',
  `ket_notif_id` varchar(255) NOT NULL DEFAULT '',
  `ket_notif_en` varchar(255) NOT NULL DEFAULT '',
  `tgl_notif` timestamp NOT NULL DEFAULT current_timestamp(),
  `flag_baca` enum('0','1') NOT NULL DEFAULT '0',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_notif`),
  KEY `id_karyawan` (`id_karyawan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `notif_data` */

insert  into `notif_data`(`id_notif`,`id_karyawan`,`jenis`,`id_ref`,`rute`,`ket_notif`,`ket_notif_id`,`ket_notif_en`,`tgl_notif`,`flag_baca`,`id_company`) values 
('D20250800120250800001','D20250800100002','lembur','D20250800120250800001','detail_lembur_pegawai','Example Staff mengajukan lembur pada 2025-08-19','Example Staff mengajukan lembur pada 2025-08-19','Example Staff mengajukan lembur pada 2025-08-19','2025-08-19 14:35:56','0','D202508001');

/*Table structure for table `notif_izin_lembur` */

DROP TABLE IF EXISTS `notif_izin_lembur`;

CREATE TABLE `notif_izin_lembur` (
  `id_notif` varchar(50) NOT NULL DEFAULT '',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '' COMMENT 'id karyawan yang menerima notif',
  `jenis` enum('izin','lembur','shift') NOT NULL DEFAULT 'izin',
  `id_ref` varchar(50) NOT NULL DEFAULT '',
  `rute` enum('detail_izin_saya','detail_izin_pegawai','detail_lembur_saya','detail_lembur_pegawai','detail_shift') NOT NULL DEFAULT 'detail_izin_saya',
  `ket_notif` varchar(255) NOT NULL DEFAULT '',
  `tgl_notif` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `flag_baca` enum('0','1') NOT NULL DEFAULT '0',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_notif`),
  KEY `id_karyawan` (`id_karyawan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `notif_izin_lembur` */

/*Table structure for table `notif_kepegawaian` */

DROP TABLE IF EXISTS `notif_kepegawaian`;

CREATE TABLE `notif_kepegawaian` (
  `id_notif` varchar(50) NOT NULL DEFAULT '',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '' COMMENT 'id karyawan yang menerima notif',
  `id_karyawan_pengajuan` varchar(50) NOT NULL DEFAULT '' COMMENT 'id karyawan yang mengajukan',
  `jenis` enum('pengajuan','approval','revisi') NOT NULL DEFAULT 'approval',
  `menu` enum('data_diri','data_keluarga','data_pendidikan','pengalaman_kerja','sertifikat','kelengkapan') NOT NULL DEFAULT 'data_diri',
  `id_ref` varchar(50) NOT NULL DEFAULT '',
  `rute` enum('detail_data_diri','detail_data_keluarga','detail_data_pendidikan','detail_data_pengalaman_kerja','detail_data_sertifikat','detail_data_kelengkapan_file') NOT NULL DEFAULT 'detail_data_diri',
  `ket_notif` varchar(255) NOT NULL DEFAULT '',
  `ket_notif_id` varchar(255) NOT NULL,
  `ket_notif_en` varchar(255) NOT NULL,
  `tgl_notif` timestamp NOT NULL DEFAULT current_timestamp(),
  `flag_baca` enum('0','1') NOT NULL DEFAULT '0',
  `action` enum('1','2','3') NOT NULL DEFAULT '1' COMMENT '1=Tambah; 2=Edit; 3=Hapus;',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_notif`),
  KEY `id_karyawan` (`id_karyawan`),
  KEY `THIRD` (`id_karyawan_pengajuan`,`id_company`,`jenis`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `notif_kepegawaian` */

/*Table structure for table `notif_kpi` */

DROP TABLE IF EXISTS `notif_kpi`;

CREATE TABLE `notif_kpi` (
  `id_notif` varchar(50) NOT NULL DEFAULT '',
  `id_karyawan` varchar(50) NOT NULL COMMENT 'id karyawan yang menerima notif',
  `id_karyawan_kpi` varchar(50) NOT NULL COMMENT 'id karyawan yang menerima notif',
  `jenis` enum('kpi') NOT NULL DEFAULT 'kpi',
  `tahun` smallint(4) NOT NULL DEFAULT 0,
  `bulan` tinyint(2) NOT NULL DEFAULT 0,
  `status` enum('1','2','3','4','5','6','7','8','9') DEFAULT '5' COMMENT '1=Pengajuan actual, 2=ditolak, 3=cancel, 4=approve actual, 5=draft target, 6=publish target, 7=draft actual, 8=draft approval, 9=diterima bawahan',
  `nama_lengkap` varchar(255) NOT NULL DEFAULT '',
  `rute` enum('detail_pengajuan_kpi_saya','pengajuan_kpi_approval_team','detail_approval_kpi_saya','detail_kpi_approval_diterima_team') NOT NULL DEFAULT 'detail_pengajuan_kpi_saya',
  `ket_notif` varchar(255) NOT NULL DEFAULT '',
  `tgl_notif` timestamp NOT NULL DEFAULT current_timestamp(),
  `flag_baca` enum('0','1') NOT NULL DEFAULT '0',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_notif`),
  KEY `id_karyawan` (`id_karyawan`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `notif_kpi` */

/*Table structure for table `otp` */

DROP TABLE IF EXISTS `otp`;

CREATE TABLE `otp` (
  `telepon` varchar(15) NOT NULL,
  `waktu` int(11) NOT NULL,
  `kode_otp` mediumint(9) NOT NULL,
  PRIMARY KEY (`telepon`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `otp` */

/*Table structure for table `p_adm_absensi` */

DROP TABLE IF EXISTS `p_adm_absensi`;

CREATE TABLE `p_adm_absensi` (
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_karyawan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `p_adm_absensi` */

/*Table structure for table `p_adm_payroll` */

DROP TABLE IF EXISTS `p_adm_payroll`;

CREATE TABLE `p_adm_payroll` (
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(255) NOT NULL DEFAULT '255' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_karyawan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `p_adm_payroll` */

/*Table structure for table `p_adm_reimbursement` */

DROP TABLE IF EXISTS `p_adm_reimbursement`;

CREATE TABLE `p_adm_reimbursement` (
  `id` varchar(50) NOT NULL COMMENT 'id_company + yyyymmm + 3 digit nomor urut',
  `id_karyawan` varchar(255) NOT NULL,
  `id_cabang` varchar(255) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `p_adm_reimbursement` */

/*Table structure for table `p_approval_izin` */

DROP TABLE IF EXISTS `p_approval_izin`;

CREATE TABLE `p_approval_izin` (
  `id` varchar(50) NOT NULL COMMENT 'id_company + yyyymmm + 3 digit nomor urut',
  `id_cabang` varchar(50) NOT NULL,
  `level_user` varchar(50) NOT NULL,
  `level_approval` varchar(50) NOT NULL COMMENT 'level approval bisa diisi lebih dari satu dengan pemisah tanda koma',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_update` varchar(100) DEFAULT '' COMMENT 'nik - nama karyawan',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `p_approval_izin` */

insert  into `p_approval_izin`(`id`,`id_cabang`,`level_user`,`level_approval`,`id_company`,`tgl_input`,`user_input`,`tgl_update`,`user_update`) values 
('C202403001202403001','C202508001202403001','3','7,2,1','C202508001','2023-03-29 15:32:50','','2024-08-06 12:03:46',''),
('C202403001202403002','C202508001202403001','7','2,1','C202508001','2023-03-29 15:32:50','','2024-08-06 12:03:46',''),
('C202403001202403003','C202508001202403001','2','5,1','C202508001','2023-03-29 15:32:50','','2024-08-06 12:03:46',''),
('C202403001202403004','C202508001202403001','5','1','C202508001','2023-03-29 15:32:50','','2024-08-06 12:03:46',''),
('D202403001202403001','D202508001202403001','3','2,1','D202508001','2023-12-14 09:23:57','','2024-08-08 09:21:07',''),
('D202403001202403002','D202508001202403001','7','2,1','D202508001','2023-12-14 09:23:57','','2024-08-08 09:21:07',''),
('D202403001202403003','D202508001202403001','2','5,1','D202508001','2023-12-14 09:23:57','','2024-08-08 09:21:07',''),
('D202403001202403004','D202508001202403001','5','1','D202508001','2023-12-14 09:23:57','','2024-08-08 09:21:07','');

/*Table structure for table `p_approval_lembur` */

DROP TABLE IF EXISTS `p_approval_lembur`;

CREATE TABLE `p_approval_lembur` (
  `id` varchar(50) NOT NULL COMMENT 'id_company + yyyymmm + 3 digit nomor urut',
  `id_cabang` varchar(50) NOT NULL,
  `level_user` varchar(50) NOT NULL,
  `level_approval` varchar(50) NOT NULL COMMENT 'level approval bisa diisi lebih dari satu dengan pemisah tanda koma',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  PRIMARY KEY (`id`),
  KEY `KEY` (`id_cabang`,`level_user`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `p_approval_lembur` */

insert  into `p_approval_lembur`(`id`,`id_cabang`,`level_user`,`level_approval`,`id_company`,`tgl_input`,`user_input`,`tgl_update`,`user_update`) values 
('C202403001202403001','C202508001202403001','3','2','C202508001','2023-03-29 15:32:50','','2024-08-06 12:03:46',''),
('C202403001202403002','C202508001202403001','7','2','C202508001','2023-03-29 15:32:50','','2024-08-06 12:03:46',''),
('C202403001202403003','C202508001202403001','2','5','C202508001','2023-03-29 15:32:50','','2024-08-06 12:03:46',''),
('C202403001202403004','C202508001202403001','5','4','C202508001','2023-03-29 15:32:50','','2024-08-06 12:03:46',''),
('D202403001202403001','D202508001202403001','3','2','D202508001','2023-12-14 09:23:57','','2024-08-08 09:30:18',''),
('D202403001202403002','D202508001202403001','7','2','D202508001','2023-12-14 09:23:57','','2024-08-08 09:30:18',''),
('D202403001202403003','D202508001202403001','2','5','D202508001','2023-12-14 09:23:57','','2024-08-08 09:30:18',''),
('D202403001202403004','D202508001202403001','5','4','D202508001','2023-12-14 09:23:57','','2024-08-08 09:30:18','');

/*Table structure for table `p_approval_reimbursement` */

DROP TABLE IF EXISTS `p_approval_reimbursement`;

CREATE TABLE `p_approval_reimbursement` (
  `id` varchar(50) NOT NULL COMMENT 'id_company + yyyymmm + 3 digit nomor urut',
  `id_cabang` varchar(50) NOT NULL,
  `level_user` varchar(50) NOT NULL,
  `level_approval` varchar(50) NOT NULL COMMENT 'level approval bisa diisi lebih dari satu dengan pemisah tanda koma',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `p_approval_reimbursement` */

insert  into `p_approval_reimbursement`(`id`,`id_cabang`,`level_user`,`level_approval`,`id_company`,`tgl_input`,`user_input`,`tgl_update`,`user_update`) values 
('C202403001202403001','C202508001202403001','3','7,2,1','C202508001','2023-03-29 15:32:50','','2024-08-06 12:03:46',''),
('C202403001202403002','C202508001202403001','7','2,1','C202508001','2023-03-29 15:32:50','','2024-08-06 12:03:46',''),
('C202403001202403003','C202508001202403001','2','5,1','C202508001','2023-03-29 15:32:50','','2024-08-06 12:03:46',''),
('C202403001202403004','C202508001202403001','5','1','C202508001','2023-03-29 15:32:50','','2024-08-06 12:03:46',''),
('D202403001202403001','D202508001202403001','3','2,1','D202508001','2023-12-14 09:23:57','','2024-08-06 12:03:46',''),
('D202403001202403002','D202508001202403001','7','2,1','D202508001','2023-12-14 09:23:57','','2024-08-06 12:03:46',''),
('D202403001202403003','D202508001202403001','2','5,1','D202508001','2023-12-14 09:23:57','','2024-08-06 12:03:46',''),
('D202403001202403004','D202508001202403001','5','1','D202508001','2023-12-14 09:23:57','','2024-08-06 12:03:46','');

/*Table structure for table `p_atasan` */

DROP TABLE IF EXISTS `p_atasan`;

CREATE TABLE `p_atasan` (
  `id` varchar(50) NOT NULL COMMENT 'id_company + yyyymmm + 3 digit nomor urut',
  `id_cabang` varchar(50) NOT NULL,
  `id_departemen` varchar(50) NOT NULL,
  `id_jabatan` varchar(50) NOT NULL,
  `atasan` varchar(50) NOT NULL COMMENT 'Atasan adalah id jabatan yg levelnya sama dengan id_jabatan',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `p_atasan` */

/*Table structure for table `p_jenis_klien` */

DROP TABLE IF EXISTS `p_jenis_klien`;

CREATE TABLE `p_jenis_klien` (
  `id_jenis_klien` varchar(11) NOT NULL,
  `nama_jenis_klien` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `p_jenis_klien` */

/*Table structure for table `p_kacab` */

DROP TABLE IF EXISTS `p_kacab`;

CREATE TABLE `p_kacab` (
  `id` varchar(50) NOT NULL COMMENT 'id_company + yyyymmm + 3 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL,
  `id_cabang` varchar(50) NOT NULL,
  `flag` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0=cabang tambahan, 1=cabang utama',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tgl_update` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `p_kacab` */

insert  into `p_kacab`(`id`,`id_karyawan`,`id_cabang`,`flag`,`id_company`,`tgl_input`,`tgl_update`) values 
('C202508001202403001','C20250800100005','C202508001202403001','1','C202508001','2024-03-14 06:13:50','2024-06-25 15:34:19'),
('D202508001202403001','D20250800100005','D202508001202403001','1','D202508001','2024-03-13 10:25:50','2024-06-25 15:34:22');

/*Table structure for table `p_kedep` */

DROP TABLE IF EXISTS `p_kedep`;

CREATE TABLE `p_kedep` (
  `id` varchar(50) NOT NULL COMMENT 'id_company + yyyymmm + 3 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL,
  `id_cabang` varchar(50) NOT NULL,
  `id_departemen` varchar(50) NOT NULL,
  `flag` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0=departemen tambahan, 1= departemen utama',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tgl_update` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `id_karyawan` (`id_karyawan`,`id_departemen`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `p_kedep` */

insert  into `p_kedep`(`id`,`id_karyawan`,`id_cabang`,`id_departemen`,`flag`,`id_company`,`tgl_input`,`tgl_update`) values 
('C202508001202403001','C20250800100002','C202508001202403001','C202508001202403001','1','C202508001','2024-03-14 06:11:36','2024-06-25 15:33:49'),
('D202508001202403001','D20250800100002','D202508001202403001','D202508001202403001','1','D202508001','2024-03-13 10:21:50','2024-06-25 15:33:53');

/*Table structure for table `p_notification` */

DROP TABLE IF EXISTS `p_notification`;

CREATE TABLE `p_notification` (
  `id_notification` varchar(50) NOT NULL COMMENT 'id_company + yyyymmm + 3 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL,
  `notif_hrd` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0= tidak dapat notif, 1=dapat notif',
  `notif_finance` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0= tidak dapat notif, 1=dapat notif',
  `id_company` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id_notification`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `p_notification` */

/*Table structure for table `patroli_jadwal` */

DROP TABLE IF EXISTS `patroli_jadwal`;

CREATE TABLE `patroli_jadwal` (
  `id` varchar(50) NOT NULL DEFAULT '' COMMENT 'id_company + yymm + 3 digit nomor urut',
  `id_cabang` varchar(50) NOT NULL DEFAULT '',
  `nm_jadwal` varchar(100) NOT NULL DEFAULT '',
  `min_absen` time NOT NULL DEFAULT '00:00:00',
  `max_absen` time NOT NULL DEFAULT '00:00:00',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama lengkap',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama lengkap',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `patroli_jadwal` */

/*Table structure for table `patroli_m` */

DROP TABLE IF EXISTS `patroli_m`;

CREATE TABLE `patroli_m` (
  `id` varchar(50) NOT NULL DEFAULT '' COMMENT 'id_company + yymm + 3 digit nomor urut',
  `id_cabang` varchar(50) NOT NULL DEFAULT '',
  `nm_lokasi` varchar(100) NOT NULL DEFAULT '',
  `path` varchar(255) NOT NULL DEFAULT '',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama lengkap',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama lengkap',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `patroli_m` */

/*Table structure for table `patroli_trx` */

DROP TABLE IF EXISTS `patroli_trx`;

CREATE TABLE `patroli_trx` (
  `id_patroli` varchar(50) NOT NULL DEFAULT '' COMMENT 'id_company + yyyymm + 4digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `id_company` varchar(50) NOT NULL,
  `tgl_cp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `nm_jadwal` varchar(100) NOT NULL DEFAULT '',
  `min_absen` time NOT NULL DEFAULT '00:00:00',
  `max_absen` time NOT NULL DEFAULT '00:00:00',
  `nm_lokasi` varchar(100) NOT NULL DEFAULT '',
  `nm_qr` varchar(255) NOT NULL,
  `timezone` varchar(100) NOT NULL DEFAULT '',
  `gmt` varchar(6) NOT NULL DEFAULT '',
  `latitude` varchar(30) NOT NULL DEFAULT '',
  `longitude` varchar(30) NOT NULL DEFAULT '',
  `path_foto` varchar(100) NOT NULL DEFAULT '',
  `ket_pat` varchar(100) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama lengkap',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama lengkap',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_patroli`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `patroli_trx` */

/*Table structure for table `payroll_bpjs_kes_comp_p` */

DROP TABLE IF EXISTS `payroll_bpjs_kes_comp_p`;

CREATE TABLE `payroll_bpjs_kes_comp_p` (
  `id_company` varchar(20) NOT NULL DEFAULT '',
  `flag` enum('0','1') NOT NULL DEFAULT '0',
  `tunj_perus` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT '4.00',
  `pot_kry` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT '1.00',
  `pot_tambahan_kry` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT '1.00',
  `user_input` varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

/*Data for the table `payroll_bpjs_kes_comp_p` */

/*Table structure for table `payroll_bpjs_kes_config` */

DROP TABLE IF EXISTS `payroll_bpjs_kes_config`;

CREATE TABLE `payroll_bpjs_kes_config` (
  `tunj_perus` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT '4.00',
  `pot_kry` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT '1.00',
  `pot_tambahan_kry` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT '1.00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

/*Data for the table `payroll_bpjs_kes_config` */

/*Table structure for table `payroll_bpjs_kes_m` */

DROP TABLE IF EXISTS `payroll_bpjs_kes_m`;

CREATE TABLE `payroll_bpjs_kes_m` (
  `id_karyawan` varchar(50) NOT NULL,
  `flag` enum('0','1') NOT NULL DEFAULT '0',
  `jml_anak` tinyint(2) NOT NULL DEFAULT 0,
  `ttl_gaji_terdaftar` int(11) NOT NULL DEFAULT 0 COMMENT 'total gaji yang didatarkan',
  `tunj_perus_persen` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT '4.00',
  `tunj_perus_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `pot_kry_persen` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT '1.00',
  `pot_kry_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `id_company` varchar(20) NOT NULL DEFAULT '',
  `user_input` varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_karyawan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

/*Data for the table `payroll_bpjs_kes_m` */

/*Table structure for table `payroll_bpjs_kes_temp` */

DROP TABLE IF EXISTS `payroll_bpjs_kes_temp`;

CREATE TABLE `payroll_bpjs_kes_temp` (
  `id_karyawan` varchar(50) NOT NULL,
  `flag` enum('0','1') NOT NULL DEFAULT '0',
  `jml_anak` tinyint(2) NOT NULL DEFAULT 0,
  `ttl_gaji_terdaftar` int(11) NOT NULL DEFAULT 0 COMMENT 'total gaji yang didatarkan',
  `tunj_perus_persen` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT '4.00',
  `tunj_perus_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `pot_kry_persen` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT '1.00',
  `pot_kry_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `id_company` varchar(20) NOT NULL DEFAULT '',
  `user_input` varchar(150) NOT NULL DEFAULT '' COMMENT 'id karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `flag_import` enum('1','2','3','4') NOT NULL DEFAULT '2' COMMENT '1:data valid, 2:data tidak valid, 3=data sudah ada, 4=data berhasil di simpan',
  PRIMARY KEY (`id_karyawan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_bpjs_kes_temp` */

/*Table structure for table `payroll_bpjs_kes_trx` */

DROP TABLE IF EXISTS `payroll_bpjs_kes_trx`;

CREATE TABLE `payroll_bpjs_kes_trx` (
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `periode` varchar(7) NOT NULL DEFAULT '',
  `id_cabang` varchar(50) NOT NULL DEFAULT '',
  `id_departemen` varchar(50) NOT NULL DEFAULT '',
  `ttl_gaji_terdaftar` int(11) NOT NULL DEFAULT 0 COMMENT 'total gaji yang didatarkan',
  `tunj_perus_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `tunj_perus_rp` decimal(11,2) NOT NULL DEFAULT 0.00,
  `pot_kry_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `pot_kry_rp` decimal(11,2) NOT NULL DEFAULT 0.00,
  `id_company` varchar(20) NOT NULL DEFAULT '1',
  `user_input` varchar(50) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(50) NOT NULL DEFAULT '',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_karyawan`,`periode`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_bpjs_kes_trx` */

/*Table structure for table `payroll_bpjs_komp_gaji_trx` */

DROP TABLE IF EXISTS `payroll_bpjs_komp_gaji_trx`;

CREATE TABLE `payroll_bpjs_komp_gaji_trx` (
  `id_karyawan` varchar(50) NOT NULL,
  `periode` varchar(7) NOT NULL DEFAULT '',
  `id_company` varchar(20) NOT NULL DEFAULT '1',
  `id_item` varchar(50) NOT NULL COMMENT 'id_company+yymm+5digit nomor urut',
  `tipe` enum('gapok','tunj_tetap') NOT NULL DEFAULT 'gapok',
  `nm_komponen` varchar(255) NOT NULL DEFAULT '',
  `nominal` int(11) NOT NULL DEFAULT 0,
  `user_input` varchar(50) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(50) NOT NULL DEFAULT '',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_karyawan`,`periode`,`id_company`,`id_item`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_bpjs_komp_gaji_trx` */

/*Table structure for table `payroll_bpjs_tk_comp_p` */

DROP TABLE IF EXISTS `payroll_bpjs_tk_comp_p`;

CREATE TABLE `payroll_bpjs_tk_comp_p` (
  `id_company` varchar(20) NOT NULL DEFAULT '1',
  `tunj_jht_perus` decimal(3,2) NOT NULL DEFAULT 0.00,
  `pot_jht_kry` decimal(3,2) NOT NULL DEFAULT 0.00,
  `flag_jht` enum('0','1') NOT NULL DEFAULT '0',
  `tunj_jkk` decimal(3,2) NOT NULL DEFAULT 0.00,
  `flag_jkk` enum('0','1') NOT NULL DEFAULT '0',
  `tunj_jp_perus` decimal(3,2) NOT NULL DEFAULT 0.00,
  `pot_jp_kry` decimal(3,2) NOT NULL DEFAULT 0.00,
  `flag_jp` enum('0','1') NOT NULL DEFAULT '0',
  `tunj_jkm` decimal(3,2) NOT NULL DEFAULT 0.00,
  `flag_jkm` enum('0','1') NOT NULL DEFAULT '0',
  `user_input` varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

/*Data for the table `payroll_bpjs_tk_comp_p` */

/*Table structure for table `payroll_bpjs_tk_config` */

DROP TABLE IF EXISTS `payroll_bpjs_tk_config`;

CREATE TABLE `payroll_bpjs_tk_config` (
  `tunj_jht_perus` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT 'default 3.70',
  `pot_jht_kry` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT 'default 2.00',
  `tunj_jkk` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT 'default 0.24',
  `tunj_jp_perus` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT 'default 2.00',
  `pot_jp_kry` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT 'default 1.00',
  `tunj_jkm` decimal(3,2) NOT NULL DEFAULT 0.00 COMMENT 'default 3.00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

/*Data for the table `payroll_bpjs_tk_config` */

/*Table structure for table `payroll_bpjs_tk_m` */

DROP TABLE IF EXISTS `payroll_bpjs_tk_m`;

CREATE TABLE `payroll_bpjs_tk_m` (
  `id_karyawan` varchar(50) NOT NULL,
  `ttl_gaji_terdaftar` int(11) NOT NULL DEFAULT 0 COMMENT 'total gaji yang didatarkan',
  `tunj_jht_perus_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `tunj_jht_perus_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `pot_jht_kry_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `pot_jht_kry_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `flag_jht` enum('0','1') NOT NULL DEFAULT '0',
  `tunj_jkk_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `tunj_jkk_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `flag_jkk` enum('0','1') NOT NULL DEFAULT '0',
  `tunj_jp_perus_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `tunj_jp_perus_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `pot_jp_kry_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `pot_jp_kry_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `flag_jp` enum('0','1') NOT NULL DEFAULT '0',
  `tunj_jkm_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `tunj_jkm_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `flag_jkm` enum('0','1') NOT NULL DEFAULT '0',
  `ttl_pot_karyawan` decimal(9,2) NOT NULL DEFAULT 0.00,
  `ttl_tunj_dibiayai_perus` decimal(9,2) NOT NULL DEFAULT 0.00,
  `id_company` varchar(20) NOT NULL DEFAULT '1',
  `user_input` varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_karyawan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

/*Data for the table `payroll_bpjs_tk_m` */

/*Table structure for table `payroll_bpjs_tk_temp` */

DROP TABLE IF EXISTS `payroll_bpjs_tk_temp`;

CREATE TABLE `payroll_bpjs_tk_temp` (
  `id_karyawan` varchar(50) NOT NULL,
  `ttl_gaji_terdaftar` int(11) NOT NULL DEFAULT 0 COMMENT 'total gaji yang didatarkan',
  `tunj_jht_perus_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `tunj_jht_perus_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `pot_jht_kry_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `pot_jht_kry_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `flag_jht` enum('0','1') NOT NULL DEFAULT '0',
  `tunj_jkk_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `tunj_jkk_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `flag_jkk` enum('0','1') NOT NULL DEFAULT '0',
  `tunj_jp_perus_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `tunj_jp_perus_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `pot_jp_kry_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `pot_jp_kry_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `flag_jp` enum('0','1') NOT NULL DEFAULT '0',
  `tunj_jkm_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `tunj_jkm_rp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `flag_jkm` enum('0','1') NOT NULL DEFAULT '0',
  `ttl_pot_karyawan` decimal(9,2) NOT NULL DEFAULT 0.00,
  `ttl_tunj_dibiayai_perus` decimal(9,2) NOT NULL DEFAULT 0.00,
  `id_company` varchar(20) NOT NULL DEFAULT '1',
  `user_input` varchar(150) NOT NULL DEFAULT '' COMMENT 'id karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_karyawan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_bpjs_tk_temp` */

/*Table structure for table `payroll_bpjs_tk_trx` */

DROP TABLE IF EXISTS `payroll_bpjs_tk_trx`;

CREATE TABLE `payroll_bpjs_tk_trx` (
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `periode` varchar(7) NOT NULL DEFAULT '' COMMENT 'format yyyy-mm',
  `id_cabang` varchar(50) NOT NULL DEFAULT '',
  `id_departemen` varchar(50) NOT NULL DEFAULT '',
  `ttl_gaji_terdaftar` int(11) NOT NULL DEFAULT 0 COMMENT 'total gaji yang didatarkan',
  `tunj_jht_perus_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `tunj_jht_perus_rp` decimal(11,2) NOT NULL DEFAULT 0.00,
  `pot_jht_kry_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `pot_jht_kry_rp` decimal(11,2) NOT NULL DEFAULT 0.00,
  `flag_jht` enum('0','1') NOT NULL DEFAULT '0',
  `tunj_jkk_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `tunj_jkk_rp` decimal(11,2) NOT NULL DEFAULT 0.00,
  `flag_jkk` enum('0','1') NOT NULL DEFAULT '0',
  `tunj_jp_perus_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `tunj_jp_perus_rp` decimal(11,2) NOT NULL DEFAULT 0.00,
  `pot_jp_kry_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `pot_jp_kry_rp` decimal(11,2) NOT NULL DEFAULT 0.00,
  `flag_jp` enum('0','1') NOT NULL DEFAULT '0',
  `tunj_jkm_persen` decimal(3,2) NOT NULL DEFAULT 0.00,
  `tunj_jkm_rp` decimal(11,2) NOT NULL DEFAULT 0.00,
  `flag_jkm` enum('0','1') NOT NULL DEFAULT '0',
  `id_company` varchar(20) NOT NULL DEFAULT '1',
  `user_input` varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(150) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_karyawan`,`periode`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

/*Data for the table `payroll_bpjs_tk_trx` */

/*Table structure for table `payroll_gaji_trx` */

DROP TABLE IF EXISTS `payroll_gaji_trx`;

CREATE TABLE `payroll_gaji_trx` (
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `nik` varchar(50) NOT NULL DEFAULT '',
  `nm_karyawan` varchar(50) NOT NULL DEFAULT '',
  `id_jabatan` varchar(20) NOT NULL DEFAULT '',
  `kd_jabatan` varchar(50) NOT NULL DEFAULT '',
  `nm_jabatan` varchar(50) NOT NULL DEFAULT '',
  `id_cabang` varchar(50) NOT NULL DEFAULT '',
  `kd_cabang` varchar(50) NOT NULL DEFAULT '',
  `nm_cabang` varchar(50) NOT NULL DEFAULT '',
  `id_departemen` varchar(50) NOT NULL DEFAULT '',
  `kd_departemen` varchar(50) NOT NULL DEFAULT '',
  `nm_departemen` varchar(50) NOT NULL DEFAULT '',
  `periode` varchar(7) NOT NULL DEFAULT '',
  `tgl_mulai` date NOT NULL DEFAULT '0000-00-00',
  `tgl_selesai` date NOT NULL DEFAULT '0000-00-00',
  `gapok` int(11) NOT NULL DEFAULT 0,
  `tunj_kehadiran_ttl` int(11) NOT NULL DEFAULT 0,
  `tunj_tetap_ttl` int(11) NOT NULL DEFAULT 0,
  `tunj_tdk_tetap_ttl` int(11) NOT NULL DEFAULT 0,
  `ttl_tunjangan` int(11) NOT NULL DEFAULT 0 COMMENT 'tunj tetap+tunj tdk tetap+tunj kehadiran',
  `lembur_menit` int(11) NOT NULL DEFAULT 0 COMMENT 'sudah tidak terpakai di payroll terbaru',
  `lembur_per_jam` int(11) NOT NULL DEFAULT 0 COMMENT 'sudah tidak terpakai di payroll terbaru',
  `lembur_rp` int(11) NOT NULL DEFAULT 0,
  `pot_tetap_ttl` int(11) NOT NULL DEFAULT 0,
  `pot_tdk_tetap_ttl` int(11) NOT NULL DEFAULT 0,
  `pot_absensi_pc` int(11) NOT NULL DEFAULT 0,
  `pot_absensi_t` int(11) NOT NULL DEFAULT 0,
  `pot_absensi_a` int(11) NOT NULL DEFAULT 0,
  `pot_absensi_tap` int(11) NOT NULL DEFAULT 0,
  `pot_absensi_mak` int(11) NOT NULL DEFAULT 0,
  `pot_absensi_actual` int(11) NOT NULL DEFAULT 0,
  `pot_absensi_acc` int(11) NOT NULL DEFAULT 0,
  `tunj_bpjs_kes` decimal(11,0) NOT NULL DEFAULT 0,
  `pot_bpjs_kes` decimal(11,2) NOT NULL DEFAULT 0.00,
  `tunj_bpjs_tk` decimal(11,2) NOT NULL DEFAULT 0.00,
  `pot_bpjs_tk` decimal(11,2) NOT NULL DEFAULT 0.00,
  `pot_pph21` int(11) NOT NULL DEFAULT 0,
  `ttl_potongan` decimal(13,2) NOT NULL DEFAULT 0.00,
  `ttl_tunj_dibiayai_perus` decimal(11,2) NOT NULL DEFAULT 0.00 COMMENT 'tunj bpjs kes+tunj bpjs tk',
  `thp` decimal(13,2) NOT NULL DEFAULT 0.00,
  `bank_atas_nama` varchar(255) NOT NULL DEFAULT '',
  `bank_rek` varchar(30) NOT NULL DEFAULT '',
  `bank_nama` varchar(30) NOT NULL DEFAULT '',
  `no_ktp` varchar(20) NOT NULL DEFAULT '',
  `tanggungan` varchar(5) NOT NULL DEFAULT '' COMMENT 'relasi tabel ptkp',
  `npwp` varchar(20) NOT NULL DEFAULT '',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(150) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(150) NOT NULL DEFAULT '',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_flag` enum('0','1') NOT NULL DEFAULT '0',
  `publish_user` varchar(150) NOT NULL DEFAULT '',
  `publish_sch` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_tgl` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_company`,`id_karyawan`,`periode`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_gaji_trx` */

/*Table structure for table `payroll_gapok_log` */

DROP TABLE IF EXISTS `payroll_gapok_log`;

CREATE TABLE `payroll_gapok_log` (
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `action` enum('tambah','edit','hapus') NOT NULL DEFAULT 'tambah',
  `nominal_lama` int(11) NOT NULL DEFAULT 0,
  `nominal_baru` int(11) NOT NULL DEFAULT 0,
  `user_input` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_company`,`id_karyawan`,`tgl_input`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_gapok_log` */

/*Table structure for table `payroll_gapok_m` */

DROP TABLE IF EXISTS `payroll_gapok_m`;

CREATE TABLE `payroll_gapok_m` (
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `nominal` int(11) NOT NULL DEFAULT 0,
  `lembur_per_jam` int(11) NOT NULL DEFAULT 0 COMMENT 'sudah tidak terpakai di payroll terbaru',
  `flag_pot_absensi` enum('0','1') NOT NULL DEFAULT '0',
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_company`,`id_karyawan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_gapok_m` */

/*Table structure for table `payroll_gapok_m_temp` */

DROP TABLE IF EXISTS `payroll_gapok_m_temp`;

CREATE TABLE `payroll_gapok_m_temp` (
  `id_karyawan` varchar(255) NOT NULL,
  `id_cabang` varchar(50) NOT NULL COMMENT 'id_company + yyyymmm + 3 digit nomor urut',
  `lembur_per_jam` int(11) NOT NULL DEFAULT 0 COMMENT 'sudah tidak terpakai di payroll terbaru',
  `flag_pot_absensi` enum('0','1') NOT NULL DEFAULT '0',
  `nominal` int(11) NOT NULL DEFAULT 0,
  `flag` enum('1','2','3','4') NOT NULL DEFAULT '2' COMMENT '1:data valid, 2:data tidak valid, 3=data sudah ada, 4=data berhasil di simpan',
  `user_input` varchar(255) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_karyawan`,`id_company`,`user_input`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_gapok_m_temp` */

/*Table structure for table `payroll_gapok_trx` */

DROP TABLE IF EXISTS `payroll_gapok_trx`;

CREATE TABLE `payroll_gapok_trx` (
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `periode` varchar(7) NOT NULL DEFAULT '0000-00',
  `nominal` int(11) NOT NULL DEFAULT 0,
  `flag_pot_absensi` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_company`,`id_karyawan`,`periode`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_gapok_trx` */

/*Table structure for table `payroll_komponen_m` */

DROP TABLE IF EXISTS `payroll_komponen_m`;

CREATE TABLE `payroll_komponen_m` (
  `id_item` varchar(50) NOT NULL DEFAULT '' COMMENT 'id_company+yymm+5digit nomor urut',
  `jenis_komponen` enum('tetap','tidak tetap') NOT NULL DEFAULT 'tetap',
  `jenis_master` enum('pendapatan','potongan','kehadiran') NOT NULL DEFAULT 'pendapatan' COMMENT '1:pendapatan; 2: potongan',
  `nm_komponen` varchar(255) NOT NULL DEFAULT '',
  `flag_persentase_gapok` enum('0','1') NOT NULL DEFAULT '0',
  `gapok_persen` decimal(4,2) NOT NULL DEFAULT 0.00,
  `flag_bpjs` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pph21` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pot_absensi` enum('0','1') NOT NULL DEFAULT '0',
  `flag_upah_lembur` enum('0','1') NOT NULL DEFAULT '0',
  `flag_cuti` enum('0','1') NOT NULL DEFAULT '0',
  `flag_izin` enum('0','1') NOT NULL DEFAULT '0',
  `flag_sakit` enum('0','1') NOT NULL DEFAULT '0',
  `no_urut` int(11) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(50) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(50) NOT NULL DEFAULT '',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_item`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_komponen_m` */

/*Table structure for table `payroll_komponen_trx` */

DROP TABLE IF EXISTS `payroll_komponen_trx`;

CREATE TABLE `payroll_komponen_trx` (
  `id_item` varchar(50) NOT NULL DEFAULT '' COMMENT 'id master komponen',
  `periode` varchar(7) NOT NULL DEFAULT '0000-00',
  `jenis_komponen` enum('tetap','tidak tetap') NOT NULL DEFAULT 'tetap',
  `jenis_master` enum('pendapatan','potongan','kehadiran') NOT NULL DEFAULT 'pendapatan' COMMENT '1:pendapatan; 2: potongan',
  `nm_komponen` varchar(255) NOT NULL DEFAULT '',
  `flag_persentase_gapok` enum('0','1') NOT NULL DEFAULT '0',
  `gapok_persen` decimal(4,2) NOT NULL DEFAULT 0.00,
  `flag_bpjs` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pph21` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pot_absensi` enum('0','1') NOT NULL DEFAULT '0',
  `flag_upah_lembur` enum('0','1') NOT NULL DEFAULT '0',
  `no_urut` int(11) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(50) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_item`,`periode`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_komponen_trx` */

/*Table structure for table `payroll_lembur_m` */

DROP TABLE IF EXISTS `payroll_lembur_m`;

CREATE TABLE `payroll_lembur_m` (
  `id_lembur_m` varchar(150) NOT NULL DEFAULT '' COMMENT 'id_company + Y + 4 digit angka',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `lembur_hari_kerja` varchar(150) NOT NULL DEFAULT '' COMMENT 'id_lembur dari table payroll_lembur_p',
  `lembur_libur_off` varchar(150) NOT NULL DEFAULT '' COMMENT 'id_lembur dari table payroll_lembur_p',
  `lembur_libur_nasional` varchar(150) NOT NULL DEFAULT '' COMMENT 'id_lembur dari table payroll_lembur_p',
  `lembur_libur_khusus` varchar(150) NOT NULL DEFAULT '' COMMENT 'id_lembur dari table payroll_lembur_p',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_lembur_m`),
  KEY `filter 1` (`id_company`,`id_lembur_m`),
  KEY `filter 2` (`id_company`,`id_karyawan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_lembur_m` */

/*Table structure for table `payroll_lembur_m_temp` */

DROP TABLE IF EXISTS `payroll_lembur_m_temp`;

CREATE TABLE `payroll_lembur_m_temp` (
  `id_lembur_m_temp` varchar(150) NOT NULL DEFAULT '' COMMENT 'id_company + Y + 4 digit angka',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `lembur_hari_kerja` varchar(150) NOT NULL DEFAULT '' COMMENT 'id_lembur dari table payroll_lembur_p',
  `lembur_libur_off` varchar(150) NOT NULL DEFAULT '' COMMENT 'id_lembur dari table payroll_lembur_p',
  `lembur_libur_nasional` varchar(150) NOT NULL DEFAULT '' COMMENT 'id_lembur dari table payroll_lembur_p',
  `lembur_libur_khusus` varchar(150) NOT NULL DEFAULT '' COMMENT 'id_lembur dari table payroll_lembur_p',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_lembur_m_temp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_lembur_m_temp` */

/*Table structure for table `payroll_lembur_p` */

DROP TABLE IF EXISTS `payroll_lembur_p`;

CREATE TABLE `payroll_lembur_p` (
  `id_lembur_p` varchar(150) NOT NULL DEFAULT '' COMMENT 'id_company + Y + 4 digit angka',
  `kode` varchar(50) NOT NULL DEFAULT '',
  `keterangan` varchar(255) NOT NULL DEFAULT '',
  `flag_rounding` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0=mengabaikan master_lembur_pembulatan, 1=wajib isi master_lembur_pembulatan minimal 1 data',
  `jenis_upah_lembur` enum('flat','prorate') NOT NULL DEFAULT 'prorate',
  `nominal_flat` int(11) NOT NULL DEFAULT 0,
  `divide_prorate` int(11) NOT NULL DEFAULT 173 COMMENT 'divide_prorate digunakan untuk membagi gapok dan tunjangan tetap',
  `flag_pph21` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pot_absensi` enum('0','1') NOT NULL DEFAULT '0',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_lembur_p`),
  KEY `filter 1` (`id_company`,`id_lembur_p`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_lembur_p` */

/*Table structure for table `payroll_lembur_p_pembulatan` */

DROP TABLE IF EXISTS `payroll_lembur_p_pembulatan`;

CREATE TABLE `payroll_lembur_p_pembulatan` (
  `id_lembur_pembulatan` varchar(150) NOT NULL DEFAULT '' COMMENT 'id_company + Y + 4 digit angka',
  `id_lembur` varchar(150) NOT NULL DEFAULT '',
  `menit_mulai` int(3) NOT NULL DEFAULT 0,
  `menit_selesai` int(3) NOT NULL DEFAULT 0,
  `menit_dihitung` int(3) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_lembur_pembulatan`),
  KEY `filter 1` (`id_company`,`id_lembur`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_lembur_p_pembulatan` */

/*Table structure for table `payroll_lembur_p_perkalian` */

DROP TABLE IF EXISTS `payroll_lembur_p_perkalian`;

CREATE TABLE `payroll_lembur_p_perkalian` (
  `id_lembur_perkalian` varchar(150) NOT NULL DEFAULT '' COMMENT 'id_company + Y + 4 digit angka',
  `id_lembur` varchar(150) NOT NULL DEFAULT '',
  `jam_mulai` int(3) NOT NULL DEFAULT 0,
  `jam_selesai` int(3) NOT NULL DEFAULT 0,
  `perkalian` decimal(5,2) NOT NULL DEFAULT 0.00,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_lembur_perkalian`),
  KEY `filter 1` (`id_company`,`id_lembur`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_lembur_p_perkalian` */

/*Table structure for table `payroll_lembur_trx` */

DROP TABLE IF EXISTS `payroll_lembur_trx`;

CREATE TABLE `payroll_lembur_trx` (
  `id_lembur_trx` varchar(150) NOT NULL DEFAULT '' COMMENT 'id_lembur dari r_lembur',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `periode` varchar(7) NOT NULL DEFAULT '0000-00',
  `tgl_lembur` date NOT NULL DEFAULT '0000-00-00',
  `ttl_lembur` int(11) NOT NULL DEFAULT 0 COMMENT 'menit',
  `ttl_lembur_rounded` varchar(5) NOT NULL DEFAULT '0' COMMENT 'total lembur setelah dibulatkan satuan jam, contoh: 1.20 = 1 jam 20 menit',
  `ttl_lembur_dikali` longtext NOT NULL DEFAULT '' COMMENT 'format json array',
  `nominal_lembur_per_jam` decimal(9,2) NOT NULL DEFAULT 0.00,
  `ttl_lembur_rp` decimal(9,2) NOT NULL DEFAULT 0.00 COMMENT 'ttl_setelah_dikali x ttl_lembur_per_jam',
  `flag_pph21` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pot_absensi` enum('0','1') NOT NULL DEFAULT '0',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_lembur_trx`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_lembur_trx` */

/*Table structure for table `payroll_objek_pajak` */

DROP TABLE IF EXISTS `payroll_objek_pajak`;

CREATE TABLE `payroll_objek_pajak` (
  `kode` varchar(100) NOT NULL DEFAULT '',
  `nama` varchar(255) NOT NULL DEFAULT '',
  `kap` int(8) NOT NULL DEFAULT 0,
  `kjs` int(3) NOT NULL DEFAULT 0,
  `keterangan` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`kode`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_objek_pajak` */

/*Table structure for table `payroll_pot_absensi_p` */

DROP TABLE IF EXISTS `payroll_pot_absensi_p`;

CREATE TABLE `payroll_pot_absensi_p` (
  `jenis` enum('terlambat','pc','tap','alpa') NOT NULL DEFAULT 'terlambat',
  `flag_aktif` enum('0','1') NOT NULL DEFAULT '0',
  `flag_persentase_gapok` enum('0','1') NOT NULL DEFAULT '0',
  `persentase` decimal(4,2) NOT NULL DEFAULT 0.00,
  `nominal_potongan` int(11) NOT NULL DEFAULT 0,
  `menit` int(11) NOT NULL DEFAULT 0,
  `kelipatan` enum('0','1') NOT NULL DEFAULT '0',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `user_update` varchar(255) NOT NULL DEFAULT '',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`jenis`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_pot_absensi_p` */

/*Table structure for table `payroll_pot_absensi_trx` */

DROP TABLE IF EXISTS `payroll_pot_absensi_trx`;

CREATE TABLE `payroll_pot_absensi_trx` (
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `periode` varchar(7) NOT NULL DEFAULT '',
  `id_cabang` varchar(50) NOT NULL DEFAULT '',
  `id_departemen` varchar(50) NOT NULL DEFAULT '',
  `tgl_absen` date NOT NULL DEFAULT '0000-00-00',
  `jenis_absen` varchar(10) NOT NULL DEFAULT '',
  `kode_absen` varchar(50) NOT NULL DEFAULT '',
  `t_nominal` int(11) NOT NULL DEFAULT 0,
  `t_menit_p` int(11) NOT NULL DEFAULT 0,
  `t_kelipatan_p` enum('0','1') NOT NULL DEFAULT '0',
  `t_menit` int(11) NOT NULL DEFAULT 0,
  `t_ttl` int(11) NOT NULL DEFAULT 0,
  `pc_nominal` int(11) NOT NULL DEFAULT 0,
  `pc_menit_p` int(11) NOT NULL DEFAULT 0,
  `pc_kelipatan_p` enum('0','1') NOT NULL DEFAULT '0',
  `pc_menit` int(11) NOT NULL DEFAULT 0,
  `pc_ttl` int(11) NOT NULL DEFAULT 0,
  `tap_nominal` int(11) NOT NULL DEFAULT 0,
  `tap_ttl` int(11) NOT NULL DEFAULT 0,
  `alpa_nominal` int(11) NOT NULL DEFAULT 0,
  `alpa_ttl` int(11) NOT NULL DEFAULT 0,
  `ttl_potongan` int(11) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(150) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `user_update` varchar(150) NOT NULL DEFAULT '',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_company`,`id_karyawan`,`periode`,`tgl_absen`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_pot_absensi_trx` */

/*Table structure for table `payroll_pot_tdk_tetap_m` */

DROP TABLE IF EXISTS `payroll_pot_tdk_tetap_m`;

CREATE TABLE `payroll_pot_tdk_tetap_m` (
  `id_item` varchar(50) NOT NULL DEFAULT '' COMMENT 'id master komponen',
  `periode` varchar(7) NOT NULL DEFAULT '0000-00',
  `jenis_komponen` enum('tetap','tidak tetap') NOT NULL DEFAULT 'tetap',
  `jenis_master` enum('pendapatan','potongan') NOT NULL DEFAULT 'pendapatan',
  `cabang` varchar(255) NOT NULL DEFAULT '',
  `departemen` varchar(255) NOT NULL DEFAULT '',
  `jabatan` varchar(255) NOT NULL DEFAULT '',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `nm_potongan` varchar(255) NOT NULL DEFAULT '',
  `flag_persentase_gapok` enum('0','1') NOT NULL DEFAULT '0',
  `gapok_persen` decimal(4,2) NOT NULL DEFAULT 0.00,
  `gapok_rp` int(11) NOT NULL DEFAULT 0,
  `nominal_potongan` int(11) NOT NULL DEFAULT 0,
  `flag_bpjs` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pph21` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pot_absensi` enum('0','1') NOT NULL DEFAULT '0',
  `no_urut` int(11) NOT NULL DEFAULT 0,
  `flag_gaji` enum('0','1') NOT NULL DEFAULT '0',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(50) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(50) NOT NULL DEFAULT '',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_karyawan`,`id_item`,`periode`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_pot_tdk_tetap_m` */

/*Table structure for table `payroll_pot_tdk_tetap_temp` */

DROP TABLE IF EXISTS `payroll_pot_tdk_tetap_temp`;

CREATE TABLE `payroll_pot_tdk_tetap_temp` (
  `nik` varchar(50) NOT NULL DEFAULT '',
  `nm_karyawan` varchar(255) NOT NULL DEFAULT '',
  `bulan` varchar(7) NOT NULL DEFAULT '',
  `cabang` varchar(255) NOT NULL DEFAULT '',
  `departemen` varchar(255) NOT NULL DEFAULT '',
  `jabatan` varchar(255) NOT NULL DEFAULT '',
  `gapok` int(11) NOT NULL DEFAULT 0,
  `nm_potongan` varchar(255) NOT NULL DEFAULT '',
  `nominal_potongan` int(11) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`nik`,`bulan`,`nm_potongan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_pot_tdk_tetap_temp` */

/*Table structure for table `payroll_pot_tdk_tetap_trx` */

DROP TABLE IF EXISTS `payroll_pot_tdk_tetap_trx`;

CREATE TABLE `payroll_pot_tdk_tetap_trx` (
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `id_cabang` varchar(50) NOT NULL DEFAULT '',
  `id_departemen` varchar(50) NOT NULL DEFAULT '',
  `periode` varchar(7) NOT NULL DEFAULT '',
  `id_item` varchar(50) NOT NULL DEFAULT '' COMMENT 'id master komponen',
  `nm_potongan` varchar(255) NOT NULL DEFAULT '',
  `nominal_potongan` int(11) NOT NULL DEFAULT 0,
  `no_urut` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id_company`,`id_karyawan`,`periode`,`id_item`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_pot_tdk_tetap_trx` */

/*Table structure for table `payroll_pot_tetap_m` */

DROP TABLE IF EXISTS `payroll_pot_tetap_m`;

CREATE TABLE `payroll_pot_tetap_m` (
  `id_item` varchar(50) NOT NULL DEFAULT '' COMMENT 'id master komponen',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `jenis_komponen` enum('tetap','tidak tetap') NOT NULL DEFAULT 'tetap',
  `jenis_master` enum('pendapatan','potongan') NOT NULL DEFAULT 'pendapatan',
  `nm_potongan` varchar(255) NOT NULL DEFAULT '',
  `flag_persentase_gapok` enum('0','1') NOT NULL DEFAULT '0',
  `gapok_persen` decimal(4,2) NOT NULL DEFAULT 0.00,
  `gapok_rp` int(11) NOT NULL DEFAULT 0,
  `nominal_potongan` int(11) NOT NULL DEFAULT 0,
  `flag_bpjs` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pph21` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pot_absensi` enum('0','1') NOT NULL DEFAULT '0',
  `no_urut` int(11) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(50) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(50) NOT NULL DEFAULT '',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_karyawan`,`id_item`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_pot_tetap_m` */

/*Table structure for table `payroll_pot_tetap_temp` */

DROP TABLE IF EXISTS `payroll_pot_tetap_temp`;

CREATE TABLE `payroll_pot_tetap_temp` (
  `nik` varchar(50) NOT NULL DEFAULT '',
  `nm_karyawan` varchar(255) NOT NULL DEFAULT '',
  `cabang` varchar(255) NOT NULL DEFAULT '',
  `departemen` varchar(255) NOT NULL DEFAULT '',
  `jabatan` varchar(255) NOT NULL DEFAULT '',
  `gapok` int(11) NOT NULL DEFAULT 0,
  `nm_potongan` varchar(255) NOT NULL DEFAULT '',
  `nominal_potongan` int(11) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`nik`,`nm_potongan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_pot_tetap_temp` */

/*Table structure for table `payroll_pot_tetap_trx` */

DROP TABLE IF EXISTS `payroll_pot_tetap_trx`;

CREATE TABLE `payroll_pot_tetap_trx` (
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `id_cabang` varchar(50) NOT NULL DEFAULT '',
  `id_departemen` varchar(50) NOT NULL DEFAULT '',
  `periode` varchar(7) NOT NULL DEFAULT '',
  `id_item` varchar(50) NOT NULL DEFAULT '' COMMENT 'id master komponen',
  `nm_potongan` varchar(255) NOT NULL DEFAULT '',
  `nominal_potongan` int(11) NOT NULL DEFAULT 0,
  `no_urut` int(11) NOT NULL DEFAULT 0,
  `flag_pph21` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_company`,`id_karyawan`,`periode`,`id_item`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_pot_tetap_trx` */

/*Table structure for table `payroll_pph21_kd_negara` */

DROP TABLE IF EXISTS `payroll_pph21_kd_negara`;

CREATE TABLE `payroll_pph21_kd_negara` (
  `kode` varchar(3) NOT NULL DEFAULT '',
  `nm_negara` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`kode`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_pph21_kd_negara` */

/*Table structure for table `payroll_pph21_objek_pajak` */

DROP TABLE IF EXISTS `payroll_pph21_objek_pajak`;

CREATE TABLE `payroll_pph21_objek_pajak` (
  `kode` varchar(9) NOT NULL DEFAULT '',
  `nama` varchar(50) NOT NULL DEFAULT '',
  `kap` varchar(10) NOT NULL DEFAULT '',
  `kjs` varchar(3) NOT NULL DEFAULT '',
  `keterangan` enum('TIDAK FINAL','FINAL') NOT NULL DEFAULT 'TIDAK FINAL',
  `status_karyawan` enum('0','1','2','3','4','5','6','7') NOT NULL DEFAULT '0' COMMENT 'untuk mapping ke status karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`kode`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_pph21_objek_pajak` */

/*Table structure for table `payroll_pph21_p` */

DROP TABLE IF EXISTS `payroll_pph21_p`;

CREATE TABLE `payroll_pph21_p` (
  `aktif` enum('0','1') NOT NULL DEFAULT '1',
  `jenis` enum('gross','net') NOT NULL DEFAULT 'net' COMMENT 'gross dikurangkan gaji; nett tidak dikurangkan gaji',
  `nm_pemotong` varchar(50) NOT NULL DEFAULT '',
  `jenis_pemotong` enum('NIK','NPWP') NOT NULL DEFAULT 'NPWP',
  `npwp` varchar(20) NOT NULL DEFAULT '',
  `no_ktp` varchar(20) NOT NULL DEFAULT '',
  `id_tku` varchar(20) NOT NULL DEFAULT '',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `user_update` varchar(255) NOT NULL DEFAULT '',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_pph21_p` */

/*Table structure for table `payroll_pph21_p_trx` */

DROP TABLE IF EXISTS `payroll_pph21_p_trx`;

CREATE TABLE `payroll_pph21_p_trx` (
  `periode_gaji` varchar(7) NOT NULL DEFAULT '' COMMENT 'YYYY-MM',
  `aktif` enum('0','1') NOT NULL DEFAULT '1',
  `jenis` enum('gross','net') NOT NULL DEFAULT 'net' COMMENT 'gross dikurangkan gaji; nett tidak dikurangkan gaji',
  `nm_pemotong` varchar(50) NOT NULL DEFAULT '',
  `jenis_pemotong` enum('NIK','NPWP') NOT NULL DEFAULT 'NPWP',
  `npwp` varchar(20) NOT NULL DEFAULT '',
  `no_ktp` varchar(20) NOT NULL DEFAULT '',
  `id_tku` varchar(20) NOT NULL,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `user_update` varchar(255) NOT NULL DEFAULT '',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_company`,`periode_gaji`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_pph21_p_trx` */

/*Table structure for table `payroll_pph21_tarif` */

DROP TABLE IF EXISTS `payroll_pph21_tarif`;

CREATE TABLE `payroll_pph21_tarif` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ter_jenis` enum('A','B','C') NOT NULL DEFAULT 'A',
  `no_urut` tinyint(3) NOT NULL DEFAULT 0,
  `ptkp` varchar(50) NOT NULL DEFAULT '',
  `min` int(11) NOT NULL DEFAULT 0,
  `max` int(11) NOT NULL DEFAULT 0,
  `ter_persen` decimal(4,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=126 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_pph21_tarif` */

/*Table structure for table `payroll_pph21_trx` */

DROP TABLE IF EXISTS `payroll_pph21_trx`;

CREATE TABLE `payroll_pph21_trx` (
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `nik` varchar(50) NOT NULL DEFAULT '',
  `nm_karyawan` varchar(50) NOT NULL DEFAULT '',
  `no_ktp` varchar(20) NOT NULL DEFAULT '',
  `npwp` varchar(20) NOT NULL DEFAULT '',
  `tanggungan` varchar(10) NOT NULL DEFAULT '',
  `local_expat` varchar(10) NOT NULL DEFAULT '',
  `mulai_kerja_bulan` varchar(2) NOT NULL DEFAULT '0',
  `akhir_kerja_bulan` varchar(2) NOT NULL DEFAULT '0',
  `id_jabatan` varchar(20) NOT NULL DEFAULT '',
  `kd_jabatan` varchar(50) NOT NULL DEFAULT '',
  `nm_jabatan` varchar(50) NOT NULL DEFAULT '',
  `id_cabang` varchar(50) NOT NULL DEFAULT '',
  `kd_cabang` varchar(50) NOT NULL DEFAULT '',
  `nm_cabang` varchar(50) NOT NULL DEFAULT '',
  `id_departemen` varchar(50) NOT NULL DEFAULT '',
  `kd_departemen` varchar(50) NOT NULL DEFAULT '',
  `nm_departemen` varchar(50) NOT NULL DEFAULT '',
  `periode` varchar(7) NOT NULL DEFAULT '',
  `gapok` int(11) NOT NULL DEFAULT 0 COMMENT '9',
  `tunj_pph` int(11) NOT NULL DEFAULT 0 COMMENT '10',
  `tunj_lain` int(11) NOT NULL DEFAULT 0 COMMENT '11 : tunjangan tetap dan tidak tetap yg flag 1',
  `honorarium` int(11) NOT NULL DEFAULT 0 COMMENT '12',
  `premi_asuransi` int(11) NOT NULL DEFAULT 0 COMMENT '13 : tunjangan bpjs kesehatan + iuran jkk + iuran jkm + premi lainnya',
  `natura` int(11) NOT NULL DEFAULT 0 COMMENT '14',
  `peng_bruto_ttl` int(11) NOT NULL DEFAULT 0 COMMENT '15: jumlah 9 s/d 14',
  `bonus_thr` int(11) NOT NULL DEFAULT 0 COMMENT '16',
  `ttl_bruto_bonus` int(11) NOT NULL DEFAULT 0 COMMENT '17: jumlah 15 s/d 16',
  `pot_jabatan_atas_peng_bruto` int(11) NOT NULL DEFAULT 0 COMMENT '18',
  `pot_jabatan_atas_ttl_bruto_bonus` int(11) NOT NULL DEFAULT 0 COMMENT '19',
  `pot_iuran_pensiun_tht` int(11) NOT NULL DEFAULT 0 COMMENT '20',
  `ttl_potongan` int(11) NOT NULL DEFAULT 0 COMMENT '21',
  `jml_ph_neto_disetahunkan` int(11) NOT NULL DEFAULT 0 COMMENT '22',
  `ptkp` int(11) NOT NULL DEFAULT 0 COMMENT '23',
  `pkp_5` int(11) NOT NULL DEFAULT 0 COMMENT 'pkp 60jt',
  `pkp_15` int(11) NOT NULL DEFAULT 0 COMMENT 'pkp 60jt s/d 250jt',
  `pkp_25` int(11) NOT NULL DEFAULT 0 COMMENT 'pkp 250jt s/d 500jt',
  `pkp_30` int(11) NOT NULL DEFAULT 0 COMMENT 'pkp 500jt s/d 5m',
  `pkp_35` int(11) NOT NULL DEFAULT 0 COMMENT 'pkp diatas 5m',
  `ttl_pkp_disetahunkan` int(11) NOT NULL DEFAULT 0 COMMENT '24',
  `pph21_dtp` int(11) NOT NULL DEFAULT 0 COMMENT '25',
  `pph21_non_dtp` int(11) NOT NULL DEFAULT 0 COMMENT '26',
  `jenis_pph` enum('net','gross') NOT NULL DEFAULT 'net',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(150) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_pph21_trx` */

/*Table structure for table `payroll_pph21_trx_uu24` */

DROP TABLE IF EXISTS `payroll_pph21_trx_uu24`;

CREATE TABLE `payroll_pph21_trx_uu24` (
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `nik` varchar(50) NOT NULL DEFAULT '',
  `nm_karyawan` varchar(50) NOT NULL DEFAULT '' COMMENT '(F) Nama Penerima Penghasilan Sesuai NIK',
  `no_ktp` varchar(20) NOT NULL DEFAULT '' COMMENT '(E)',
  `npwp` varchar(20) NOT NULL DEFAULT '' COMMENT '(D)',
  `alamat_ktp` varchar(255) NOT NULL DEFAULT '' COMMENT '(G)',
  `id_jabatan` varchar(20) NOT NULL DEFAULT '',
  `kd_jabatan` varchar(50) NOT NULL DEFAULT '',
  `nm_jabatan` varchar(50) NOT NULL DEFAULT '',
  `id_cabang` varchar(50) NOT NULL DEFAULT '',
  `kd_cabang` varchar(50) NOT NULL DEFAULT '',
  `nm_cabang` varchar(50) NOT NULL DEFAULT '',
  `id_departemen` varchar(50) NOT NULL DEFAULT '',
  `kd_departemen` varchar(50) NOT NULL DEFAULT '',
  `nm_departemen` varchar(50) NOT NULL DEFAULT '',
  `periode` varchar(7) NOT NULL DEFAULT '',
  `gapok` decimal(11,2) NOT NULL DEFAULT 0.00,
  `ttl_tunjangan` decimal(11,2) NOT NULL DEFAULT 0.00 COMMENT 'Total Tunjanngan yg didaftarkan pph21',
  `gaji_bruto` decimal(11,2) NOT NULL DEFAULT 0.00 COMMENT '(O)',
  `gaji_bruto_setahun` decimal(11,2) NOT NULL DEFAULT 0.00,
  `biaya_jabatan` decimal(11,2) NOT NULL DEFAULT 0.00 COMMENT '5% x gaji bruto dan maksimal 500rb',
  `biaya_jabatan_setahun` decimal(11,2) NOT NULL DEFAULT 0.00 COMMENT 'total biaya jabatan dari januari sampai desember dan maksimal 6jt',
  `iuran_pensiun` decimal(11,2) NOT NULL DEFAULT 0.00 COMMENT 'dalam setahun',
  `ptkp` decimal(11,2) NOT NULL DEFAULT 0.00 COMMENT 'dalam setahun, sesuai tabel ptkp',
  `penerima_penghasilan` enum('NIK','NPWP') NOT NULL DEFAULT 'NPWP' COMMENT '(C)',
  `kd_objek_pajak` varchar(10) NOT NULL DEFAULT '' COMMENT '(H)',
  `penandatangan_jenis` enum('NPWP','NIK') NOT NULL DEFAULT 'NPWP' COMMENT '(I) Penandatangan Menggunakan? (NPWP/NIK)',
  `penandatangan_npwp` varchar(25) NOT NULL DEFAULT '' COMMENT '(J) NPWP Penandatangan (tanpa format/tanda baca)',
  `penandatangan_nik` varchar(25) NOT NULL DEFAULT '' COMMENT '(K) NIK Penandatangan (tanpa format/tanda baca)',
  `kd_ptkp` varchar(10) NOT NULL DEFAULT '' COMMENT '(L)',
  `pegawai_harian` enum('YA','TIDAK') NOT NULL DEFAULT 'TIDAK' COMMENT '(M)',
  `gross_up` enum('YA','TIDAK') NOT NULL DEFAULT 'TIDAK' COMMENT '(N)',
  `fasilitas` enum('N','SKB','DTP') NOT NULL DEFAULT 'N' COMMENT '(P) Mendapatkan Fasilitas ? (N/SKB/DTP)',
  `no_skb_dtp` varchar(50) NOT NULL DEFAULT '' COMMENT '(Q) Nomor SKB/Nomor DTP',
  `tgl_pemotongan` date NOT NULL DEFAULT '0000-00-00' COMMENT '(B)',
  `ter_jenis` enum('A','B','C') NOT NULL,
  `ter_persen` decimal(4,2) NOT NULL DEFAULT 0.00 COMMENT 'Tarif pajak',
  `min_bruto` int(11) NOT NULL DEFAULT 0,
  `max_bruto` int(11) NOT NULL DEFAULT 0,
  `pph21_setahun` decimal(11,2) NOT NULL DEFAULT 0.00 COMMENT 'pph21 terutang setahun',
  `pph21_terpotong` decimal(11,2) NOT NULL DEFAULT 0.00 COMMENT 'jumlah pph21 yang sudah dipotong sampai dengan november',
  `pph21` decimal(11,2) NOT NULL DEFAULT 0.00,
  `id_tku` varchar(20) NOT NULL DEFAULT '',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(150) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_company`,`id_karyawan`,`periode`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_pph21_trx_uu24` */

/*Table structure for table `payroll_tunj_kehadiran_m` */

DROP TABLE IF EXISTS `payroll_tunj_kehadiran_m`;

CREATE TABLE `payroll_tunj_kehadiran_m` (
  `id_item` varchar(50) NOT NULL DEFAULT '' COMMENT 'id master komponen',
  `no_urut` int(11) NOT NULL DEFAULT 0,
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `nm_tunjangan` varchar(255) NOT NULL DEFAULT '',
  `flag_persentase_gapok` enum('0','1') NOT NULL DEFAULT '0',
  `gapok_persen` decimal(4,2) NOT NULL DEFAULT 0.00,
  `gapok_rp` int(11) NOT NULL DEFAULT 0,
  `nominal_tunjangan` int(11) NOT NULL DEFAULT 0,
  `flag_bpjs` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pph21` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pot_absensi` enum('0','1') NOT NULL DEFAULT '0',
  `flag_upah_lembur` enum('0','1') NOT NULL DEFAULT '0',
  `flag_cuti` enum('0','1') NOT NULL DEFAULT '0',
  `flag_izin` enum('0','1') NOT NULL DEFAULT '0',
  `flag_sakit` enum('0','1') NOT NULL DEFAULT '0',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_karyawan`,`id_item`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_tunj_kehadiran_m` */

/*Table structure for table `payroll_tunj_kehadiran_temp` */

DROP TABLE IF EXISTS `payroll_tunj_kehadiran_temp`;

CREATE TABLE `payroll_tunj_kehadiran_temp` (
  `nik` varchar(50) NOT NULL DEFAULT '',
  `nm_karyawan` varchar(255) NOT NULL DEFAULT '',
  `cabang` varchar(255) NOT NULL DEFAULT '',
  `departemen` varchar(255) NOT NULL DEFAULT '',
  `jabatan` varchar(255) NOT NULL DEFAULT '',
  `gapok` int(11) NOT NULL DEFAULT 0,
  `nm_tunjangan` varchar(255) NOT NULL DEFAULT '',
  `nominal_tunjangan` int(11) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`nik`,`nm_tunjangan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_tunj_kehadiran_temp` */

/*Table structure for table `payroll_tunj_kehadiran_trx` */

DROP TABLE IF EXISTS `payroll_tunj_kehadiran_trx`;

CREATE TABLE `payroll_tunj_kehadiran_trx` (
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `id_cabang` varchar(50) NOT NULL DEFAULT '',
  `id_departemen` varchar(50) NOT NULL DEFAULT '',
  `periode` varchar(7) NOT NULL DEFAULT '',
  `id_item` varchar(50) NOT NULL DEFAULT '' COMMENT 'id master komponen',
  `nm_tunjangan` varchar(255) NOT NULL DEFAULT '',
  `nominal_tunjangan` int(11) NOT NULL DEFAULT 0,
  `ttl_kehadiran` int(11) NOT NULL DEFAULT 0,
  `ttl_tunjangan` int(11) NOT NULL DEFAULT 0,
  `flag_bpjs` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pph21` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pot_absensi` enum('0','1') NOT NULL DEFAULT '0',
  `flag_upah_lembur` enum('0','1') NOT NULL DEFAULT '0',
  `flag_cuti` enum('0','1') NOT NULL DEFAULT '0',
  `flag_izin` enum('0','1') NOT NULL DEFAULT '0',
  `flag_sakit` enum('0','1') NOT NULL DEFAULT '0',
  `no_urut` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id_company`,`id_karyawan`,`periode`,`id_item`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_tunj_kehadiran_trx` */

/*Table structure for table `payroll_tunj_tdk_tetap_m` */

DROP TABLE IF EXISTS `payroll_tunj_tdk_tetap_m`;

CREATE TABLE `payroll_tunj_tdk_tetap_m` (
  `id_item` varchar(50) NOT NULL DEFAULT '' COMMENT 'id master komponen',
  `periode` varchar(7) NOT NULL DEFAULT '0000-00',
  `jenis_komponen` enum('tetap','tidak tetap') NOT NULL DEFAULT 'tetap',
  `jenis_master` enum('pendapatan','potongan') NOT NULL DEFAULT 'pendapatan',
  `cabang` varchar(255) NOT NULL DEFAULT '',
  `departemen` varchar(255) NOT NULL DEFAULT '',
  `jabatan` varchar(255) NOT NULL DEFAULT '',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `nm_tunjangan` varchar(255) NOT NULL DEFAULT '',
  `flag_persentase_gapok` enum('0','1') NOT NULL DEFAULT '0',
  `gapok_persen` decimal(4,2) NOT NULL DEFAULT 0.00,
  `gapok_rp` int(11) NOT NULL DEFAULT 0,
  `nominal_tunjangan` int(11) NOT NULL DEFAULT 0,
  `flag_bpjs` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pph21` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pot_absensi` enum('0','1') NOT NULL DEFAULT '0',
  `no_urut` int(11) NOT NULL DEFAULT 0,
  `flag_gaji` enum('0','1') NOT NULL DEFAULT '0',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_karyawan`,`id_item`,`periode`,`id_company`),
  KEY `filter_1` (`id_company`,`periode`,`id_item`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_tunj_tdk_tetap_m` */

/*Table structure for table `payroll_tunj_tdk_tetap_temp` */

DROP TABLE IF EXISTS `payroll_tunj_tdk_tetap_temp`;

CREATE TABLE `payroll_tunj_tdk_tetap_temp` (
  `nik` varchar(50) NOT NULL DEFAULT '',
  `nm_karyawan` varchar(255) NOT NULL DEFAULT '',
  `bulan` varchar(7) NOT NULL DEFAULT '',
  `cabang` varchar(255) NOT NULL DEFAULT '',
  `departemen` varchar(255) NOT NULL DEFAULT '',
  `jabatan` varchar(255) NOT NULL DEFAULT '',
  `gapok` int(11) NOT NULL DEFAULT 0,
  `nm_tunjangan` varchar(255) NOT NULL DEFAULT '',
  `nominal_tunjangan` int(11) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`nik`,`bulan`,`nm_tunjangan`,`id_company`),
  KEY `filter_1` (`id_company`,`bulan`,`nm_tunjangan`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_tunj_tdk_tetap_temp` */

/*Table structure for table `payroll_tunj_tdk_tetap_trx` */

DROP TABLE IF EXISTS `payroll_tunj_tdk_tetap_trx`;

CREATE TABLE `payroll_tunj_tdk_tetap_trx` (
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `id_cabang` varchar(50) NOT NULL DEFAULT '',
  `id_departemen` varchar(50) NOT NULL DEFAULT '',
  `periode` varchar(7) NOT NULL DEFAULT '',
  `id_item` varchar(50) NOT NULL DEFAULT '' COMMENT 'id master komponen',
  `nm_tunjangan` varchar(255) NOT NULL DEFAULT '',
  `nominal_tunjangan` int(11) NOT NULL DEFAULT 0,
  `flag_pph21` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pot_absensi` enum('0','1') NOT NULL DEFAULT '0',
  `no_urut` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id_company`,`id_karyawan`,`periode`,`id_item`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_tunj_tdk_tetap_trx` */

/*Table structure for table `payroll_tunj_tetap_m` */

DROP TABLE IF EXISTS `payroll_tunj_tetap_m`;

CREATE TABLE `payroll_tunj_tetap_m` (
  `id_item` varchar(50) NOT NULL DEFAULT '' COMMENT 'id master komponen',
  `no_urut` int(11) NOT NULL DEFAULT 0,
  `jenis_komponen` enum('tetap','tidak tetap') NOT NULL DEFAULT 'tetap',
  `jenis_master` enum('pendapatan','potongan') NOT NULL DEFAULT 'pendapatan',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `nm_tunjangan` varchar(255) NOT NULL DEFAULT '',
  `flag_persentase_gapok` enum('0','1') NOT NULL DEFAULT '0',
  `gapok_persen` decimal(4,2) NOT NULL DEFAULT 0.00,
  `gapok_rp` int(11) NOT NULL DEFAULT 0,
  `nominal_tunjangan` int(11) NOT NULL DEFAULT 0,
  `flag_bpjs` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pph21` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pot_absensi` enum('0','1') NOT NULL DEFAULT '0',
  `flag_upah_lembur` enum('0','1') NOT NULL DEFAULT '0',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_karyawan`,`id_item`,`id_company`),
  KEY `filter_1` (`id_company`,`id_item`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_tunj_tetap_m` */

/*Table structure for table `payroll_tunj_tetap_temp` */

DROP TABLE IF EXISTS `payroll_tunj_tetap_temp`;

CREATE TABLE `payroll_tunj_tetap_temp` (
  `nik` varchar(50) NOT NULL DEFAULT '',
  `nm_karyawan` varchar(255) NOT NULL DEFAULT '',
  `cabang` varchar(255) NOT NULL DEFAULT '',
  `departemen` varchar(255) NOT NULL DEFAULT '',
  `jabatan` varchar(255) NOT NULL DEFAULT '',
  `gapok` int(11) NOT NULL DEFAULT 0,
  `nm_tunjangan` varchar(255) NOT NULL DEFAULT '',
  `nominal_tunjangan` int(11) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`nik`,`nm_tunjangan`,`id_company`),
  KEY `filter_1` (`id_company`,`nm_tunjangan`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_tunj_tetap_temp` */

/*Table structure for table `payroll_tunj_tetap_trx` */

DROP TABLE IF EXISTS `payroll_tunj_tetap_trx`;

CREATE TABLE `payroll_tunj_tetap_trx` (
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `id_cabang` varchar(50) NOT NULL DEFAULT '',
  `id_departemen` varchar(50) NOT NULL DEFAULT '',
  `periode` varchar(7) NOT NULL DEFAULT '',
  `id_item` varchar(50) NOT NULL DEFAULT '' COMMENT 'id master komponen',
  `nm_tunjangan` varchar(255) NOT NULL DEFAULT '',
  `nominal_tunjangan` int(11) NOT NULL DEFAULT 0,
  `flag_bpjs` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pph21` enum('0','1') NOT NULL DEFAULT '0',
  `flag_pot_absensi` enum('0','1') NOT NULL DEFAULT '0',
  `flag_upah_lembur` enum('0','1') NOT NULL DEFAULT '0',
  `no_urut` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id_company`,`id_karyawan`,`periode`,`id_item`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `payroll_tunj_tetap_trx` */

/*Table structure for table `pkwt_data` */

DROP TABLE IF EXISTS `pkwt_data`;

CREATE TABLE `pkwt_data` (
  `id_pkwt` varchar(50) NOT NULL DEFAULT '' COMMENT 'id_company+yyyymm+4 digit nomor urut',
  `no_pkwt` varchar(20) NOT NULL DEFAULT '',
  `jenis_pkwt` enum('baru','perpanjangan') NOT NULL DEFAULT 'perpanjangan',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `nik` varchar(20) NOT NULL DEFAULT '',
  `nm_karyawan` varchar(50) NOT NULL DEFAULT '',
  `lahir_tempat` varchar(50) NOT NULL DEFAULT '',
  `lahir_tgl` date NOT NULL DEFAULT '0000-00-00',
  `alamat` varchar(255) NOT NULL DEFAULT '' COMMENT 'alamat karyawan',
  `nm_lvl_user` varchar(50) NOT NULL DEFAULT '',
  `nm_jabatan` varchar(50) NOT NULL DEFAULT '',
  `nm_departemen` varchar(50) NOT NULL DEFAULT '',
  `nm_cabang` varchar(50) NOT NULL DEFAULT '',
  `tgl_pkwt` date NOT NULL DEFAULT '0000-00-00',
  `tgl_pkwt_mulai` date NOT NULL DEFAULT '0000-00-00',
  `tgl_pkwt_selesai` date NOT NULL DEFAULT '0000-00-00',
  `nm_direktur` varchar(50) NOT NULL,
  `ttd_direktur` varchar(255) NOT NULL DEFAULT '',
  `ttd_karyawan` varchar(255) NOT NULL DEFAULT '',
  `id_template` varchar(20) NOT NULL,
  `nm_draft_pkwt` varchar(255) NOT NULL DEFAULT '' COMMENT 'nm file html',
  `draft_pkwt_parameter` text NOT NULL,
  `draft_pkwt_value` text NOT NULL,
  `status` enum('0','1','2','3','4') NOT NULL DEFAULT '0' COMMENT '0: Draft, 1: Pengajuan, 2: Dibatalkan, 3: Ditolak, 4. Disetujui',
  `apv_karyawan` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0: tidak perlu persetujuan, 1: Pengajuan, 2: Dibatalkan, 3: Ditolak, 4. Disetujui',
  `apv_direksi` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0: tidak perlu persetujuan, 1: Pengajuan, 2: Dibatalkan, 3: Ditolak, 4. Disetujui',
  `tgl_apv_karyawan` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `tgl_apv_direksi` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_apv_karyawan` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama lengkap',
  `user_apv_direksi` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama lengkap',
  `ket_tolak` varchar(255) NOT NULL DEFAULT '',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama lengkap',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama lengkap',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_pkwt`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `pkwt_data` */

/*Table structure for table `pkwt_data_temp` */

DROP TABLE IF EXISTS `pkwt_data_temp`;

CREATE TABLE `pkwt_data_temp` (
  `id_pkwt_temp` varchar(20) NOT NULL DEFAULT '' COMMENT 'id_company+yyyymm+4 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `jenis_pkwt` enum('baru','perpanjangan') DEFAULT 'perpanjangan',
  `nik` varchar(20) NOT NULL DEFAULT '',
  `nm_karyawan` varchar(50) NOT NULL DEFAULT '',
  `lahir_tempat` varchar(50) NOT NULL DEFAULT '',
  `lahir_tgl` date NOT NULL DEFAULT '0000-00-00',
  `alamat` varchar(255) NOT NULL DEFAULT '' COMMENT 'alamat karyawan',
  `nm_lvl_user` varchar(50) NOT NULL DEFAULT '',
  `nm_jabatan` varchar(50) NOT NULL DEFAULT '',
  `nm_departemen` varchar(50) NOT NULL DEFAULT '',
  `nm_cabang` varchar(50) NOT NULL DEFAULT '',
  `tgl_pkwt` date NOT NULL DEFAULT '0000-00-00',
  `tgl_pkwt_mulai` date NOT NULL DEFAULT '0000-00-00',
  `tgl_pkwt_selesai` date NOT NULL DEFAULT '0000-00-00',
  `nm_direktur` varchar(50) NOT NULL DEFAULT '',
  `ttd_direktur` varchar(255) NOT NULL DEFAULT '',
  `ttd_karyawan` varchar(255) NOT NULL DEFAULT '',
  `id_template` varchar(20) NOT NULL,
  `nm_draft_pkwt` varchar(255) NOT NULL DEFAULT '' COMMENT 'nm file html',
  `draft_pkwt_parameter` text NOT NULL,
  `draft_pkwt_value` text NOT NULL,
  `status` enum('0','1','2','3','4') NOT NULL DEFAULT '0' COMMENT '0: Draft, 1: Pengajuan, 2: Dibatalkan, 3: Ditolak, 4. Disetujui',
  `apv_karyawan` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0: tidak perlu persetujuan, 1: Pengajuan, 2: Dibatalkan, 3: Ditolak, 4. Disetujui',
  `apv_direksi` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0: tidak perlu persetujuan, 1: Pengajuan, 2: Dibatalkan, 3: Ditolak, 4. Disetujui',
  `tgl_apv_karyawan` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `tgl_apv_direksi` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_apv_karyawan` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama lengkap',
  `user_apv_direksi` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama lengkap',
  `flag` enum('1','2','3') NOT NULL DEFAULT '2' COMMENT '1:data valid  2:data tidak lengkap  3:data sudah ada',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama lengkap',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama lengkap',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_pkwt_temp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `pkwt_data_temp` */

/*Table structure for table `pkwt_direktur` */

DROP TABLE IF EXISTS `pkwt_direktur`;

CREATE TABLE `pkwt_direktur` (
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `nm_karyawan` varchar(50) NOT NULL DEFAULT '',
  `nm_jabatan` varchar(50) NOT NULL DEFAULT '',
  `path_ttd` varchar(255) NOT NULL DEFAULT '',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_input` varchar(100) NOT NULL COMMENT 'nik - nama lengkap',
  `tgl_update` time NOT NULL DEFAULT '00:00:00',
  `user_update` varchar(100) NOT NULL COMMENT 'nik - nama lengkap',
  PRIMARY KEY (`id_karyawan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `pkwt_direktur` */

/*Table structure for table `pkwt_draft_m` */

DROP TABLE IF EXISTS `pkwt_draft_m`;

CREATE TABLE `pkwt_draft_m` (
  `id_draft_pkwt` varchar(50) NOT NULL DEFAULT '',
  `nm_draft` varchar(50) NOT NULL DEFAULT '',
  `nm_file` varchar(50) DEFAULT '' COMMENT 'Nama File Draft',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama lengkap',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama lengkap',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_draft_pkwt`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `pkwt_draft_m` */

/*Table structure for table `pkwt_gaji_m` */

DROP TABLE IF EXISTS `pkwt_gaji_m`;

CREATE TABLE `pkwt_gaji_m` (
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `gapok` int(11) NOT NULL DEFAULT 0,
  `jkk` decimal(4,2) NOT NULL DEFAULT 0.00,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama lengkap',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama lengkap',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_karyawan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `pkwt_gaji_m` */

/*Table structure for table `pkwt_template_m` */

DROP TABLE IF EXISTS `pkwt_template_m`;

CREATE TABLE `pkwt_template_m` (
  `id_template` varchar(20) NOT NULL,
  `nama` varchar(50) NOT NULL,
  `template` varchar(255) NOT NULL,
  `parameter` text NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `user_input` varchar(100) NOT NULL,
  `tgl_input` datetime NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL,
  `tgl_update` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_template`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `pkwt_template_m` */

/*Table structure for table `pkwt_update` */

DROP TABLE IF EXISTS `pkwt_update`;

CREATE TABLE `pkwt_update` (
  `nik` varchar(10) DEFAULT '',
  `nama_lengkap` varchar(100) DEFAULT '',
  `tempat_lahir` varchar(50) DEFAULT '',
  `tgl_lahir` date DEFAULT '0000-00-00',
  `alamat_domisili` varchar(250) DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `pkwt_update` */

/*Table structure for table `ptkp` */

DROP TABLE IF EXISTS `ptkp`;

CREATE TABLE `ptkp` (
  `kode` varchar(5) NOT NULL,
  `keterangan` varchar(70) NOT NULL,
  `nominal` int(11) NOT NULL DEFAULT 0,
  `no_urut` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`kode`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `ptkp` */

/*Table structure for table `r_absensi` */

DROP TABLE IF EXISTS `r_absensi`;

CREATE TABLE `r_absensi` (
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `nik` varchar(50) NOT NULL DEFAULT '',
  `nama_karyawan` varchar(255) NOT NULL DEFAULT '',
  `id_cabang` varchar(50) NOT NULL DEFAULT '',
  `kode_cabang` varchar(20) NOT NULL DEFAULT '',
  `nama_cabang` varchar(255) NOT NULL DEFAULT '',
  `id_departemen` varchar(50) NOT NULL DEFAULT '',
  `kode_departemen` varchar(50) NOT NULL DEFAULT '',
  `nama_departemen` varchar(255) NOT NULL DEFAULT '',
  `id_jabatan` varchar(50) NOT NULL DEFAULT '',
  `kode_jabatan` varchar(50) NOT NULL DEFAULT '',
  `nama_jabatan` varchar(255) NOT NULL DEFAULT '',
  `supervisi` varchar(50) NOT NULL DEFAULT '',
  `nama_supervisi` varchar(255) NOT NULL DEFAULT '',
  `tgl_absen` date NOT NULL DEFAULT '0000-00-00',
  `jenis_absen` varchar(20) NOT NULL DEFAULT '' COMMENT 'reguler; shift; libur; izin(Sakit, cuti), alpha',
  `kode_absensi` varchar(255) NOT NULL DEFAULT '',
  `ket_kode` varchar(255) NOT NULL DEFAULT '',
  `jam_masuk_kerja` time NOT NULL DEFAULT '00:00:00',
  `absen_masuk` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `terlambat` int(4) NOT NULL DEFAULT 0,
  `lokasi_masuk` varchar(255) NOT NULL DEFAULT '',
  `timezone_masuk` varchar(255) NOT NULL DEFAULT '',
  `gmt_masuk` varchar(6) NOT NULL DEFAULT '',
  `lat_masuk` varchar(30) NOT NULL DEFAULT '',
  `long_masuk` varchar(30) NOT NULL DEFAULT '',
  `ket_absen_masuk` varchar(100) NOT NULL DEFAULT '',
  `foto_masuk` varchar(255) NOT NULL DEFAULT '',
  `absen_ist_mulai` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lokasi_ist_mulai` varchar(255) NOT NULL DEFAULT '',
  `timezone_ist_mulai` varchar(255) NOT NULL DEFAULT '',
  `gmt_ist_mulai` varchar(6) NOT NULL DEFAULT '',
  `lat_ist_mulai` varchar(30) NOT NULL DEFAULT '',
  `long_ist_mulai` varchar(30) NOT NULL DEFAULT '',
  `ket_ist_mulai` varchar(100) NOT NULL DEFAULT '',
  `foto_ist_mulai` varchar(255) NOT NULL DEFAULT '',
  `absen_ist_selesai` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lokasi_ist_selesai` varchar(255) NOT NULL DEFAULT '',
  `timezone_ist_selesai` varchar(255) NOT NULL DEFAULT '',
  `gmt_ist_selesai` varchar(6) NOT NULL DEFAULT '',
  `lat_ist_selesai` varchar(30) NOT NULL DEFAULT '',
  `long_ist_selesai` varchar(30) NOT NULL DEFAULT '',
  `ket_ist_selesai` varchar(100) NOT NULL DEFAULT '',
  `foto_ist_selesai` varchar(100) NOT NULL DEFAULT '',
  `jam_pulang_kerja` time NOT NULL DEFAULT '00:00:00',
  `absen_pulang` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `pulang_cepat` int(4) NOT NULL DEFAULT 0,
  `lokasi_pulang` varchar(255) NOT NULL DEFAULT '',
  `timezone_pulang` varchar(255) NOT NULL DEFAULT '',
  `gmt_pulang` varchar(255) NOT NULL DEFAULT '',
  `lat_pulang` varchar(30) NOT NULL DEFAULT '',
  `long_pulang` varchar(30) NOT NULL DEFAULT '',
  `ket_absen_pulang` varchar(100) NOT NULL DEFAULT '',
  `foto_absen_pulang` varchar(255) NOT NULL DEFAULT '',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tgl_update` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_karyawan`,`tgl_absen`,`id_company`),
  KEY `filter 1` (`id_company`,`tgl_absen`),
  KEY `filter 2` (`id_company`,`tgl_absen`,`id_karyawan`),
  KEY `filter 3` (`id_company`,`tgl_absen`,`id_cabang`),
  KEY `filter 4` (`id_company`,`tgl_absen`,`id_cabang`,`id_departemen`),
  KEY `filter 5` (`tgl_absen`,`jenis_absen`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `r_absensi` */

insert  into `r_absensi`(`id_karyawan`,`nik`,`nama_karyawan`,`id_cabang`,`kode_cabang`,`nama_cabang`,`id_departemen`,`kode_departemen`,`nama_departemen`,`id_jabatan`,`kode_jabatan`,`nama_jabatan`,`supervisi`,`nama_supervisi`,`tgl_absen`,`jenis_absen`,`kode_absensi`,`ket_kode`,`jam_masuk_kerja`,`absen_masuk`,`terlambat`,`lokasi_masuk`,`timezone_masuk`,`gmt_masuk`,`lat_masuk`,`long_masuk`,`ket_absen_masuk`,`foto_masuk`,`absen_ist_mulai`,`lokasi_ist_mulai`,`timezone_ist_mulai`,`gmt_ist_mulai`,`lat_ist_mulai`,`long_ist_mulai`,`ket_ist_mulai`,`foto_ist_mulai`,`absen_ist_selesai`,`lokasi_ist_selesai`,`timezone_ist_selesai`,`gmt_ist_selesai`,`lat_ist_selesai`,`long_ist_selesai`,`ket_ist_selesai`,`foto_ist_selesai`,`jam_pulang_kerja`,`absen_pulang`,`pulang_cepat`,`lokasi_pulang`,`timezone_pulang`,`gmt_pulang`,`lat_pulang`,`long_pulang`,`ket_absen_pulang`,`foto_absen_pulang`,`id_company`,`tgl_input`,`tgl_update`) values 
('C20250800100003','00003','Example Staff','C202508001202403001','PST','PUSAT','C202508001202403001','OFC','Office','C202508001202403003','STAFF','Staff','','','2025-08-15','reguler','H','Reguler','08:00:00','2025-08-15 08:00:00',0,'','','','','','','','0000-00-00 00:00:00','','','','','','','','0000-00-00 00:00:00','','','','','','','','17:00:00','2025-08-15 17:00:00',0,'','','','','','','','C202508001','2025-08-19 14:29:22','2025-08-19 14:29:22');

/*Table structure for table `r_absensi_bc` */

DROP TABLE IF EXISTS `r_absensi_bc`;

CREATE TABLE `r_absensi_bc` (
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `nik` varchar(50) NOT NULL DEFAULT '',
  `nama_karyawan` varchar(255) NOT NULL DEFAULT '',
  `id_cabang` varchar(50) NOT NULL DEFAULT '',
  `kode_cabang` varchar(20) NOT NULL DEFAULT '',
  `nama_cabang` varchar(255) NOT NULL DEFAULT '',
  `id_departemen` varchar(50) NOT NULL DEFAULT '',
  `kode_departemen` varchar(50) NOT NULL DEFAULT '',
  `nama_departemen` varchar(255) NOT NULL DEFAULT '',
  `id_jabatan` varchar(50) NOT NULL DEFAULT '',
  `kode_jabatan` varchar(50) NOT NULL DEFAULT '',
  `nama_jabatan` varchar(255) NOT NULL DEFAULT '',
  `supervisi` varchar(50) NOT NULL DEFAULT '',
  `nama_supervisi` varchar(255) NOT NULL DEFAULT '',
  `tgl_absen` date NOT NULL DEFAULT '0000-00-00',
  `jenis_absen` varchar(20) NOT NULL DEFAULT '' COMMENT 'reguler; shift; libur; izin(Sakit, cuti), alpha',
  `kode_absensi` varchar(255) NOT NULL DEFAULT '',
  `ket_kode` varchar(255) NOT NULL DEFAULT '',
  `jam_masuk_kerja` time NOT NULL DEFAULT '00:00:00',
  `absen_masuk` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `terlambat` int(4) NOT NULL DEFAULT 0,
  `lokasi_masuk` varchar(255) NOT NULL DEFAULT '',
  `timezone_masuk` varchar(255) NOT NULL DEFAULT '',
  `gmt_masuk` varchar(6) NOT NULL DEFAULT '',
  `lat_masuk` varchar(30) NOT NULL DEFAULT '',
  `long_masuk` varchar(30) NOT NULL DEFAULT '',
  `ket_absen_masuk` varchar(100) NOT NULL DEFAULT '',
  `foto_masuk` varchar(255) NOT NULL DEFAULT '',
  `absen_ist_mulai` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lokasi_ist_mulai` varchar(255) NOT NULL DEFAULT '',
  `timezone_ist_mulai` varchar(255) NOT NULL DEFAULT '',
  `gmt_ist_mulai` varchar(6) NOT NULL DEFAULT '',
  `lat_ist_mulai` varchar(30) NOT NULL DEFAULT '',
  `long_ist_mulai` varchar(30) NOT NULL DEFAULT '',
  `ket_ist_mulai` varchar(100) NOT NULL DEFAULT '',
  `foto_ist_mulai` varchar(255) NOT NULL DEFAULT '',
  `absen_ist_selesai` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lokasi_ist_selesai` varchar(255) NOT NULL DEFAULT '',
  `timezone_ist_selesai` varchar(255) NOT NULL DEFAULT '',
  `gmt_ist_selesai` varchar(6) NOT NULL DEFAULT '',
  `lat_ist_selesai` varchar(30) NOT NULL DEFAULT '',
  `long_ist_selesai` varchar(30) NOT NULL DEFAULT '',
  `ket_ist_selesai` varchar(100) NOT NULL DEFAULT '',
  `foto_ist_selesai` varchar(100) NOT NULL DEFAULT '',
  `jam_pulang_kerja` time NOT NULL DEFAULT '00:00:00',
  `absen_pulang` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `pulang_cepat` int(4) NOT NULL DEFAULT 0,
  `lokasi_pulang` varchar(255) NOT NULL DEFAULT '',
  `timezone_pulang` varchar(255) NOT NULL DEFAULT '',
  `gmt_pulang` varchar(255) NOT NULL DEFAULT '',
  `lat_pulang` varchar(30) NOT NULL DEFAULT '',
  `long_pulang` varchar(30) NOT NULL DEFAULT '',
  `ket_absen_pulang` varchar(100) NOT NULL DEFAULT '',
  `foto_absen_pulang` varchar(255) NOT NULL DEFAULT '',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tgl_update` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_karyawan`,`tgl_absen`,`id_company`),
  KEY `filter 1` (`id_company`,`tgl_absen`),
  KEY `filter 2` (`id_company`,`tgl_absen`,`id_karyawan`),
  KEY `filter 3` (`id_company`,`tgl_absen`,`id_cabang`),
  KEY `filter 4` (`id_company`,`tgl_absen`,`id_cabang`,`id_departemen`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `r_absensi_bc` */

/*Table structure for table `r_lembur` */

DROP TABLE IF EXISTS `r_lembur`;

CREATE TABLE `r_lembur` (
  `id_lembur` varchar(50) NOT NULL DEFAULT '',
  `tgl_lembur` date NOT NULL DEFAULT '0000-00-00',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `nik` varchar(50) NOT NULL DEFAULT '',
  `nama_karyawan` varchar(250) NOT NULL DEFAULT '',
  `id_cabang` varchar(50) NOT NULL DEFAULT '',
  `nama_cabang` varchar(250) NOT NULL DEFAULT '',
  `id_departemen` varchar(50) NOT NULL DEFAULT '',
  `nama_departemen` varchar(250) NOT NULL DEFAULT '',
  `id_jabatan` varchar(50) NOT NULL DEFAULT '',
  `nama_jabatan` varchar(250) NOT NULL DEFAULT '',
  `ttl_lembur` varchar(50) NOT NULL DEFAULT '0',
  `lembur_mulai` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lok_mulai` varchar(225) NOT NULL DEFAULT '',
  `timezone_mulai` varchar(150) NOT NULL DEFAULT '',
  `gmt_mulai` varchar(225) NOT NULL DEFAULT '',
  `lat_mulai` varchar(50) NOT NULL DEFAULT '',
  `long_mulai` varchar(50) NOT NULL DEFAULT '',
  `ket_mulai` varchar(225) NOT NULL DEFAULT '',
  `foto_mulai` varchar(225) NOT NULL DEFAULT '',
  `lembur_selesai` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lok_selesai` varchar(225) NOT NULL DEFAULT '',
  `timezone_selesai` varchar(150) NOT NULL DEFAULT '',
  `gmt_selesai` varchar(100) NOT NULL DEFAULT '',
  `lat_selesai` varchar(50) NOT NULL DEFAULT '',
  `long_selesai` varchar(50) NOT NULL DEFAULT '',
  `ket_selesai` varchar(225) NOT NULL DEFAULT '',
  `foto_selesai` varchar(225) NOT NULL DEFAULT '',
  `id_company` varchar(20) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_lembur`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `r_lembur` */

/*Table structure for table `r_login_mobile` */

DROP TABLE IF EXISTS `r_login_mobile`;

CREATE TABLE `r_login_mobile` (
  `id_karyawan` varchar(50) NOT NULL,
  `nama_karyawan` varchar(100) NOT NULL,
  `emulator` enum('false','true') NOT NULL DEFAULT 'false',
  `os` varchar(100) NOT NULL,
  `versi_os` varchar(100) NOT NULL,
  `base_os` varchar(100) NOT NULL,
  `brand` varchar(100) NOT NULL,
  `model` varchar(100) NOT NULL,
  `token_fcm` varchar(200) NOT NULL,
  `device_id` varchar(100) NOT NULL,
  `tgl_login` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `id_company` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `r_login_mobile` */

insert  into `r_login_mobile`(`id_karyawan`,`nama_karyawan`,`emulator`,`os`,`versi_os`,`base_os`,`brand`,`model`,`token_fcm`,`device_id`,`tgl_login`,`id_company`) values 
('D20250800100003','Example Staff','false','Android','15','','OPPO','CPH2711','eEarJSOzTc6EgxXhTUCG3B:APA91bE_KFXal8bEUcpPv5q-b0AmyviQsQsVfWHzqKIMow1oJH_6nV5m0b2M3rREt0gYy4RPeQtPMQVtcrqeeVVoeaOySU0rcM0rr-E9IKYaHMjASNMTVYw','AP3A.240617.008','2025-08-19 10:37:52','D202508001'),
('D20250800100003','Example Staff','false','Android','15','','OPPO','CPH2711','eEarJSOzTc6EgxXhTUCG3B:APA91bE_KFXal8bEUcpPv5q-b0AmyviQsQsVfWHzqKIMow1oJH_6nV5m0b2M3rREt0gYy4RPeQtPMQVtcrqeeVVoeaOySU0rcM0rr-E9IKYaHMjASNMTVYw','AP3A.240617.008','2025-08-19 11:04:25','D202508001'),
('D20250800100003','Example Staff','false','Android','15','','OPPO','CPH2711','eEarJSOzTc6EgxXhTUCG3B:APA91bE_KFXal8bEUcpPv5q-b0AmyviQsQsVfWHzqKIMow1oJH_6nV5m0b2M3rREt0gYy4RPeQtPMQVtcrqeeVVoeaOySU0rcM0rr-E9IKYaHMjASNMTVYw','AP3A.240617.008','2025-08-19 14:09:55','D202508001'),
('D20250800100003','Example Staff','false','Android','15','','OPPO','CPH2711','c4YVpw10TCa3LPdN0lkVJo:APA91bGjAxoiH7xDwT2qGEVBBianu7Kgm0YtisDtY42EcXT6ActrFAfQAROBGZ3BGx2gBLhlTZEpkDORUkWrhg3d8aysZ6GRKxZYx5tkJ3IlgyHeTBNlzlU','AP3A.240617.008','2025-08-19 14:25:43','D202508001');

/*Table structure for table `r_plan` */

DROP TABLE IF EXISTS `r_plan`;

CREATE TABLE `r_plan` (
  `id_plan` int(11) NOT NULL AUTO_INCREMENT,
  `id_customer` int(11) NOT NULL,
  `status` int(11) NOT NULL COMMENT '2=trial; 3=lunas/aktif; 4=request aktivasi; 5=perpanjangan; 6=Layanan Berakhir',
  `tgl_aktif` date NOT NULL,
  `tgl_berakhir` date NOT NULL,
  `tgl_daftar` date DEFAULT NULL,
  `masa_layanan` int(11) NOT NULL DEFAULT 1 COMMENT '1=lifetime;2=30hari;3=6bulan;4=12bulan',
  `max_cabang` varchar(10) NOT NULL DEFAULT '~',
  `max_karyawan` varchar(10) NOT NULL DEFAULT '~',
  `id_company` varchar(50) NOT NULL,
  PRIMARY KEY (`id_plan`),
  KEY `master_plan` (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `r_plan` */

/*Table structure for table `referal` */

DROP TABLE IF EXISTS `referal`;

CREATE TABLE `referal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_company` varchar(20) NOT NULL,
  `nama_company_referal` varchar(100) NOT NULL,
  `email_referal` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `referal` */

/*Table structure for table `reimbursement_akun` */

DROP TABLE IF EXISTS `reimbursement_akun`;

CREATE TABLE `reimbursement_akun` (
  `id_akun` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `kode_akun` varchar(20) NOT NULL,
  `nama_akun` varchar(150) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `user_input` varchar(100) NOT NULL COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(100) NOT NULL COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_akun`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `reimbursement_akun` */

/*Table structure for table `reimbursement_data` */

DROP TABLE IF EXISTS `reimbursement_data`;

CREATE TABLE `reimbursement_data` (
  `id` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `id_pengajuan_reimbursement` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `id_karyawan` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `id_jenis_reimbursement` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `nominal` int(11) NOT NULL,
  `nominal_disetujui` int(11) NOT NULL,
  `keterangan` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '',
  `tgl_bukti` date NOT NULL,
  `file` text CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL COMMENT 'uploads/reimbursement/id_company/id_karyawan/yyyymm/nama_file',
  `kode_akun` varchar(100) NOT NULL COMMENT 'kode-nama',
  `apv_spv` enum('0','1','2','3','4','5','6') CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui\r\n6=proses',
  `apv_kedep` enum('0','1','2','3','4','5','6') CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui\r\n6=proses',
  `apv_kacab` enum('0','1','2','3','4','5','6') CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui\r\n6=proses',
  `apv_direksi` enum('0','1','2','3','4','5','6') CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui\r\n6=proses',
  `apv_finance` enum('0','1','2','3','4','5','6') CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui\r\n6=proses',
  `ket_apv_spv` varchar(255) NOT NULL DEFAULT '',
  `ket_apv_kedep` varchar(255) NOT NULL DEFAULT '',
  `ket_apv_kacab` varchar(255) NOT NULL DEFAULT '',
  `ket_apv_direksi` varchar(255) NOT NULL DEFAULT '',
  `ket_apv_finance` varchar(255) NOT NULL DEFAULT '' COMMENT 'finance = adm reimbursment',
  `ket_rev_spv` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '' COMMENT 'Keterangan Revisi',
  `ket_rev_kedep` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '' COMMENT 'Keterangan Revisi',
  `ket_rev_kacab` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '' COMMENT 'Keterangan Revisi',
  `ket_rev_direksi` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '' COMMENT 'Keterangan Revisi',
  `ket_rev_finance` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '' COMMENT 'Keterangan Revisi',
  `ket_tolak_spv` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '',
  `ket_tolak_kedep` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '',
  `ket_tolak_kacab` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '',
  `ket_tolak_direksi` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '',
  `ket_tolak_finance` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '',
  `user_spv` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '',
  `user_kedep` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '',
  `user_kacab` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '',
  `user_direksi` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '',
  `user_finance` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '',
  `tgl_apv_spv` datetime NOT NULL,
  `tgl_apv_kedep` datetime NOT NULL,
  `tgl_apv_kacab` datetime NOT NULL,
  `tgl_apv_direksi` datetime NOT NULL,
  `tgl_apv_finance` datetime NOT NULL,
  `id_company` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2 COLLATE=latin2_general_ci;

/*Data for the table `reimbursement_data` */

/*Table structure for table `reimbursement_jenis` */

DROP TABLE IF EXISTS `reimbursement_jenis`;

CREATE TABLE `reimbursement_jenis` (
  `id_jenis_reimbursement` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `kode_plafon` varchar(20) NOT NULL,
  `jenis_plafon` varchar(150) NOT NULL,
  `max_nominal_plafon` float NOT NULL,
  `id_cabang` varchar(50) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_input` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_update` varchar(100) NOT NULL COMMENT 'nik - nama karyawan',
  PRIMARY KEY (`id_jenis_reimbursement`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `reimbursement_jenis` */

/*Table structure for table `reimbursement_pengajuan` */

DROP TABLE IF EXISTS `reimbursement_pengajuan`;

CREATE TABLE `reimbursement_pengajuan` (
  `id` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `no_pengajuan` varchar(50) NOT NULL COMMENT 'yyyymm + 4 digit nomor urut',
  `tgl_pengajuan` datetime NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `id_departemen` varchar(50) NOT NULL,
  `id_cabang` varchar(50) NOT NULL,
  `keterangan` varchar(255) NOT NULL,
  `status` enum('1','2','3','4','5') NOT NULL COMMENT '1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui, 6=proses',
  `apv_spv` enum('0','1','2','3','4','5','6') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui, 6=proses',
  `apv_kedep` enum('0','1','2','3','4','5','6') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui, 6=proses',
  `apv_kacab` enum('0','1','2','3','4','5','6') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui, 6=proses',
  `apv_direksi` enum('0','1','2','3','4','5','6') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui, 6=proses',
  `apv_finance` enum('0','1','2','3','4','5','6') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui, 6=proses',
  `user_spv` varchar(50) DEFAULT NULL,
  `user_kedep` varchar(50) DEFAULT NULL,
  `user_kacab` varchar(50) DEFAULT NULL,
  `user_direksi` varchar(50) DEFAULT NULL,
  `user_finance` varchar(50) DEFAULT NULL,
  `tgl_apv_spv` datetime DEFAULT NULL,
  `tgl_apv_kedep` datetime DEFAULT NULL,
  `tgl_apv_kacab` datetime DEFAULT NULL,
  `tgl_apv_direksi` datetime DEFAULT NULL,
  `tgl_apv_finance` datetime DEFAULT NULL,
  `id_company` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `reimbursement_pengajuan` */

/*Table structure for table `reimbursement_temp` */

DROP TABLE IF EXISTS `reimbursement_temp`;

CREATE TABLE `reimbursement_temp` (
  `id` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `id_karyawan` varchar(100) NOT NULL,
  `id_jenis_reimbursement` varchar(50) NOT NULL,
  `nominal` int(11) NOT NULL,
  `keterangan` text NOT NULL,
  `tgl_bukti` date NOT NULL,
  `file` text NOT NULL,
  `id_company` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `reimbursement_temp` */

/*Table structure for table `reset_password` */

DROP TABLE IF EXISTS `reset_password`;

CREATE TABLE `reset_password` (
  `id_reset` int(11) NOT NULL AUTO_INCREMENT,
  `id_karyawan` varchar(50) NOT NULL,
  `email` varchar(255) NOT NULL,
  `aktif` int(11) NOT NULL,
  `id_company` varchar(20) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id_reset`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `reset_password` */

/*Table structure for table `riwayat_pekerjaan` */

DROP TABLE IF EXISTS `riwayat_pekerjaan`;

CREATE TABLE `riwayat_pekerjaan` (
  `id_riwayat_pekerjaan` varchar(50) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `nama_perusahaan` varchar(250) NOT NULL,
  `jenis_perusahaan` varchar(250) NOT NULL,
  `jabatan` varchar(250) NOT NULL,
  `kota` varchar(150) NOT NULL,
  `provinsi` varchar(150) NOT NULL,
  `alamat_perusahaan` text NOT NULL,
  `tgl_masuk` date NOT NULL,
  `tgl_keluar` date NOT NULL,
  `alasan_berhenti` text NOT NULL,
  `file` varchar(250) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_riwayat_pekerjaan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `riwayat_pekerjaan` */

/*Table structure for table `riwayat_pekerjaan_h` */

DROP TABLE IF EXISTS `riwayat_pekerjaan_h`;

CREATE TABLE `riwayat_pekerjaan_h` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_riwayat_pekerjaan` varchar(50) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `nama_perusahaan` varchar(250) NOT NULL,
  `jenis_perusahaan` varchar(250) NOT NULL,
  `jabatan` varchar(250) NOT NULL,
  `kota` varchar(150) NOT NULL,
  `provinsi` varchar(150) NOT NULL,
  `alamat_perusahaan` text NOT NULL,
  `tgl_masuk` date NOT NULL,
  `tgl_keluar` date NOT NULL,
  `alasan_berhenti` text NOT NULL,
  `file` varchar(250) NOT NULL,
  `action` enum('1','2','3') NOT NULL DEFAULT '1' COMMENT '1=INSERT; 2=EDIT; 3=DELETE;',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `id_karyawan` (`id_karyawan`,`id_company`)
) ENGINE=InnoDB AUTO_INCREMENT=1870 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `riwayat_pekerjaan_h` */

/*Table structure for table `riwayat_pekerjaan_p` */

DROP TABLE IF EXISTS `riwayat_pekerjaan_p`;

CREATE TABLE `riwayat_pekerjaan_p` (
  `id_riwayat_pekerjaan` varchar(50) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `nama_perusahaan` varchar(250) NOT NULL,
  `jenis_perusahaan` varchar(250) NOT NULL,
  `jabatan` varchar(250) NOT NULL,
  `kota` varchar(150) NOT NULL,
  `provinsi` varchar(150) NOT NULL,
  `alamat_perusahaan` text NOT NULL,
  `tgl_masuk` date NOT NULL,
  `tgl_keluar` date NOT NULL,
  `alasan_berhenti` text NOT NULL,
  `file` varchar(250) NOT NULL,
  `status_pengajuan` enum('1','2','3','4') NOT NULL DEFAULT '1' COMMENT '1:Pengajuan, 2:Approve, 3:Revisi, 4:Hapus',
  `ket_revisi` text DEFAULT NULL,
  `action` enum('1','2','3') NOT NULL DEFAULT '1' COMMENT '1=INSERT; 2=EDIT; 3=DELETE;',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_riwayat_pekerjaan`),
  KEY `id_karyawan` (`id_karyawan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `riwayat_pekerjaan_p` */

/*Table structure for table `riwayat_pendidikan` */

DROP TABLE IF EXISTS `riwayat_pendidikan`;

CREATE TABLE `riwayat_pendidikan` (
  `id_riwayat_pendidikan` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL,
  `nama_sekolah` varchar(150) NOT NULL,
  `jenjang` varchar(50) NOT NULL,
  `jurusan` varchar(150) NOT NULL,
  `lulusan_asal` varchar(100) NOT NULL,
  `gelar` varchar(50) NOT NULL,
  `tahun_masuk` varchar(4) NOT NULL,
  `tahun_lulus` varchar(4) NOT NULL,
  `ijazah` varchar(250) NOT NULL,
  `transkrip` varchar(250) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_riwayat_pendidikan`),
  KEY `SECOND` (`id_karyawan`,`id_company`),
  KEY `THIRD` (`id_karyawan`,`id_company`,`id_riwayat_pendidikan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `riwayat_pendidikan` */

/*Table structure for table `riwayat_pendidikan_h` */

DROP TABLE IF EXISTS `riwayat_pendidikan_h`;

CREATE TABLE `riwayat_pendidikan_h` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_riwayat_pendidikan` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL,
  `nama_sekolah` varchar(150) NOT NULL,
  `jenjang` varchar(50) NOT NULL,
  `jurusan` varchar(150) NOT NULL,
  `lulusan_asal` varchar(100) NOT NULL,
  `gelar` varchar(50) NOT NULL,
  `tahun_masuk` varchar(4) NOT NULL,
  `tahun_lulus` varchar(4) NOT NULL,
  `ijazah` varchar(250) NOT NULL,
  `transkrip` varchar(250) NOT NULL,
  `action` enum('1','2','3') NOT NULL DEFAULT '1' COMMENT '1=INSERT; 2=EDIT; 3=DELETE;',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2528 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `riwayat_pendidikan_h` */

/*Table structure for table `riwayat_pendidikan_p` */

DROP TABLE IF EXISTS `riwayat_pendidikan_p`;

CREATE TABLE `riwayat_pendidikan_p` (
  `id_riwayat_pendidikan` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4 digit nomor urut',
  `id_karyawan` varchar(50) NOT NULL,
  `nama_sekolah` varchar(150) NOT NULL,
  `jenjang` varchar(50) NOT NULL,
  `jurusan` varchar(150) NOT NULL,
  `lulusan_asal` varchar(100) NOT NULL,
  `gelar` varchar(50) NOT NULL,
  `tahun_masuk` varchar(4) NOT NULL,
  `tahun_lulus` varchar(4) NOT NULL,
  `ijazah` varchar(250) NOT NULL,
  `transkrip` varchar(250) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  `status_pengajuan` enum('1','2','3','4') NOT NULL DEFAULT '1' COMMENT '1: Pengajuan, 2:Approve, 3:Revisi, 4:Delete',
  `ket_revisi` text DEFAULT NULL,
  `action` enum('1','2','3') NOT NULL DEFAULT '1' COMMENT '1=INSERT; 2=EDIT; 3=DELETE;',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_riwayat_pendidikan`),
  KEY `SECOND` (`id_karyawan`,`id_company`),
  KEY `THIRD` (`id_karyawan`,`id_company`,`id_riwayat_pendidikan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `riwayat_pendidikan_p` */

/*Table structure for table `sales_activity_m` */

DROP TABLE IF EXISTS `sales_activity_m`;

CREATE TABLE `sales_activity_m` (
  `id_activity_m` varchar(150) NOT NULL DEFAULT '' COMMENT 'id_company + Y + m + 5 digit angka',
  `nama` varchar(255) NOT NULL DEFAULT '',
  `poin` int(4) NOT NULL DEFAULT 0,
  `flag_lokasi` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0 = tidak, 1 = ya',
  `flag_upload_foto` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0 = tidak, 1 = ya',
  `no_urut` int(11) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_activity_m`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `sales_activity_m` */

/*Table structure for table `sales_admin_m` */

DROP TABLE IF EXISTS `sales_admin_m`;

CREATE TABLE `sales_admin_m` (
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `id_group_m` varchar(255) NOT NULL DEFAULT '' COMMENT 'bisa multi id dan all jika semua id',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_karyawan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `sales_admin_m` */

/*Table structure for table `sales_approver` */

DROP TABLE IF EXISTS `sales_approver`;

CREATE TABLE `sales_approver` (
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `status` enum('0','1') NOT NULL DEFAULT '1' COMMENT '0=sales nonaktif, 1=sales aktif',
  `approval` enum('0','1') NOT NULL DEFAULT '1' COMMENT '0=tanpa approval, 1=dengan approval',
  `id_atasan` varchar(50) NOT NULL DEFAULT '',
  `id_group_m` varchar(50) NOT NULL DEFAULT '',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_karyawan`),
  KEY `FILTER_1` (`id_company`,`id_atasan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `sales_approver` */

/*Table structure for table `sales_group_m` */

DROP TABLE IF EXISTS `sales_group_m`;

CREATE TABLE `sales_group_m` (
  `id_group_m` varchar(150) NOT NULL DEFAULT '' COMMENT 'id_company + Y + m + 4 digit angka',
  `kode` varchar(255) NOT NULL DEFAULT '',
  `nama` varchar(255) NOT NULL DEFAULT '',
  `no_urut` int(11) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_group_m`),
  KEY `FILTER_1` (`id_company`,`nama`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `sales_group_m` */

/*Table structure for table `sales_jenis_perusahaan_m` */

DROP TABLE IF EXISTS `sales_jenis_perusahaan_m`;

CREATE TABLE `sales_jenis_perusahaan_m` (
  `id_jenis_perusahaan_m` varchar(150) NOT NULL DEFAULT '' COMMENT 'id_company + Y + m + 4 digit angka',
  `nama` varchar(255) NOT NULL DEFAULT '',
  `flag_jenis` enum('1','2') NOT NULL DEFAULT '1' COMMENT '1: perusahaan; 2: perorangan',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_jenis_perusahaan_m`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `sales_jenis_perusahaan_m` */

/*Table structure for table `sales_lead_m` */

DROP TABLE IF EXISTS `sales_lead_m`;

CREATE TABLE `sales_lead_m` (
  `id_lead_m` varchar(150) NOT NULL DEFAULT '' COMMENT 'id_company + Y + m + 3 digit angka',
  `nama` varchar(255) NOT NULL DEFAULT '',
  `no_urut` int(11) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_lead_m`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `sales_lead_m` */

/*Table structure for table `sales_pelanggan` */

DROP TABLE IF EXISTS `sales_pelanggan`;

CREATE TABLE `sales_pelanggan` (
  `id_pelanggan` varchar(150) NOT NULL DEFAULT '' COMMENT 'id_company + Y + m + 5 digit angka',
  `id_jenis_perusahaan_m` varchar(150) NOT NULL DEFAULT '',
  `id_lead_m` varchar(150) NOT NULL DEFAULT '',
  `nama_perusahaan` varchar(255) NOT NULL DEFAULT '',
  `jenis` enum('1','2') NOT NULL DEFAULT '2' COMMENT '1=pelanggan, 2=calon pelanggan',
  `kategori_pelanggan` enum('perusahaan','perorangan') NOT NULL DEFAULT 'perusahaan',
  `alamat` varchar(255) NOT NULL DEFAULT '',
  `id_provinsi` int(2) NOT NULL DEFAULT 0,
  `id_kota` int(4) NOT NULL DEFAULT 0,
  `id_kecamatan` int(8) NOT NULL DEFAULT 0,
  `id_kelurahan` varchar(30) NOT NULL DEFAULT '0',
  `pic_nama` varchar(255) NOT NULL DEFAULT '',
  `pic_email` varchar(255) NOT NULL DEFAULT '',
  `pic_telp` varchar(15) NOT NULL DEFAULT '',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_pelanggan`),
  KEY `FILTER_1` (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `sales_pelanggan` */

/*Table structure for table `sales_pipeline_activity` */

DROP TABLE IF EXISTS `sales_pipeline_activity`;

CREATE TABLE `sales_pipeline_activity` (
  `id_pipeline_main` varchar(150) NOT NULL DEFAULT '',
  `id_pipeline_main_log` varchar(150) NOT NULL DEFAULT '',
  `id_pelanggan` varchar(150) NOT NULL DEFAULT '',
  `id_karyawan` varchar(150) NOT NULL DEFAULT '',
  `nik` varchar(50) NOT NULL DEFAULT '',
  `nama_karyawan` varchar(150) NOT NULL DEFAULT '',
  `tgl_activity` date NOT NULL DEFAULT '0000-00-00',
  `jam_activity` time NOT NULL DEFAULT '00:00:00',
  `jenis_activity` varchar(255) NOT NULL DEFAULT '',
  `keterangan` varchar(1000) NOT NULL DEFAULT '',
  `poin` int(4) NOT NULL DEFAULT 0,
  `flag_lokasi` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0 = tidak, 1 = ya',
  `flag_upload_foto` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0 = tidak, 1 = ya',
  `lat` varchar(50) NOT NULL DEFAULT '',
  `long` varchar(50) NOT NULL DEFAULT '',
  `path_foto` varchar(255) NOT NULL DEFAULT '',
  `status` enum('pengajuan','tolak','approve') NOT NULL DEFAULT 'pengajuan',
  `kategori` enum('new','move') NOT NULL DEFAULT 'new' COMMENT 'kebutuhan pindah bulan',
  `id_group_m` varchar(50) NOT NULL DEFAULT '',
  `nama_group` varchar(150) NOT NULL DEFAULT '' COMMENT 'kode - nama group',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_approve` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_approve` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_company`,`id_karyawan`,`tgl_activity`,`jam_activity`,`id_pipeline_main`),
  KEY `Filter 1` (`id_company`,`tgl_activity`,`id_group_m`,`id_karyawan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `sales_pipeline_activity` */

/*Table structure for table `sales_pipeline_layanan` */

DROP TABLE IF EXISTS `sales_pipeline_layanan`;

CREATE TABLE `sales_pipeline_layanan` (
  `id_pipeline_layanan` varchar(150) NOT NULL DEFAULT '' COMMENT 'id_company + Y + m + 5 digit angka',
  `id_pipeline_main` varchar(150) NOT NULL DEFAULT '',
  `id_product_m` varchar(150) NOT NULL DEFAULT '',
  `harga` bigint(20) NOT NULL DEFAULT 0,
  `jumlah` int(11) NOT NULL DEFAULT 0,
  `diskon` decimal(4,2) NOT NULL DEFAULT 0.00,
  `harga_total` decimal(22,2) NOT NULL DEFAULT 0.00 COMMENT 'total harga setelah diskon',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_pipeline_layanan`),
  KEY `FILTER_1` (`id_pipeline_main`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `sales_pipeline_layanan` */

/*Table structure for table `sales_pipeline_layanan_draft` */

DROP TABLE IF EXISTS `sales_pipeline_layanan_draft`;

CREATE TABLE `sales_pipeline_layanan_draft` (
  `id_pipeline_layanan_draft` varchar(150) NOT NULL DEFAULT '' COMMENT 'id_company + Y + m + 5 digit angka',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `id_product_m` varchar(150) NOT NULL DEFAULT '',
  `harga` bigint(20) NOT NULL DEFAULT 0,
  `jumlah` int(11) NOT NULL DEFAULT 0,
  `diskon` decimal(4,2) NOT NULL DEFAULT 0.00,
  `harga_total` decimal(22,2) NOT NULL DEFAULT 0.00 COMMENT 'total harga setelah diskon',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_pipeline_layanan_draft`),
  KEY `FILTER_1` (`id_company`,`id_karyawan`,`id_product_m`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `sales_pipeline_layanan_draft` */

/*Table structure for table `sales_pipeline_main` */

DROP TABLE IF EXISTS `sales_pipeline_main`;

CREATE TABLE `sales_pipeline_main` (
  `id_pipeline_main` varchar(150) NOT NULL DEFAULT '' COMMENT 'id_company + Y + m + 5 digit angka',
  `id_karyawan` varchar(150) NOT NULL DEFAULT '',
  `tahun` varchar(4) NOT NULL DEFAULT '',
  `bulan` varchar(2) NOT NULL DEFAULT '',
  `id_lead_m` varchar(255) NOT NULL DEFAULT '',
  `nama_lead_source` varchar(255) NOT NULL DEFAULT '',
  `id_tahapan_m` varchar(150) NOT NULL DEFAULT '',
  `id_pelanggan` varchar(150) NOT NULL DEFAULT '',
  `pic_nama` varchar(255) NOT NULL DEFAULT '',
  `pic_email` varchar(255) NOT NULL DEFAULT '',
  `pic_telp` varchar(15) NOT NULL DEFAULT '',
  `status` enum('pengajuan','tolak','approve') NOT NULL DEFAULT 'pengajuan',
  `title` varchar(255) NOT NULL DEFAULT '',
  `keterangan` varchar(255) NOT NULL DEFAULT '',
  `id_pindah_bulan` varchar(150) NOT NULL DEFAULT '' COMMENT 'id_pipeline_main ketika pindah bulan',
  `id_group_m` varchar(50) NOT NULL DEFAULT '',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_pipeline_main`),
  KEY `FILTER_1` (`id_company`,`id_karyawan`,`tahun`,`bulan`,`id_pelanggan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `sales_pipeline_main` */

/*Table structure for table `sales_pipeline_main_log` */

DROP TABLE IF EXISTS `sales_pipeline_main_log`;

CREATE TABLE `sales_pipeline_main_log` (
  `id_pipeline_main_log` varchar(150) NOT NULL DEFAULT '' COMMENT 'id_company + Y + m + 5 digit angka',
  `id_pipeline_main` varchar(150) NOT NULL DEFAULT '',
  `tahapan_sebelum_id` varchar(255) NOT NULL DEFAULT '',
  `tahapan_sebelum_nm` varchar(255) NOT NULL DEFAULT '',
  `tahapan_sesudah_id` varchar(255) NOT NULL DEFAULT '',
  `tahapan_sesudah_nm` varchar(255) NOT NULL DEFAULT '',
  `status` enum('pengajuan','tolak','approve') NOT NULL DEFAULT 'pengajuan',
  `kategori` enum('new','move') NOT NULL DEFAULT 'new' COMMENT 'kebutuhan pindah bulan',
  `keterangan` varchar(255) NOT NULL DEFAULT '',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_approve` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_approve` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_pipeline_main_log`),
  KEY `filter_get_id_pipeline_main` (`id_company`,`id_pipeline_main`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `sales_pipeline_main_log` */

/*Table structure for table `sales_pipeline_trx` */

DROP TABLE IF EXISTS `sales_pipeline_trx`;

CREATE TABLE `sales_pipeline_trx` (
  `id_pipeline_trx` varchar(150) NOT NULL DEFAULT '' COMMENT 'id_company + Y + m + 5 digit angka',
  `id_pipeline_main` varchar(150) NOT NULL DEFAULT '',
  `id_karyawan` varchar(150) NOT NULL DEFAULT '',
  `nik` varchar(50) NOT NULL DEFAULT '',
  `nama_karyawan` varchar(150) NOT NULL DEFAULT '',
  `tahun` varchar(4) NOT NULL DEFAULT '',
  `bulan` varchar(2) NOT NULL DEFAULT '',
  `id_tahapan` varchar(150) NOT NULL DEFAULT '',
  `jenis_tahapan` enum('incoming','activity','wont','lost') NOT NULL DEFAULT 'activity',
  `nama_tahapan` varchar(255) NOT NULL DEFAULT '',
  `warna_tahapan` varchar(7) NOT NULL DEFAULT '#FFFFFF',
  `warna_text_tahapan` varchar(7) NOT NULL DEFAULT '#FFFFFF',
  `no_urut_tahapan` int(11) NOT NULL DEFAULT 0,
  `nominal_layanan` bigint(20) NOT NULL DEFAULT 0,
  `jumlah_layanan` int(11) NOT NULL DEFAULT 0,
  `id_pelanggan` varchar(150) NOT NULL DEFAULT '' COMMENT 'id dari table sales_pelanggan',
  `nama_perusahaan` varchar(255) NOT NULL DEFAULT '',
  `provinsi` varchar(255) NOT NULL DEFAULT '',
  `kota` varchar(255) NOT NULL DEFAULT '',
  `kecamatan` varchar(255) NOT NULL DEFAULT '',
  `kelurahan` varchar(255) NOT NULL DEFAULT '',
  `alamat` varchar(255) NOT NULL DEFAULT '',
  `nama_jenis_perusahaan` varchar(255) NOT NULL DEFAULT '',
  `nama_lead_source` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `id_group_m` varchar(50) NOT NULL DEFAULT '',
  `nama_group` varchar(150) NOT NULL DEFAULT '' COMMENT 'kode - nama',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `tgl_incoming` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_approve` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_approve` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_pipeline_trx`),
  KEY `filter_id_company_id_karyawan_tahun_bulan` (`id_company`,`id_karyawan`,`tahun`,`bulan`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `sales_pipeline_trx` */

/*Table structure for table `sales_product_group_m` */

DROP TABLE IF EXISTS `sales_product_group_m`;

CREATE TABLE `sales_product_group_m` (
  `id_product_group_m` varchar(150) NOT NULL DEFAULT '' COMMENT 'id_company + Y + m + 4 digit angka',
  `id_group_m` varchar(150) NOT NULL DEFAULT '',
  `kode` varchar(255) NOT NULL DEFAULT '',
  `nama` varchar(255) NOT NULL DEFAULT '',
  `no_urut` int(11) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_product_group_m`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `sales_product_group_m` */

/*Table structure for table `sales_product_m` */

DROP TABLE IF EXISTS `sales_product_m`;

CREATE TABLE `sales_product_m` (
  `id_product_m` varchar(150) NOT NULL DEFAULT '' COMMENT 'id_company + Y + m + 5 digit angka',
  `id_product_group_m` varchar(150) NOT NULL DEFAULT '' COMMENT 'relasi dengan sales_product_group_m',
  `kode` varchar(255) NOT NULL DEFAULT '',
  `nama` varchar(255) NOT NULL DEFAULT '',
  `harga` int(11) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_product_m`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `sales_product_m` */

/*Table structure for table `sales_tahapan_m` */

DROP TABLE IF EXISTS `sales_tahapan_m`;

CREATE TABLE `sales_tahapan_m` (
  `id_tahapan_m` varchar(150) NOT NULL DEFAULT '' COMMENT 'id_company + Y + m + 5 digit angka',
  `jenis` enum('incoming','activity','wont','lost') NOT NULL DEFAULT 'activity',
  `nama` varchar(255) NOT NULL DEFAULT '',
  `warna` varchar(7) NOT NULL DEFAULT '#FFFFFF',
  `warna_text` varchar(7) NOT NULL DEFAULT '#FFFFFF',
  `no_urut` int(11) NOT NULL DEFAULT 0 COMMENT 'berlaku untuk jenis tahapan activity',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_tahapan_m`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `sales_tahapan_m` */

/*Table structure for table `sales_tahapan_trx` */

DROP TABLE IF EXISTS `sales_tahapan_trx`;

CREATE TABLE `sales_tahapan_trx` (
  `tahun` varchar(4) NOT NULL DEFAULT '',
  `bulan` varchar(2) NOT NULL DEFAULT '',
  `id_tahapan_m` varchar(150) NOT NULL DEFAULT '' COMMENT 'id_company + Y + m + 5 digit angka',
  `jenis` enum('incoming','activity','wont','lost') NOT NULL DEFAULT 'activity',
  `nama` varchar(255) NOT NULL DEFAULT '',
  `warna` varchar(7) NOT NULL DEFAULT '#FFFFFF',
  `warna_text` varchar(7) NOT NULL DEFAULT '#FFFFFF',
  `no_urut` int(11) NOT NULL DEFAULT 0 COMMENT 'berlaku untuk jenis tahapan activity',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`tahun`,`bulan`,`id_tahapan_m`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `sales_tahapan_trx` */

/*Table structure for table `sales_target_bulanan_p` */

DROP TABLE IF EXISTS `sales_target_bulanan_p`;

CREATE TABLE `sales_target_bulanan_p` (
  `tahun` varchar(4) NOT NULL DEFAULT '',
  `bulan` varchar(2) NOT NULL DEFAULT '',
  `nominal` bigint(20) NOT NULL DEFAULT 0,
  `id_group_m` varchar(50) NOT NULL DEFAULT '',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`tahun`,`bulan`,`id_group_m`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `sales_target_bulanan_p` */

/*Table structure for table `sales_target_kuartal_p` */

DROP TABLE IF EXISTS `sales_target_kuartal_p`;

CREATE TABLE `sales_target_kuartal_p` (
  `tahun` varchar(4) NOT NULL DEFAULT '',
  `bulan` varchar(2) NOT NULL DEFAULT '',
  `nominal` bigint(20) NOT NULL DEFAULT 0,
  `id_group_m` varchar(50) NOT NULL DEFAULT '',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`tahun`,`bulan`,`id_group_m`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `sales_target_kuartal_p` */

/*Table structure for table `sales_target_personil_p` */

DROP TABLE IF EXISTS `sales_target_personil_p`;

CREATE TABLE `sales_target_personil_p` (
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `tahun` varchar(4) NOT NULL DEFAULT '',
  `bulan` varchar(2) NOT NULL DEFAULT '',
  `nominal` bigint(20) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_karyawan`,`tahun`,`bulan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `sales_target_personil_p` */

/*Table structure for table `sales_target_personil_r` */

DROP TABLE IF EXISTS `sales_target_personil_r`;

CREATE TABLE `sales_target_personil_r` (
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `nik` varchar(50) NOT NULL DEFAULT '',
  `nama_karyawan` varchar(150) NOT NULL DEFAULT '',
  `tahun` varchar(4) NOT NULL DEFAULT '',
  `bulan` varchar(2) NOT NULL DEFAULT '',
  `nominal_target` bigint(20) NOT NULL DEFAULT 0,
  `nominal_realisasi` bigint(20) NOT NULL DEFAULT 0,
  `jumlah_po` int(11) NOT NULL DEFAULT 0,
  `id_group_m` varchar(50) NOT NULL DEFAULT '',
  `nama_group` varchar(150) NOT NULL DEFAULT '' COMMENT 'kode - nama',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_company`,`id_karyawan`,`tahun`,`bulan`,`id_group_m`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `sales_target_personil_r` */

/*Table structure for table `sales_target_poin_p` */

DROP TABLE IF EXISTS `sales_target_poin_p`;

CREATE TABLE `sales_target_poin_p` (
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `poin` int(11) NOT NULL DEFAULT 0,
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_karyawan`),
  KEY `filter` (`id_company`,`id_karyawan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `sales_target_poin_p` */

/*Table structure for table `sales_target_poin_trx` */

DROP TABLE IF EXISTS `sales_target_poin_trx`;

CREATE TABLE `sales_target_poin_trx` (
  `tgl_trx` date NOT NULL DEFAULT '0000-00-00',
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `nik` varchar(50) NOT NULL DEFAULT '',
  `nama_karyawan` varchar(100) NOT NULL DEFAULT '',
  `poin` int(11) NOT NULL DEFAULT 0,
  `id_group_m` varchar(50) NOT NULL DEFAULT '',
  `nama_group` varchar(150) NOT NULL DEFAULT '' COMMENT 'kode - nama',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`tgl_trx`,`id_karyawan`),
  KEY `filter` (`id_company`,`tgl_trx`,`id_group_m`,`id_karyawan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `sales_target_poin_trx` */

/*Table structure for table `sales_target_tahunan_p` */

DROP TABLE IF EXISTS `sales_target_tahunan_p`;

CREATE TABLE `sales_target_tahunan_p` (
  `tahun` varchar(4) NOT NULL DEFAULT '',
  `bulan` varchar(2) NOT NULL DEFAULT '',
  `nominal` bigint(20) NOT NULL DEFAULT 0,
  `id_group_m` varchar(50) NOT NULL DEFAULT '',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_input` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_update` varchar(255) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`tahun`,`bulan`,`id_group_m`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `sales_target_tahunan_p` */

/*Table structure for table `shift_p` */

DROP TABLE IF EXISTS `shift_p`;

CREATE TABLE `shift_p` (
  `aktif` enum('0','1') NOT NULL DEFAULT '1',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  `user_update` varchar(100) NOT NULL DEFAULT '' COMMENT 'nik - nama karyawan',
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `shift_p` */

/*Table structure for table `shift_p_approval` */

DROP TABLE IF EXISTS `shift_p_approval`;

CREATE TABLE `shift_p_approval` (
  `level_approval` varchar(50) NOT NULL COMMENT 'level approval bisa diisi lebih dari satu dengan pemisah tanda koma',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `shift_p_approval` */

/*Table structure for table `shift_pengajuan` */

DROP TABLE IF EXISTS `shift_pengajuan`;

CREATE TABLE `shift_pengajuan` (
  `no_pengajuan` varchar(100) NOT NULL DEFAULT '' COMMENT 'TK+yy+mm+5digit nomor urut',
  `id_karyawan` varchar(100) NOT NULL DEFAULT '',
  `status` enum('0','1','2','3','4') NOT NULL DEFAULT '0' COMMENT '1:pengajuan; 2:dibatalkan; 3:ditolak; 4:disetujui',
  `tgl_pengajuan` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `apv_teman` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `apv_spv` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `apv_kedep` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `apv_kacab` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `apv_direksi` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `apv_hrd` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0' COMMENT '0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=disetujui, 5=proses',
  `user_teman` varchar(50) NOT NULL DEFAULT '',
  `user_spv` varchar(50) NOT NULL DEFAULT '',
  `user_kedep` varchar(50) NOT NULL DEFAULT '',
  `user_kacab` varchar(50) NOT NULL DEFAULT '',
  `user_direksi` varchar(50) NOT NULL DEFAULT '',
  `user_hrd` varchar(50) NOT NULL DEFAULT '',
  `tgl_apv_teman` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `tgl_apv_kedep` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `tgl_apv_spv` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `tgl_apv_kacab` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `tgl_apv_direksi` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `tgl_apv_hrd` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`no_pengajuan`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `shift_pengajuan` */

/*Table structure for table `shift_pengajuan_item` */

DROP TABLE IF EXISTS `shift_pengajuan_item`;

CREATE TABLE `shift_pengajuan_item` (
  `id_pengajuan` varchar(100) NOT NULL COMMENT 'id_company+yy+mm+5_digit_nomor_urut',
  `no_pengajuan` varchar(100) NOT NULL DEFAULT '' COMMENT 'TK+yy+mm+5digit nomor urut',
  `id_karyawan` varchar(100) NOT NULL DEFAULT '',
  `id_karyawan_tukar` varchar(100) NOT NULL DEFAULT '',
  `tgl_shift` date NOT NULL DEFAULT '0000-00-00',
  `kd_shift_awal` varchar(50) NOT NULL DEFAULT '',
  `nm_shift_awal` varchar(50) NOT NULL DEFAULT '',
  `masuk_awal` time NOT NULL DEFAULT '00:00:00',
  `pulang_awal` time NOT NULL DEFAULT '00:00:00',
  `kd_shift_baru` varchar(50) NOT NULL DEFAULT '',
  `nm_shift_baru` varchar(50) NOT NULL DEFAULT '',
  `masuk_baru` time NOT NULL DEFAULT '00:00:00',
  `pulang_baru` time NOT NULL DEFAULT '00:00:00',
  `keterangan` varchar(100) NOT NULL,
  `id_company` varchar(50) NOT NULL,
  PRIMARY KEY (`id_pengajuan`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `shift_pengajuan_item` */

/*Table structure for table `slip_gaji` */

DROP TABLE IF EXISTS `slip_gaji`;

CREATE TABLE `slip_gaji` (
  `id_slip` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `nama` varchar(50) NOT NULL,
  `jabatan` varchar(50) NOT NULL,
  `no_rekening` varchar(50) NOT NULL,
  `gaji_pokok` varchar(50) NOT NULL DEFAULT '0',
  `tunj_jab` varchar(50) NOT NULL DEFAULT '0',
  `tunj_ops` varchar(50) NOT NULL DEFAULT '0',
  `thp` varchar(50) NOT NULL DEFAULT '0',
  `tunj_transport` varchar(50) NOT NULL DEFAULT '0',
  `uang_makan` varchar(50) NOT NULL DEFAULT '0',
  `total_gaji` varchar(50) NOT NULL DEFAULT '0',
  `lain_lain` varchar(50) NOT NULL DEFAULT '0',
  `tunj_istri` varchar(50) NOT NULL DEFAULT '0',
  `tunj_anak` varchar(50) NOT NULL DEFAULT '0',
  `komisi` varchar(50) NOT NULL DEFAULT '0',
  `lembur` varchar(50) NOT NULL DEFAULT '0',
  `cashbon` varchar(50) NOT NULL DEFAULT '0',
  `koperasi` varchar(50) NOT NULL DEFAULT '0',
  `bpjs_ketenagakerjaan` varchar(50) NOT NULL DEFAULT '0',
  `bpjs_kesehatan` varchar(50) NOT NULL DEFAULT '0',
  `iuran_koperasi` varchar(50) NOT NULL DEFAULT '0',
  `absensi` varchar(50) NOT NULL DEFAULT '0',
  `kekurangan_sebelumnya` varchar(50) NOT NULL DEFAULT '0',
  `gaji_bersih` varchar(50) NOT NULL DEFAULT '0',
  `nik` varchar(50) NOT NULL DEFAULT '0',
  `bpjs_tk_perusahaan` varchar(50) NOT NULL DEFAULT '0',
  `bpjs_ks_perusahaan` varchar(50) NOT NULL DEFAULT '0',
  `axa` varchar(50) NOT NULL DEFAULT '0',
  `pot_asuransi` varchar(20) NOT NULL DEFAULT '0' COMMENT 'personal',
  `email` varchar(100) DEFAULT NULL,
  `nikx` varchar(100) DEFAULT NULL,
  `kirim` tinyint(4) NOT NULL DEFAULT 0,
  `id_company` varchar(20) NOT NULL DEFAULT '1',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_slip`),
  KEY `slip_gaji` (`tanggal`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `slip_gaji` */

/*Table structure for table `slip_gaji_temp` */

DROP TABLE IF EXISTS `slip_gaji_temp`;

CREATE TABLE `slip_gaji_temp` (
  `id_slip_temp` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `flag` int(11) NOT NULL DEFAULT 0,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tanggal` date NOT NULL,
  `nama` varchar(50) NOT NULL,
  `jabatan` varchar(50) NOT NULL,
  `no_rekening` varchar(50) NOT NULL,
  `gaji_pokok` varchar(50) NOT NULL DEFAULT '0',
  `tunj_jab` varchar(50) NOT NULL DEFAULT '0',
  `tunj_ops` varchar(50) NOT NULL DEFAULT '0',
  `thp` varchar(50) NOT NULL DEFAULT '0',
  `tunj_transport` varchar(50) NOT NULL DEFAULT '0',
  `uang_makan` varchar(50) NOT NULL DEFAULT '0',
  `total_gaji` varchar(50) NOT NULL DEFAULT '0',
  `lain_lain` varchar(50) NOT NULL DEFAULT '0',
  `tunj_istri` varchar(50) NOT NULL DEFAULT '0',
  `tunj_anak` varchar(50) NOT NULL DEFAULT '0',
  `komisi` varchar(50) NOT NULL DEFAULT '0',
  `lembur` varchar(50) NOT NULL DEFAULT '0',
  `cashbon` varchar(50) NOT NULL DEFAULT '0',
  `koperasi` varchar(50) NOT NULL DEFAULT '0',
  `bpjs_ketenagakerjaan` varchar(50) NOT NULL DEFAULT '0',
  `bpjs_kesehatan` varchar(50) NOT NULL DEFAULT '0',
  `iuran_koperasi` varchar(50) NOT NULL DEFAULT '0',
  `absensi` varchar(50) NOT NULL DEFAULT '0',
  `kekurangan_sebelumnya` varchar(50) NOT NULL DEFAULT '0',
  `gaji_bersih` varchar(50) NOT NULL DEFAULT '0',
  `nik` varchar(50) NOT NULL DEFAULT '0',
  `bpjs_tk_perusahaan` varchar(50) NOT NULL DEFAULT '0',
  `bpjs_ks_perusahaan` varchar(50) NOT NULL DEFAULT '0',
  `axa` varchar(50) NOT NULL DEFAULT '0',
  `pot_asuransi` varchar(50) NOT NULL DEFAULT '0',
  `email` varchar(100) NOT NULL DEFAULT '0',
  `kirim` tinyint(4) NOT NULL DEFAULT 0,
  `id_company` varchar(20) NOT NULL,
  `nikx` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id_slip_temp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `slip_gaji_temp` */

/*Table structure for table `sos_data` */

DROP TABLE IF EXISTS `sos_data`;

CREATE TABLE `sos_data` (
  `id` varchar(50) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `tanggal` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `keterangan` text NOT NULL,
  `id_company` varchar(11) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `sos_data` */

/*Table structure for table `sos_file` */

DROP TABLE IF EXISTS `sos_file`;

CREATE TABLE `sos_file` (
  `id_file_sos` int(11) NOT NULL AUTO_INCREMENT,
  `id_sos` varchar(50) NOT NULL,
  `file` text NOT NULL,
  `id_company` varchar(12) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_file_sos`)
) ENGINE=InnoDB AUTO_INCREMENT=228 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `sos_file` */

/*Table structure for table `status_karyawan` */

DROP TABLE IF EXISTS `status_karyawan`;

CREATE TABLE `status_karyawan` (
  `id_status` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(250) NOT NULL,
  PRIMARY KEY (`id_status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `status_karyawan` */

/*Table structure for table `tabel_bantuan_update` */

DROP TABLE IF EXISTS `tabel_bantuan_update`;

CREATE TABLE `tabel_bantuan_update` (
  `id_karyawan` varchar(50) NOT NULL DEFAULT '',
  `nik` varchar(50) NOT NULL DEFAULT '',
  `nama_karyawan` varchar(50) NOT NULL DEFAULT '',
  `id_cabang` varchar(50) NOT NULL DEFAULT '',
  `kode_cabang` varchar(50) NOT NULL DEFAULT '',
  `nama_cabang` varchar(50) NOT NULL DEFAULT '',
  `id_departemen` varchar(50) NOT NULL DEFAULT '',
  `kode_departemen` varchar(50) NOT NULL DEFAULT '',
  `nama_departemen` varchar(50) NOT NULL DEFAULT '',
  `id_jabatan` varchar(50) NOT NULL DEFAULT '',
  `kode_jabatan` varchar(50) NOT NULL DEFAULT '',
  `nama_jabatan` varchar(50) NOT NULL DEFAULT '',
  `supervisi` varchar(50) NOT NULL DEFAULT '',
  `nama_supervisi` varchar(50) NOT NULL DEFAULT '',
  `tgl_absen` date NOT NULL DEFAULT '0000-00-00',
  `jenis_absen` varchar(50) NOT NULL DEFAULT '',
  `kode_absensi` varchar(50) NOT NULL DEFAULT '',
  `ket_kode` varchar(50) NOT NULL DEFAULT '',
  `jam_masuk_kerja` time NOT NULL DEFAULT '00:00:00',
  `absen_masuk` time NOT NULL DEFAULT '00:00:00',
  `jam_pulang_kerja` time NOT NULL DEFAULT '00:00:00',
  `absen_pulang` time NOT NULL DEFAULT '00:00:00',
  `id_company` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_karyawan`,`tgl_absen`,`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `tabel_bantuan_update` */

/*Table structure for table `tb_history` */

DROP TABLE IF EXISTS `tb_history`;

CREATE TABLE `tb_history` (
  `id_history` int(11) NOT NULL AUTO_INCREMENT,
  `id_company` varchar(20) DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `tgl_request` datetime DEFAULT NULL,
  `tgl_approval_marketing` datetime DEFAULT NULL,
  `tgl_approval_support` datetime DEFAULT NULL,
  `id_paket` int(11) DEFAULT NULL,
  `id_paket_lama` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_history`)
) ENGINE=InnoDB AUTO_INCREMENT=69283 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `tb_history` */

/*Table structure for table `tb_invoice` */

DROP TABLE IF EXISTS `tb_invoice`;

CREATE TABLE `tb_invoice` (
  `id_invoice` int(11) NOT NULL AUTO_INCREMENT,
  `tgl_invoice` datetime DEFAULT NULL,
  `tgl_jatuh_tempo` datetime DEFAULT NULL,
  `total` varchar(255) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `tgl_bayar` datetime DEFAULT NULL,
  `gateway` varchar(255) DEFAULT NULL,
  `id_order` varchar(20) DEFAULT NULL COMMENT 'relasi dengan id_transaksi pada tabel tb_transaksi',
  PRIMARY KEY (`id_invoice`),
  KEY `id_order` (`id_order`)
) ENGINE=InnoDB AUTO_INCREMENT=10632 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `tb_invoice` */

/*Table structure for table `tb_paket` */

DROP TABLE IF EXISTS `tb_paket`;

CREATE TABLE `tb_paket` (
  `id_tb_paket` int(11) NOT NULL,
  `id_paket` int(11) NOT NULL,
  `nama` varchar(100) NOT NULL DEFAULT '',
  `tarif` float NOT NULL,
  `komponen` text DEFAULT NULL,
  `komponen_web` longtext NOT NULL COMMENT '1= Master Cabang, 2= Master Departemen, 3= Master jabatan, 4= Master lokasi, 5= Shift (master shift dan jadwal shift), 6= Izin (master izin, p aproval izin, laporan izin), 7= Lembur (master lembur, p aproval lembur, laporan lembur), 8= Aktivitas, 9= Informasi Gaji, 10= Reimbursement, 11= Payroll, 12 = KPI',
  `komponen_mobile` varchar(255) NOT NULL COMMENT '1=izin, 2=lembur, 3=shift, 4=remburse, 5=info gaji, 6=aktivitas, 7=berita, 8=payroll, 9 = KPI',
  `max_karyawan` int(11) NOT NULL DEFAULT 0,
  `max_sales` int(11) NOT NULL DEFAULT 0,
  `max_cabang` varchar(250) NOT NULL DEFAULT '-',
  `id_company` varchar(255) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tgl_update` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_tb_paket`),
  KEY `idx_idpaket` (`id_paket`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `tb_paket` */

insert  into `tb_paket`(`id_tb_paket`,`id_paket`,`nama`,`tarif`,`komponen`,`komponen_web`,`komponen_mobile`,`max_karyawan`,`max_sales`,`max_cabang`,`id_company`,`tgl_input`,`tgl_update`) values 
(202403002,13,'Absenku Custom',0,'{\"absensi\":true,\"cuti\":true,\"shift\":true,\"lembur\":true,\"aktivitas\":true,\"berita\":true,\"info_gaji\":true,\"reimburse\":true,\"payroll\":false,\"ess\":true,\"sales_activity\":false,\"kpi\":false,\"flexible_jam_kerja\":true,\"patroli\":false,\"sos_button\":false,\"pkwt\":false}','1-1-1-1-1-1-1-1-1-0-1','1-1-1-0-1-1-1-1-1',30,0,'-','','2025-02-07 15:15:59','2025-08-19 15:21:16');

/*Table structure for table `tb_transaksi` */

DROP TABLE IF EXISTS `tb_transaksi`;

CREATE TABLE `tb_transaksi` (
  `id_transaksi` varchar(20) NOT NULL COMMENT 'id_company + yyyy + 2 digit',
  `id_company` varchar(20) DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `tgl_aktif` date DEFAULT NULL COMMENT 'tgl_berakhir',
  `id_tb_paket` int(11) DEFAULT NULL,
  `masa_layanan` int(11) DEFAULT NULL COMMENT '1=lifetime;2=30hari;3=6bulan;4=12bulan',
  `sub_total` varchar(15) NOT NULL DEFAULT '0',
  `diskon` varchar(15) NOT NULL DEFAULT '0',
  `ppn` varchar(15) NOT NULL DEFAULT '0',
  `materai` int(11) NOT NULL DEFAULT 0,
  `tagihan` varchar(15) NOT NULL DEFAULT '0',
  `opsi` int(11) NOT NULL DEFAULT 1 COMMENT '1=beli; 2=perpanjang; 3=ubah',
  `status` int(11) NOT NULL COMMENT '1=belum bayar; 2=waiting; 3=aktif',
  `jumlah_user` smallint(5) unsigned NOT NULL DEFAULT 0,
  `harga_per_user` smallint(5) unsigned NOT NULL DEFAULT 0,
  `tarif` int(11) NOT NULL DEFAULT 0,
  `dp` int(11) NOT NULL DEFAULT 0,
  `jenis_hutang_piutang` enum('0','1') NOT NULL DEFAULT '0',
  `hutang_piutang` int(11) NOT NULL DEFAULT 0,
  `keterangan` text DEFAULT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_transaksi`),
  KEY `tb_transaksi` (`id_company`,`opsi`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `tb_transaksi` */

/*Table structure for table `token_auto_login` */

DROP TABLE IF EXISTS `token_auto_login`;

CREATE TABLE `token_auto_login` (
  `id_company` varchar(20) NOT NULL,
  `token` varchar(100) NOT NULL,
  `waktu` datetime DEFAULT NULL,
  `tgl_input` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci COMMENT='tabel untuk menyimpan token fitur auto login';

/*Data for the table `token_auto_login` */

/*Table structure for table `tujuan_menggunakan` */

DROP TABLE IF EXISTS `tujuan_menggunakan`;

CREATE TABLE `tujuan_menggunakan` (
  `id` tinyint(1) NOT NULL,
  `tujuan` varchar(30) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `tujuan_menggunakan` */

/*Table structure for table `user_dashboard` */

DROP TABLE IF EXISTS `user_dashboard`;

CREATE TABLE `user_dashboard` (
  `id_user` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(20) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `nama` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `level` int(11) DEFAULT NULL COMMENT '1=admin;2=marketing;3=apps;4=finance;',
  `status` enum('aktif','non_aktif') NOT NULL DEFAULT 'aktif',
  PRIMARY KEY (`id_user`)
) ENGINE=InnoDB AUTO_INCREMENT=103 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `user_dashboard` */

/*Table structure for table `usergroup` */

DROP TABLE IF EXISTS `usergroup`;

CREATE TABLE `usergroup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `level` varchar(50) NOT NULL,
  `urutan` int(11) NOT NULL DEFAULT 1,
  `urutan_payroll` tinyint(2) DEFAULT 1,
  `lang_id` varchar(50) NOT NULL DEFAULT '',
  `lang_en` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `usergroup` */

insert  into `usergroup`(`id`,`level`,`urutan`,`urutan_payroll`,`lang_id`,`lang_en`) values 
(1,'Administrator',1,1,'Administrator','Administrator'),
(2,'Kepala Unit',5,4,'Kepala Unit','Head of Departement'),
(3,'Pegawai',7,6,'Pegawai','Staff'),
(4,'Direksi',3,2,'Direksi','Director'),
(5,'Kepala Klien',4,3,'Kepala Klien','Branch Head'),
(6,'Admin Finance',2,7,'Admin Finance','Finance Admin'),
(7,'Supervisi',6,5,'Supervisi','Supervisor');

/*Table structure for table `users` */

DROP TABLE IF EXISTS `users`;

CREATE TABLE `users` (
  `id_user` varchar(50) NOT NULL COMMENT 'id_company + yyyymm + 4digit nomor urut',
  `username` varchar(50) NOT NULL,
  `password` varchar(100) NOT NULL DEFAULT '2bdbce3554458f3211dd08fdd30d86f1a180dce4',
  `password_2` varchar(100) NOT NULL,
  `id_karyawan` varchar(50) NOT NULL,
  `device_id` varchar(255) NOT NULL,
  `lock_device` enum('0','1') NOT NULL DEFAULT '0',
  `token_fcm` varchar(255) NOT NULL,
  `lock_facerecognition` enum('0','1') NOT NULL DEFAULT '0',
  `matrix_facerecognition` text DEFAULT NULL,
  `foto_facerecognition` text DEFAULT NULL,
  `kamera` enum('0','1','2') NOT NULL DEFAULT '2',
  `qrcode_flag` tinyint(1) NOT NULL DEFAULT 0,
  `login` tinyint(4) NOT NULL DEFAULT 0,
  `versi_aplikasi` varchar(8) NOT NULL DEFAULT '',
  `lang` enum('id','en') NOT NULL DEFAULT 'en',
  `id_company` varchar(11) NOT NULL DEFAULT '1',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tgl_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_user`),
  KEY `user` (`id_karyawan`),
  KEY `user2` (`username`,`password`,`password_2`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `users` */

insert  into `users`(`id_user`,`username`,`password`,`password_2`,`id_karyawan`,`device_id`,`lock_device`,`token_fcm`,`lock_facerecognition`,`matrix_facerecognition`,`foto_facerecognition`,`kamera`,`qrcode_flag`,`login`,`versi_aplikasi`,`lang`,`id_company`,`tgl_input`,`tgl_update`) values 
('C2025080012024030001','e_kedep','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','C20250800100002','','0','','0','','','2',0,0,'','id','C202508001','2024-03-14 06:11:36','2024-06-25 15:09:20'),
('C2025080012024030002','e_staff','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','C20250800100003','','0','','0','','','2',0,0,'','id','C202508001','2024-03-14 06:12:31','2024-06-25 15:09:20'),
('C2025080012024030003','e_direksi','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','C20250800100004','','0','','0','','','2',0,0,'','id','C202508001','2024-03-14 06:13:09','2024-06-25 15:09:20'),
('C2025080012024030004','e_kacab','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','C20250800100005','','0','','0','','','2',0,0,'','id','C202508001','2024-03-14 06:13:50','2024-06-25 15:09:20'),
('C2025080012024030005','e_admin','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','C20250800100001','','1','','1','','','1',0,0,'','id','C202508001','2023-03-29 15:32:50','2024-06-25 15:28:55'),
('C2025080012024030006','e_supervisi','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','C20250800100007','','0','','0','','','2',0,0,'','id','C202508001','2024-03-14 06:15:18','2024-06-25 15:09:20'),
('C2025080012025030001','e_finance','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','C20250800100006','','0','','0','','','2',0,0,'','en','C202508001','2025-03-07 09:46:50','0000-00-00 00:00:00'),
('D2025080012024030001','de_kedep','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','D20250800100002','4e8bb69e93a5008b','0','','0','','','2',0,0,'1.0.0','id','D202508001','2024-03-13 10:21:50','2025-08-19 14:27:58'),
('D2025080012024030002','de_staff','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','D20250800100003','AP3A.240617.008','0','c4YVpw10TCa3LPdN0lkVJo:APA91bGjAxoiH7xDwT2qGEVBBianu7Kgm0YtisDtY42EcXT6ActrFAfQAROBGZ3BGx2gBLhlTZEpkDORUkWrhg3d8aysZ6GRKxZYx5tkJ3IlgyHeTBNlzlU','0','','','2',0,1,'1.0.0','id','D202508001','2024-03-13 10:23:35','2025-08-19 14:25:43'),
('D2025080012024030003','de_direksi','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','D20250800100004','','0','','0','','','2',0,0,'','id','D202508001','2024-03-13 10:24:55','2024-06-25 15:09:20'),
('D2025080012024030004','de_kacab','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','D20250800100005','','0','','0','','','2',0,0,'','id','D202508001','2024-03-13 10:25:50','2024-06-25 15:09:20'),
('D2025080012024030005','de_admin','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','D20250800100001','','0','','0','','','2',0,0,'','id','D202508001','2024-01-12 14:29:55','2024-06-25 15:29:19'),
('D2025080012024030006','de_supervisi','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','D20250800100007','','0','','0','','','2',0,0,'','id','D202508001','2024-03-13 10:27:57','2024-06-25 15:09:20'),
('D2025080012024080001','de_slamet','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','D20250800100009','','0','','0','','','2',0,0,'','en','D202508001','2024-08-09 14:11:51','0000-00-00 00:00:00'),
('D2025080012025030001','de_finance','2bdbce3554458f3211dd08fdd30d86f1a180dce4','','D202508001000006','','0','','0','','','2',0,0,'','en','D202508001','2025-03-07 09:44:46','0000-00-00 00:00:00');

/*Table structure for table `v_aplikasi` */

DROP TABLE IF EXISTS `v_aplikasi`;

CREATE TABLE `v_aplikasi` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `version_code` varchar(50) NOT NULL,
  `version_name` varchar(50) NOT NULL,
  `keterangan_update` text NOT NULL,
  `aktif` enum('0','1') NOT NULL DEFAULT '0',
  `force_update` enum('0','1') NOT NULL DEFAULT '0',
  `link_update` text NOT NULL,
  `link_update_android` varchar(255) NOT NULL,
  `link_update_ios` varchar(255) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `v_aplikasi` */

/*Table structure for table `v_aplikasi_company` */

DROP TABLE IF EXISTS `v_aplikasi_company`;

CREATE TABLE `v_aplikasi_company` (
  `id_company` varchar(100) NOT NULL DEFAULT '',
  `company_name` varchar(150) NOT NULL DEFAULT '',
  `version_code` varchar(5) NOT NULL DEFAULT '',
  `version_name` varchar(15) NOT NULL DEFAULT '',
  `flag_aktif` enum('0','1') NOT NULL DEFAULT '0',
  `flag_force_update` enum('0','1') NOT NULL DEFAULT '0',
  `tgl_force_update` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `keterangan_update` text NOT NULL,
  `link_update_android` varchar(255) NOT NULL DEFAULT '',
  `link_update_ios` varchar(255) NOT NULL DEFAULT '',
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `v_aplikasi_company` */

/*Table structure for table `wilayah` */

DROP TABLE IF EXISTS `wilayah`;

CREATE TABLE `wilayah` (
  `kode` varchar(13) NOT NULL,
  `nama` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

/*Data for the table `wilayah` */

/*Table structure for table `wizard` */

DROP TABLE IF EXISTS `wizard`;

CREATE TABLE `wizard` (
  `data_lokasi` enum('0','1') NOT NULL DEFAULT '0',
  `akun_kedep` enum('0','1') NOT NULL DEFAULT '0',
  `akun_staff` enum('0','1') NOT NULL DEFAULT '0',
  `tambah_akun` enum('0','1') NOT NULL DEFAULT '0',
  `selesai` enum('0','1') NOT NULL DEFAULT '0',
  `id_company` varchar(50) NOT NULL,
  `tgl_input` timestamp NOT NULL DEFAULT current_timestamp(),
  `tgl_update` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id_company`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

/*Data for the table `wizard` */

/* Procedure structure for procedure `find_admin_by_username` */

/*!50003 DROP PROCEDURE IF EXISTS  `find_admin_by_username` */;

DELIMITER $$

/*!50003 CREATE DEFINER=`absenku`@`172.16.88.%` PROCEDURE `find_admin_by_username`(IN user_name VARCHAR(50), OUT user_admin VARCHAR(50))
BEGIN
SET @id_company = (select id_company from users where username = user_name);
SELECT
    users.username
FROM
    data_karyawan
    JOIN users ON users.id_karyawan = data_karyawan.id_karyawan
    JOIN master_jabatan ON master_jabatan.id_jabatan = data_karyawan.id_jabatan
    AND level_user = 1
WHERE
    data_karyawan.id_company = @id_company;
END */$$
DELIMITER ;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
