<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key=<?= $this->config->item('api_map_key') ?>&sensor=false<?= $preview->flag_lokasi == '1' ? '&callback=initMap' : '' ?>"></script>
<script type="text/javascript">
    var map;

    function initMap() {
        map = new google.maps.Map(document.getElementById('map'), {
            center: {
                lat: <?= $preview->lat ?: 0 ?>,
                lng: <?= $preview->long ?: 0 ?>
            },
            zoom: 16,
            mapTypeId: google.maps.MapTypeId.ROADMAP
        });

        var marker = new google.maps.Marker({
            position: {
                lat: <?= $preview->lat ?: 0 ?>,
                lng: <?= $preview->long ?: 0 ?>
            },
            map: map,
            animation: google.maps.Animation.DROP,
        });
    }
</script>

<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>

<div id="detail-aktivitas-preview" class="card-body">
    <div class="form-group">
        <div class="row">
            <div class="col-6">
                <h6>Status</h6>
                <p class="font-weight-bold">
                    <span class="badge <?= ($preview->status == 'approve' ? 'badge-success' : ($preview->status == 'pengajuan' ? 'badge-warning' : 'badge-danger')) ?>">
                        <?php
                        if ($preview->status == 'approve') {
                            echo $this->lang->line('disetujui');
                        } elseif ($preview->status == 'pengajuan') {
                            echo $this->lang->line('pengajuan');
                        } else {
                            echo $this->lang->line('ditolak');
                        }
                        ?>
                    </span>
                </p>
            </div>
            <div class="col-6">
                <h6>Dibuat oleh</h6>
                <p class="font-weight-bold"><?= ($preview->id_karyawan == $this->id_karyawan) ? 'Anda' : ltrim(explode('-', $preview->user)[1]) ?></p>
            </div>
        </div>
    </div>
    <div class="form-group">
        <div class="row">
            <div class="col-6">
                <h6><?= $this->lang->line('tgl') ?></h6>
                <p class="font-weight-bold">
                    <?php
                    if (!empty($preview->tgl)) {
                        if ($this->code_lang == 'id') {
                            echo indo_date(strtotime($preview->tgl), 'l, d M  Y');
                        } else {
                            echo date('l, d M  Y ', strtotime($preview->tgl));
                        }
                    } else {
                        echo '-';
                    }
                    ?>
                </p>
            </div>
            <div class="col-6">
                <h6>Jam</h6>
                <p class="font-weight-bold"><?= $preview->jam ?: '-' ?></p>
            </div>
        </div>
    </div>
    <div class="form-group">
        <div class="row">
            <div class="col-12">
                <h6>Aktivitas</h6>
                <p class="font-weight-bold"><?= $preview->aktivitas ?: '-' ?></p>
            </div>
        </div>
    </div>
    <div class="form-group">
        <div class="row">
            <div class="col-12">
                <h6>Keterangan</h6>
                <p class="font-weight-bold"><?= htmlspecialchars($preview->keterangan) ?: '-' ?></p>
            </div>
        </div>
    </div>
    <div class="form-group">
        <div class="row">
            <?php if ($preview->flag_lokasi == '1') : ?>
                <div class="col-6">
                    <h6>Lokasi</h6>
                    <div id="map" style="width:100%; height:200px;"></div>
                </div>
            <?php endif; ?>
            <?php if ($preview->flag_upload_foto == '1') : ?>
                <div class="col-6">
                    <h6>Foto</h6>
                    <?php
                    $foto = $this->config->item('base_image') . 'image?_t=absensi&_d=' . $preview->path_foto;
                    ?>
                    <a href="<?= $foto ?>" data-lightbox="image_activity"><img src="<?= $foto ?>" height="200"></a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
