<form action="">
    <div class="form-group row">
        <label for="periode" class="col-sm-2 form-label">Periode</label>
        <div class="col-sm-3">
            <input type="text" name="periode" id="periode" class="form-control">
        </div>
    </div>
    <div class="form-group row">
        <label for="karyawan" class="col-sm-2 form-label">Karyawan</label>
        <div class="col-sm-3">
            <select name="karyawan" id="karyawan" class="form-control"></select>
        </div>
        <div class="col-sm-1">
            <button type="button" class="btn btn-primary ladda-button" data-style="expand-left" id="filter" onclick="filterData();">Filter</button>
        </div>
    </div>
</form>
<table class="table table-striped table-bordered" width=100%>
    <thead>
        <tr style="font-family: Poppins SemiBold;">
            <th class="no_sort align-middle _center" width=50 height=50>No</th>
            <th class="align-middle">Karyawan</th>
            <th class="align-middle" width=250>Jabatan</th>
            <th class="no_sort _center align-middle" width=150>Periode</th>
            <th class="no_sort _center align-middle" width=150>Tanggal Pengajuan</th>
            <th class="no_sort _center align-middle" width=150>Status</th>
            <th class="no_sort _center align-middle" width=50>Aksi</th>
        </tr>
    </thead>
    <tbody></tbody>
</table>
<script>
    $(function() {
        $('#periode').datepicker({
            format     : "MM yyyy",
            minViewMode: 1,
            autoclose  : true,
            orientation: "bottom",
            language   : "id"
        });
        
        const ls_menu_kpi = localStorage.getItem("menu_kpi");
        let menu_kpi;
        let displayStart = 0;
        let pageLength   = 10;
        if(ls_menu_kpi !== undefined) {
            menu_kpi = JSON.parse(ls_menu_kpi);
            if(menu_kpi.hasOwnProperty("filter")) {
                $('#periode').datepicker('setDate', new Date(menu_kpi.filter.periode));
                displayStart = 10*menu_kpi.filter.page;
                pageLength   = menu_kpi.filter.length;
            } else {
                $('#periode').datepicker('setDate', new Date());
            }
        } else {
            $('#periode').datepicker('setDate', new Date());
        }

        $('#periode').datepicker().on('changeDate', function() {
            select2Karyawan();
        });

        select2Karyawan();
        if(ls_menu_kpi !== undefined) {
            if(menu_kpi.hasOwnProperty("filter")) {
                if(menu_kpi.filter.hasOwnProperty("karyawan")) {
                    var option = new Option(menu_kpi.filter.karyawan.selected, menu_kpi.filter.karyawan.value, true, true);
                    $('#karyawan').append(option).trigger('change');
                }

                delete menu_kpi.filter;
                localStorage.setItem("menu_kpi", JSON.stringify(menu_kpi));
            }
        }
        
        list_data = $('table').DataTable({
            displayStart: displayStart,
            pageLength  : pageLength,
            ordering : false,
            searching: false,
            scrollX  : true,
            language : {
                url: '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>'
            },
            order: [],
            columnDefs: [
                { targets: 'no_sort', orderable: false },
                { targets: '_center', className: 'text-center' }
            ],
            ajax: {
                url: '<?= route("kpi.approval.list-data") ?>',
                data: function(d) {
                    delete d.columns;
                    delete d.search;

                    const waktu = $('#periode').datepicker('getDate');

                    d.karyawan = $('#karyawan').val();
                    d.tahun    = waktu.getFullYear();
                    d.bulan    = waktu.getMonth()+1;
                    d.jenis    = "<?= $jenis?>";
                }
            },
            drawCallback: function() {
                const data = this.api().ajax.json();
                if(data !== undefined) {
                    $('#message_kpi').html('');
                    $('#message_kpi').html(this.api().ajax.json().validasiPeriode);
                }
            }
        });
    });

    function select2Karyawan() {
        const waktu = $('#periode').datepicker('getDate');
        const tahun = waktu.getFullYear();
        const bulan = waktu.getMonth()+1;
        $('#karyawan').select2({
            placeholder: 'Pilih Karyawan',
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.kpi.bawahan", ['input' => 'false'])  ?>',
                data: function(params) {
                    const query = {
                        search: params.term,
                        tahun : tahun,
                        bulan : bulan
                    };

                    return query;
                },
                dataType: 'json',
                processResults: function(data) {
                    return {
                        results: data
                    };
                }
            }
        });
    }

function filterData() {
    event.preventDefault();
    var loading = Ladda.create(document.querySelector('#filter'));
    loading.start();
    list_data.ajax.reload(function() {
        loading.stop();
    });
}
</script>