<style>
/* Required Drawer CSS */
    .js-menu__context {
        /* background: rgba(0, 0, 0, 0.5); */
        left: 0;
        opacity: 0;
        position: absolute;
        top: 0;
        transition: opacity 0.5s, visibility 0.5s;
        visibility: hidden;
        width: 100%;
        height: 100%;
        border-radius: 0 15px 15px 0;
        z-index: 99;
    }

    .js-menu {
        color: #000;
        height: 100%;
        width: 100%;
        padding: 20px;
        margin: 0;
        background: #fff;
        overflow-y: auto;
        border-radius: 0 15px 15px 0;

        -webkit-overflow-scrolling: touch;
        -ms-overflow-style: -ms-autohiding-scrollbar;
        transition: background 0.5s, transform 0.5s;
    }

    .js-menu--left {
        -webkit-transform: translateX(-100%);
        transform: translateX(-100%);
    }

    .js-menu--right {
        -webkit-transform: translateX(100%);
        transform: translateX(100%);
        position: absolute;
        right: 0;
    }

    .js-menu__open {
        cursor: pointer;
    }

    .js-menu__close {
        cursor: pointer;
    }

    .js-menu__expanded {
        -webkit-transform: translateX(0);
        transform: translateX(0);
        visibility: visible;
        opacity: 1;
    }
</style>

<div class="div_pembungkus_js_menu_context">
    <div class="js-menu__context">
        <div id="drawer" class="js-menu js-menu--right">
            <div id="drawer-content"></div>
        </div>
    </div>
</div>


<div class="row align-items-center mt-1">
    <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
        <h5 class="dark-blue-color">Kompetensi</h5>
    </div>
</div>
<hr>

<div class="table-responsive">
    <table id="list_data" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th class="text-center text-uppercase">No</th>
                <th class="text-left text-uppercase">Nama Jabatan</th>
                <th class="text-center text-uppercase">Bobot</th>
                <!-- <th class="text-center text-uppercase">Bobot Yang Sudah Diiisi</th> -->
                <th class="text-center text-uppercase">Detail</th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>

<!-- START TAMPIL MODAL -->
<div id="modal_form_aspek" class="modal fade in">
    <div class="modal-dialog modal-lg">
        <div id="tampil_form_aspek" class="modal-content"></div>
    </div>
</div>
<!-- END TAMPIL MODAL -->

<script type="text/javascript">
    $(function() {
        list_data_home = $('#list_data').DataTable({ 
                    'searching'   : true,
                    'paging'      : true,
                    'lengthChange': true,
                    'ordering'    : false,
                    'info'        : true,
                    'scrollX'     : true,
                    // 'scrollCollapse': true,
                    // 'fixedColumns': true,
                    'language'    :{
                                    'url'         : '<?=base_url("assets/plugins/datatables/dataTables-language-id.json")?>',
                                    'sEmptyTable' : 'Tidak ada data untuk ditampilkan',
                                    'searchPlaceholder': 'Nama Jabatan'
                                },
                    "processing"  : true, 
                    "serverSide"  : true, 
                    "order"       : [], 
                    "ajax"        : {
                                        "url": "<?= route('kpi.master.kepribadian.list.data') ?>",
                                        "type": "GET",
                                        "complete" : function(data){
                                            reconfigure(data);
                                        }
                                    },
                    "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            $('td:eq(0)', nRow).css({'text-align':'center', 'width':'10px'});
                            $('td:eq(2)', nRow).css({'text-align':'center', 'width':'200px'});
                            $('td:eq(3)', nRow).css({'text-align':'center', 'width':'200px'});
                            $('td:eq(4)', nRow).css({'text-align':'center', 'width':'30px'});
                    }
        });

        // START JS DRAWER
        $('.js-menu__open').on('touchend click', function() {
            var menu = $(this).attr('data-menu');

            $(menu).toggleClass('js-menu__expanded');
            $(menu).parent().toggleClass('js-menu__expanded');
        });

        $('.js-menu__context, .js-menu__close').on('touchend click', function(event) {
            if ($(event.target).hasClass('js-menu__context') || $(event.target).hasClass('js-menu__close')) {
                $('.js-menu__expanded').removeClass('js-menu__expanded');
                $(".div_pembungkus_js_menu_context").css('height', "0px");
            }
        });
    });

    function test_slide(e){
        var menu = $(e).attr('data-menu');
        $(menu).toggleClass('js-menu__expanded');
        $(menu).parent().toggleClass('js-menu__expanded');

        var id_aspek = $(e).attr('id');set_detail_active('master', id_aspek);
        load_url = "<?= route('kpi.master.kepribadian.detail.view.detail') ?>" + "/" +id_aspek;
        return $.get(load_url, function(data) {
            $("#drawer-content").html(data);
        });
    }
</script>