<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Data_reimburse extends MY_Controller {

	public function __construct(){
        parent::__construct();
        $this->load->model('Data_reimburse_m');
    }

	public function index($pengajuan = null){
        if ($pengajuan) {
            $data['judul'] = 'Pengajuan Saya';
            $data['aktif'] = 'reimburse_saya';
            $data['saya'] = 1;
        }else{
            $data['judul'] = 'Pengajuan Reimburse';
            $data['aktif'] = 'reimburse';
            // $data['saya'] = 2;
        }
        $data['menu'] = $this->load->view('main_menu', $data, true);
		$data['content'] = $this->load->view('data_reimburse/home', $data, true);
		$this->load->view('main_template', $data, false);
	}

	public function list_data(){
        $tipe = $this->input->post("tipe");

        // 1 untuk pengajuan saya, 2 untuk pengajuan reimbursement
        $saya = $this->input->post("saya");

        if ($saya == 1) {
            $list = $this->Data_reimburse_m->get_datatables($tipe, $saya);
            $count_all = $this->Data_reimburse_m->count_all($tipe, $saya);
            $count_filtered = $this->Data_reimburse_m->count_filtered($tipe, $saya);
        }else{
            $list = $this->Data_reimburse_m->get_datatables($tipe);
            $count_all = $this->Data_reimburse_m->count_all($tipe);
            $count_filtered = $this->Data_reimburse_m->count_filtered($tipe);
        }
		$data = array();
		$no = $_POST['start'];

		foreach ($list as $field) {
            // button verifikasi
            $btn_verifikasi = "<a href='".route("reimburse.detail")."/karyawan/".MD5($field->id)."'>
                                   <button class='btn btn-info'>VERIFIKASI</button>
                               </a>";
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = $this->fungsi->format_date_strip($field->tgl_pengajuan);
            $row[] = $field->no_pengajuan;
            $row[] = $field->nama_karyawan."<br><b>".$field->nik."</b>";
            $row[] = $field->nama_cabang."<br><b>".$field->kode_cabang."</b>";
            $row[] = $field->nama_departemen."<br><b>".$field->kode_departemen."</b>";
            $row[] = number_format($field->total_reimburse,0,",",".");
            $row[] = $field->keterangan;
            if ($saya == 1) {
                if ($field->status == "3") {
                    $row[] = ($field->apv_spv != "3") ? "" : $this->fungsi->get_approval_reimburse($field->apv_spv);
                    $row[] = ($field->apv_kedep != "3") ? "" : $this->fungsi->get_approval_reimburse($field->apv_kedep);
                    $row[] = ($field->apv_kacab != "3") ? "" : $this->fungsi->get_approval_reimburse($field->apv_kacab);
                    $row[] = ($field->apv_direksi != "3") ? "" : $this->fungsi->get_approval_reimburse($field->apv_direksi);
                    $row[] = ($field->apv_finance != "3") ? "" : $this->fungsi->get_approval_reimburse($field->apv_finance);
                }else if ($field->status == "4") {
                    $row[] = ($field->apv_spv != "4") ? "" : $this->fungsi->get_approval_reimburse($field->apv_spv);
                    $row[] = ($field->apv_kedep != "4") ? "" : $this->fungsi->get_approval_reimburse($field->apv_kedep);
                    $row[] = ($field->apv_kacab != "4") ? "" : $this->fungsi->get_approval_reimburse($field->apv_kacab);
                    $row[] = ($field->apv_direksi != "4") ? "" : $this->fungsi->get_approval_reimburse($field->apv_direksi);
                    $row[] = ($field->apv_finance != "4") ? "" : $this->fungsi->get_approval_reimburse($field->apv_finance);
                }else{
                    $row[] = $this->fungsi->get_approval_reimburse($field->apv_spv);
                    $row[] = $this->fungsi->get_approval_reimburse($field->apv_kedep);
                    $row[] = $this->fungsi->get_approval_reimburse($field->apv_kacab);
                    $row[] = $this->fungsi->get_approval_reimburse($field->apv_direksi);
                    $row[] = $this->fungsi->get_approval_reimburse($field->apv_finance);
                }

            }else{
                if ($this->adm_reimbursement == true) {
                    # MUNCULKAN SEMUA TOMBOL VERIFIKASI KARENA SBG ADMIN REIMBURSE
                    $row[] = ($field->apv_spv == '1') ? $btn_verifikasi : $this->fungsi->get_approval_reimburse($field->apv_spv);
                    $row[] = ($field->apv_kedep == '1') ? $btn_verifikasi : $this->fungsi->get_approval_reimburse($field->apv_kedep);
                    $row[] = ($field->apv_kacab == '1') ? $btn_verifikasi : $this->fungsi->get_approval_reimburse($field->apv_kacab);
                    $row[] = ($field->apv_direksi == '1') ? $btn_verifikasi : $this->fungsi->get_approval_reimburse($field->apv_direksi);
                    $row[] = ($field->apv_finance == '1') ? $btn_verifikasi : $this->fungsi->get_approval_reimburse($field->apv_finance);
                }else{
                    # MUNCULKAN TOMBOL VERIFIKASI JIKA SEBAGAI ATASAN
                    if ($field->status == "3") {
                        $row[] = ($field->apv_spv != "3") ? "" : $this->fungsi->get_approval_reimburse($field->apv_spv);
                        $row[] = ($field->apv_kedep != "3") ? "" : $this->fungsi->get_approval_reimburse($field->apv_kedep);
                        $row[] = ($field->apv_kacab != "3") ? "" : $this->fungsi->get_approval_reimburse($field->apv_kacab);
                        $row[] = ($field->apv_direksi != "3") ? "" : $this->fungsi->get_approval_reimburse($field->apv_direksi);
                        $row[] = ($field->apv_finance != "3") ? "" : $this->fungsi->get_approval_reimburse($field->apv_finance);
                    }else if ($field->status == "4") {
                        $row[] = ($field->apv_spv != "4") ? "" : $this->fungsi->get_approval_reimburse($field->apv_spv);
                        $row[] = ($field->apv_kedep != "4") ? "" : $this->fungsi->get_approval_reimburse($field->apv_kedep);
                        $row[] = ($field->apv_kacab != "4") ? "" : $this->fungsi->get_approval_reimburse($field->apv_kacab);
                        $row[] = ($field->apv_direksi != "4") ? "" : $this->fungsi->get_approval_reimburse($field->apv_direksi);
                        $row[] = ($field->apv_finance != "4") ? "" : $this->fungsi->get_approval_reimburse($field->apv_finance);
                    }else{
                        $row[] = ($this->level_user == '7' && $field->apv_spv == '1') ? $btn_verifikasi : $this->fungsi->get_approval_reimburse($field->apv_spv);
                        $row[] = ($this->level_user == '2' && $field->apv_kedep == '1') ? $btn_verifikasi : $this->fungsi->get_approval_reimburse($field->apv_kedep);
                        $row[] = ($this->level_user == '5' && $field->apv_kacab == '1') ? $btn_verifikasi : $this->fungsi->get_approval_reimburse($field->apv_kacab);
                        $row[] = ($this->level_user == '4' && $field->apv_direksi == '1') ? $btn_verifikasi : $this->fungsi->get_approval_reimburse($field->apv_direksi);
                        $row[] = ($this->level_user == '6' && $field->apv_finance == '1') ? $btn_verifikasi : $this->fungsi->get_approval_reimburse($field->apv_finance);
                    }
                }
            }
            if ($saya == 1) {
                $row[] = "<a href='".route("reimburse.detail")."/saya/".MD5($field->id)."'>
                            <button class='btn btn-info'>DETAIL</button>
                        </a>";
            }else{
                if ($tipe != 1) {
                    $row[] = "<a href='".route("reimburse.detail")."/karyawan/".MD5($field->id)."'>
                                <button class='btn btn-info'>DETAIL</button>
                            </a>";
                }else{
                    $row[] = '';
                }
            }
            // echo count($row);exit;
            $data[] = $row;
        }

			$output = array("draw"            => $_POST['draw'],
							"recordsTotal"    => $count_all,
							"recordsFiltered" => $count_filtered,
							"data"            => $data);

            $output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

	public function detail($pengajuan_saya="", $id_pengajuan=null){
        if ($pengajuan_saya == "saya") {
            $data['judul']          = 'Detail Pengajuan Reimburse';
            $data['aktif']          = 'reimburse_saya';
        }else{
            $data['judul']          = 'Detail Pengajuan Reimburse';
            $data['aktif']          = 'reimburse';
        }

        $data['data_pengajuan'] = $this->Data_reimburse_m->getNoPengajuan($id_pengajuan);
        $data_pengajuan = $data['data_pengajuan'];
        $data['status']         = $data_pengajuan->status;
        // klik verifikasi sebagai
        $approve_arr = array(
            $data_pengajuan->apv_spv,     // 0 = supervisi
            $data_pengajuan->apv_kedep,   // 1 = kepala departemen
            $data_pengajuan->apv_kacab,   // 2 = kepala cabang
            $data_pengajuan->apv_direksi, // 3 = direksi
            $data_pengajuan->apv_finance  // 4 = admin reimbursement
        );
        // status approval dengan status pengajuan (1)
        // approval sesuai dengan index diatas (0 = spv, dst..)
        if ($this->level_user != '3') {
            $data['approve_sebagai'] = array_search('1' ,$approve_arr);
        }else{
            if ($this->adm_reimbursement == true) {
                $data['approve_sebagai'] = array_search('1' ,$approve_arr);
            }else{
                $data['approve_sebagai'] = '-';
            }
        }


        $i_apv = 0;
        foreach ($approve_arr as $apv) {
            // jika status approval pengajuan bukan pengajuan dan bukan proses
            if ($apv > 1 && $apv != 6) {
                $data['ket_arr'] = $i_apv;
            }
            $i_apv++;
        }
        // dari pengecekan diatas mendapatkan nilai
        // yang melakukan verifikasi adalah
        switch ($data['ket_arr']) {
            case 0:
                $data['ket_arr'] = array($data['ket_arr'],'SUPERVISI');
                break;

            case 1:
                $data['ket_arr'] = array($data['ket_arr'],'KEPALA DEPARTEMEN');
                break;

            case 2:
                $data['ket_arr'] = array($data['ket_arr'],'KEPAlA CABANG');
                break;

            case 3:
                $data['ket_arr'] = array($data['ket_arr'],'DIREKSI');
                break;

            case 4:
                $data['ket_arr'] = array($data['ket_arr'],'ADMIN REIMBURSE');
                break;

            default:
                $data['ket_arr'] = array($data['approve_sebagai'],'');
                break;
        }

        $data['list_pengajuan'] = $this->Data_reimburse_m->list_pengajuan($id_pengajuan);

        // cek siapa yang tolak
        $list_pengajuan_arr = $data['list_pengajuan'];
        $list_tolak = array('');
        foreach ($list_pengajuan_arr as $list_pengajuan) {
            $list_tolak_arr = array(
                $list_pengajuan->apv_spv,     // 0 = supervisi
                $list_pengajuan->apv_kedep,   // 1 = kepala departemen
                $list_pengajuan->apv_kacab,   // 2 = kepala cabang
                $list_pengajuan->apv_direksi, // 3 = direksi
                $list_pengajuan->apv_finance  // 4 = admin reimbursement
            );
            if (in_array('3', $list_tolak_arr)) {
                $list_tolak[] = array_search('3' , $list_tolak_arr);
            }else{
                $list_tolak[] = '';
            }
        }
        $data['tolak_sebagai'] = $list_tolak; // array

        $data['list_akun'] = $this->Data_reimburse_m->list_akun();
        $data['menu'] = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('data_reimburse/detail_pengajuan', $data, true);
        $this->load->view('main_template', $data, false);
    }

    private function __approve_to_service($post_data){

		$base = $this->config->item('url_api_reimbursement');
        // echo $base;
        // die();
        $request_headers = array(
            "id-company:".$this->id_company,
            "id-departemen:".$this->id_departemen,
            "id-cabang:".$this->id_cabang,
            "id-karyawan:".$this->id_karyawan,
            "level-user:".$this->level_user,
            "api-key:absenku123**"
        );

        // print_r($request_headers);
        // die();
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL,$base."reimbursement/update-status");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS,$post_data);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $request_headers);

        // In real life you should use something like:
        // curl_setopt($ch, CURLOPT_POSTFIELDS,
        //          http_build_query(array('postvar1' => 'value1')));

        // Receive server response ...
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $server_output = curl_exec($ch);

        curl_close ($ch);

        // echo '<pre>'.print_r($server_output, true).'</pre>';
        // exit;


        if(!empty($server_output)){
            $json = json_decode($server_output);

            $data['status'] = $json->success;
            $data['message'] = $json->message;
        }else{
            $data['status'] = false;
            $data['message'] = 'Request tidak diketahui';
        }

		return $data;
	}


    public function save(){
        $jumlah_data = $this->input->post("jumlah_data");
        $id_pengajuan_reimburse = $this->input->post("id_pengajuan_reimburse");
        $approve_sebagai = $this->input->post("approve_sebagai");

        // $token_fcm = $request->input('token_fcm');
        // $id_pengajuan = $request->input('id_pengajuan');
        // $jml_item = $request->input('jumlah_item');
        // $id_item_0 = $request->input('id_item_0');
        // $status_0 = $request->input(status_0');
        // $nominal_0 = $request->input('nominal_0');
        // $keterangan_0 = $request->input('keterangan_0');

        $post_data = "id_pengajuan=".$id_pengajuan_reimburse.
                    "&jumlah_item=".$jumlah_data."";

        // echo $jumlah_data;
        // echo $this->input->post("id_akun_0");
        // echo $post_data;
        // exit;

        $no=0;
        for ($i = 1; $i <= $jumlah_data; $i++) {
            $id_reimburse       = $this->input->post("id_reimburse_$i");
            $nm_plafon          = $this->input->post("nm_plafon_$i");
            $status_reimburse   = $this->input->post("status_reimburse_$i");
            $ket_revisi         = $this->input->post("ket_revisi_$i");
            $ket_ditolak        = $this->input->post("ket_ditolak_$i");
            $ket_approve        = $this->input->post("ket_approve_$i");
            $nominal_setuju     = str_replace('.','',$this->input->post("nominal_setuju_$i"));
            $id_akun            = $this->input->post("id_akun_$i");

            if ($status_reimburse == "3") {
                $keterangan = $ket_ditolak;
            }else if ($status_reimburse == "4") {
                $keterangan = $ket_revisi;
            }else{
                $keterangan = $ket_approve;
            }
            // $keterangan         = ($status_reimburse=="3")?$ket_ditolak:$ket_revisi;

            // 0=tidak perlu persetujuan, 1=pengajuan, 2=dibatalkan, 3=ditolak, 4=direvisi, 5=disetujui 6=proses
            if(!empty($status_reimburse)) {
                    if($approve_sebagai == "4" && empty($id_akun)){
                        if ($status_reimburse == "5") {
                            $warning = "GAGAL, Plafon ".$nm_plafon." belum dipilih akun reimbursenya";
                            $message = '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>'.$warning.'</font>';
                            return __response_update_reimburse(false,5,$message);
                        }else{
                            $id_akun = '-'; // API wajib diisi
                        }
                    }

                    $post_data .="&id_item".$no."=".$id_reimburse.
                                    "&status".$no."=".$status_reimburse.
                                    "&nominal".$no."=".$nominal_setuju.
                                    "&keterangan".$no."=".$keterangan.
                                    "&kode_akun".$no."=".$id_akun."";

                    $no++;
            }else{
                return __response_update_reimburse(false,5);
            }
        }

        // print_r($post_data);
        // exit;

        $res = $this->__approve_to_service($post_data);

        // var_dump($res);
        // die();


        if($res['status'] === true) {
			$color = '#009900';
			$icon = 'fa-check-square';
            $status = true;
		}else{
            $status = false;
			$color = '#eb3a28';
			$icon = 'fa-close';
		}

		$json['message'] = '<font color="'.$color.'"><i class="fa '.$icon.'">&nbsp;</i> '.$res['message'].'</font>';
		$json['success'] = $status;

		$response = __response($this->MY_response, $json);
		echo json_encode($response);
    }
}
