<script>
    $(function() {
        $("#btn_submit").on("click", function(e) {
            e.preventDefault();
            $("#message").html("");
            var loading = Ladda.create(this);

            <?php if ($this->level_user === '1' || $this->is_sales_admin === true || $this->is_sales_atasan === true) : ?>
                if (!$("#select_sales").val()) {
                    $("#message").html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_sales_kosong') ?></font>");
                    return false;
                }
            <?php endif; ?>

            var param = {};
            param.id = "<?= $id ?>";
            param.sales = $("#select_sales").length ? $("#select_sales").val() : "";

            $.ajax({
                type: 'POST',
                url: "<?= route('sales_activity.kanban.update_pindah_bulan') ?>",
                data: param,
                dataType: 'JSON',
                beforeSend: function() {
                    loading.start();
                    disable_form("#form_pindah_bulan", ["input", "button"], true);
                },
                success: function(result) {
                    disable_form("#form_pindah_bulan", ["input", "button"], false);
                    if (result.success == true) {
                        var periode = get_periode();
                        $("#detail-perusahaan").load("<?= route('sales_activity.kanban.detail.perusahaan', ['id' => $id, 'periode' => '" + periode + "']) ?>");
                    }
                    loading.stop();
                    $('#message').show();
                    $('#message').html(result.message);
                },
                error: function() {
                    loading.stop();
                    disable_form("#form_pindah_bulan", ["input", "button"], false);
                    $('#message').show();
                    $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });

        <?php if ($this->level_user === '1' || $this->is_sales_admin === true || $this->is_sales_atasan === true) : ?>
            $("#select_sales").select2({
                placeholder: "Pilih sales",
                allowClear: true,
                dropdownParent: $("#form_pindah_bulan"),
                ajax: {
                    url: '<?= route("sales_activity.kanban.list_sales") ?>',
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            search: params.term,
                            topic: "kanban",
                            range: 0,
                            start: get_periode()
                        };
                    },
                    processResults: function(data) {
                        return {
                            results: data
                        };
                    },
                    cache: false
                },
                minLength: 3
            });
        <?php endif; ?>
    });
</script>

<div id="form_pindah_bulan">
    <div class="card-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
        <h3 class="title modal-title">Apakah Anda yakin akan memindahkan data <span id="nama_tahapan" class="font-weight-bold">-</span> ini ke bulan <span class="font-weight-bold"><?= ($this->code_lang == 'id') ? indo_date(time(), 'F') : date('F') ?></span>?</h3>
    </div>

    <div class="card-body">
        <div class="form-group w-100">
            <div class="alert alert-info" role="alert">
                <i class="fa fa-info-circle"></i> Tidak dapat dilakukan pemindahan jika masih terdapat aktivitas didalamnya dengan status <span class="badge badge-warning"><?= $this->lang->line('pengajuan') ?></span>
            </div>
        </div>
        <?php if ($this->level_user === '1' || $this->is_sales_admin === true || $this->is_sales_atasan === true): ?>
            <div class="form-group">
                <label>Sales<i class="text-danger">*</i></label>
                <select id="select_sales" class="select2 form-control" style="width: 100%"></select>
            </div>
        <?php endif; ?>
    </div>

    <div class="card-footer">
        <div class="row">
            <div class="col-md-6 text-left">
                <div id="message"></div>
            </div>
            <div class="col-md-6 text-right">
                <button class="btn btn-light text-white" data-dismiss="modal"><?= '<i class="fa fa-times"></i> ' . $this->lang->line('button_form_batal') ?></button>
                <button id="btn_submit" class="btn btn-primary text-uppercase ladda-button" data-style="expand-left"><?= '<i class="fa fa-check"></i> ' . $this->lang->line('ya') ?></button>
            </div>
        </div>
    </div>
</div>
