<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>
<div id="form_input" class="card-body" disabled>
    <input type="hidden" id="id_karyawan" class="form-control" value="<?= $id_karyawan ?>">
    <input type="hidden" id="id_pendidikan" class="form-control" value="<?= ((isset($data)) ? md5($data->id_riwayat_pendidikan) : '') ?>">
    <div class="form-group">
        <div class="row">
            <div class="col-md-6">
                <label><?= $this->lang->line('jenjang_pendidikan') ?> <i class="text-danger">*</i></label>
                <select id="jenjang" class="form-control">
                    <option value="SD/MI" <?= ((isset($data) and $data->jenjang == 'SD') ? 'selected' : '') ?>><?= $this->lang->line('sd_mi') ?></option>
                    <option value="SMP/MTS" <?= ((isset($data) and $data->jenjang == 'SMP/MTs') ? 'selected' : '') ?>><?= $this->lang->line('smp_mts') ?></option>
                    <option value="SMA/SMK" <?= ((isset($data) and $data->jenjang == 'SMA/SMK') ? 'selected' : '') ?>><?= $this->lang->line('sma_smk') ?></option>
                    <option value="Diploma" <?= ((isset($data) and $data->jenjang == 'Diploma') ? 'selected' : '') ?>><?= $this->lang->line('diploma') ?></option>
                    <option value="Sarjana" <?= ((isset($data) and $data->jenjang == 'Sarjana') ? 'selected' : '') ?>><?= $this->lang->line('sarjana') ?></option>
                    <option value="Magister" <?= ((isset($data) and $data->jenjang == 'Magister') ? 'selected' : '') ?>><?= $this->lang->line('magister') ?></option>
                    <option value="Doctor" <?= ((isset($data) and $data->jenjang == 'Doctor') ? 'selected' : '') ?>><?= $this->lang->line('doctor') ?></option>
                </select>
            </div>

            <div class="col-md-6">
                <label><?= $this->lang->line('jurusan') ?></label>
                <input type="text" id="jurusan" class="form-control" value="<?= ((isset($data)) ? $data->jurusan : '') ?>">
            </div>
        </div>
    </div>
    <div class="form-group">
        <div class="row">
            <div class="col-md-12">
                <label><?= $this->lang->line('nama_sekolah') ?> <i class="text-danger">*</i></label>
                <input type="text" id="nama_sekolah" class="form-control" value="<?= ((isset($data)) ? $data->nama_sekolah : '') ?>">
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="row">
            <div class="col-md-6">
                <label><?= $this->lang->line('lulusan_asal') ?> <i class="text-danger">*</i></label><br>
                <select id="lulusan_asal" class="form-control" style="width: 100%">
                    <option value="Dalam Negeri" <?= ((isset($data) and $data->lulusan_asal == 'Dalam Negeri') ? 'selected' : '') ?>><?= $this->lang->line('dalam_negeri') ?></option>
                    <option value="Luar Negeri" <?= ((isset($data) and $data->lulusan_asal == 'Luar Negeri') ? 'selected' : '') ?>><?= $this->lang->line('luar_negeri') ?></option>
                </select>
            </div>

            <div class="col-md-6">
                <label><?= $this->lang->line('gelar') ?></label><br>
                <input type="text" id="gelar" class="form-control" value="<?= ((isset($data)) ? $data->gelar : '') ?>">
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="row">
            <div class="col-md-6">
                <label><?= $this->lang->line('tahun_masuk') ?> <i class="text-danger">*</i></label>
                <input type="text" id="tahun_masuk" class="numberbox form-control" maxlength="4" value="<?= ((isset($data)) ? $data->tahun_masuk : '') ?>">
            </div>

            <div class="col-md-6">
                <label><?= $this->lang->line('tahun_lulus') ?> <i class="text-danger">*</i></label>
                <input type="text" id="tahun_lulus" class="numberbox form-control" maxlength="4" value="<?= ((isset($data)) ? $data->tahun_lulus : '') ?>">
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="row">
            <div class="col-md-6">
                <label>Upload <?= $this->lang->line('ijazah') ?></label>
                <?php
                if (empty($data->ijazah)) {
                    $ijazah = "";
                } else {
                    $ijazah = $this->config->item('base_image') . 'image?_t=file&_d=' . $data->ijazah;
                }
                ?>
                <input type="file" name="ijazah" id="ijazah" class="dropify" data-default-file="<?= $ijazah ?>" />
                <input type="hidden" name="ijazah_lama" id="ijazah_lama" value="<?= $data->ijazah ?>">
            </div>
            <div class="col-md-6">
                <label>Upload <?= $this->lang->line('transkrip_nilai') ?> </label>
                <?php
                if (empty($data->transkrip)) {
                    $transkrip = "";
                } else {
                    $transkrip = $this->config->item('base_image') . 'image?_t=file&_d=' . $data->transkrip;
                }
                ?>
                <input type="file" name="transkrip" id="transkrip" class="dropify" data-default-file="<?= $transkrip ?>" />
                <input type="hidden" name="trankrip_lama" id="transkrip_lama" value="<?= $data->transkrip ?>">
            </div>
        </div>
    </div>
</div>
<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <!-- <button id="btn_new_input" class="btn" style="display:none">TAMBAH BARU</button> -->
            <button id="btn_new_input" class="btn"><?= $this->lang->line('button_form_tambah_baru') ?></button>
            <button class="btn_save_pendidikan ladda-button" id="btn_save_pendidikan" data-style="expand-left"></button>
        </div>
    </div><!-- ./row -->
</div>

<script>
    $(document).ready(function() {
        // Basic

        $('.dropify').dropify(
            <?php if ($this->code_lang == 'id') { ?> {
                    messages: {
                        'default': 'Seret dan lepas atau klik disini',
                        'replace': 'Seret dan lepas atau klik disini',
                        'remove': 'Hapus',
                        'error': 'Ooops, terjadi kesalahan.',
                    },
                    error: {
                        'fileSize': 'The file size is too big ({{ value }} max).',
                        'minWidth': 'The image width is too small ({{ value }}}px min).',
                        'maxWidth': 'The image width is too big ({{ value }}}px max).',
                        'minHeight': 'The image height is too small ({{ value }}}px min).',
                        'maxHeight': 'The image height is too big ({{ value }}px max).',
                        'imageFormat': 'Format file tidak diperbolehkan ({{ value }} only).'
                    }

                }
            <?php } ?>
        );

        transkrip = $('#form_input #transkrip').dropify();

        transkrip.on('dropify.afterClear', function(event, element) {
            $("#transkrip_lama").val("");
        });

        ijazah = $('#form_input #ijazah').dropify();

        ijazah.on('dropify.afterClear', function(event, element) {
            $("#ijazah_lama").val("");
        });


    });
</script>
