<script type="text/javascript">
    datepicker();

    $(document).on("change", "#jabatan", function() {
        $('#form_input  #cabang, #departemen').val(null).trigger('change');
        var level_user = $(this).select2('data')[0].leveluser;
        levelUser(level_user);

    });

    $('#jabatan').select2({
        placeholder: '<?= $this->lang->line('pilih_jabatan') ?>',
        allowClear: true,
        ajax: {
            // type: 'POST',
            url: '<?= route('dropdown.jabatan')  ?>',
            dataType: 'json',
            delay: 250,
            processResults: function(data) {
                return {
                    results: data
                };
            },
            cache: false
        },
        minLength: 3
    });

    $('#cabang').select2({
        placeholder: '<?= $this->lang->line('pilih_cabang') ?>',
        allowClear: true,
        ajax: {
            // type: 'POST',
            url: '<?= route('dropdown.cabang')  ?>',
            dataType: 'json',
            delay: 250,
            processResults: function(data) {
                return {
                    results: data
                };
            },
            cache: false
        },
        minLength: 3
    });

    $('#departemen').select2({
        placeholder: '<?= $this->lang->line('pilih_departemen') ?>',
        allowClear: true,
        ajax: {
            // type: 'POST',
            url: '<?= route("dropdown.departemen")  ?>',
            dataType: 'json',
            delay: 250,
            processResults: function(data) {
                return {
                    results: data
                };
            },
            cache: false
        },
        minLength: 3
    });

    function levelUser(level_user) {
        if (level_user == '1') {
            $("#div_cabang").show();
            $("#div_departemen").hide();
            // $("#div_supervisi").hide();
        } else if (level_user == '2') {
            $("#div_cabang").show();
            $("#div_departemen").show();
            // $("#div_supervisi").hide();
        } else if (level_user == '3') {
            $("#div_cabang").show();
            $("#div_departemen").show();
            // $("#div_supervisi").show();
        } else if (level_user == '4') {
            $("#div_cabang").show();
            $("#div_departemen").hide();
            // $("#div_supervisi").hide();
        } else if (level_user == '5') {
            $("#div_cabang").show();
            $("#div_departemen").hide();
            // $("#div_supervisi").hide();
        } else if (level_user == '6') {
            $("#div_cabang").show();
            $("#div_departemen").hide();
            // $("#div_supervisi").hide();
        } else if (level_user == '7') {
            $("#div_cabang").show();
            $("#div_departemen").show();
            // $("#div_supervisi").hide();
        } else {
            $("#div_cabang").hide();
            $("#div_departemen").hide();
            // $("#div_supervisi").hide();
        }
    }
</script>
<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>
<div id="form_input" class="card-body" disabled>
    <input type="hidden" id="id_karyawan" class="form-control" value="<?= $id_karyawan ?>">
    <input type="hidden" id="id_karir_pekerjaan" class="form-control" value="<?= ((isset($data)) ? md5($data->id_karir_pekerjaan) : '') ?>">
    <div class="form-group">
        <div class="row">
            <div class="col-md-12">
                <label><?= $this->lang->line('nomor_surat_keputusan') ?> <i class="text-danger">*</i></label>
                <input type="text" id="nomor_surat_keputusan" class="form-control" value="<?= ((isset($data)) ? $data->nomor_surat_keputusan : '') ?>">
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="row">
            <div id="div_jabatan" class="col-md-6">
                <label><?= $this->lang->line('jabatan') ?> <i class="text-danger">*</i></label>
                <select class="form-control" id="jabatan" class="select2 form-control" style="border-radius: 5px; width: 100%;">
                    <?php
                    if (isset($data) && $data->nama_jabatan) {
                        echo "<option kodejabatan='" . $data->kode_jabatan . "' namajabatan='" . $data->nama_jabatan . "' selected>" . $data->kode_jabatan . " - " . $data->nama_jabatan . "</option>";
                    }
                    ?>
                </select>
            </div>
            <div id="div_cabang" class="col-md-6">
                <label><?= $this->lang->line('cabang') ?> <i class="text-danger">*</i></label>
                <select class="form-control" id="cabang" class="select2 form-control" style="border-radius: 5px; width: 100%;">
                    <?php
                    if (isset($data) && $data->nama_cabang) {
                        echo "<option kodecabang='" . $data->kode_cabang . "' namacabang='" . $data->nama_cabang . "' selected>" . $data->kode_cabang . " - " . $data->nama_cabang . "</option>";
                    }
                    ?>
                </select>
            </div>
        </div>
    </div>

    <div class="form-group">
        <div id="div_departemen" class="row" <?= ((isset($form_departemen)) ? $form_departemen : "") ?>>
            <div class="col-md-12 dep_div">
                <label><?= $this->lang->line('departemen') ?> <i class="text-danger">*</i></label><br>
                <select class="form-control" id="departemen" class="select2 form-control" style="border-radius: 5px; width: 100%;">
                    <?php
                    if (isset($data) && $data->nama_departemen) {
                        echo "<option kodedepartemen='" . $data->kode_departemen . "' namadepartemen='" . $data->nama_departemen . "' selected>" . $data->kode_departemen . " - " . $data->nama_departemen . "</option>";
                    }
                    ?>
                </select>
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="row">
            <div class="col-md-6">
                <label><?= $this->lang->line('tgl_mulai') ?> <i class="text-danger">*</i></label>
                <?php
                if (isset($data)) {
                    if ($data->tgl_mulai != "0000-00-00") {
                        $tanggal_mulai = date('d-m-Y', strtotime($data->tgl_mulai));
                    } else {
                        $tanggal_mulai = "";
                    }
                } else {
                    $tanggal_mulai = "";
                }
                ?>
                <input type="text" id="tgl_mulai" class="form-control datepicker" data-inputmask="'alias': 'datetime','inputFormat': 'dd-mm-yyyy'" value="<?= $tanggal_mulai ?>" autocomplete="off" placeholder="dd-mm-yyyy">
            </div>

            <div class="col-md-6">
                <label><?= $this->lang->line('tgl_berakhir') ?></label>
                <?php
                if (isset($data)) {
                    if ($data->tgl_akhir != "0000-00-00") {
                        $tanggal_akhir = date('d-m-Y', strtotime($data->tgl_berakhir));
                    } else {
                        $tanggal_akhir = "";
                    }
                } else {
                    $tanggal_akhir = "";
                }
                ?>
                <input type="text" id="tgl_akhir" class="form-control datepicker" data-inputmask="'alias': 'datetime','inputFormat': 'dd-mm-yyyy'" value="<?= $tanggal_akhir ?>" autocomplete="off" placeholder="dd-mm-yyyy">
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="row">
            <div class="col-md-12">
                <label>Status <i class="text-danger">*</i></label>
                <select class="form-control" name="status" id="status">
                    <option value="0" <?= ((isset($data) and $data->status == '0') ? 'selected' : '') ?>><?= $this->lang->line('pilih_opsi') ?></option>
                    <option value="1" <?= ((isset($data) and $data->status == '1') ? 'selected' : '') ?>><?= $this->lang->line('kontrak') ?></option>
                    <option value="2" <?= ((isset($data) and $data->status == '2') ? 'selected' : '') ?>><?= $this->lang->line('tetap') ?></option>
                    <option value="3" <?= ((isset($data) and $data->status == '3') ? 'selected' : '') ?>><?= $this->lang->line('promosi') ?></option>
                </select>
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="row">
            <div class="col-md-12">
                <label><?= $this->lang->line('keterangan_status') ?> <i class="text-danger">*</i></label>
                <input type="text" id="keterangan_status" class="form-control" value="<?= ((isset($data)) ? $data->keterangan_status : '') ?>">
            </div>
        </div>
    </div>

</div>
<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <button id="btn_new_input" class="btn"><?= $this->lang->line('button_form_tambah_baru') ?></button>
            <button class="btn_save_pekerjaan btn btn-primary ladda-button" id="btn_save_pekerjaan" data-style="expand-left"></button>
        </div>
    </div><!-- ./row -->
</div>
