<script type="text/javascript">
    $(document).ready(function() {
        datepicker();
        dropdown_supervisi();

        $("#username, #password").on({
            keydown: function(e) {
                if (e.which === 32)
                    return false;
            },
            keyup: function() {
                this.value = this.value.replace(/\s/g, "");
            }
        });

        var status = $("#status").val();
        statusKaryawan(status);

        $("#status").change(function() {
            var status = $(this).val();
            statusKaryawan(status);
        });

        $('#jabatan').select2({
            placeholder: 'Pilih Jabatan',
            allowClear: true,
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.jabatan")  ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });


        $("#jabatan").change(function() {
            if ($(this).select2('data').lenght > 0) {
                var level_user = $("#jabatan option:selected").attr("leveluser");
            } else {
                var level_user = $("#jabatan").select2('data')[0].leveluser;
            }
            levelUser(level_user);
        });

        $('#cabang').select2({
            placeholder: '<?= $this->lang->line('pilih_cabang') ?>',
            allowClear: true,
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.cabang")  ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });

        $("#cabang").change(function() {
            $('#supervisi').val('0');
            dropdown_supervisi();
        });

        $('#departemen').select2({
            placeholder: '<?= $this->lang->line('pilih_departemen') ?>',
            allowClear: true,
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.departemen")  ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });

        $("#departemen").change(function() {
            $('#supervisi').val('0');
            dropdown_supervisi();
        });


        $(".btn_save_datadiri").click(function(e) {
            e.preventDefault();
            $('#message').html("");
            var loading = Ladda.create(this);

            if (typeof $("#jabatan").select2('data')[0].leveluser === "undefined") {
                var level_user = $("#jabatan option:selected").attr("leveluser");
            } else {
                var level_user = $("#jabatan").select2('data')[0].leveluser;
            }

            if ($("#no_induk_karyawan").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_nomor_induk_karyawan') ?></font>");
                $("#no_induk_karyawan").focus();
                return false;
            } else if ($("#nama_lengkap").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_nama_lengkap') ?></font>");
                $("#nama_lengkap").focus();
                return false;
            }
            // else if($("#jenis_kelamin").val() ==""){
            //     $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Jenis Kelamin belum diiisi</font>");
            //     $('#jenis_kelamin').focus();
            //     return false;
            // }
            else if ($("#jabatan").val() == null) {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_jabatan') ?></font>");
                $('#jabatan').select2('open');
                return false;
            } else if (level_user == "1") {
                if ($("#cabang").val() == null) {
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_cabang') ?></font>");
                    $('#cabang').select2('open');
                    return false;
                }
            } else if (level_user == "2") {
                if ($("#cabang").val() == null) {
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_cabang') ?></font>");
                    $('#cabang').select2('open');
                    return false;
                } else if ($("#departemen").val() == null) {
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_departemen') ?></font>");
                    $('#departemen').select2('open');
                    return false;
                }
            } else if (level_user == "3") {
                if ($("#cabang").val() == null) {
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_cabang') ?></font>");
                    $('#cabang').select2('open');
                    return false;
                } else if ($("#departemen").val() == null) {
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_departemen') ?></font>");
                    $('#departemen').select2('open');
                    return false;
                }
            } else if (level_user == "4") {
                if ($("#cabang").val() == null) {
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_cabang') ?></font>");
                    $('#cabang').select2('open');
                    return false;
                }
            } else if (level_user == "5") {
                if ($("#cabang").val() == null) {
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_cabang') ?></font>");
                    $('#cabang').select2('open');
                    return false;
                }
            } else if (level_user == "6") {
                if ($("#cabang").val() == null) {
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_cabang') ?></font>");
                    $('#cabang').select2('open');
                    return false;
                }
            } else if (level_user == "7") {
                if ($("#cabang").val() == null) {
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_cabang') ?></font>");
                    $('#cabang').select2('open');
                    return false;
                } else if ($("#departemen").val() == null) {
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_departemen') ?></font>");
                    $('#cabang').select2('open');
                    return false;
                }
            }

            if ($("#status").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_status_karyawan') ?></font>");
                $('#status').focus();
                return false;
            } else if ($("#status").val() == "1") {
                if ($("#tgl_aktif_bekerja").val() == "" || $("#tgl_aktif_bekerja").val() == "01-01-1970") {
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_tgl_mulai_kontrak') ?></font>");
                    $('#tgl_aktif_bekerja').focus()
                    return false;
                } else if ($("#tgl_berhenti_bekerja").val() == "" || $("#tgl_berhenti_bekerja").val() == "01-01-1970") {
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_tgl_berakhir_kontrak') ?></font>");
                    $('#tgl_berhenti_bekerja').focus();
                    return false;
                }
            } else if ($("#status").val() == "2") {
                if ($("#tgl_aktif_bekerja").val() == "") {
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_tgl_mulai_aktif') ?></font>");
                    $('#tgl_aktif_bekerja').focus()
                    return false;
                }
            }

            if ($("#join_date").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_tgl_join') ?></font>");
                $('#join_date').focus()
                return false;
            } else if ($("#username").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_username') ?></font>");
                $('#username').focus()
                return false;
            } else if ($("#password").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_password') ?></font>");
                $('#password').focus()
                return false;
            }

            loading.start();

            var param = new FormData();
            param.append('id_temp', $("#id_temp").val());
            param.append('no_induk_karyawan', $("#no_induk_karyawan").val());
            param.append('nama_lengkap', $("#nama_lengkap").val());
            param.append('gelar_depan', $("#gelar_depan").val());
            param.append('gelar_belakang', $("#gelar_belakang").val());
            param.append('jenis_kelamin', $("#jenis_kelamin").val());
            param.append('agama', $("#agama").val());
            param.append('tempat_lahir', $("#tempat_lahir").val());
            param.append('tgl_lahir', $("#tgl_lahir").val());
            param.append('alamat_domisili', $("#alamat_domisili").val());
            param.append('telepon', $("#telepon").val());
            param.append('email', $("#email").val());
            param.append('no_ktp', $("#no_ktp").val());
            param.append('tgl_aktif_bekerja', $("#tgl_aktif_bekerja").val());
            param.append('tgl_berhenti_bekerja', $("#tgl_berhenti_bekerja").val());
            param.append('join_date', $("#join_date").val());
            param.append('departemen', $("#departemen").val());
            param.append('level_user', level_user);
            param.append('cabang', $("#cabang").val());
            param.append('jabatan', $("#jabatan").val());
            param.append('jatah_cuti', $("#jatah_cuti").val());
            param.append('status', $("#status").val());
            param.append('username', $('#username').val());
            param.append('password_baru', $('#password_baru').val());

            $.ajax({
                type: 'POST',
                url: "<?= route('karyawan.import.save') ?>",
                data: param,
                dataType: 'JSON',
                contentType: false,
                processData: false,
                cache: false,
                success: function(result) {
                    if (result.success == true) {
                        if (result.type == 'update') {
                            window.location.href = '<?= route('karyawan.import.home') ?>';
                        }
                    }
                    loading.stop();
                    $('#message').show();
                    $('#message').html(result.message);
                },
                error: function() {
                    loading.stop();
                    $('#message').show();
                    $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
                }
            });
        });
    });

    function statusKaryawan(status) {
        if (status == '1') {
            $("#div_tgl_mulai_kerja").show();
            $("#lbl_tgl_mulai_kerja").html('<?= $this->lang->line('tgl_mulai_kontrak') ?>  <i class="text-danger">*</i>');
            $("#tgl_aktif_bekerja").prop("disabled", false);

            $("#div_tgl_berakhir_kerja").show();
            $("#lbl_tgl_berakhir_kerja").html('<?= $this->lang->line('tgl_berakhir_kontrak') ?> <i class="text-danger">*</i>');
            $("#tgl_berhenti_bekerja").prop("disabled", false);
        } else if (status == '2') {
            $("#div_tgl_mulai_kerja").show();
            $("#lbl_tgl_mulai_kerja").html('<?= $this->lang->line('tgl_aktif') ?> <i class="text-danger">*</i>');
            $("#tgl_aktif_bekerja").prop("disabled", false);

            $("#div_tgl_berakhir_kerja").hide();
        } else {

        }
    }

    function levelUser(level_user) {
        if (level_user == '1') {
            $("#div_cabang").show();

            $("#departemen").val("").trigger("change");
            $("#div_departemen").hide();

            $("#supervisi").val("");
            $("#div_supervisi").hide();

        } else if (level_user == '2') {
            $("#div_cabang").show();
            $("#div_departemen").show();

            $("#supervisi").val("");
            $("#div_supervisi").hide();

        } else if (level_user == '3') {
            $("#div_cabang").show();
            $("#div_departemen").show();
            $("#div_supervisi").show();

        } else if (level_user == '4') {
            $("#div_cabang").show();

            $("#departemen").val("").trigger("change");
            $("#div_departemen").hide();

            $("#supervisi").val("");
            $("#div_supervisi").hide();

        } else if (level_user == '5') {
            $("#div_cabang").show();

            $("#departemen").val("").trigger("change");
            $("#div_departemen").hide();

            $("#supervisi").val("");
            $("#div_supervisi").hide();
        } else if (level_user == '6') {
            $("#div_cabang").show();

            $("#departemen").val("").trigger("change");
            $("#div_departemen").hide();

            $("#supervisi").val("");
            $("#div_supervisi").hide();

        } else if (level_user == '7') {
            $("#div_cabang").show();
            $("#div_departemen").show();
            $("#div_supervisi").hide();
        } else {
            $("#cabang").val("");
            $("#departemen").val("").trigger("change");
            $("#supervisi").val("");

            $("#div_cabang").hide();
            $("#div_departemen").hide();
            $("#div_supervisi").hide();
        }
    }

    function dropdown_supervisi() {
        $('#supervisi').select2({
            placeholder: '<?= $this->lang->line('pilih_supervisi') ?>',
            allowClear: true,
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.supervisi")  ?>' + '/' + $('#cabang').val() + '/' + $('#departemen').val(),
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    }
</script>
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#"><?= $this->lang->line('menu_master_data') ?></a>
                        </li>
                        <li class="breadcrumb-item"><a href="#"><?= $this->lang->line('menu_karyawan') ?></a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <div class="float-md-right">
                <a href="<?= route('karyawan.import.home') ?>" class="btn btn-secondary btn-min-width">
                    <i class="fa fa-arrow-left"></i> <?= $this->lang->line('button_form_kembali') ?>
                </a>
            </div>
        </div>
    </div>
</div>


<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <input type="hidden" name="id_temp" id="id_temp" value="<?= isset($data->id_temp) ? md5($data->id_temp) : '' ?>">
            <div id="form_input" class="row">
                <div class="col-md-8">
                    <div class="row">
                        <div class="col-md-12"><label class="font-weight-bold"><?= $this->lang->line('data_diri') ?></label></div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <fieldset class="form-group">
                                <label><?= $this->lang->line('nomor_induk_karyawan') ?> <i class="text-danger">*</i></label>
                                <input type="text" id="no_induk_karyawan" class="form-control" placeholder="<?= $this->lang->line('nomor_induk_karyawan') ?>" value="<?= isset($data->nik) ? $data->nik : '' ?>">
                            </fieldset>
                        </div>
                        <div class="col-md-6">
                            <fieldset class="form-group">
                                <label><?= $this->lang->line('nama_lengkap') ?> <i class="text-danger">*</i></label>
                                <input type="text" value="<?= isset($data->nama_lengkap) ? $data->nama_lengkap : '' ?>" class="form-control" name="nama_lengkap" id="nama_lengkap" placeholder="<?= $this->lang->line('nama_lengkap') ?>">
                            </fieldset>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <fieldset class="form-group">
                                <label><?= $this->lang->line('gelar_depan') ?></label>
                                <input type="text" id="gelar_depan" class="form-control" placeholder="<?= $this->lang->line('gelar_depan') ?>" value="<?= isset($data->gelar_depan) ? $data->gelar_depan : '' ?>">
                            </fieldset>
                        </div>
                        <div class="col-md-6">
                            <fieldset class="form-group">
                                <label><?= $this->lang->line('gelar_belakang') ?></label>
                                <input type="text" id="gelar_belakang" class="form-control" placeholder="<?= $this->lang->line('gelar_belakang') ?>" value="<?= isset($data->gelar_belakang) ? $data->gelar_belakang : '' ?>">
                            </fieldset>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <fieldset class="form-group">
                                <label><?= $this->lang->line('jenis_kelamin') ?></label>
                                <select id="jenis_kelamin" class="form-control">
                                    <option value=""><?= $this->lang->line('pilih_opsi') ?></option>
                                    <option value="L" <?= ((isset($data) and $data->jenis_kelamin == 'L') ? 'selected' : '') ?>><?= $this->lang->line('laki_laki') ?></option>
                                    <option value="P" <?= ((isset($data) and $data->jenis_kelamin == 'P') ? 'selected' : '') ?>><?= $this->lang->line('perempuan') ?></option>
                                </select>
                            </fieldset>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <fieldset class="form-group">
                                <label><?= $this->lang->line('tempat_lahir') ?></label>
                                <input type="text" id="tempat_lahir" class="form-control" placeholder="<?= $this->lang->line('tempat_lahir') ?>" value="<?= isset($data->tempat_lahir) ? $data->tempat_lahir : '' ?>">
                            </fieldset>
                        </div>
                        <div class="col-md-6">
                            <fieldset class="form-group">
                                <label><?= $this->lang->line('tgl_lahir') ?></label>
                                <?php
                                if (isset($data)) {
                                    $tanggal_lahir = date('d-m-Y', strtotime($data->tgl_lahir));
                                } else {
                                    $tanggal_lahir = "";
                                }
                                ?>
                                <input type="text" id="tgl_lahir" class="form-control datepicker" data-inputmask="'alias': 'datetime','inputFormat': 'dd-mm-yyyy'" placeholder="dd-mm-yyyy" value="<?= $tanggal_lahir ?>">
                            </fieldset>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <fieldset class="form-group">
                                <label><?= $this->lang->line('no_telp') ?></label>
                                <input type="text" name="telepon" value="<?= isset($data->telepon) ? $data->telepon : '' ?>" class="form-control numberbox" id="telepon" placeholder="<?= $this->lang->line('no_telp') ?>">
                            </fieldset>
                        </div>
                        <div class="col-md-6">
                            <fieldset class="form-group">
                                <label><?= $this->lang->line('email') ?></label>
                                <input type="email" value="<?= isset($data->email) ? $data->email : '' ?>" name="email" class="form-control" id="email" placeholder="<?= $this->lang->line('email') ?>">
                            </fieldset>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <fieldset class="form-group">
                                <label><?= $this->lang->line('agama') ?></label>
                                <select id="agama" class="form-control">
                                    <option value="" <?= ((isset($data) and $data->agama == '') ? 'selected' : '') ?>><?= $this->lang->line('pilih_opsi') ?></option>
                                    <option value="Islam" <?= ((isset($data) and $data->agama == 'Islam') ? 'selected' : '') ?>><?= $this->lang->line('islam') ?></option>
                                    <option value="Kristen" <?= ((isset($data) and $data->agama == 'Kristen') ? 'selected' : '') ?>><?= $this->lang->line('kristen') ?></option>
                                    <option value="Hindu" <?= ((isset($data) and $data->agama == 'Hindu') ? 'selected' : '') ?>><?= $this->lang->line('hindu') ?></option>
                                    <option value="Budha" <?= ((isset($data) and $data->agama == 'Budha') ? 'selected' : '') ?>><?= $this->lang->line('buddha') ?></option>
                                    <option value="Katolik" <?= ((isset($data) and $data->agama == 'Katolik') ? 'selected' : '') ?>><?= $this->lang->line('katolik') ?></option>
                                    <option value="Khonghucu" <?= ((isset($data) and $data->agama == 'Khonghucu') ? 'selected' : '') ?>><?= $this->lang->line('khonghucu') ?></option>
                                </select>
                            </fieldset>
                        </div>
                        <div class="col-md-6">
                            <fieldset class="form-group">
                                <label><?= $this->lang->line('no_ktp') ?></label>
                                <input type="text" id="no_ktp" class="form-control numberbox" placeholder="Nomor KTP" value="<?= isset($data->no_ktp) ? $data->no_ktp : '' ?>">
                            </fieldset>
                        </div>
                    </div>


                    <div class="row mt-3">
                        <div class="col-md-12"><label class="font-weight-bold"><?= $this->lang->line('data_alamat_domisili') ?></label></div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <fieldset class="form-group">
                                <label><?= $this->lang->line('alamat') ?></label>
                                <textarea id="alamat_domisili" class="form-control" rows="3" placeholder="<?= $this->lang->line('alamat') ?>"><?= isset($data->alamat_domisili) ? $data->alamat_domisili : '' ?></textarea>
                            </fieldset>
                        </div>
                    </div>

                    <div class="row mt-3">
                        <div class="col-md-12"><label class="font-weight-bold"><?= $this->lang->line('data_kepegawaian') ?></label></div>
                    </div>
                    <?php

                    if (isset($data->level_user)) {
                        $level_user = $data->level_user;
                        if (in_array($level_user, array('1', '4', '6'))) { # Admin HR, Direksi, Admin Finance
                            $hidden_departemen = "style='display:none'";
                            $hidden_supervisi = "style='display:none'";
                        } else if ($level_user == '5') { # Kepala Cabang
                            $hidden_departemen = "style='display:none'";
                            $hidden_supervisi = "style='display:none'";
                        } else if ($level_user == '2') { # Kepala Departemen
                            $hidden_departemen = " ";
                            $hidden_supervisi = "style='display:none'";
                        } else if ($level_user == '7') { # Supervisi
                            $hidden_departemen = " ";
                            $hidden_supervisi = "style='display:none'";
                        } else { # STaff
                            $hidden_departemen = " ";
                            $hidden_supervisi = " ";
                        }
                    } else {
                        $hidden_departemen = "";
                        $hidden_supervisi = "";
                    }

                    ?>
                    <div class="row">
                        <div class="col-md-6">
                            <fieldset class="form-group">
                                <label><?= $this->lang->line('jabatan') ?> <i class="text-danger">*</i></label>
                                <select class="form-control" id="jabatan" class="select2 form-control" style="border-radius: 5px; width: 100%;">
                                    <?php
                                    if (isset($data->id_jabatan)) {
                                        echo '<option value="' . $data->id_jabatan . '" leveluser="' . $data->level_user . '" selected>' . $data->kode_jabatan . ' - ' . $data->nama_jabatan . '</option>';
                                    }
                                    ?>
                                </select>
                            </fieldset>
                        </div>

                        <div id="div_cabang" class="col-md-6">
                            <fieldset class="form-group">
                                <label><?= $this->lang->line('cabang') ?> <i class="text-danger">*</i></label>
                                <select id="cabang" class="select2 form-control" style="border-radius: 5px; width: 100%;">
                                    <?php
                                    if (isset($data->id_cabang)) {
                                        echo '<option value="' . $data->id_cabang . '" selected>' . $data->kode_cabang . ' - ' . $data->nama_cabang . '</option>';
                                    }
                                    ?>
                                </select>
                            </fieldset>
                        </div>
                    </div>
                    <div class="row">
                        <div id="div_departemen" class="col-md-6" <?= $hidden_departemen ?>>
                            <fieldset class="form-group">
                                <label><?= $this->lang->line('departemen') ?> <i class="text-danger">*</i></label>
                                <select id="departemen" class="select2 form-control" style="border-radius: 5px; width: 100%;">
                                    <?php
                                    if (isset($data->id_departemen)) {
                                        echo '<option value="' . $data->id_departemen . '" selected>' . $data->kode_departemen . ' - ' . $data->nama_departemen . '</option>';
                                    }
                                    ?>
                                </select>
                            </fieldset>
                        </div>

                        <div id="div_supervisi" class="col-md-6" <?= $hidden_supervisi ?>>
                            <fieldset class="form-group">
                                <label><?= $this->lang->line('supervisi') ?> </label>
                                <select id="supervisi" class="select2 form-control" style="border-radius: 5px; width: 100%;">
                                    <?php
                                    if (isset($data->id_supervisi)) {
                                        echo '<option value="' . $data->id_supervisi . '" selected>' . $data->nik_supervisi . ' - ' . $data->nama_supervisi . '</option>';
                                    }
                                    ?>
                                </select>
                            </fieldset>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <fieldset class="form-group">
                                <label><?= $this->lang->line('sisa_cuti_tahunan') ?></label>
                                <input type="text" id="jatah_cuti" class="form-control numberbox" placeholder="<?= $this->lang->line('sisa_cuti_tahunan') ?>" value="<?= isset($data->jatah_cuti) ? $data->jatah_cuti : '' ?>">
                            </fieldset>
                        </div>
                        <div class="col-md-6">
                            <fieldset class="form-group">
                                <label>Status <i class="text-danger">*</i></label>
                                <select class="form-control" id="status">
                                    <option value="1" <?= ((isset($data) and $data->status == '1') ? 'selected' : '') ?>><?= $this->lang->line('kontrak') ?></option>
                                    <option value="2" <?= ((isset($data) and $data->status == '2') ? 'selected' : '') ?>><?= $this->lang->line('tetap') ?> (<?= $this->lang->line('aktif') ?>)</option>
                                </select>
                            </fieldset>
                        </div>
                    </div>
                    <div class="row">
                        <div id="div_tgl_mulai_kerja" class="col-md-6">
                            <fieldset class="form-group">
                                <label id="lbl_tgl_mulai_kerja"><?= $this->lang->line('tgl_aktif_bekerja') ?> <i class="text-danger">*</i></label>
                                <?php
                                if (isset($data)) {
                                    if ($data->tgl_aktif_bekerja != "0000-00-00" && $data->tgl_aktif_bekerja != "1970-01-01") {
                                        $tanggal_aktif = date('d-m-Y', strtotime($data->tgl_aktif_bekerja));
                                    } else {
                                        $tanggal_aktif = "";
                                    }
                                } else {
                                    $tanggal_aktif = "";
                                }


                                ?>
                                <input type="text" id="tgl_aktif_bekerja" class="form-control datepicker" data-inputmask="'alias': 'datetime','inputFormat': 'dd-mm-yyyy'" placeholder="dd-mm-yyyy" value="<?= $tanggal_aktif ?>">
                            </fieldset>
                        </div>
                        <div id="div_tgl_berakhir_kerja" class="col-md-6">
                            <fieldset class="form-group">
                                <label id="lbl_tgl_berakhir_kerja"><?= $this->lang->line('tgl_berhenti_bekerja') ?></label>
                                <?php
                                if (isset($data)) {
                                    if ($data->tgl_berhenti_bekerja != "0000-00-00" && $data->tgl_berhenti_bekerja != "1970-01-01") {
                                        $tanggal_berhenti = date('d-m-Y', strtotime($data->tgl_berhenti_bekerja));
                                    } else {
                                        $tanggal_berhenti = "";
                                    }
                                } else {
                                    $tanggal_berhenti = "";
                                }
                                ?>
                                <input type="text" value="<?= $tanggal_berhenti ?>" class="form-control datepicker" id="tgl_berhenti_bekerja" data-inputmask="'alias': 'datetime','inputFormat': 'dd-mm-yyyy'" placeholder="dd-mm-yyyy">
                            </fieldset>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <fieldset class="form-group">
                                <label>Join Date<i class="text-danger">*</i></label>
                                <?php
                                if (!empty($data->join_date) && $data->join_date != '1970-01-01') {
                                    $join_date = date('d-m-Y', strtotime($data->join_date));
                                } else {
                                    $join_date = "";
                                }
                                ?>
                                <input type="text" id="join_date" value="<?= $join_date ?>" class="form-control datepicker" data-inputmask="'alias': 'datetime','inputFormat': 'dd-mm-yyyy'" placeholder="dd-mm-yyyy">
                            </fieldset>
                        </div>
                    </div>
                    <div class="row mt-3">
                        <div class="col-md-12"><label class="font-weight-bold"><?= $this->lang->line('data_akun') ?></label></div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <fieldset class="form-group">
                                <label>Username <i class="text-danger">*</i></label>
                                <input type="text" value="<?= isset($data->username) ? $data->username : '' ?>" name="username" class="form-control" id="username" placeholder="Username">
                            </fieldset>
                        </div>
                        <!-- <div class="col-md-6">
                            <fieldset class="form-group">
                                <label>Password <i class="text-danger">*</i></label>
                                <input type="text" value="<?= isset($data->password) ? '*******' : '' ?>" name="password" class="form-control" id="password" placeholder="Password">

                            </fieldset>
                        </div> -->
                    </div>

                </div>
                <div class="col-md-12">
                    <div class="row">
                        <div class="col-md-7 text-left">
                            <div id="message"></div>
                        </div>
                        <div class="col-md-5 text-right">
                            <button class="btn_save_datadiri btn btn-primary btn-min-width ladda-button" data-style="expand-left"><i class="fa fa-save"></i> <?= $this->lang->line('button_form_simpan') ?></button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
