<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Approver_m extends CI_Model
{
    var $table = 'kpi_approver_p';
    public function __construct()
    {
        parent::__construct();
    }

    function get_datatables($status_atasan = 0)
    {
        $this->_get_datatables_query($status_atasan);
        if ($_GET['length'] != -1) {
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered($status_atasan = 0)
    {
        $this->_get_datatables_query($status_atasan);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all($status_atasan = "")
    {
        $this->_get_datatables_query($status_atasan);
        $query = $this->db->get();
        return $query->num_rows();
    }

    private function _get_datatables_query($status_atasan = "")
    {
        $this->db->select("
            dk.id_karyawan,
            dk.nik,
            dk.nama_lengkap,

            CASE
                WHEN dk.id_departemen != '' 
                THEN (SELECT md.nama FROM master_departemen AS md WHERE md.id_departemen = dk.id_departemen LIMIT 1)
                ELSE '-' 
            END AS nama_departemen,

            mj.nama as nama_jabatan,
            appv.id_atasan,
            IF(appv.id_atasan IS NULL, 'insert', 'update') AS action,
            atasan.nik as nik_atasan,
            atasan.nama_lengkap as nama_atasan
        ")
            ->from('data_karyawan as dk')
            ->join($this->table . " AS appv", "dk.id_karyawan = appv.id_karyawan", 'LEFT')
            // ->join('master_departemen as md','md.id_departemen = dk.id_departemen','LEFT')
            ->join('master_jabatan as mj','mj.id_jabatan = dk.id_jabatan')
            ->join('data_karyawan as atasan','atasan.id_karyawan = appv.id_atasan', 'LEFT')
            ->join('usergroup AS group', 'group.id = mj.level_user')
            ->where("dk.id_company", $this->id_company)
            ->where_not_in("mj.level_user", ['1', '6'])
            ->where_in("dk.status", [1,2,3,4]);

        if ($status_atasan == "belum") {
            $this->db->where("appv.id_atasan", null);
        }else if($status_atasan == "sudah"){
            $this->db->where("appv.id_atasan !=", null);
        }

        $column_search = array('dk.nama_lengkap');
        $i = 0;

        foreach ($column_search as $item) {  // looping awal
            if ($_GET['search']['value']) { // jika datatable mengirimkan pencarian dengan metode POST

                if ($i === 0) { // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                } else {
                    $this->db->or_like($item, $_GET['search']['value']);
                }

                if (count($column_search) - 1 == $i) {
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array('', '', '', '');

        if (isset($_GET['order'])) {
            $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        } else {
            $this->db->order_by('group.urutan ASC, nama_departemen ASC, mj.nama ASC, dk.nama_lengkap ASC');
        }
    }

    public function getDataById($id = null)
    {
        $select = $this->db->select("
                dk.id_karyawan,
                dk.nik,
                dk.nama_lengkap,
                IF(md.nama IS NULL, '-', md.nama) AS nama_departemen,
                mj.nama as nama_jabatan,
                appv.id_atasan,
                IF(appv.id_atasan IS NULL, 'insert', 'update') AS action,
                atasan.nik as nik_atasan,
                atasan.nama_lengkap as nama_atasan
            ")
            ->from('data_karyawan as dk')
            ->join($this->table . " AS appv", "dk.id_karyawan = appv.id_karyawan", 'LEFT')
            ->join('master_departemen as md','md.id_departemen = dk.id_departemen','LEFT')
            ->join('master_jabatan as mj','mj.id_jabatan = dk.id_jabatan')
            ->join('data_karyawan as atasan','atasan.id_karyawan = appv.id_atasan', 'LEFT')
            ->join('usergroup AS group', 'group.id = mj.level_user')
            ->where("MD5(dk.id_karyawan)", $id)
            ->where("dk.id_company", $this->id_company)
            ->get()
            ->row();
            
        return $select;
    }

    public function delete($id = null){
        $this->db->where(array('md5(id_karyawan)' => $id, 'id_company' => $this->id_company));
        $delete = $this->db->delete($this->table);
        $this->logger->create_log('approver_kpi', 'delete', $this->db->last_query());
        return  __response_delete($delete);
    }

}
