<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends MY_Controller {

	public function __construct(){
        parent::__construct();
		$this->load->model('pkwt/perpanjang/Draft_pkwt_m');
		$this->load->helper('pkwt');
    }

	public function index(){
		$data['judul'] = 'PKWT Perpanjangan';
		$data['aktif'] = 'pkwt_perpanjangan';
		$data['level_user'] = $this->level_user;
		$data['periode_awal'] = date('d-m-Y',  strtotime(date('Y-m-').'01'));
		$data['periode_akhir'] = date('d-m-Y',  strtotime(date('Y-m-d')));
        $data['menu'] = $this->load->view('main_menu', $data, true);
		$data['content'] = $this->load->view('pkwt/perpanjang/home', $data, true);
		$this->load->view('main_template', $data, false);
	}

	public function tabs($tabs = null){
		if($tabs == "habis_masa_kerja"){
			$this->load->view('pkwt/perpanjang/tabs_habis_masa_kerja');
		}else if($tabs == "draft_pkwt"){
			$this->load->view('pkwt/perpanjang/tabs_draft_pkwt', $data);
		}else if($tabs == "verifikasi"){
			$this->load->view('pkwt/perpanjang/tabs_verifikasi');
		}
	}

	// UNTUK MOBILE
	public function download_pdf($id_pkwt=""){
		$data['data'] = $this->Draft_pkwt_m->getDataById($id_pkwt);
		$data['document'] = 'pdf';

		$filename = $data['data']->no_pkwt;
		if(!empty($filename)){
			$filename = str_replace('/', '_', $filename);
		}else{
			$filename = 'draft_pkwt';
		}

		$nama_file_pkwt = explode("/", $data['data']->nm_draft_pkwt);
		if(!empty($nama_file_pkwt)){
			$nama_file_pkwt = explode(".",$nama_file_pkwt[count($nama_file_pkwt)-1]);
			$html           = read_template_file($data['data']->nm_draft_pkwt);
			$html           = set_parameter($html, $data['data']->draft_pkwt_parameter, $data['data']->draft_pkwt_value);
			$html           = set_ttd($html, $data['data']);
		}else{
			echo "File PKWT Belum Ada"; die();
		}

		$this->load->library('mpdf');
		$param['title'] = $filename;
		$param['page_number'] = true;
		$param['show_watermark'] = false;
		$param['custom_font'] = false;
		$param['download']	= true;	
		$param['header']	= true;	
		$this->mpdf->generate($html, $filename, 'A4', 'P', $param);
	}

	// UNTUK WEB
	public function download_pdf_web($id_pkwt="", $jenis = "data"){
		$this->load->model('pkwt/perpanjang/import_m');
		if($jenis == "data") {
			$data['data'] = $this->Draft_pkwt_m->getDataById($id_pkwt);
		} else {
			$data['data'] = $this->import_m->getDataById($id_pkwt);
		}
		$data['document'] = 'pdf';

		$filename = $data['data']->no_pkwt;
		if(!empty($filename)){
			$filename = str_replace('/', '_', $filename);
		}else{
			$filename = 'draft_pkwt';
		}

		$nama_file_pkwt = explode("/", $data['data']->nm_draft_pkwt);
		if(!empty($nama_file_pkwt)){
			$nama_file_pkwt = explode(".",$nama_file_pkwt[count($nama_file_pkwt)-1]);
			$html           = read_template_file($data['data']->nm_draft_pkwt);
			$html           = set_parameter($html, $data['data']->draft_pkwt_parameter, $data['data']->draft_pkwt_value);
			$html           = set_ttd($html, $data['data']);
		}else{
			echo "File PKWT Belum Ada"; die();
		}

		$this->load->library('mpdf');
		$param['title'] = $filename;
		$param['page_number'] = true;
		$param['show_watermark'] = false;
		$param['custom_font'] = false;
		$param['download']	= false;	
		$param['header']	= true;	
		$this->mpdf->generate($html, $filename, 'A4', 'P', $param);
	}

	// VIEW HTML
	public function view_html($id_pkwt=""){
		$data['data'] = $this->Draft_pkwt_m->getDataById($id_pkwt);
		$data['document'] = 'html';

		$nama_file_pkwt = explode("/", $data['data']->nm_draft_pkwt);
		if(!empty($nama_file_pkwt)){
			     $nama_file_pkwt = explode(".",$nama_file_pkwt[count($nama_file_pkwt)-1]);
			     $html           = read_template_file($data['data']->nm_draft_pkwt);
			     $html           = set_parameter($html, $data['data']->draft_pkwt_parameter, $data['data']->draft_pkwt_value);
			echo $html           = set_ttd($html, $data['data']);
		}else{
			echo "File PKWT Belum Ada"; die();
		}
	}
}