<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Master_lembur_pengaturan extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('payroll/master_lembur/Master_lembur_pengaturan_m', 'model');
    }

    public function view_data()
    {
        $data['judul'] = 'Master Pengaturan Lembur';
        $this->load->view('payroll/master_lembur/pengaturan/index', $data);
    }

    public function form($for = 'tambah', $encrypt_id = null)
    {
        if ($for == 'tambah') {
            return $this->load->view('payroll/master_lembur/pengaturan/modal');
        }

        // get data
        $data['data'] = $this->model->getDataById($encrypt_id);

        if ($for === 'edit') {
            return $this->load->view('payroll/master_lembur/pengaturan/modal', $data);
        }

        if ($for === 'delete') {
            return $this->load->view('payroll/master_lembur/pengaturan/modal_detail', $data);
        }
    }

    public function save()
    {
        $kode              = $this->input->post('kode');
        $keterangan        = $this->input->post('keterangan');
        $flag_rounding     = $this->input->post('flag_rounding');
        $arr_pembulatan    = $this->input->post('arr_pembulatan');
        $arr_kompensasi    = $this->input->post('arr_kompensasi');
        $jenis_upah_lembur = $this->input->post('jenis_upah_lembur');
        $nominal_flat      = $this->input->post('nominal_flat');
        $divide_prorate    = $this->input->post('divide_prorate');
        $flag_pph21        = $this->input->post('flag_pph21');
        $flag_pot_absensi  = $this->input->post('flag_pot_absensi');

        // validasi
        $kode_exist = $this->db->select('kode')
            ->from('payroll_lembur_p')
            ->where('id_company', $this->id_company)
            ->where('kode', $kode)
            ->get()
            ->num_rows();
        if ($kode_exist > 0) {
            return __response_save(false, ['message' => '<font style="color:Crimson"><i class="fa fa-exclamation-triangle"></i> Kode sudah ada</font>']);
        }

        $data = array(
            'kode'              => $kode,
            'keterangan'        => $keterangan,
            'flag_rounding'     => $flag_rounding,
            'jenis_upah_lembur' => $jenis_upah_lembur,
            'nominal_flat'      => str_replace('.', '', $nominal_flat),
            'divide_prorate'    => $divide_prorate,
            'flag_pph21'        => $flag_pph21,
            'flag_pot_absensi'  => $flag_pot_absensi,
        );

        $this->model->save($data, $arr_pembulatan, $arr_kompensasi);
    }

    public function update($encrypt_id)
    {
        $kode              = $this->input->post('kode');
        $keterangan        = $this->input->post('keterangan');
        $flag_rounding     = $this->input->post('flag_rounding');
        $arr_pembulatan    = $this->input->post('arr_pembulatan');
        $arr_kompensasi    = $this->input->post('arr_kompensasi');
        $jenis_upah_lembur = $this->input->post('jenis_upah_lembur');
        $nominal_flat      = $this->input->post('nominal_flat');
        $divide_prorate    = $this->input->post('divide_prorate');
        $flag_pph21        = $this->input->post('flag_pph21');
        $flag_pot_absensi  = $this->input->post('flag_pot_absensi');

        // validasi
        $kode_exist = $this->db->select('kode')
            ->from('payroll_lembur_p')
            ->where('id_company', $this->id_company)
            ->where('kode', $kode)
            ->where('md5(id_lembur_p) != "' . $encrypt_id . '"')
            ->get()
            ->num_rows();
        if ($kode_exist > 0) {
            return __response_update(false, ['message' => '<font style="color:Crimson"><i class="fa fa-exclamation-triangle"></i> Kode sudah ada</font>']);
        }

        $data = array(
            'kode'              => $kode,
            'keterangan'        => $keterangan,
            'flag_rounding'     => $flag_rounding,
            'jenis_upah_lembur' => $jenis_upah_lembur,
            'nominal_flat'      => str_replace('.', '', $nominal_flat),
            'divide_prorate'    => $divide_prorate,
            'flag_pph21'        => $flag_pph21,
            'flag_pot_absensi'  => $flag_pot_absensi,
        );

        $this->model->update($data, $arr_pembulatan, $arr_kompensasi, $encrypt_id);
    }

    public function delete()
    {
        $encrypt_id = $this->input->post('id');

        // validasi
        $id_exist = $this->db->select('id_lembur_p')
            ->from('payroll_lembur_p')
            ->where('md5(id_lembur_p)', $encrypt_id)
            ->get();
        if ($id_exist->num_rows() == 0) {
            return __response_delete(false, ['message' => '<font><i class="fa fa-exclamation-triangle"></i> Data tidak ditemukan</font>']);
        }

        $decrypt_id = $id_exist->row()->id_lembur_p;
        $this->model->delete($decrypt_id);
    }
}
