<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Master_lembur extends MY_Controller
{
    public function index()
    {
        $data['judul'] = 'Master Lembur';
        $data['aktif'] = 'master_lembur';
        $data['menu'] = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('payroll/master_lembur/index', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function list_data($tab, $params = null)
    {
        if ($tab === 'pengaturan') {
            $this->list_pengaturan();
        } elseif ($tab === 'lembur_karyawan') {
            $this->list_lembur_karyawan($params);
        }
    }

    private function list_pengaturan()
    {
        $this->load->model('payroll/master_lembur/Master_lembur_pengaturan_m', 'model');

        $list = $this->model->get_datatables();
        $data = array();
        $no = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = $field->kode;
            $row[] = $field->keterangan;
            $row[] = ($field->flag_pph21 == '1') ? '<i class="text-success fa fa-check"></i>' : '<i class="text-danger fa fa-close"></i>';
            $row[] = ($field->flag_pot_absensi == '1') ? '<i class="text-success fa fa-check"></i>' : '<i class="text-danger fa fa-close"></i>';

            $btn_edit  = '<a href="javascript:void(0)" class="text-warning" title="EDIT"> <i id="' . md5($field->id_lembur_p) . '" class="btn_edit fa fa-edit (alias) "> </i></a>';
            $btn_hapus = '<a href="javascript:void(0)" class="text-danger" title="HAPUS"><i id="' . md5($field->id_lembur_p) . '" class="btn_delete fa fa-trash"></i></a>';

            $row[] = $btn_edit . ' ' . $btn_hapus;

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->model->count_all(),
            "recordsFiltered" => $this->model->count_filtered(),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    private function list_lembur_karyawan($params)
    {
        $this->load->model('payroll/master_lembur/Master_lembur_karyawan_m', 'model');

        $master_lembur = $this->model->getMasterLembur();
        $list = $this->model->get_datatables($params);
        $data = array();
        $no   = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();

            # lembur hari kerja
            $lembur_hari_kerja = '<span>' . ($master_lembur[$field->lembur_hari_kerja]['kode'] ?: '-') . '</span>';
            $lembur_hari_kerja .= '<select data-old="' . $field->lembur_hari_kerja . '" class="hidden form-control" style="font-size: 12px;"><option value="" ' . ($field->lembur_hari_kerja ? '' : 'selected') . '>Pilih</option>';
            foreach ($master_lembur as $key => $value) {
                $lembur_hari_kerja .= '<option value="' . $key . '" ' . ($key == $field->lembur_hari_kerja ? 'selected' : '') . '>' . $value['kode'] . '</option>';
            }
            $lembur_hari_kerja .= '</select>';

            # lembur libur off
            $lembur_libur_off = '<span>' . ($master_lembur[$field->lembur_libur_off]['kode'] ?: '-') . '</span>';
            $lembur_libur_off .= '<select data-old="' . $field->lembur_libur_off . '" class="hidden form-control" style="font-size: 12px;"><option value="" ' . ($field->lembur_libur_off ? '' : 'selected') . '>Pilih</option>';
            foreach ($master_lembur as $key => $value) {
                $lembur_libur_off .= '<option value="' . $key . '" ' . ($key == $field->lembur_libur_off ? 'selected' : '') . '>' . $value['kode'] . '</option>';
            }
            $lembur_hari_kerja .= '</select>';

            # lembur libur nasional
            $lembur_libur_nasional = '<span>' . ($master_lembur[$field->lembur_libur_nasional]['kode'] ?: '-') . '</span>';
            $lembur_libur_nasional .= '<select data-old="' . $field->lembur_libur_nasional . '" class="hidden form-control" style="font-size: 12px;"><option value="" ' . ($field->lembur_libur_nasional ? '' : 'selected') . '>Pilih</option>';
            foreach ($master_lembur as $key => $value) {
                $lembur_libur_nasional .= '<option value="' . $key . '" ' . ($key == $field->lembur_libur_nasional ? 'selected' : '') . '>' . $value['kode'] . '</option>';
            }
            $lembur_hari_kerja .= '</select>';

            # lembur libur khusus
            $lembur_libur_khusus = '<span>' . ($master_lembur[$field->lembur_libur_khusus]['kode'] ?: '-') . '</span>';
            $lembur_libur_khusus .= '<select data-old="' . $field->lembur_libur_khusus . '" class="hidden form-control" style="font-size: 12px;"><option value="" ' . ($field->lembur_libur_khusus ? '' : 'selected') . '>Pilih</option>';
            foreach ($master_lembur as $key => $value) {
                $lembur_libur_khusus .= '<option value="' . $key . '" ' . ($key == $field->lembur_libur_khusus ? 'selected' : '') . '>' . $value['kode'] . '</option>';
            }
            $lembur_hari_kerja .= '</select>';

            $row[] = $no;
            $row[] = $field->nama . '<br><span class="text-light" style="font-size: 12px">' . $field->nik . '</span>';
            $row[] = $field->cabang . '<br>' . $field->departemen;
            $row[] = $lembur_hari_kerja;
            $row[] = $lembur_libur_off;
            $row[] = $lembur_libur_nasional;
            $row[] = $lembur_libur_khusus;

            $btn_save  = '<a href="javascript:void(0)" class="text-primary" title="SIMPAN"> <i id="' . $field->id_karyawan . '" class="btn_save fa fa-check (alias) "> </i></a>';
            $btn_batal = '<a href="javascript:void(0)" class="text-danger" title="BATAL"> <i class="btn_batal fa fa-close (alias) "> </i></a>';
            $btn_edit  = '<a href="javascript:void(0)" class="text-warning" title="EDIT"> <i class="btn_edit fa fa-edit (alias) "> </i></a>';
            $btn_hapus = '<a href="javascript:void(0)" class="text-danger" title="HAPUS"><i id="' . md5($field->id_karyawan) . '" class="btn_delete fa fa-trash"></i></a>';

            $loading = '<div class="custom-loader hidden"></div>';
            $row[] = $loading . '<div id="save" class="hidden">' . $btn_save . ' ' . $btn_batal . '</div><div id="edit">' . $btn_edit . ' ' . $btn_hapus . '</div>';

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->model->count_all($params),
            "recordsFiltered" => $this->model->count_filtered($params),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }
}
