<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Karyawan extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Karyawan_m');
    }

    public function index()
    {
        $this->session->set_userdata('id_kar', 0);
        $data['judul']   = $this->lang->line('menu_karyawan');
        $data['aktif']   = 'karyawan';
        $data['menu']    = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('karyawan/home', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function tabs($tabs = null)
    {
        if ($tabs == "jabatan") {
            $this->load->view('karyawan/tabs_jabatan');
        } else if ($tabs == "pengguna_aktif") {
            $this->load->view('karyawan/tabs_pengguna_aktif');
        } else if ($tabs == "pendidikan") {
            $this->load->view('karyawan/tabs_pendidikan');
        } else if ($tabs == "lokasi") {
            $this->load->view('karyawan/tabs_lokasi');
        } else if ($tabs == "device") {
            $this->load->view('karyawan/tabs_device');
        } else if ($tabs == "facerecognition") {
            $this->load->view('karyawan/tabs_facerecognition');
        } else if ($tabs == "camera") {
            $this->load->view('karyawan/tabs_camera');
        }
    }

    public function form($id_karyawan = null)
    {
        $data['judul'] = $this->lang->line('tambah_karyawan');
        $data['aktif'] = 'karyawan';
        $data['menu']  = $this->load->view('main_menu', $data, true);
        if ($id_karyawan == null) {
            $data['content'] = $this->load->view('karyawan/form', $data, true);
        } else {
            $data['data']    = $this->Karyawan_m->getDataById($id_karyawan);
            $data['id']      = $data['data']->id_karyawan;
            $data['content'] = $this->load->view('karyawan/form', $data, true);
        }

        $data['menu'] = $this->load->view('main_menu', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function detail($id_karyawan)
    {
        $data['judul']               = $this->lang->line('menu_karyawan');
        $data['aktif']               = 'karyawan';
        $data['row']                 = $this->Karyawan_m->getDataById($id_karyawan);
        // $data['level_user_karyawan'] = $data['row']->level_user;
        $data['id_karyawan']         = md5($data['row']->id_karyawan);
        $data['menu']                = $this->load->view('main_menu', $data, true);
        $data['content']             = $this->load->view('karyawan/karyawan_detail', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function data_tabs_jabatan($jenis = null, $id_cabang = "0", $id_departemen = "0", $id_jabatan = "0", $status = "0", $jenis_kelamin, $id_karyawan = "0")
    {
        $list        = $this->Karyawan_m->get_datatables_tabs_jabatan($jenis, $id_cabang, $id_departemen, $id_jabatan, $status, $jenis_kelamin, $id_karyawan);
        $jml_admin   = $this->Karyawan_m->getDataById_numrows();
        $jml_finance = $this->Karyawan_m->getDataByIFnc_numrows();
        $data        = array();
        $no          = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();

            $foto = $this->config->item('base_image') . 'imagebiodata?_t=photo&_d=' . $field->foto;
            $notif_pengajuan = $this->notif_status->per_karyawan(md5($field->id_karyawan));
            $row[] = $no;
            $row[] = '<a href="'.$foto.'" data-lightbox="mulai-'.$no.'"><img class="media-object avatar avatar-sm img-fit-cover" src="' . $foto . '" style="border-radius: 2;"></a>';
            $row[] = '<a href="' . site_url('master/karyawan/detail/' . md5($field->id_karyawan)) . '" class="media border-0" onclick="save_filter_session();">' . $field->nama_lengkap . $notif_pengajuan . '</a>' . $field->nik;
            $row[] = isset($field->nama_cabang) ? $field->nama_cabang . "<br><b>" . $field->kode_cabang."</b>" : "";
            $row[] = isset($field->nama_departemen) ? $field->nama_departemen . "<br><b>" . $field->kode_departemen."</b>" : "-";
            $row[] = isset($field->nama_jabatan) ? $field->nama_jabatan . "<br><b>" . $field->kode_jabatan."</b>" : "";
            $row[] = $this->jenis_kelamin($field->jenis_kelamin);
            $row[] = $this->fungsi->status_karyawan($field->status);

            $btn_detail = '<a href="' . site_url('master/karyawan/detail/' . md5($field->id_karyawan)) . '" title="Detail" class="text-primary"><i class="btn_detail fa fa-info-circle (alias) " onclick="save_filter_session();"> </i></a>';
            $btn_hapus  = '<a href="#" title="Delete" class="text-danger"><i class="btn_delete fa fa-trash" id="' . md5($field->id_karyawan) . '"></i></a>';

            if ($this->level_user == '1') {
                if ($field->level_user == 1) {
                    if ($jml_admin > 1) {
                        $row[] = $btn_detail . '&nbsp;' . $btn_hapus;
                    } else {
                        $row[] = $btn_detail;
                    }
                } else if ($field->level_user == 6) {
                    if ($jml_finance > 1) {
                        $row[] = $btn_detail . '&nbsp;' . $btn_hapus;
                    } else {
                        $row[] = $btn_detail;
                    }
                } else {
                    $row[] = $btn_detail . '&nbsp;' . $btn_hapus;
                }
            } else {
                $row[] = $btn_detail;
            }

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->Karyawan_m->count_all_tabs_jabatan($jenis, $id_cabang, $id_departemen, $id_jabatan, $status, $jenis_kelamin, $id_karyawan),
            "recordsFiltered" => $this->Karyawan_m->count_filtered_tabs_jabatan($jenis, $id_cabang, $id_departemen, $id_jabatan, $status, $jenis_kelamin, $id_karyawan),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    private function jenis_kelamin($jenis)
    {
        if ($jenis == 'L') {
            return $this->lang->line('laki_laki');
        } elseif ($jenis == 'P') {
            return $this->lang->line('perempuan');
        } else {
            return $this->lang->line('belum_diatur');
        }
    }

    public function data_tabs_pengguna_aktif($jenis = null, $id_cabang = "0", $id_departemen = "0", $id_jabatan = "0", $jenis_kelamin, $id_karyawan = "0")
    {
        $list = $this->Karyawan_m->get_datatables_tabs_pengguna_aktif($jenis, $id_cabang, $id_departemen, $id_jabatan, $jenis_kelamin, $id_karyawan);
        $data = array();
        $no = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();

            $foto = $this->config->item('base_image') . 'imagebiodata?_t=photo&_d=' . $field->foto;
            $notif_pengajuan = $this->notif_status->per_karyawan(md5($field->id_karyawan));
            $row[] = $no;
            $row[] = '<a href="'.$foto.'" data-lightbox="mulai-'.$no.'"><img class="media-object avatar avatar-sm img-fit-cover" src="' . $foto . '" style="border-radius: 2;"></a>';
            $row[] = '<a href="' . site_url('master/karyawan/detail/' . md5($field->id_karyawan)) . '" class="media border-0" onclick="save_filter_session();">' . $field->nama_lengkap . $notif_pengajuan . '</a>' . $field->nik;
            $row[] = isset($field->nama_cabang) ? $field->nama_cabang . "<br><b>" . $field->kode_cabang."</b>" : "";
            $row[] = isset($field->nama_departemen) ? $field->nama_departemen . "<br><b>" . $field->kode_departemen."</b>" : "-";
            $row[] = isset($field->nama_jabatan) ? $field->nama_jabatan . "<br><b>" . $field->kode_jabatan."</b>" : "";
            $row[] = $this->jenis_kelamin($field->jenis_kelamin);
            $row[] = $this->fungsi->status_karyawan($field->status);

            if (in_array($this->level_user, array("1"))) {
                $row[] = '  <a href="' . site_url('master/karyawan/detail/' . md5($field->id_karyawan)) . '" title="Detail" class="text-primary" onclick="save_filter_session();">
                                <i class="btn_detail fa fa-info-circle (alias) "> </i>
                                </a>&nbsp;
                                <a href="#" title="Delete" class="text-danger">
									<i class="btn_delete fa fa-trash" id="' . md5($field->id_karyawan) . '"></i>
                                </a>';
            } else {
                $row[] = '  <a href="' . site_url('master/karyawan/detail/' . md5($field->id_karyawan)) . '" title="Detail" class="text-primary" onclick="save_filter_session();">
							<i class="btn_detail fa fa-info-circle (alias) "> </i>
							</a>&nbsp;';
            }

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->Karyawan_m->count_all_tabs_pengguna_aktif($jenis, $id_cabang, $id_departemen, $id_jabatan, $jenis_kelamin, $id_karyawan),
            "recordsFiltered" => $this->Karyawan_m->count_filtered_tabs_pengguna_aktif($jenis, $id_cabang, $id_departemen, $id_jabatan, $jenis_kelamin, $id_karyawan),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function data_tabs_pendidikan($jenis = null, $id_cabang = "0", $id_departemen = "0", $id_jabatan = "0", $pendidikan = "0", $jenis_kelamin, $id_karyawan = "0")
    {
        $list = $this->Karyawan_m->get_datatables_tabs_pendidikan($jenis, $id_cabang, $id_departemen, $id_jabatan, $pendidikan, $jenis_kelamin, $id_karyawan);
        $data = array();
        $no = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();

            $foto = $this->config->item('base_image') . 'imagebiodata?_t=photo&_d=' . $field->foto;
            $notif_pengajuan = $this->notif_status->per_karyawan(md5($field->id_karyawan));
            $row[] = $no;
            $row[] = '<a href="'.$foto.'" data-lightbox="mulai-'.$no.'"><img class="media-object avatar avatar-sm img-fit-cover" src="' . $foto . '" style="border-radius: 2;"></a>';
            $row[] = '<a href="' . site_url('master/karyawan/detail/' . md5($field->id_karyawan)) . '" class="media border-0" onclick="save_filter_session();">' . $field->nama_lengkap . $notif_pengajuan . '</a>' . $field->nik;
            $row[] = $field->nama_cabang . "<br><b>" . $field->kode_cabang."</b>";
            $row[] = $field->nama_departemen . "<br><b>" . $field->kode_departemen."</b>";
            $row[] = $field->nama_jabatan . "<br><b>" . $field->kode_jabatan."</b>";
            $row[] = $this->jenis_kelamin($field->jenis_kelamin);
            $row[] = $field->pendidikan_terakhir;

            if (in_array($this->level_user, array("1"))) {
                $row[] = '  <a href="' . site_url('master/karyawan/detail/' . md5($field->id_karyawan)) . '" title="Detail" class="text-primary" onclick="save_filter_session();">
                                <i class="btn_detail fa fa-info-circle (alias) "> </i>
                                </a>&nbsp;
                                <a href="#" title="Delete" class="text-danger">
									<i class="btn_delete fa fa-trash" id="' . md5($field->id_karyawan) . '"></i>
                                </a>';
            } else {
                $row[] = '  <a href="' . site_url('master/karyawan/detail/' . md5($field->id_karyawan)) . '" title="Detail" class="text-primary" onclick="save_filter_session();">
							<i class="btn_detail fa fa-info-circle (alias) "> </i>
							</a>&nbsp;';
            }

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->Karyawan_m->count_all_tabs_pendidikan($jenis, $id_cabang, $id_departemen, $id_jabatan, $pendidikan, $jenis_kelamin, $id_karyawan),
            "recordsFiltered" => $this->Karyawan_m->count_filtered_tabs_pendidikan($jenis, $id_cabang, $id_departemen, $id_jabatan, $pendidikan, $jenis_kelamin, $id_karyawan),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function data_tabs_lokasi($jenis = null, $id_cabang = "-", $id_departemen = "-", $id_jabatan = "-", $lock_lokasi = "-", $jenis_kelamin, $id_karyawan = "-")
    {
        $list = $this->Karyawan_m->get_datatables_tabs_lokasi($jenis, $id_cabang, $id_departemen, $id_jabatan, $lock_lokasi, $jenis_kelamin, $id_karyawan);
        $data = array();
        $no = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();

            $foto = $this->config->item('base_image') . 'imagebiodata?_t=photo&_d=' . $field->foto;
            $notif_pengajuan = $this->notif_status->per_karyawan(md5($field->id_karyawan));
            $row[] = $no;
            $row[] = '<a href="'.$foto.'" data-lightbox="mulai-'.$no.'"><img class="media-object avatar avatar-sm img-fit-cover" src="' . $foto . '" style="border-radius: 2;"></a>';
            $row[] = '<a href="' . site_url('master/karyawan/detail/' . md5($field->id_karyawan)) . '" class="media border-0" onclick="save_filter_session();">' . $field->nama_lengkap . $notif_pengajuan . '</a>' . $field->nik;
            $row[] = $field->nama_cabang . "<br><b>" . $field->kode_cabang."</b>";
            $row[] = $field->nama_departemen . "<br><b>" . $field->kode_departemen."</b>";
            $row[] = $field->nama_jabatan . "<br><b>" . $field->kode_jabatan."</b>";
            $row[] = $this->jenis_kelamin($field->jenis_kelamin);
            $row[] = ($field->lock_lokasi === "0") ? '<div class="badge badge-warning">' . $this->lang->line('tidak') . '</div>' : '<div class="badge badge-success">' . $this->lang->line('ya') . '</div>';

            if (in_array($this->level_user, array("1"))) {
                $row[] = '  <a href="' . site_url('master/karyawan/detail/' . md5($field->id_karyawan)) . '" title="Detail" class="text-primary" onclick="save_filter_session();">
                                <i class="btn_detail fa fa-info-circle (alias) "> </i>
                                </a>&nbsp;
                                <a href="#" title="Delete" class="text-danger">
									<i class="btn_delete fa fa-trash" id="' . md5($field->id_karyawan) . '"></i>
                                </a>';
            } else {
                $row[] = '  <a href="' . site_url('master/karyawan/detail/' . md5($field->id_karyawan)) . '" title="Detail" class="text-primary" onclick="save_filter_session();">
							<i class="btn_detail fa fa-info-circle (alias) "> </i>
							</a>&nbsp;';
            }

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->Karyawan_m->count_all_tabs_lokasi($jenis, $id_cabang, $id_departemen, $id_jabatan, $lock_lokasi, $jenis_kelamin, $id_karyawan),
            "recordsFiltered" => $this->Karyawan_m->count_filtered_tabs_lokasi($jenis, $id_cabang, $id_departemen, $id_jabatan, $lock_lokasi, $jenis_kelamin, $id_karyawan),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function data_tabs_device($jenis = null, $id_cabang = "-", $id_departemen = "-", $id_jabatan = "-", $lock_device = "-", $jenis_kelamin, $id_karyawan = "-")
    {
        $list = $this->Karyawan_m->get_datatables_tabs_device($jenis, $id_cabang, $id_departemen, $id_jabatan, $lock_device, $jenis_kelamin, $id_karyawan);
        $data = array();
        $no   = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();

            $foto = $this->config->item('base_image') . 'imagebiodata?_t=photo&_d=' . $field->foto;
            $notif_pengajuan = $this->notif_status->per_karyawan(md5($field->id_karyawan));
            $row[] = $no;
            $row[] = '<a href="'.$foto.'" data-lightbox="mulai-'.$no.'"><img class="media-object avatar avatar-sm img-fit-cover" src="' . $foto . '" style="border-radius: 2;"></a>';
            $row[] = '<a href="' . site_url('master/karyawan/detail/' . md5($field->id_karyawan)) . '" class="media border-0" onclick="save_filter_session();">' . $field->nama_lengkap . $notif_pengajuan . '</a>' . $field->nik;
            $row[] = $field->nama_cabang . "<br><b>" . $field->kode_cabang."</b>";
            $row[] = $field->nama_departemen . "<br><b>" . $field->kode_departemen."</b>";
            $row[] = $field->nama_jabatan . "<br><b>" . $field->kode_jabatan."</b>";
            $row[] = $this->jenis_kelamin($field->jenis_kelamin);
            $row[] = ($field->lock_device === "0") ? '<div class="badge badge-warning">' . $this->lang->line('tidak') . '</div>' : '<div class="badge badge-success">' . $this->lang->line('ya') . '</div>';

            if (in_array($this->level_user, array("1"))) {
                $row[] = '  <a href="' . site_url('master/karyawan/detail/' . md5($field->id_karyawan)) . '" title="Detail" class="text-primary" onclick="save_filter_session();">
                                <i class="btn_detail fa fa-info-circle (alias) "> </i>
                                </a>&nbsp;
                                <a href="#" title="Delete" class="text-danger">
									<i class="btn_delete fa fa-trash" id="' . md5($field->id_karyawan) . '"></i>
                                </a>';
            } else {
                $row[] = '  <a href="' . site_url('master/karyawan/detail/' . md5($field->id_karyawan)) . '" title="Detail" class="text-primary" onclick="save_filter_session();">
							<i class="btn_detail fa fa-info-circle (alias) "> </i>
							</a>&nbsp;';
            }

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->Karyawan_m->count_all_tabs_device($jenis, $id_cabang, $id_departemen, $id_jabatan, $lock_device, $jenis_kelamin, $id_karyawan),
            "recordsFiltered" => $this->Karyawan_m->count_filtered_tabs_device($jenis, $id_cabang, $id_departemen, $id_jabatan, $lock_device, $jenis_kelamin, $id_karyawan),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function data_tabs_facerecognition($jenis = null, $id_cabang = "-", $id_departemen = "-", $id_jabatan = "-", $lock_facerecognition = "-", $jenis_kelamin, $id_karyawan = "-")
    {
        $list = $this->Karyawan_m->get_datatables_tabs_facerecognition($jenis, $id_cabang, $id_departemen, $id_jabatan, $lock_facerecognition, $jenis_kelamin, $id_karyawan);
        $data = array();
        $no   = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();

            $foto = $this->config->item('base_image') . 'imagebiodata?_t=photo&_d=' . $field->foto;
            $notif_pengajuan = $this->notif_status->per_karyawan(md5($field->id_karyawan));
            $row[] = $no;
            $row[] = '<a href="'.$foto.'" data-lightbox="mulai-'.$no.'"><img class="media-object avatar avatar-sm img-fit-cover" src="' . $foto . '" style="border-radius: 2;"></a>';
            $row[] = '<a href="' . site_url('master/karyawan/detail/' . md5($field->id_karyawan)) . '" class="media border-0" onclick="save_filter_session();">' . $field->nama_lengkap . $notif_pengajuan . '</a>' . $field->nik;
            $row[] = $field->nama_cabang . "<br><b>" . $field->kode_cabang."</b>";
            $row[] = $field->nama_departemen . "<br><b>" . $field->kode_departemen."</b>";
            $row[] = $field->nama_jabatan . "<br><b>" . $field->kode_jabatan."</b>";
            $row[] = $this->jenis_kelamin($field->jenis_kelamin);
            $row[] = ($field->lock_facerecognition === "0") ? '<div class="badge badge-warning">' . $this->lang->line('tidak') . '</div>' : '<div class="badge badge-success">' . $this->lang->line('ya') . '</div>';

            if (in_array($this->level_user, array("1"))) {
                $row[] = '  <a href="' . site_url('master/karyawan/detail/' . md5($field->id_karyawan)) . '" title="Detail" class="text-primary" onclick="save_filter_session();">
                                <i class="btn_detail fa fa-info-circle (alias) "> </i>
                                </a>&nbsp;
                                <a href="#" title="Delete" class="text-danger">
									<i class="btn_delete fa fa-trash" id="' . md5($field->id_karyawan) . '"></i>
                                </a>';
            } else {
                $row[] = '  <a href="' . site_url('master/karyawan/detail/' . md5($field->id_karyawan)) . '" title="Detail" class="text-primary" onclick="save_filter_session();">
							<i class="btn_detail fa fa-info-circle (alias) "> </i>
							</a>&nbsp;';
            }

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->Karyawan_m->count_all_tabs_facerecognition($jenis, $id_cabang, $id_departemen, $id_jabatan, $lock_facerecognition, $jenis_kelamin, $id_karyawan),
            "recordsFiltered" => $this->Karyawan_m->count_filtered_tabs_facerecognition($jenis, $id_cabang, $id_departemen, $id_jabatan, $lock_facerecognition, $jenis_kelamin, $id_karyawan),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function data_tabs_camera($jenis = null, $id_cabang = "-", $id_departemen = "-", $id_jabatan = "-", $camera = "-", $jenis_kelamin, $id_karyawan = "-")
    {
        $list = $this->Karyawan_m->get_datatables_tabs_camera($jenis, $id_cabang, $id_departemen, $id_jabatan, $camera, $jenis_kelamin, $id_karyawan);
        $data = array();
        $no   = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();

            $foto = $this->config->item('base_image') . 'imagebiodata?_t=photo&_d=' . $field->foto;
            $notif_pengajuan = $this->notif_status->per_karyawan(md5($field->id_karyawan));
            $row[] = $no;
            $row[] = '<a href="'.$foto.'" data-lightbox="mulai-'.$no.'"><img class="media-object avatar avatar-sm img-fit-cover" src="' . $foto . '" style="border-radius: 2;"></a>';
            $row[] = '<a href="' . site_url('master/karyawan/detail/' . md5($field->id_karyawan)) . '" class="media border-0" onclick="save_filter_session();">' . $field->nama_lengkap . $notif_pengajuan . '</a>' . $field->nik;
            $row[] = $field->nama_cabang . "<br><b>" . $field->kode_cabang."</b>";
            $row[] = $field->nama_departemen . "<br><b>" . $field->kode_departemen."</b>";
            $row[] = $field->nama_jabatan . "<br><b>" . $field->kode_jabatan."</b>";
            $row[] = $this->jenis_kelamin($field->jenis_kelamin);
            $row[] = (in_array($field->kamera, ['1', '2'])) ? '<div class="badge badge-primary">Absenku</div>' : '<div class="badge badge-warning">HP</div>';

            if (in_array($this->level_user, array("1"))) {
                $row[] = '  <a href="' . site_url('master/karyawan/detail/' . md5($field->id_karyawan)) . '" title="Detail" class="text-primary" onclick="save_filter_session();">
                                <i class="btn_detail fa fa-info-circle (alias) "> </i>
                                </a>&nbsp;
                                <a href="#" title="Delete" class="text-danger">
									<i class="btn_delete fa fa-trash" id="' . md5($field->id_karyawan) . '"></i>
                                </a>';
            } else {
                $row[] = '  <a href="' . site_url('master/karyawan/detail/' . md5($field->id_karyawan)) . '" title="Detail" class="text-primary" onclick="save_filter_session();">
							<i class="btn_detail fa fa-info-circle (alias) "> </i>
							</a>&nbsp;';
            }

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->Karyawan_m->count_all_tabs_camera($jenis, $id_cabang, $id_departemen, $id_jabatan, $camera, $jenis_kelamin, $id_karyawan),
            "recordsFiltered" => $this->Karyawan_m->count_filtered_tabs_camera($jenis, $id_cabang, $id_departemen, $id_jabatan, $camera, $jenis_kelamin, $id_karyawan),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function export_pdf($karyawan = '')
    {
        $data['data_diri']          = $this->db->select('*')->from('data_karyawan')->where('md5(id_karyawan)', $karyawan)->get()->row();
        $data['riwayat_pendidikan'] = $this->db->select('*')->from('riwayat_pendidikan')->where('md5(id_karyawan)', $karyawan)->order_by('tahun_lulus', 'DESC')->get()->result();
        $data['riwayat_pekerjaan']  = $this->db->select('*')->from('riwayat_pekerjaan')->where('md5(id_karyawan)', $karyawan)->order_by('tgl_keluar', 'DESC')->get()->result();
        $data['karir_pekerjaan']    = $this->db->select('*')->from('karir_pekerjaan')->where('md5(id_karyawan)', $karyawan)->order_by('tgl_mulai', 'DESC')->get()->result();
        $data['data_sertifikat']    = $this->db->select('*')->from('data_sertifikat')->where('md5(id_karyawan)', $karyawan)->order_by('tgl_berakhir', 'DESC')->get()->result();
        $data['data_keluarga']      = $this->db->query("SELECT * FROM data_keluarga WHERE id_karyawan = '$karyawan' ORDER BY (
                                                    CASE hub_keluarga

                                                    WHEN 'Ayah'
                                                    THEN 1

                                                    WHEN 'Ibu'
                                                    THEN 2

                                                    WHEN 'Suami'
                                                    THEN 3

                                                    WHEN 'Istri'
                                                    THEN 4

                                                    WHEN 'Anak'
                                                    THEN 5

                                                    WHEN 'Saudara Kandung'
                                                    THEN 6

                                                    END
							) ASC")->result();

        $this->logger->create_log('export_karyawan', 'export', $this->db->last_query());
        $html = $this->load->view('karyawan/cetak_karyawan', $data, true);
        $html = preg_replace('/>\s+</', '><', $html); //bug dompdf
        $this->load->add_package_path(APPPATH . 'third_party/dompdf/');
        require_once(APPPATH . "third_party/dompdf/dompdf_config.inc.php");
        $name = "Data_karyawan.pdf";
        $dompdf = new DOMPDF();
        $dompdf->set_paper('A4', 'potrait');
        $dompdf->load_html($html);
        $dompdf->render();
        $dompdf->stream($name, array("Attachment" => false));
        echo $html;
    }

    public function view_pdf($karyawan = '')
    {
        $data['data_diri']          = $this->db->select('*')->from('data_karyawan')->where('md5(id_karyawan)', $karyawan)->get()->row();
        $data['riwayat_pendidikan'] = $this->db->select('*')->from('riwayat_pendidikan')->where('md5(id_karyawan)', $karyawan)->order_by('tahun_keluar', 'DESC')->get()->result();
        $data['riwayat_pekerjaan']  = $this->db->select('*')->from('riwayat_pekerjaan')->where('md5(id_karyawan)', $karyawan)->order_by('tgl_keluar', 'DESC')->get()->result();
        $data['karir_pekerjaan']    = $this->db->select('*')->from('karir_pekerjaan')->where('md5(id_karyawan)', $karyawan)->order_by('tgl_mulai', 'DESC')->get()->result();
        $data['data_sertifikat']    = $this->db->select('*')->from('data_sertifikat')->where('md5(id_karyawan)', $karyawan)->order_by('tgl_berakhir', 'DESC')->get()->result();
        $data['data_keluarga']      = $this->db->query("SELECT * FROM data_keluarga WHERE md5(id_karyawan) = '$karyawan' ORDER BY (
												CASE hub_keluarga

												WHEN 'Ayah'
												THEN 1

												WHEN 'Ibu'
												THEN 2

												WHEN 'Suami'
												THEN 3

												WHEN 'Istri'
												THEN 4

												WHEN 'Anak'
												THEN 5

												WHEN 'Saudara Kandung'
												THEN 6

												END
							) ASC")->result();
        $this->load->view('karyawan/cetak_karyawan', $data, false);
    }

    public function delete()
    {
        $id_karyawan = $this->fungsi->decrypt_idkaryawan($this->input->post('id_karyawan'));

        $cek_jabatan = $this->db->query("SELECT id_jabatan FROM data_karyawan WHERE id_company = '" . $this->id_company . "' AND id_karyawan = '" . $id_karyawan . "'")->row()->id_jabatan;

        $cek_level_user = $this->db->query("SELECT level_user FROM master_jabatan WHERE id_company = '" . $this->id_company . "' AND id_jabatan = '" . $cek_jabatan . "' ")->row()->level_user;

        if ($cek_level_user == 1 && $id_karyawan == $this->id_karyawan) {
            $message = '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $this->lang->line('error_hapus_karyawan') . '</font>';
            return __response_save(false, array('message' => $message));
        } else {
            $this->Karyawan_m->delete($id_karyawan);
        }
    }

    public function download($jenis = 0, $id_cabang = 0, $id_departemen = 0, $id_jabatan = 0, $status = 0, $jenis_kelamin, $id_karyawan = 0)
    {
        if ($id_karyawan != "0") {
            $nama = $this->_nama_karyawan($id_karyawan);
            $filename = strtoupper($this->lang->line('karyawan') . '_' . $nama);
        } else {
            if ($id_cabang == "0") {
                $filename = strtoupper($this->lang->line('karyawan') . '_' . str_replace(' ', '_', $this->lang->line('semua_cabang')));
            } else {
                if ($id_departemen != "0") {
                    $nama_cab = $this->_nama_cabang($id_cabang);
                    $nama_dep = $this->_nama_departemen($id_departemen);
                    $nama     = '_' . strtoupper($this->lang->line('cabang')) . '_' . $nama_cab . '_' . strtoupper($this->lang->line('departemen')) . '_' . $nama_dep;
                    $filename = strtoupper($this->lang->line('karyawan') . '_' . $nama);
                } else {
                    $nama_cab = $this->_nama_cabang($id_cabang);
                    $filename = strtoupper($this->lang->line('karyawan') . '_' . strtoupper($this->lang->line('cabang')) . '_' . $nama_cab . '_' . str_replace(' ', '_', $this->lang->line('semua_departemen')));
                }
            }
        }

        $data['nama']  = $nama;
        $data['jenis'] = $jenis;
        $data['title'] = str_replace('_', ' ', $filename);

        $data['data'] = $this->Karyawan_m->get_datatables_tabs_jabatan($jenis, $id_cabang, $id_departemen, $id_jabatan, $status, $jenis_kelamin, $id_karyawan, $order_by = "custom");

        $output = true;

        $data['is_excel'] = true;
        $sb_view = $this->load->view('karyawan/download/status', $data, $output);

        $param = [
            'download'     => true,
            'cLength'      => 20,
            'file_name'    => strtoupper($filename),
            'paper_size'   => 'LEGAL',
            'font-size'    => 9,
            'pagebreak'    => true,
            'page_margin'  => ['top' => 0, 'right' => 0.75, 'left' => 0.75, 'botom' => 0],
            'orientation'  => 'landscape',
            'freezecolumn' => ['D5'],
            'header'       => [
                '1' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '2' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '3' => ['merge' => true, 'align' => 'center', 'weight' => 'bold']
            ],
            'thead'        => ['4'],
            'tbody'        => [
                'start'  => '4',
                'height' => 13,
                'wrap'   => ['B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S'],
                'column' => [
                    'A'    => ['width' => 7, 'align' => 'center', 'valign' => 'middle'],
                    'B'    => ['width' => 25, 'align' => 'center', 'valign' => 'middle', 'format' => 'text', 'bentuk' => 'bentuk-text'],
                    'C'    => ['width' => 25, 'align' => 'left', 'valign' => 'middle'],
                    'D'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
                    'D'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
                    'E'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
                    'F'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
                    'G'    => ['width' => 16, 'align' => 'center', 'valign' => 'top'],
                    'H'    => ['width' => 15, 'align' => 'center', 'valign' => 'top'],
                    'I'    => ['width' => 15, 'align' => 'center', 'valign' => 'top'],
                    'J'    => ['width' => 18, 'align' => 'center', 'valign' => 'top'],
                    'K'    => ['width' => 20, 'align' => 'center', 'valign' => 'top'],
                    'L'    => ['width' => 18, 'align' => 'center', 'valign' => 'top'],
                    'M'    => ['width' => 18, 'align' => 'center', 'valign' => 'top'],
                    'N'    => ['width' => 12, 'align' => 'center', 'valign' => 'top'],
                    'O'    => ['width' => 10, 'align' => 'center', 'valign' => 'top'],
                    'P'    => ['width' => 15, 'align' => 'left', 'valign' => 'top'],
                    'Q'    => ['width' => 15, 'align' => 'center', 'valign' => 'top'],
                    'R'    => ['width' => 50, 'align' => 'left', 'valign' => 'top'],
                    'S'    => ['width' => 13, 'align' => 'center', 'valign' => 'top', 'format' => 'text'],
                    'T'    => ['width' => 30, 'align' => 'left', 'valign' => 'top'],
                    'U'    => ['width' => 30, 'align' => 'center', 'valign' => 'top', 'format' => 'text'],
                ],
            ],
        ];

        if ($output) {
            $this->load->library('PHPExcel/Excel');
            $this->excel->generateExcel($sb_view, $param);
        }
    }

    public function download_pengguna_aktif($jenis = 0,$id_cabang = 0, $id_departemen = 0, $id_jabatan = 0, $jenis_kelamin, $id_karyawan = 0)
    {
        if ($id_karyawan != "0") {
            $nama = $this->_nama_karyawan($id_karyawan);
            $filename = strtoupper($this->lang->line('karyawan') . '_'. $this->lang->line('pengguna_aktif') . '_' . $nama);
        } else {
            if ($id_cabang == "0") {
                $filename = strtoupper($this->lang->line('karyawan') . '_'. $this->lang->line('pengguna_aktif') . '_' . str_replace(' ', '_', $this->lang->line('semua_cabang')));
            } else {
                if ($id_departemen != "0") {
                    $nama_cab = $this->_nama_cabang($id_cabang);
                    $nama_dep = $this->_nama_departemen($id_departemen);
                    $nama     = '_' . strtoupper($this->lang->line('cabang')) . '_' . $nama_cab . '_' . strtoupper($this->lang->line('departemen')) . '_' . $nama_dep;
                    $filename = strtoupper($this->lang->line('karyawan') . '_'. $this->lang->line('pengguna_aktif') . '_' . $nama);
                } else {
                    $nama_cab = $this->_nama_cabang($id_cabang);
                    $filename = strtoupper($this->lang->line('karyawan') . '_'. $this->lang->line('pengguna_aktif') . '_' . strtoupper($this->lang->line('cabang')) . '_' . $nama_cab . '_' . str_replace(' ', '_', $this->lang->line('semua_departemen')));
                }
            }
        }

        $data['nama']  = $nama;;
        $data['title'] = str_replace('_', ' ', $filename);

        $data['data'] = $this->Karyawan_m->get_datatables_tabs_pengguna_aktif($jenis, $id_cabang, $id_departemen, $id_jabatan,  $jenis_kelamin, $id_karyawan, $order_by = "custom");

        $output = true;

        $data['is_excel'] = true;
        $sb_view = $this->load->view('karyawan/download/pengguna_aktif', $data, $output);

        $param = [
            'download'     => true,
            'cLength'      => 7,
            'file_name'    => strtoupper($filename),
            'paper_size'   => 'LEGAL',
            'font-size'    => 9,
            'pagebreak'    => true,
            'page_margin'  => ['top' => 0, 'right' => 0.75, 'left' => 0.75, 'botom' => 0],
            'orientation'  => 'landscape',
            'freezecolumn' => ['D5'],
            'header'       => [
                '1' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '2' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '3' => ['merge' => true, 'align' => 'center', 'weight' => 'bold']
            ],
            'thead'        => ['4'],
            'tbody'        => [
                'start'  => '4',
                'height' => 13,
                'wrap'   => ['B', 'C', 'D', 'E', 'F', 'G','H'],
                'column' => [
                    'A'    => ['width' => 7, 'align' => 'center', 'valign' => 'middle'],
                    'B'    => ['width' => 25, 'align' => 'center', 'valign' => 'middle', 'format' => 'text', 'bentuk' => 'bentuk-text'],
                    'C'    => ['width' => 25, 'align' => 'left', 'valign' => 'middle'],
                    'D'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
                    'D'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
                    'E'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
                    'F'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
                    'G'    => ['width' => 15, 'align' => 'center', 'valign' => 'top'],
                    'H'    => ['width' => 10, 'align' => 'center', 'valign' => 'top'],
                ],
            ],
        ];

        if ($output) {
            $this->load->library('PHPExcel/Excel');
            $this->excel->generateExcel($sb_view, $param);
        }
    }

    public function download_tab_pendidikan($jenis = 0,$id_cabang = 0, $id_departemen = 0, $id_jabatan = 0, $pendidikan = 0, $jenis_kelamin, $id_karyawan = 0)
    {
        if ($id_karyawan != "0") {
            $nama = $this->_nama_karyawan($id_karyawan);
            $filename = strtoupper($this->lang->line('karyawan') . '_'. $this->lang->line('pendidikan') . '_' . $nama);
        } else {
            if ($id_cabang == "0") {
                $filename = strtoupper($this->lang->line('karyawan') . '_'. $this->lang->line('pendidikan') . '_' . str_replace(' ', '_', $this->lang->line('semua_cabang')));
            } else {
                if ($id_departemen != "0") {
                    $nama_cab = $this->_nama_cabang($id_cabang);
                    $nama_dep = $this->_nama_departemen($id_departemen);
                    $nama     = '_' . strtoupper($this->lang->line('cabang')) . '_' . $nama_cab . '_' . strtoupper($this->lang->line('departemen')) . '_' . $nama_dep;
                    $filename = strtoupper($this->lang->line('karyawan') . '_'. $this->lang->line('pendidikan') . '_' . $nama);
                } else {
                    $nama_cab = $this->_nama_cabang($id_cabang);
                    $filename = strtoupper($this->lang->line('karyawan') . '_'. $this->lang->line('pendidikan') . '_' . strtoupper($this->lang->line('cabang')) . '_' . $nama_cab . '_' . str_replace(' ', '_', $this->lang->line('semua_departemen')));
                }
            }
        }

        $data['nama']  = $nama;;
        $data['title'] = str_replace('_', ' ', $filename);

        $data['data'] = $this->Karyawan_m->get_datatables_tabs_pendidikan($jenis, $id_cabang, $id_departemen, $id_jabatan, $pendidikan, $jenis_kelamin, $id_karyawan, $order_by = "custom");

        $output = true;

        $data['is_excel'] = true;
        $sb_view = $this->load->view('karyawan/download/pendidikan', $data, $output);

        $param = [
            'download'     => true,
            'cLength'      => 7,
            'file_name'    => strtoupper($filename),
            'paper_size'   => 'LEGAL',
            'font-size'    => 9,
            'pagebreak'    => true,
            'page_margin'  => ['top' => 0, 'right' => 0.75, 'left' => 0.75, 'botom' => 0],
            'orientation'  => 'landscape',
            'freezecolumn' => ['D5'],
            'header'       => [
                '1' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '2' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '3' => ['merge' => true, 'align' => 'center', 'weight' => 'bold']
            ],
            'thead'        => ['4'],
            'tbody'        => [
                'start'  => '4',
                'height' => 13,
                'wrap'   => ['B', 'C', 'D', 'E', 'F', 'G','H'],
                'column' => [
                    'A'    => ['width' => 7, 'align' => 'center', 'valign' => 'middle'],
                    'B'    => ['width' => 25, 'align' => 'center', 'valign' => 'middle', 'format' => 'text', 'bentuk' => 'bentuk-text'],
                    'C'    => ['width' => 25, 'align' => 'left', 'valign' => 'middle'],
                    'D'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
                    'D'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
                    'E'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
                    'F'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
                    'G'    => ['width' => 15, 'align' => 'center', 'valign' => 'top'],
                    'H'    => ['width' => 17, 'align' => 'center', 'valign' => 'top'],
                ],
            ],
        ];

        if ($output) {
            $this->load->library('PHPExcel/Excel');
            $this->excel->generateExcel($sb_view, $param);
        }
    }

    public function download_tab_lokasi($jenis = 0,$id_cabang = "-", $id_departemen = "-", $id_jabatan = "-", $lokasi = "-", $jenis_kelamin, $id_karyawan = 0)
    {
        if ($id_karyawan != "0") {
            $nama = $this->_nama_karyawan($id_karyawan);
            $filename = strtoupper($this->lang->line('karyawan') . '_'. $this->lang->line('lock_lokasi_absensi') . '_' . $nama);
        } else {
            if ($id_cabang == "-") {
                $filename = strtoupper($this->lang->line('karyawan') . '_'. $this->lang->line('lock_lokasi_absensi') . '_' . str_replace(' ', '_', $this->lang->line('semua_cabang')));
            } else {
                if ($id_departemen != "-") {
                    $nama_cab = $this->_nama_cabang($id_cabang);
                    $nama_dep = $this->_nama_departemen($id_departemen);
                    $nama     = '_' . strtoupper($this->lang->line('cabang')) . '_' . $nama_cab . '_' . strtoupper($this->lang->line('departemen')) . '_' . $nama_dep;
                    $filename = strtoupper($this->lang->line('karyawan') . '_'. $this->lang->line('lock_lokasi_absensi') . '_' . $nama);
                } else {
                    $nama_cab = $this->_nama_cabang($id_cabang);
                    $filename = strtoupper($this->lang->line('karyawan') . '_'. $this->lang->line('lock_lokasi_absensi') . '_' . strtoupper($this->lang->line('cabang')) . '_' . $nama_cab . '_' . str_replace(' ', '_', $this->lang->line('semua_departemen')));
                }
            }
        }

        $data['nama']  = $nama;;
        $data['title'] = str_replace('_', ' ', $filename);

        $data['data'] = $this->Karyawan_m->get_datatables_tabs_lokasi($jenis, $id_cabang, $id_departemen, $id_jabatan, $lokasi, $jenis_kelamin, $id_karyawan, $order_by = "custom");

        $output = true;

        $data['is_excel'] = true;
        $sb_view = $this->load->view('karyawan/download/lock_lokasi', $data, $output);

        $param = [
            'download'     => true,
            'cLength'      => 7,
            'file_name'    => strtoupper($filename),
            'paper_size'   => 'LEGAL',
            'font-size'    => 9,
            'pagebreak'    => true,
            'page_margin'  => ['top' => 0, 'right' => 0.75, 'left' => 0.75, 'botom' => 0],
            'orientation'  => 'landscape',
            'freezecolumn' => ['D5'],
            'header'       => [
                '1' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '2' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '3' => ['merge' => true, 'align' => 'center', 'weight' => 'bold']
            ],
            'thead'        => ['4'],
            'tbody'        => [
                'start'  => '4',
                'height' => 13,
                'wrap'   => ['B', 'C', 'D', 'E', 'F', 'G','H'],
                'column' => [
                    'A'    => ['width' => 7, 'align' => 'center', 'valign' => 'middle'],
                    'B'    => ['width' => 25, 'align' => 'center', 'valign' => 'middle', 'format' => 'text', 'bentuk' => 'bentuk-text'],
                    'C'    => ['width' => 25, 'align' => 'left', 'valign' => 'middle'],
                    'D'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
                    'D'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
                    'E'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
                    'F'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
                    'G'    => ['width' => 15, 'align' => 'center', 'valign' => 'top'],
                    'H'    => ['width' => 17, 'align' => 'center', 'valign' => 'top'],
                ],
            ],
        ];

        if ($output) {
            $this->load->library('PHPExcel/Excel');
            $this->excel->generateExcel($sb_view, $param);
        }
    }

    public function download_tab_device($jenis = 0,$id_cabang = "-", $id_departemen = "-", $id_jabatan = "-", $lock_device = "-", $jenis_kelamin, $id_karyawan = 0)
    {
        if ($id_karyawan != "0") {
            $nama = $this->_nama_karyawan($id_karyawan);
            $filename = strtoupper($this->lang->line('karyawan') . '_'. $this->lang->line('lock_device') . '_' . $nama);
        } else {
            if ($id_cabang == "-") {
                $filename = strtoupper($this->lang->line('karyawan') . '_'. $this->lang->line('lock_device') . '_' . str_replace(' ', '_', $this->lang->line('semua_cabang')));
            } else {
                if ($id_departemen != "-") {
                    $nama_cab = $this->_nama_cabang($id_cabang);
                    $nama_dep = $this->_nama_departemen($id_departemen);
                    $nama     = '_' . strtoupper($this->lang->line('cabang')) . '_' . $nama_cab . '_' . strtoupper($this->lang->line('departemen')) . '_' . $nama_dep;
                    $filename = strtoupper($this->lang->line('karyawan') . '_'. $this->lang->line('lock_device') . '_' . $nama);
                } else {
                    $nama_cab = $this->_nama_cabang($id_cabang);
                    $filename = strtoupper($this->lang->line('karyawan') . '_'. $this->lang->line('lock_device') . '_' . strtoupper($this->lang->line('cabang')) . '_' . $nama_cab . '_' . str_replace(' ', '_', $this->lang->line('semua_departemen')));
                }
            }
        }

        $data['nama']  = $nama;;
        $data['title'] = str_replace('_', ' ', $filename);

        $data['data'] = $this->Karyawan_m->get_datatables_tabs_device($jenis, $id_cabang, $id_departemen, $id_jabatan, $lock_device, $jenis_kelamin, $id_karyawan, $order_by = "custom");

        $output = true;

        $data['is_excel'] = true;
        $sb_view = $this->load->view('karyawan/download/lock_device', $data, $output);
        
        $param = [
            'download'     => true,
            'cLength'      => 7,
            'file_name'    => strtoupper($filename),
            'paper_size'   => 'LEGAL',
            'font-size'    => 9,
            'pagebreak'    => true,
            'page_margin'  => ['top' => 0, 'right' => 0.75, 'left' => 0.75, 'botom' => 0],
            'orientation'  => 'landscape',
            'freezecolumn' => ['D5'],
            'header'       => [
                '1' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '2' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '3' => ['merge' => true, 'align' => 'center', 'weight' => 'bold']
            ],
            'thead'        => ['4'],
            'tbody'        => [
                'start'  => '4',
                'height' => 13,
                'wrap'   => ['B', 'C', 'D', 'E', 'F', 'G','H'],
                'column' => [
                    'A'    => ['width' => 7, 'align' => 'center', 'valign' => 'middle'],
                    'B'    => ['width' => 25, 'align' => 'center', 'valign' => 'middle', 'format' => 'text', 'bentuk' => 'bentuk-text'],
                    'C'    => ['width' => 25, 'align' => 'left', 'valign' => 'middle'],
                    'D'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
                    'D'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
                    'E'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
                    'F'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
                    'G'    => ['width' => 15, 'align' => 'center', 'valign' => 'top'],
                    'H'    => ['width' => 17, 'align' => 'center', 'valign' => 'top'],
                ],
            ],
        ];

        if ($output) {
            $this->load->library('PHPExcel/Excel');
            $this->excel->generateExcel($sb_view, $param);
        }
    }

    public function download_tab_facerecognition($jenis = 0,$id_cabang = "-", $id_departemen = "-", $id_jabatan = "-", $lock_facerecognition = "-", $jenis_kelamin, $id_karyawan = 0)
    {
        if ($id_karyawan != "0") {
            $nama = $this->_nama_karyawan($id_karyawan);
            $filename = strtoupper($this->lang->line('karyawan') . '_'. $this->lang->line('lock_face_recognition') . '_' . $nama);
        } else {
            if ($id_cabang == "-") {
                $filename = strtoupper($this->lang->line('karyawan') . '_'. $this->lang->line('lock_face_recognition') . '_' . str_replace(' ', '_', $this->lang->line('semua_cabang')));
            } else {
                if ($id_departemen != "-") {
                    $nama_cab = $this->_nama_cabang($id_cabang);
                    $nama_dep = $this->_nama_departemen($id_departemen);
                    $nama     = '_' . strtoupper($this->lang->line('cabang')) . '_' . $nama_cab . '_' . strtoupper($this->lang->line('departemen')) . '_' . $nama_dep;
                    $filename = strtoupper($this->lang->line('karyawan') . '_'. $this->lang->line('lock_face_recognition') . '_' . $nama);
                } else {
                    $nama_cab = $this->_nama_cabang($id_cabang);
                    $filename = strtoupper($this->lang->line('karyawan') . '_'. $this->lang->line('lock_face_recognition') . '_' . strtoupper($this->lang->line('cabang')) . '_' . $nama_cab . '_' . str_replace(' ', '_', $this->lang->line('semua_departemen')));
                }
            }
        }

        $data['nama']  = $nama;;
        $data['title'] = str_replace('_', ' ', $filename);

        $data['data'] = $this->Karyawan_m->get_datatables_tabs_facerecognition($jenis, $id_cabang, $id_departemen, $id_jabatan, $lock_facerecognition, $jenis_kelamin, $id_karyawan, $order_by = "custom");

        $output = true;

        $data['is_excel'] = true;
        $sb_view = $this->load->view('karyawan/download/lock_facerecognition', $data, $output);
        
        $param = [
            'download'     => true,
            'cLength'      => 7,
            'file_name'    => strtoupper($filename),
            'paper_size'   => 'LEGAL',
            'font-size'    => 9,
            'pagebreak'    => true,
            'page_margin'  => ['top' => 0, 'right' => 0.75, 'left' => 0.75, 'botom' => 0],
            'orientation'  => 'landscape',
            'freezecolumn' => ['D5'],
            'header'       => [
                '1' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '2' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '3' => ['merge' => true, 'align' => 'center', 'weight' => 'bold']
            ],
            'thead'        => ['4'],
            'tbody'        => [
                'start'  => '4',
                'height' => 13,
                'wrap'   => ['B', 'C', 'D', 'E', 'F', 'G','H'],
                'column' => [
                    'A'    => ['width' => 7, 'align' => 'center', 'valign' => 'middle'],
                    'B'    => ['width' => 25, 'align' => 'center', 'valign' => 'middle', 'format' => 'text', 'bentuk' => 'bentuk-text'],
                    'C'    => ['width' => 25, 'align' => 'left', 'valign' => 'middle'],
                    'D'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
                    'D'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
                    'E'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
                    'F'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
                    'G'    => ['width' => 15, 'align' => 'center', 'valign' => 'top'],
                    'H'    => ['width' => 20, 'align' => 'center', 'valign' => 'top'],
                ],
            ],
        ];

        if ($output) {
            $this->load->library('PHPExcel/Excel');
            $this->excel->generateExcel($sb_view, $param);
        }
    }

    public function download_tab_camera($jenis = 0,$id_cabang = "-", $id_departemen = "-", $id_jabatan = "-", $lock_facerecognition = "-", $jenis_kelamin, $id_karyawan = 0)
    {
        if ($id_karyawan != "0") {
            $nama = $this->_nama_karyawan($id_karyawan);
            $filename = strtoupper($this->lang->line('karyawan') . '_'. $this->lang->line('default_kamera') . '_' . $nama);
        } else {
            if ($id_cabang == "-") {
                $filename = strtoupper($this->lang->line('karyawan') . '_'. $this->lang->line('default_kamera') . '_' . str_replace(' ', '_', $this->lang->line('semua_cabang')));
            } else {
                if ($id_departemen != "-") {
                    $nama_cab = $this->_nama_cabang($id_cabang);
                    $nama_dep = $this->_nama_departemen($id_departemen);
                    $nama     = '_' . strtoupper($this->lang->line('cabang')) . '_' . $nama_cab . '_' . strtoupper($this->lang->line('departemen')) . '_' . $nama_dep;
                    $filename = strtoupper($this->lang->line('karyawan') . '_'. $this->lang->line('default_kamera') . '_' . $nama);
                } else {
                    $nama_cab = $this->_nama_cabang($id_cabang);
                    $filename = strtoupper($this->lang->line('karyawan') . '_'. $this->lang->line('default_kamera') . '_' . strtoupper($this->lang->line('cabang')) . '_' . $nama_cab . '_' . str_replace(' ', '_', $this->lang->line('semua_departemen')));
                }
            }
        }

        $data['nama']  = $nama;;
        $data['title'] = str_replace('_', ' ', $filename);

        $data['data'] = $this->Karyawan_m->get_datatables_tabs_camera($jenis, $id_cabang, $id_departemen, $id_jabatan, $lock_facerecognition, $jenis_kelamin, $id_karyawan, $order_by = "custom");

        $output = true;

        $data['is_excel'] = true;
        $sb_view = $this->load->view('karyawan/download/lock_camera', $data, $output);
        
        $param = [
            'download'     => true,
            'cLength'      => 7,
            'file_name'    => strtoupper($filename),
            'paper_size'   => 'LEGAL',
            'font-size'    => 9,
            'pagebreak'    => true,
            'page_margin'  => ['top' => 0, 'right' => 0.75, 'left' => 0.75, 'botom' => 0],
            'orientation'  => 'landscape',
            'freezecolumn' => ['D5'],
            'header'       => [
                '1' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '2' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '3' => ['merge' => true, 'align' => 'center', 'weight' => 'bold']
            ],
            'thead'        => ['4'],
            'tbody'        => [
                'start'  => '4',
                'height' => 13,
                'wrap'   => ['B', 'C', 'D', 'E', 'F', 'G','H'],
                'column' => [
                    'A'    => ['width' => 7, 'align' => 'center', 'valign' => 'middle'],
                    'B'    => ['width' => 25, 'align' => 'center', 'valign' => 'middle', 'format' => 'text', 'bentuk' => 'bentuk-text'],
                    'C'    => ['width' => 25, 'align' => 'left', 'valign' => 'middle'],
                    'D'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
                    'D'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
                    'E'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
                    'F'    => ['width' => 20, 'align' => 'left', 'valign' => 'top'],
                    'G'    => ['width' => 15, 'align' => 'center', 'valign' => 'top'],
                    'H'    => ['width' => 10, 'align' => 'center', 'valign' => 'top'],
                ],
            ],
        ];

        if ($output) {
            $this->load->library('PHPExcel/Excel');
            $this->excel->generateExcel($sb_view, $param);
        }
    }

    private function _nama_karyawan($id_karyawan = null)
    {
        $this->db->select("nama_lengkap");
        $this->db->where("id_karyawan", $id_karyawan);
        $this->db->where("id_company", $this->id_company);
        $this->db->from("data_karyawan");
        $query = $this->db->get()->row();

        return $query->nama_lengkap;
    }

    private function _nama_cabang($id_cabang = null)
    {
        $this->db->select("nama");
        $this->db->where("id_cabang", $id_cabang);
        $this->db->where("id_company", $this->id_company);
        $this->db->from("master_cabang");
        $query = $this->db->get()->row();

        return $query->nama;
    }

    private function _nama_departemen($id_departemen = null)
    {
        $this->db->select("nama");
        $this->db->where("id_departemen", $id_departemen);
        $this->db->where("id_company", $this->id_company);
        $this->db->from("master_departemen");
        $query = $this->db->get()->row();

        return $query->nama;
    }
}
