<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>
<div id="form_input" class="card-body" disabled>
    <input type="hidden" name="id" id="id" value="<?= $id ?>">
    <div class="row form-group">
        <div class="col-md-12">
            <label class="font-weight-bold"><?= $this->lang->line('nama_karyawan'); ?></label><br>
            <label><?= $data->nik." - ".$data->nama_lengkap ?></label>
        </div>
    </div>
    <div class="row form-group">
        <div class="col-md-12">
            <label class="font-weight-bold"><?= $this->lang->line('tgl_pengajuan'); ?></label><br>
            <label><?= date_format(date_create($data->tgl_pengajuan),"d-m-Y") ?></label>
        </div>
    </div>
    <div class="row form-group">
        <div class="col-md-12">
            <label class="font-weight-bold"><?= $this->lang->line('periode'); ?></label><br>
            <label><?= date_format(date_create($data->tgl_mulai_izin),"d-m-Y")." ".$this->lang->line('s/d')." ".date_format(date_create($data->tgl_selesai_izin),"d-m-Y") ?></label>
        </div>
    </div>
    <div class="row form-group">
        <div class="col-md-12">
            <label class="font-weight-bold"><?= $this->lang->line('lama_izin_cuti_sakit'); ?></label><br>
            <label><?= $data->jml_izin ?> <?= $this->lang->line('hari'); ?></label>
        </div>
    </div>
    <?php
        if($data->flag == "1"){
    ?>
    <div class="row form-group">
        <div class="col-md-12">
            <label class="font-weight-bold"><?= $this->lang->line('sisa_cuti_tahunan_kary'); ?></label><br>
            <label><?= $data->sisa_cuti ?></label>
        </div>
    </div>
    <?php
        }
    ?>
    <div class="row form-group">
        <div class="col-md-12">
            <label class="font-weight-bold"><?= $this->lang->line('ket_izin_cuti_sakit'); ?></label><br>
            <label><?= $data->ket_izin ?></label>
        </div>
    </div>
    <div class="form-group">
        <div class="row">
            <div class="col-md-12">
                <label class="font-weight-bold form-label mb-2"><?= $this->lang->line('kary_sedang_melakukan_izin'); ?></label>
                <div class="table-responsive" style="width:100%; max-height: 250px; overflow-y: auto;">
                    <?php
                        $start = $data->tgl_mulai_izin;
                        $end = $data->tgl_selesai_izin;
                        $format = 'Y-m-d';
                        $array = array();
                        $interval = new DateInterval('P1D');
                        $realEnd = new DateTime($end);
                        $realEnd->add($interval);
                        $period = new DatePeriod(new DateTime($start), $interval, $realEnd);
                        foreach ($period as $date) {
                            $tanggal_real = $date->format("d-m-Y");
                            $tanggal = $date->format($format);
                    ?>
                    
                    <label class="font-weight-bold">Tanggal : <?= $tanggal_real ?></label>

                    <table class="table table-striped">
                        <thead>
                            <tr class="bg-tr">
                                <th class="text-left text-uppercase" valign="middle"><?= $this->lang->line('nama'); ?></th>
                                <th class="text-center text-uppercase" valign="middle">Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                                $arr_data = $this->fungsi->get_izin_kar($tanggal,$id,$level);
                                foreach ($arr_data['target_id'] as $index => $karyawan){ 
                            ?>
                            <tr>
                                <td class="text-left"><?= $karyawan ?></td>
                                <td class="text-center"><?= $arr_data['target_status'][$index] ?></td>
                            </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                    <?php
                        }
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <button class="btn btn-danger btn_tolak ladda-button" id="3" data-style="expand-left"><?= $this->lang->line('button_form_tolak'); ?></button>
            <button class="btn btn-success btn_setuju ladda-button" id="4" data-style="expand-left"><?= $this->lang->line('button_form_approve'); ?></button>
        </div>
    </div><!-- ./row -->
</div>

<script>
    $(document).ready(function() {
        // Basic
        $('.dropify').dropify();

        // Translated
        $('.dropify-fr').dropify({
            messages: {
                default: 'Glissez-déposez un fichier ici ou cliquez',
                replace: 'Glissez-déposez un fichier ou cliquez pour remplacer',
                remove: 'Supprimer',
                error: 'Désolé, le fichier trop volumineux'
            }
        });

        // Used events
        var drEvent = $('#input-file-events').dropify();

        drEvent.on('dropify.beforeClear', function(event, element) {
            return confirm("Do you really want to delete \"" + element.file.name + "\" ?");
        });

        drEvent.on('dropify.afterClear', function(event, element) {
            alert('File deleted');
        });

        drEvent.on('dropify.errors', function(event, element) {
            console.log('Has Errors');
        });

        var drDestroy = $('#input-file-to-destroy').dropify();
        drDestroy = drDestroy.data('dropify')
        $('#toggleDropify').on('click', function(e) {
            e.preventDefault();
            if (drDestroy.isDropified()) {
                drDestroy.destroy();
            } else {
                drDestroy.init();
            }
        })
    });
</script>
