<script type="text/javascript">
    $(document).ready(function() {
        $(".numberbox").keydown(function(e) {
            // Allow: backspace, delete, tab, escape, enter and
            if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 110]) !== -1 ||
                // Allow: Ctrl+A
                (e.keyCode == 65 && e.ctrlKey === true) ||
                // Allow: home, end, left, right, down, up
                (e.keyCode >= 35 && e.keyCode <= 40)) {
                // let it happen, don't do anything
                return;
            }
            // Ensure that it is a number and stop the keypress
            if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
                e.preventDefault();
                $("#jumlah_barang").focus();
                return false();
            }
        });
    });

    function resetCheckbox(e) {
        const name = e.name;
        if (e.checked == true) {
            if (name == 'file_1') {
                $('#file_0').prop('checked', false);
            } else {
                $('#file_1').prop('checked', false);
            }
        } else {
            if (name == 'file_1') {
                $('#file_1').prop('checked', true);
            } else {
                $('#file_0').prop('checked', true);
            }
        }
    }
</script>
<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>
<div id="form_input" class="card-body" disabled>
    <input type="hidden" id="id_jenis_izin" class="form-control" value="<?= ((isset($data)) ? md5($data->id_jenis_izin) : '') ?>">
    <div class="col-md-12">
        <div class="row">
            <div class="col-md-4">
                <div class="form-group">
                    <label><?= $this->lang->line('kode_jenis_izin') ?><i class="text-danger">*</i></label>
                    <input type="text" id="kd_jenis_izin" class="form-control" value="<?= ((isset($data)) ? $data->kode_izin : '') ?>" maxlength="5">
                    <input type="hidden" id="kd_jenis_izin_old" value="<?= ((isset($data)) ? $data->kode_izin : '') ?>">
                </div>
            </div>
            <div class="col-md-8">
                <div class="form-group">
                    <label><?= ucwords(strtolower($this->lang->line('jenis_izin'))) ?> <i class="text-danger">*</i></label>
                    <select id="jenis_izin" name="jenis_izin" class="form-control">
                        <option value=""><?= $this->lang->line('pilih_jenis_izin') ?></option>
                        <option value="sakit" <?= ((isset($data) and $data->jenis_izin == 'sakit') ? 'selected' : '') ?>><?= $this->lang->line('sakit') ?></option>
                        <option value="izin" <?= ((isset($data) and $data->jenis_izin == 'izin') ? 'selected' : '') ?>><?= $this->lang->line('izin') ?></option>
                        <option value="cuti" <?= ((isset($data) and $data->jenis_izin == 'cuti') ? 'selected' : '') ?>><?= $this->lang->line('cuti') ?></option>
                    </select>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-12">
        <div class="form-group">
            <label><?= $this->lang->line('nama_jenis_izin') ?> <i class="text-danger">*</i></label>
            <input type="text" id="nm_jenis_izin" class="form-control" value="<?= ((isset($data)) ? $data->nama : '') ?>">
        </div>
    </div>

    <div class="col-md-12">
        <div class="row">
            <div class="col-md-4">
                <div class="form-group">
                    <label><?= ucwords(strtolower($this->lang->line('max_izin'))) ?> (<?= ucwords(strtolower($this->lang->line('hari'))) ?>)</label>
                    <input type="text" id="max_izin" class="form-control numberbox" value="<?= ((isset($data)) ? $data->max_izin : '') ?>" max="">
                </div>
            </div>
            <div class="col-md-8">
                <div class="form-group">
                    <label><?= ucwords(strtolower($this->lang->line('kalender'))) ?></label>
                    <select id="flag_kalender" name="flag_kalender" class="form-control">
                        <option value="0" <?= ((isset($data) and $data->flag_kalender == '0') ? 'selected' : '') ?>><?= $this->lang->line('tidak') ?></option>
                        <option value="1" <?= ((isset($data) and $data->flag_kalender == '1') ? 'selected' : '') ?>><?= $this->lang->line('ya') ?></option>
                    </select>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-12">
        <div class="row">
            <div class="col-md-4">
                <div class="form-group">
                    <label><?= ucwords(strtolower($this->lang->line('back_date'))) ?> (<?= ucwords(strtolower($this->lang->line('hari'))) ?>)</label>
                    <input type="text" id="back_date" class="form-control numberbox" value="<?= ((isset($data)) ? $data->back_date : '') ?>">
                </div>
            </div>
            <div class="col-md-8">
                <div class="form-group">
                    <label><?= ucwords(strtolower($this->lang->line('mengurangi_cuti_tahunan'))) ?></label>
                    <select id="flag" name="flag" class="form-control">
                        <option value="0" <?= ((isset($data) and $data->flag == '0') ? 'selected' : '') ?>><?= $this->lang->line('tidak') ?></option>
                        <option value="1" <?= ((isset($data) and $data->flag == '1') ? 'selected' : '') ?>><?= $this->lang->line('ya') ?></option>
                    </select>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-12">
        <label>Upload File <i class="text-danger">*</i></label>
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <input type="checkbox" name="file_0" id="file_0" onclick="resetCheckbox(this)" <?= ((isset($data) and $data->flag_file == '0') ? 'checked' : '') ?>>
                    <label style="font-size:13px" for="file_0"><?= $this->lang->line('tidak_wajib') ?></label>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <input type="checkbox" name="file_1" id="file_1" onclick="resetCheckbox(this)" <?= ((isset($data) and $data->flag_file == '1') ? 'checked' : '') ?>>
                    <label style="font-size:13px" for="file_1"><?= $this->lang->line('wajib') ?></label>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <button id="btn_new_input" class="btn" style="display:none">TAMBAH BARU</button>
            <button class="btn_save ladda-button" data-style="expand-left"></button>
        </div>
    </div><!-- ./row -->
</div>
