<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Quick_setup_cabang_m extends CI_Model{
  var $table = 'master_cabang';
  public function __construct(){
  parent::__construct();

      $this->level_user           = $this->session->userdata('level_user');
      $this->id_company           = $this->session->userdata('id_company');
      $this->multi_cabang         = $this->session->userdata('multi_cabang');
      $this->id_cabang            = $this->session->userdata('id_cabang');
      $this->id_cabang_arr        = $this->session->userdata('id_cabang_arr');
      $this->multi_departemen     = $this->session->userdata('multi_departemen');
      $this->id_departemen        = $this->session->userdata('id_departemen');
      $this->id_departemen_arr    = $this->session->userdata('id_departemen_arr');
      $this->id_karyawan          = $this->session->userdata('id_karyawan');
}

  function get_datatables(){
      $this->_get_datatables_query();
      if($_POST['length'] != -1){
          $this->db->limit($_POST['length'], $_POST['start']);
      }
      $query = $this->db->get();
      return $query->result();
  }

  function count_filtered(){
      $this->_get_datatables_query();
      $query = $this->db->get();
      return $query->num_rows();
  }

  public function count_all(){
      $this->db->select("id_cabang")->from($this->table);
      $this->db->where("id_company",$this->id_company);
      return $this->db->count_all_results();
  }
  private function _get_datatables_query(){
      $this->db->select("nama, jarak, lat_asli, long_asli, master_cabang.kode, master_cabang.id_cabang, id_lokasi_kantor")->from($this->table);
      $this->db->join("data_lokasi_kantor", "data_lokasi_kantor.id_cabang = master_cabang.id_cabang");
      $this->db->where("master_cabang.id_company",$this->id_company);

      $column_search = array('nama','jarak','lat_asli','long_asli');
      $i = 0;

      foreach ($column_search as $item){  // looping awal
          if($_POST['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST

              if($i===0){ // looping awal
                  $this->db->group_start();
                  $this->db->like($item, $_POST['search']['value']);
              }else{
                  $this->db->or_like($item, $_POST['search']['value']);
              }

              if(count($column_search) - 1 == $i){
                  $this->db->group_end();
              }
          }
          $i++;
      }

      $column_order = array(null,'nama','jarak','lat_asli',null);

      if(isset($_POST['order'])){
          $this->db->order_by($column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
      }
      else{
          $order_by = array("master_cabang.id_cabang"=>"DESC");
          $this->db->order_by(key($order_by), $order_by[key($order_by)]);
      }
  }

  function save($data_cabang, $id_cabang, $data_lokasi, $id_company) {

    $masuk = "08:00:00";
    $pulang = "17:00:00";
    $start_absen_masuk = "07:00:00";
    $batas_absen_pulang = "23:59:59";

    $id_jam_kerja = $this->fungsi->getNextId('jam_kerja','id_jam_kerja',$id_company,3);
    $no_urut = substr($id_jam_kerja,-3);

    $data_jam_kerja = [];
    for ($i = 0; $i < 7; $i++) {
        $nextid = substr($id_jam_kerja,0,-3).sprintf("%03d",$no_urut);

        if($i == 5 OR $i == 6) {
            $data_jam_kerja[] = array('id_jam_kerja' => $nextid,
                                    'masuk' => '',
                                    'hari' => $i+1,
                                    'pulang' => '',
                                    'start_absen_masuk' => '',
                                    'batas_absen_pulang' => '',
                                    'libur' => '1',
                                    'jml_jamkerja' => '',
                                    'id_cabang' => $id_cabang,
                                    'id_company' => $id_company);
        }else{
            $data_jam_kerja[] = array('id_jam_kerja' => $nextid,
                                    'masuk' => $masuk,
                                    'hari' => $i+1,
                                    'pulang' => $pulang,
                                    'start_absen_masuk' => $start_absen_masuk,
                                    'batas_absen_pulang' => $batas_absen_pulang,
                                    'libur' => '0',
                                    'jml_jamkerja' => '8',
                                    'id_cabang' => $id_cabang,
                                    'id_company' => $id_company);
        }

        $no_urut++;
    }

    $level_user = array('3','7','2','5');

    # GET ID TERAKHIR APPROVAL IZIN
    $id_approval_izin = $this->fungsi->getNextId('p_approval_izin','id',$id_company,3);
    $no_urut_id_approval_izin = substr($id_approval_izin,-3);

    # GET ID TERAKHIR APPROVAL LEMBUR
    $id_approval_lembur = $this->fungsi->getNextId('p_approval_lembur','id',$id_company,3);
    $no_urut_id_approval_lembur = substr($id_approval_lembur,-3);

    # GET ID TERAKHIR APPROVAL REIMBURSE
    $id_approval_reimburse = $this->fungsi->getNextId('p_approval_reimbursement','id',$id_company,3);
    $no_urut_id_approval_reimburse = substr($id_approval_reimburse,-3);

    $data_approval_izin = [];
    $data_approval_lembur = [];
    $data_approval_reimbursement = [];

    foreach ($level_user as $key) {

        # DATA INSERT APPROVAL IZIN
        $nextid_approval_izin = substr($id_approval_izin,0,-3).sprintf("%03d",$no_urut_id_approval_izin);

        $data_approval_izin[] = array('id' => $nextid_approval_izin,
                                        'id_cabang' => $id_cabang,
                                        'level_user' => $key,
                                        'level_approval'=>$this->fungsi->get_level_approval_izin($key),
                                        'id_company'=>$id_company);

        # DATA INSERT APPROVAL LEMBUR
        $nextid_approval_lembur = substr($id_approval_lembur,0,-3).sprintf("%03d",$no_urut_id_approval_lembur);

        $data_approval_lembur[] = array('id' => $nextid_approval_lembur,
                                        'id_cabang' => $id_cabang,
                                        'level_user' => $key,
                                        'level_approval'=>$this->fungsi->get_level_approval_lembur($key),
                                        'id_company'=>$id_company);

        # DATA INSERT APPROVAL REIMBURSE
        $nextid_approval_reimburse = substr($id_approval_lembur,0,-3).sprintf("%03d",$no_urut_id_approval_reimburse);

        $data_approval_reimbursement[] = array('id' => $nextid_approval_reimburse,
                                                'id_cabang' => $id_cabang,
                                                'level_user' => $key,
                                                'level_approval'=>$this->fungsi->get_level_approval_reimburse($key),
                                                'id_company'=>$id_company);

        $no_urut_id_approval_izin++;
        $no_urut_id_approval_lembur++;
        $no_urut_id_approval_reimburse++;
    }

    $this->db->trans_start();

    $this->db->insert($this->table, array_merge($data_cabang, array('id_cabang' => $id_cabang)));
    $this->db->insert_batch('jam_kerja', $data_jam_kerja);
    $this->db->insert_batch('p_approval_izin', $data_approval_izin);
    $this->db->insert_batch('p_approval_lembur', $data_approval_lembur);
    $this->db->insert_batch('p_approval_reimbursement', $data_approval_reimbursement);
    $this->db->insert('data_lokasi_kantor', $data_lokasi);

    $this->db->trans_complete();

    if($this->db->trans_status() === FALSE) {
        $this->db->trans_rollback();
        return __response_save(false);
    }else{
        $this->db->trans_commit();
        return __response_save(true);
    }
  }

  function update($data_cabang, $id_cabang, $data_lokasi, $id_lokasi_kantor) {

    $this->db->trans_start();

    $this->db->update($this->table, $data_cabang, array('id_cabang' => $id_cabang));
    $this->db->update('data_lokasi_kantor', $data_lokasi, array('id_lokasi_kantor' => $id_lokasi_kantor));

    $this->db->trans_complete();

    if($this->db->trans_status() === FALSE) {
        $this->db->trans_rollback();
        return __response_update(false);
    }else{
        $this->db->trans_commit();
        return __response_update(true);
    }
  }

  function detail($id_cabang, $id_lokasi_kantor) {
    $this->db->select('master_cabang.kode,
      master_cabang.nama,
      data_lokasi_kantor.jarak,
      data_lokasi_kantor.lat_asli,
      data_lokasi_kantor.long_asli,
      data_lokasi_kantor.nama_kantor
    ');
    $this->db->join('data_lokasi_kantor', 'data_lokasi_kantor.id_cabang = master_cabang.id_cabang');
    $this->db->where('master_cabang.id_cabang', $id_cabang);
    $this->db->where('data_lokasi_kantor.id_lokasi_kantor', $id_lokasi_kantor);
    return $this->db->get('master_cabang')->row();
  }

  function delete($id_cabang, $id_lokasi_kantor) {
    $this->db->select("id_karyawan");
    $this->db->from("data_karyawan");
    $this->db->where("id_cabang",$id_cabang);
    $this->db->where("id_company",$this->id_company);
    $cek_data = $this->db->get()->num_rows();

    if($cek_data > 0){
        $message = '<font color="#ffffff"><i class="fa fa-exclamation-triangle">&nbsp;</i>Gagal, terdapat karyawan dicabang ini</font>';
        return __response_delete(false,["message"=>$message]);
    }else{
      $this->db->select("id_lokasi_kantor");
      $this->db->from("data_lokasi_kantor");
      $this->db->where("id_lokasi_kantor",$id_lokasi_kantor);
      $this->db->where("id_company",$this->id_company);
      $id_lokasi_kantor = $this->db->get()->row()->id_lokasi_kantor;

      $cek_data  = $this->db->query("SELECT id_karyawan
                                      FROM data_karyawan
                                      WHERE lock_lokasi = '1'
                                      AND FIND_IN_SET('$id_lokasi_kantor',id_lokasi)
                                      AND id_company = '".$this->id_company."'")->num_rows();

      if($cek_data > 0){
          $message = '<font color="#ffffff"><i class="fa fa-exclamation-triangle">&nbsp;</i>Gagal, terdapat karyawan menggunakan lokasi ini</font>';
          return __response_delete(false,["message"=>$message]);
      }else{

          $this->db->trans_start();

          $this->db->where(array('id_cabang'=>$id_cabang,'id_company'=>$this->id_company));
          $this->db->delete('jam_kerja');

          $this->db->where(array('id_cabang'=>$id_cabang,'id_company'=>$this->id_company));
          $this->db->delete('p_approval_izin');

          $this->db->where(array('id_cabang'=>$id_cabang,'id_company'=>$this->id_company));
          $this->db->delete('p_approval_lembur');

          $this->db->where(array('id_cabang'=>$id_cabang,'id_company'=>$this->id_company));
          $this->db->delete('p_approval_reimbursement');

          $this->db->where(array('id_cabang'=>$id_cabang));
          $this->db->delete($this->table);

          $this->db->where(array('id_lokasi_kantor'=>$id_lokasi_kantor));
          $this->db->delete('data_lokasi_kantor');

          $this->db->trans_complete();

          if($this->db->trans_status() === FALSE) {
              $this->db->trans_rollback();
              return __response_delete(false);
          }else{
              $this->db->trans_commit();
              return __response_delete(true);
          }
      }
    }
  }

  function cek_kode($kode) {
    $this->db->where('kode', $kode);
    $this->db->where('id_company', $this->id_company);
    return $this->db->get($this->table)->num_rows();
  }

  function cek_nama($nama) {
    $this->db->where('nama', $nama);
    $this->db->where('id_company', $this->id_company);
    return $this->db->get($this->table)->num_rows();
  }
}
