<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Ptkp extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('payroll/gaji/Ptkp_m', 'model');
        $this->load->library('form_validation');
    }

    public function index()
    {
        $data['judul']   = 'Detail PTKP Karyawan';
        $data['aktif']   = 'hitung_gaji';
        $data['menu']    = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('payroll/gaji/view_ptkp', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function list_data()
    {
        $list = $this->model->get_datatables();
        $ptkp = $this->model->get_ptkp();

        $data = array();
        $no   = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();

            $row[] = $no;
            $row[] = $field->nama_lengkap . '<br><b>' . $field->nik . '</b>';

            $tanggungan = '<span>' . ($ptkp[$field->tanggungan]['kode'] ?: '-') . '</span>';
            $tanggungan .= '<select data-old="' . $field->tanggungan . '" class="hidden form-control" style="font-size: 12px;"><option value="" ' . ($field->tanggungan ? '' : 'selected') . '>Pilih</option>';
            foreach ($ptkp as $key => $value) {
                $tanggungan .= '<option value="' . $key . '" ' . ($key == $field->tanggungan ? 'selected' : '') . '>' . $value['keterangan'] . '</option>';
            }
            $tanggungan .= '</select>';
            $row[] = $tanggungan;

            $btn_save  = '<a href="javascript:void(0)" class="text-primary" title="SIMPAN"> <i id="' . $field->id_karyawan . '" class="btn_save fa fa-check (alias) "> </i></a>';
            $btn_batal = '<a href="javascript:void(0)" class="text-danger" title="BATAL"> <i class="btn_batal fa fa-close (alias) "> </i></a>';
            $btn_edit  = '<a href="javascript:void(0)" class="text-warning" title="EDIT"> <i class="btn_edit fa fa-edit (alias) "> </i></a>';
            $loading   = '<div class="custom-loader hidden"></div>';
            $row[]     = $loading . '<div id="save" class="hidden">' . $btn_save . ' ' . $btn_batal . '</div><div id="edit">' . $btn_edit . '</div>';

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->model->count_all(),
            "recordsFiltered" => $this->model->count_filtered(),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function save()
    {
        $id = $this->input->post('id');
        $ptkp = $this->input->post('ptkp');

        // validasi
        $list_ptkp = $this->model->get_ptkp();
        if (!$list_ptkp[$ptkp]) {
            return __response_save(false, array('message' => '<i class="fa fa-exclamation-triangle">&nbsp;</i> PTKP tidak valid'));
        }

        $this->model->save($id, $ptkp);
    }
}
