
<script type="text/javascript">
    $(function() {
        $(".form_pendidikan #cabang, .form_status #cabang").select2({
            placeholder: 'Semua',
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.cabang") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            }
        });
    });

    function onchange_cabang(obj) {
        form = $(obj).attr('form');
        jenis = $(obj).attr('jenis');
        id_cabang = $("."+form+" #cabang").val();
        if(jenis == 'pendidikan'){
            getPendidikan(id_cabang);
        }else{
            getStatusKaryawan(id_cabang);
        }
    }

    function getPendidikan(id_cabang=0){
        $.ajax({
            type: 'GET',
            dataType:'JSON',
            url: '<?= route("dashboard.kepegawaian.diagram.pendidikan") ?>'+'/'+id_cabang,
            success : function(data){
                $("#sd").html(data['sd']);
                $("#smp").html(data['smp']);
                $("#sma").html(data['sma']);
                $("#d3").html(data['d3']);
                $("#d4").html(data['d4']);
                $("#s1").html(data['s1']);
                $("#s2").html(data['s2']);
                $("#s3").html(data['s3']);
                $("#tidak_diketahui").html(data['tidak_diketahui']);
                document.getElementById("chart-pendidikan").innerHTML = "";
                new Morris.Donut({
                    // ID of the element in which to draw the chart.
                    element: 'chart-pendidikan',
                    // Chart data records -- each entry in this array corresponds to a point on
                    // the chart.
                    data: [
                        {label: "SD", value: data['sd']},
                        {label: "SMP", value: data['smp']},
                        {label: "SMA", value: data['sma']},
                        {label: "D3", value: data['d3']},
                        {label: "D4", value: data['d4']},
                        {label: "S1", value: data['s1']},
                        {label: "S2", value: data['s2']},
                        {label: "S3", value: data['s3']},
                        {label: "Tidak Diketahui", value: data['tidak_diketahui']}
                    ],
                    colors: [
                        "#8B0000",  //sd
                        "#000080", //smp
                        "#D3D3D3", //sma
                        "#D2691E", //d3
                        "#006400", //d4
                        "#2F4F4F",  //s1
                        "#9370DB",  //s2
                        "#FFFF00",   //s3
                        "#000000"   //s3
                    ]
                });
            },
        });
    }

    function getStatusKaryawan(id_cabang=0){
        $.ajax({
            type: 'GET',
            dataType:'JSON',
            url: '<?= route("dashboard.kepegawaian.diagram.status") ?>'+'/'+id_cabang,
            success : function(data){
                $("#tetap").html(data['tetap']);
                $("#kontrak").html(data['kontrak']);
                $("#izin_belajar").html(data['izin_belajar']);
                $("#tugas_belajar").html(data['tugas_belajar']);
                $("#resign").html(data['resign']);
                $("#phk").html(data['phk']);
                $("#pensiuan").html(data['pensiuan']);

                document.getElementById("chart-kepegawaian").innerHTML = "";
                new Morris.Donut({
                    // ID of the element in which to draw the chart.
                    element: 'chart-kepegawaian',
                    // Chart data records -- each entry in this array corresponds to a point on
                    // the chart.
                    data: [
                        {label: "Kontrak", value: data.kontrak},
                        {label: "Tetap", value: data.tetap},
                        {label: "Izin Belajar", value: data.izin_belajar},
                        {label: "Tugas Belajar", value: data.tugas_belajar},
                        {label: "Resign", value: data.resign},
                        {label: "Dikeluarkan(PHK)", value: data.phk},
                        {label: "Pensiun", value: data.pensiun}
                    ],
                    colors: [
                        "#F63939", //kontrak
                        "#2883FA", //tetap
                        "#07CF72", //Izin Belajar
                        "#FF9900", //Tugas Belajar
                        "#BA47E4", //Resign
                        "#FAC800", //PHK
                        "#A9A9A9", //Pensiun
                    ]
                });
            },
        });
    }



</script>
<div class="row">
    <?php $css = in_array($this->session->userdata('level_user'),array("1","4")) ? " class='col-md-7' " : "class='col-md-12'";?>
    <div <?= $css ?>>
        <div class="row">
            <div class="col-md-12">
                <div class="card card-rounded">
                    <div class="card-absenku card-header card-info-absenku">
                        <h4 class="card-title">Data Kepegawaian Berdasarkan Status Pegawai</h4>
                        <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                    </div>
                    <div class="card-content collpase show">
                        <div class="card-body">
                            <div class="row form_status">
                                <div class="col-md-6">
                                    <div class="form-group row">
                                        <div class="col-md-3">
                                            <label>Cabang</label>
                                        </div>
                                        <div class="col-md-1">
                                            <label>:</label>
                                        </div>
                                        <div class="col-md-8">
                                        <select id="cabang" jenis="status_karyawan" form="form_status" class="form-control" onchange="onchange_cabang(this)"></select>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="row mt-1">
                                <div class="col-md-6">
                                    <div id="chart-kepegawaian" style="height: 250px;"></div>
                                </div>
                                <div class="col-md-6">
                                    <div>
                                        <table class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th>Status</th>
                                                    <th class="text-center">Jumlah</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td><i class="fa fa-stop" style="color: #F63939"></i> Kontrak</td>
                                                    <td class="text-center" id="kontrak"><?= $status_karyawan["kontrak"] ?></td>
                                                </tr>
                                                <tr>
                                                    <td><i class="fa fa-stop" style="color: #2883FA"></i> Tetap</td>
                                                    <td class="text-center" id="tetap"><?= $status_karyawan["tetap"] ?></td>
                                                </tr>
                                                <tr>
                                                    <td><i class="fa fa-stop" style="color: #07CF72"></i> Izin Belajar</td>
                                                    <td class="text-center" id="izin_belajar"><?= $status_karyawan["izin_belajar"] ?></td>
                                                </tr>
                                                <tr>
                                                    <td><i class="fa fa-stop" style="color: #FF9900"></i> Tugas Belajar</td>
                                                    <td class="text-center" id="tugas_belajar"><?= $status_karyawan["tugas_belajar"] ?></td>
                                                </tr>
                                                <tr>
                                                    <td><i class="fa fa-stop" style="color: #BA47E4"></i> Resign</td>
                                                    <td class="text-center" id="resign"><?= $status_karyawan["resign"] ?></td>
                                                </tr>
                                                <tr>
                                                    <td><i class="fa fa-stop" style="color: #FAC800"></i> Dikeluarkan(PHK)</td>
                                                    <td class="text-center" id="phk"><?= $status_karyawan["phk"] ?></td>
                                                </tr>
                                                <tr>
                                                    <td><i class="fa fa-stop" style="color: #A9A9A9"></i> Pensiun</td>
                                                    <td class="text-center" id="pensiun"><?= $status_karyawan["pensiun"] ?></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="card card-rounded">
                    <div class="card-absenku card-header card-info-absenku">
                        <h4 class="card-title">Data Kepegawaian Berdasarkan Pendidikan</h4>
                        <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                    </div>
                    <div class="card-content collpase show">
                        <div class="card-body">
                            <div class="row form_pendidikan">
                                <div class="col-md-6">
                                    <div class="form-group row">
                                        <div class="col-md-3">
                                            <label>Cabang</label>
                                        </div>
                                        <div class="col-md-1">
                                            <label>:</label>
                                        </div>
                                        <div class="col-md-8">
                                            <select id="cabang" jenis="pendidikan" form="form_pendidikan" class="form-control" onchange="onchange_cabang(this)"></select>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="row mt-1">
                                <div class="col-md-6">
                                    <div id="chart-pendidikan" style="height: 250px;"></div>
                                </div>
                                <div class="col-md-6">
                                    <div>
                                        <table class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th>Pendidikan</th>
                                                    <th class="text-center">Jumlah</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td><i class="fa fa-stop" style="color: #8B0000"></i> SD</td>
                                                    <td class="text-center" id="sd"><?= $pendidikan["sd"] ?></td>
                                                </tr>
                                                <tr>
                                                    <td><i class="fa fa-stop" style="color: #000080"></i> SMP</td>
                                                    <td class="text-center" id="smp"><?= $pendidikan["smp"] ?></td>
                                                </tr>
                                                <tr>
                                                    <td><i class="fa fa-stop" style="color: #D3D3D3"></i> SMA</td>
                                                    <td class="text-center" id="sma"><?= $pendidikan["sma"] ?></td>
                                                </tr>
                                                <tr>
                                                    <td><i class="fa fa-stop" style="color: #D2691E"></i> D3</td>
                                                    <td class="text-center" id="d3"><?= $pendidikan["d3"] ?></td>
                                                </tr>
                                                <tr>
                                                    <td><i class="fa fa-stop" style="color: #006400"></i> D4</td>
                                                    <td class="text-center" id="d4"><?= $pendidikan["d4"] ?></td>
                                                </tr>
                                                <tr>
                                                    <td><i class="fa fa-stop" style="color: #2F4F4F"></i> S1</td>
                                                    <td class="text-center" id="s1"><?= $pendidikan["s1"] ?></td>
                                                </tr>
                                                <tr>
                                                    <td><i class="fa fa-stop" style="color: #9370DB"></i> S2</td>
                                                    <td class="text-center" id="s2"><?= $pendidikan["s2"] ?></td>
                                                </tr>
                                                <tr>
                                                    <td><i class="fa fa-stop" style="color: #FFFF00"></i> S3</td>
                                                    <td class="text-center" id="s3"><?= $pendidikan["s3"] ?></td>
                                                </tr>
                                                <tr>
                                                    <td><i class="fa fa-stop" style="color: #000000"></i> Tidak Ketahui</td>
                                                    <td class="text-center" id="tidak_diketahui"><?= $pendidikan["tidak_diketahui"] ?></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>


                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php
        if(in_array($this->level_user,["1","4"])){
    ?>
    <div class="col-md-5">
        <div class="card card-rounded">
            <div class="card-absenku card-header">
                <h4 class="card-title" style="text-transform: initial;">Daftar karyawan kontrak yang akan segera berakhir</h4>
            </div>
            <div class="card-content collpase show daftar-pengajuan">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12 col-sm-12" style="height: 925px; overflow-y: auto;">
                            <?php
                                foreach($data_karyawan as $row){
                            ?>
                                    <div class="card">
                                        <div class="card-header">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <h4 class="card-title">
                                                        <i class="fa fa-user-o"></i>
                                                        <div>
                                                            <?= $row->nama_lengkap; ?>
                                                        </div>
                                                        <small class="block">
                                                            <?= $row->nik; ?>
                                                        </small>
                                                    </h4>
                                                </div>
                                                <div class="col-md-6 text-right">
                                                    <div class="mt-1">
                                                        <a href="<?= site_url('master/karyawan/detail') ?>/<?= md5($row->id_karyawan) ?>" class="btn btn-success">Detail</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-content collapse show">
                                            <div class="card-body">
                                                <?php
                                                    if($row->jml_hari < 0){
                                                ?>
                                                        <p>
                                                            <small class="badge badge-danger" style="color: white;">Kontrak Sudah Berakhir</small>
                                                        </p>
                                                <?php
                                                    }else{
                                                ?>
                                                        <p>
                                                            <small class="badge badge-warning" style="color: white;">
                                                                Kontrak tinggal <?= $row->jml_hari ?> Hari lagi
                                                            </small>
                                                        </p>
                                                <?php
                                                    }
                                                ?>
                                                <div class="infotgl">
                                                    <font color="#11c086">Mulai Kontrak :</font> <?= $this->fungsi->format_date_strip($row->tgl_aktif_bekerja); ?> <font color="#fc5656" class="ml-1"> Berakhir Kontrak :</font> <?= $this->fungsi->format_date_strip($row->tgl_berhenti_bekerja); ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                            <?php
                                }
                            ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12 col-sm-12 text-center">
                            <a href="<?= route('dashboard.kepegawaian.data.kontrak.berakhir'); ?>">
                                <button type="button" class="btn btn-outline-biru round btn-min-width">
                                    Lihat Semua
                                </button>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php
        }
    ?>
</div>


<script src="<?= base_url('assets/js/home_realtime_date.js') ?>"></script>
<script>
    $(function() {
        //status_kerja
        new Morris.Donut({
            // ID of the element in which to draw the chart.
            element: 'chart-kepegawaian',
            // Chart data records -- each entry in this array corresponds to a point on
            // the chart.
            data: [
                {label: "Kontrak", value: <?= $status_karyawan["kontrak"] ?>},
                {label: "Tetap", value: <?= $status_karyawan["tetap"] ?>},
                {label: "Izin Belajar", value: <?= $status_karyawan["izin_belajar"] ?>},
                {label: "Tugas Belajar", value: <?= $status_karyawan["tugas_belajar"] ?>},
                {label: "Resign", value: <?= $status_karyawan["resign"] ?>},
                {label: "Dikeluarkan(PHK)", value: <?= $status_karyawan["phk"] ?>},
                {label: "Pensiun", value: <?= $status_karyawan["pensiun"] ?>}
            ],
            colors: [
                "#F63939", //kontrak
                "#2883FA", //tetap
                "#07CF72", //Izin Belajar
                "#FF9900", //Tugas Belajar
                "#BA47E4", //Resign
                "#FAC800", //PHK
                "#A9A9A9", //Pensiun
            ]
        });
    });
</script>

<script type="text/javascript">

    $(function() {
    //pendidikan
        new Morris.Donut({
            // ID of the element in which to draw the chart.
            element: 'chart-pendidikan',
            // Chart data records -- each entry in this array corresponds to a point on
            // the chart.
            data: [
                {label: "SD", value: <?= $pendidikan['sd']; ?>},
                {label: "SMP", value: <?= $pendidikan['smp']; ?>},
                {label: "SMA", value: <?= $pendidikan['sma']; ?>},
                {label: "D3", value: <?= $pendidikan['d3']; ?>},
                {label: "D4", value: <?= $pendidikan['d4']; ?>},
                {label: "S1", value: <?= $pendidikan['s1']; ?>},
                {label: "S2", value: <?= $pendidikan['s2']; ?>},
                {label: "S3", value: <?= $pendidikan['s3'];; ?>},
                {label: "Tidak Diketahui", value: <?= $pendidikan['tidak_diketahui']; ?>},
            ],
            colors: [
                "#8B0000",  //sd
                "#000080", //smp
                "#D3D3D3", //sma
                "#D2691E", //d3
                "#006400", //d4
                "#2F4F4F",  //s1
                "#9370DB",  //s2
                "#FFFF00",   //s3
                "#000000"   //s3
            ]
        });
    });
</script>