<script type="text/javascript">
    $(function() {
        // reconfigure();
        list_data = $('#list_data').DataTable({ 
                    'searching'   : true,
                    'searchDelay' : 1000,
                    'paging'      : true,
                    'lengthChange': true,
                    'ordering'    : true,
                    'info'        : true,
                    'scrollX'     : true,
                    // 'scrollCollapse': true,
                    // 'fixedColumns': true,
                    'language'    :{
                                    'url'         : '<?=base_url("assets/plugins/datatables/dataTables-language-id.json")?>',
                                    'sEmptyTable' : 'Tidak ada data untuk ditampilkan'
                                },
                    "processing"  : true, 
                    "serverSide"  : true, 
                    "order"       : [], 
                    
                    "ajax"        : {
                                        "url": "<?= route('dashboard.kepegawaian.data.kontrak.list') ?>",
                                        "type": "POST",
                                        "complete" : function(data){
                                            reconfigure(data);
                                        }
                                    },
            
                    "aoColumnDefs": [
                                        { "aTargets": [0], "bSortable": false },
                                        { "aTargets": [-1], "bSortable": false }
                                    ],
                    "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            $('td:eq(0)', nRow).css({'text-align':'center','width':'10px'});
                            $('td:eq(5)', nRow).css({'text-align':'center'});
                            $('td:eq(6)', nRow).css({'text-align':'center'});
                            $('td:eq(7)', nRow).css({'text-align':'center'});
                            $('td:eq(8)', nRow).css({'text-align':'center','width':'100px'});
                    }
        
        });
        
    });
</script>
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        </li>
                        <li class="breadcrumb-item"><a href="#">Kepegawaian</a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <div class="float-md-right">
                <a href="<?= route('dashboard.kepegawaian') ?>" class="btn btn-secondary"><i class="fa fa-arrow-left"></i> KEMBALI</a>
                <a href="<?= route('dashboard.kepegawaian.kontrak.berakhir.download') ?>" class="btn btn-primary"><i class="fa fa-download"></i> Cetak Data</a>
            </div>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="table-responsive">
                <table id="list_data" class="table table-striped" style="width:100%">
                    <thead>
                        <tr>
                            <th class="text-center">NO</th>
                            <th class="text-left">NAMA</th>
                            <th class="text-left">CABANG</th>
                            <th class="text-left">DEPARTEMEN</th>
                            <th class="text-left">JABATAN</th>
                            <th class="text-center">TANGGAL MULAI KONTRAK</th>
                            <th class="text-center">TANGGAL SELESAI KONTRAK</th>
                            <th class="text-center">STATUS KONTRAK</th>
                            <th class="text-center">AKSI</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>


