<script type="text/javascript">
    $(document).ready(function() {
        datepicker();
    });
</script>
<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>
<div id="form_input" class="card-body" disabled>
    <input type="hidden" id="id_karyawan" class="form-control" value="<?= $id_karyawan ?>">
    <input type="hidden" id="id_keluarga" class="form-control" value="<?= ((isset($data))?md5($data->id_keluarga):'') ?>">
    <div class="form-group">
        <div class="row">
            <div class="col-md-6">
                <label>Hubungan Dengan Karyawan <i class="text-danger">*</i></label>
                <select id="hub_keluarga" name="hub_keluarga" class="form-control">
                    <option value="Ayah" <?= ((isset($data) AND $data->hub_keluarga == 'Ayah')?'selected':'') ?>>Ayah</option>
                    <option value="Ibu" <?= ((isset($data) AND $data->hub_keluarga == 'Ibu')?'selected':'') ?>>Ibu</option>
                    <option value="Suami" <?= ((isset($data) AND $data->hub_keluarga == 'Suami')?'selected':'') ?>>Suami</option>
                    <option value="Istri" <?= ((isset($data) AND $data->hub_keluarga == 'Istri')?'selected':'') ?>>Istri</option>
                    <option value="Anak" <?= ((isset($data) AND $data->hub_keluarga == 'Anak')?'selected':'') ?>>Anak</option>
                    <option value="Saudara Kandung" <?= ((isset($data) AND $data->hub_keluarga == 'Saudara Kandung')?'selected':'') ?>>Saudara Kandung</option>
                </select>
            </div>
            <div class="col-md-6">
                <label>Status Perkawinan <i class="text-danger">*</i></label>
                <select id="status_perkawinan" name="status_perkawinan" class="form-control">
                    <option value="Belum Kawin" <?= ((isset($data) AND $data->status_perkawinan == 'Belum Kawin')?'selected':'') ?>>Belum Kawin</option>
                    <option value="Kawin" <?= ((isset($data) AND $data->status_perkawinan == 'Kawin')?'selected':'') ?>>Kawin</option>
                    <option value="Cerai Hidup" <?= ((isset($data) AND $data->status_perkawinan == 'Cerai Hidup')?'selected':'') ?>>Cerai Hidup</option>
                    <option value="Cerai Mati" <?= ((isset($data) AND $data->status_perkawinan == 'Cerai Mati')?'selected':'') ?>>Cerai Mati</option>
                </select>
            </div>
        </div>
    </div>
    <div class="form-group">
            <div class="row">
            <div class="col-md-12">
                <label>Nama Lengkap <i class="text-danger">*</i></label>
                <input type="text" id="nama" class="form-control" value="<?= isset($data->nama) ? $data->nama : '' ?>">
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="row">
            <div class="col-md-6">
                <label>Tempat Lahir <i class="text-danger">*</i></label>
                <input type="text" id="tempat_lahir" class="form-control" value="<?= ((isset($data))?$data->tempat_lahir:'') ?>">
            </div>

            <div class="col-md-6">
                <label>Tanggal Lahir <i class="text-danger">*</i></label>
                <?php
                    if (isset($data)) {
                        $tanggal = date('d-m-Y', strtotime($data->tanggal_lahir));
                    }else{
                        $tanggal = "";
                    }
                ?>
                <input type="text" id="tanggal_lahir" class="form-control datepicker" data-inputmask="'alias': 'datetime','inputFormat': 'dd-mm-yyyy'" value="<?= $tanggal ?>" autocomplete="off" placeholder="dd-mm-yyyy">
            </div>
        </div>
    </div>   

    <div class="form-group">
        <div class="row">
            <div class="col-md-6">
                <label>Nomor Induk Kependudukan</label>
                <input type="text" id="nik" class="form-control numberbox" value="<?= ((isset($data))?$data->nik:'') ?>">
            </div>

            <div class="col-md-6">
                <label>Nomor BPJS Kesejatan</label>
                <input type="text" id="no_bpjs" class="form-control numberbox" value="<?= ((isset($data))?$data->no_bpjs:'') ?>">
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="row">
            <div class="col-md-6">
                <label>Jenis Kelamin <i class="text-danger">*</i></label>
                <select id="jenis_kelamin" name="jenis_kelamin" class="form-control">
                    <option value="L" <?= ((isset($data) AND $data->jenis_kelamin == 'L')?'selected':'') ?>>Laki - Laki</option>
                    <option value="P" <?= ((isset($data) AND $data->jenis_kelamin == 'P')?'selected':'') ?>>Perempuan</option>
                </select>
            </div>

            <div class="col-md-6">
                <label>Agama <i class="text-danger">*</i></label>
                <select id="agama" name="agama" class="form-control">
                    <option value="Islam" <?= ((isset($data) AND $data->agama == 'Islam')?'selected':'') ?>>Islam</option>
                    <option value="Kristen" <?= ((isset($data) AND $data->agama== 'Kristen')?'selected':'') ?>>Kristen</option>
                    <option value="Hindu" <?= ((isset($data) AND $data->agama == 'Hindu')?'selected':'') ?>>Hindu</option>
                    <option value="Buddha" <?= ((isset($data) AND $data->agama== 'Buddha')?'selected':'') ?>>Buddha</option>
                    <option value="Katolik" <?= ((isset($data) AND $data->agama == 'Katolik')?'selected':'') ?>>Katolik</option>
                    <option value="Khonghucu" <?= ((isset($data) AND $data->agama== 'Khonghucu')?'selected':'') ?>>Khonghucu</option>
                </select>
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="row">
            <div class="col-md-6">
                <label>Nomor Telepon</label>
                <input type="text" id="telepon" class="numberbox form-control" value="<?= ((isset($data))?$data->telepon:'') ?>">
            </div>
            <div class="col-md-6">
                <label>Pekerjaan <i class="text-danger">*</i></label>
                <select id="pekerjaan" name="pekerjaan" class="form-control">
                    <option value="Pelajar/Mahasiswa" <?= ((isset($data) AND $data->pekerjaan == 'Pelajar/Mahasiswa')?'selected':'') ?>>Pelajar/Mahasiswa</option>
                    <option value="Belum Bekerja" <?= ((isset($data) AND $data->pekerjaan == 'Belum Bekerja')?'selected':'') ?>>Tidak Bekerja</option>
                    <option value="Bekerja" <?= ((isset($data) AND $data->pekerjaan == 'Bekerja')?'selected':'') ?>>Bekerja</option>
                </select>
            </div>
        </div>
    </div>
    
    <div class="form-group">
        <div class="row">
            <div class="col-md-6">
                <label>Tanggal Perkawinan</label>
                <?php
                    if (isset($data)) {
                        if ($data->tanggal_perkawinan != "0000-00-00") {
                            $tanggal_kawin = date('d-m-Y', strtotime($data->tanggal_perkawinan));
                        }else{
                            $tanggal_kawin = "";
                        }  
                    }else{
                        $tanggal_kawin = "";
                    }
                ?>
                <input type="text" id="tanggal_perkawinan" class="form-control datepicker dateonly" data-inputmask="'alias': 'datetime','inputFormat': 'dd-mm-yyyy'" value="<?= $tanggal_kawin ?>" autocomplete="off" placeholder="dd-mm-yyyy">
            </div>
            <div class="col-md-6">
                <label>Pendidikan Terakhir <i class="text-danger">*</i></label>
                <select id="pendidikan_terakhir" name="pendidikan_terakhir" class="form-control">
                    <option value="Belum Sekolah" <?= ((isset($data) AND $data->pendidikan_terakhir == 'Belum Sekolah')?'selected':'') ?>>Belum Sekolah</option>
                    <option value="TK" <?= ((isset($data) AND $data->pendidikan_terakhir == 'TK')?'selected':'') ?>>TK</option>
                    <option value="SD" <?= ((isset($data) AND $data->pendidikan_terakhir == 'SD/MI')?'selected':'') ?>>SD/MI</option>
                    <option value="SMP" <?= ((isset($data) AND $data->pendidikan_terakhir == 'SMP/MTS')?'selected':'') ?>>SMP/MTS</option>
                    <option value="SMA" <?= ((isset($data) AND $data->pendidikan_terakhir == 'SMA/SMK')?'selected':'') ?>>SMA/SMK</option>
                    <option value="D3" <?= ((isset($data) AND $data->pendidikan_terakhir == 'D3')?'selected':'') ?>>D3</option>
                    <option value="D4" <?= ((isset($data) AND $data->pendidikan_terakhir == 'D4')?'selected':'') ?>>D4</option>
                    <option value="S1" <?= ((isset($data) AND $data->pendidikan_terakhir == 'S1')?'selected':'') ?>>S1</option>
                    <option value="S2" <?= ((isset($data) AND $data->pendidikan_terakhir == 'S2')?'selected':'') ?>>S2</option>
                    <option value="S3" <?= ((isset($data) AND $data->pendidikan_terakhir == 'S3')?'selected':'') ?>>S3</option>
                </select>
            </div>
        </div>
    </div>
    
    <div class="form-group">
        <div class="row">
            <div class="col-md-6">
                <label>Status <i class="text-danger">*</i></label>
                <select id="status" name="status" class="form-control">
                    <option value="Hidup" <?= ((isset($data) AND $data->status == 'Hidup')?'selected':'') ?>>Hidup</option>
                    <option value="Meninggal" <?= ((isset($data) AND $data->status == 'Meninggal')?'selected':'') ?>>Meninggal</option>
                </select>
            </div>
        </div>
    </div>

</div>
<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <button id="btn_new_input" class="btn" style="display:none">TAMBAH BARU</button>
            <button class="btn_save_keluarga btn btn-primary ladda-button" id="btn_save_keluarga" data-style="expand-left"></button>
        </div>
    </div><!-- ./row -->
</div>

