<script type="text/javascript">
    $(document).ready(function() {
        $(".dateonly").keydown(function (e) {
            // Allow: backspace, delete, tab, escape, enter and 
            if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 110, 189]) !== -1 ||
                // Allow: Ctrl+A
                (e.keyCode == 65 && e.ctrlKey === true) || 
                // Allow: home, end, left, right, down, up
                (e.keyCode >= 35 && e.keyCode <= 40)) {
                    // let it happen, don't do anything
                    return;
            }
            // Ensure that it is a number and stop the keypress
            if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
                e.preventDefault();
                $("#jumlah_barang").focus();
                return false();
            }
        });
    });
</script>
<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>
<div id="form_input" class="card-body" disabled>
    <input type="hidden" id="id" class="form-control" value="<?= ((isset($data))?md5($data->id):'') ?>">
    <input type="hidden" id="id_company" name="id_company" value="<?php echo $this->session->userdata('id_company') ?>">
    <div class="form-group">
        <label>Tanggal <i class="text-danger">*</i></label>
        <?php
            if (isset($data)) {
                $tanggal = date('d-m-Y', strtotime($data->tanggal));
            }else{
                $tanggal = "";
            }
        ?>
        <input type="text" id="tanggal" class="form-control datepicker dateonly" value="<?= $tanggal; ?>" autocomplete="off" placeholder="dd-mm-yyyy">
    </div>
        
    <div class="form-group">
        <label>Keterangan <i class="text-danger">*</i></label>
        <input type="text" id="keterangan" class="form-control" value="<?= ((isset($data))?$data->keterangan:'') ?>">
    </div>
</div>
<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <button id="btn_new_input" class="btn" style="display:none">TAMBAH BARU</button>
            <button class="btn_save ladda-button" data-style="expand-left"></button>
        </div>
    </div><!-- ./row -->
</div>

 <script type="text/javascript">
        $(document).ready(function() {
            $.fn.datepicker.dates['id'] = {
                days: ['Minggu', 'Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat', 'Sabtu'],
                daysShort: ['Min', 'Sen', 'Sel', 'Rab', 'Kam', 'Jum', 'Sab'],
                daysMin: ['Min', 'Sen', 'Sel', 'Rab', 'Kam', 'Jum', 'Sab'],
                months: ['Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'],
                monthsShort: ['Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun', 'Jul', 'Agu', 'Sep', 'Okt', 'Nov', 'Des'],
                today: 'Hari Ini',
                clear: 'Clear',
                /*format: 'yyyy-mm-dd',
                titleFormat: 'MM yyyy', */
                weekStart: 0
                };

            $('.datepicker').datepicker({
                    format: 'dd-mm-yyyy',
                    autoclose: true,
                    orientation: 'bottom',
                    language: 'id',
            });
        });

        function checkAvailability() {
            $("#user-availability-status").hide();
            $("#loaderIcon").show();
            jQuery.ajax({
            url: "<?= site_url('master/kalender/cek-tanggal') ?>",
            data:'tanggal='+$("#tanggal").val(),
            type: "POST",
            success:function(data){
                if (data == 'sudah') {
                    $("#user-availability-status").show();
                    $("#user-availability-status").html("<span class='status-not-available' style='color: red;'> Tanggal Libur sudah digunakan.</span>");
                    $("#loaderIcon").hide();
                    $(".btn_save").prop('disabled', true);
                } else{
                    $("#user-availability-status").show();
                    $("#user-availability-status").html("<span class='status-not-available' style='color: green;'> Tanggal Libur belum digunakan.</span>");
                    $("#loaderIcon").hide();
                    $(".btn_save").prop('disabled', false);
                }
            },
            error:function (){}
            });
        }
</script>

