<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Laporan_reimburse_m extends CI_Model
{
    var $table = 'reimbursement_pengajuan';
    public function __construct(){
		parent::__construct();

        $this->level_user           = $this->session->userdata('level_user');
        $this->id_company           = $this->session->userdata('id_company');
        $this->multi_cabang         = $this->session->userdata('multi_cabang');
        $this->id_cabang            = $this->session->userdata('id_cabang');
        $this->id_cabang_arr        = $this->session->userdata('id_cabang_arr');
        $this->multi_departemen     = $this->session->userdata('multi_departemen');
        $this->id_departemen        = $this->session->userdata('id_departemen');
        $this->id_departemen_arr    = $this->session->userdata('id_departemen_arr');
        $this->id_karyawan          = $this->session->userdata('id_karyawan');
	}

    function get_datatables($tanggal_mulai="0", $tanggal_selesai="0", $id_karyawan="0", $id_cabang="0", $id_departemen="0"){
        $query = $this->_get_datatables_query($tanggal_mulai, $tanggal_selesai, $id_karyawan, $id_cabang, $id_departemen);

        if($_POST['length'] != -1){
            $this->db->limit($_POST['length'], $_POST['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered($tanggal_mulai="0", $tanggal_selesai="0", $id_karyawan="0", $id_cabang="0", $id_departemen="0")
    {
        $this->_get_datatables_query($tanggal_mulai, $tanggal_selesai, $id_karyawan, $id_cabang, $id_departemen);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all($tanggal_mulai="0", $tanggal_selesai="0", $id_karyawan="0", $id_cabang="0", $id_departemen="0")
    {
        $this->_get_datatables_query($tanggal_mulai, $tanggal_selesai, $id_karyawan, $id_cabang, $id_departemen);
        return $this->db->count_all_results();
    }

    private function _get_datatables_query($tanggal_mulai="0", $tanggal_selesai="0", $id_karyawan="0", $id_cabang="0", $id_departemen="0")
    {

        $cek_id_cabang = $this->db->query("SELECT id_cabang 
                                        FROM data_karyawan 
                                        WHERE id_company = '$this->id_company' 
                                        AND id_karyawan = '$this->id_karyawan'")->row()->id_cabang;

        $cek_flag_cabang = $this->db->query("SELECT flag 
                                        FROM master_cabang 
                                        WHERE id_company = '$this->id_company' 
                                        AND id_cabang = '$cek_id_cabang'")->row()->flag;

       if($id_karyawan != "0") {
            $this->db->where("dk.id_karyawan", $id_karyawan);
        }

        if($id_cabang != "0") {
            $this->db->where('dk.id_cabang', $id_cabang);
        }else{
            if($cek_flag_cabang == '2'){
                $this->db->where('dk.id_cabang', $this->id_cabang);
            }
        }

        if($id_departemen != "0") {
            $this->db->where('dk.id_departemen', $id_departemen);
        }

        $this->db->select('rp.no_pengajuan,
                            rp.keterangan,
                            rp.tgl_pengajuan,
                            rp.id as id_pengajuan,
                            rj.jenis_plafon, 
                            rj.max_nominal_plafon,
                            rd.nominal AS nominal_diajukan, 
                            rd.nominal_disetujui,
                            dk.nik,
                            dk.nama_lengkap as nama_karyawan,
                            mc.kode as kode_cabang,
                            mc.nama as nama_cabang,
                            md.kode as kode_departemen,
                            md.nama as nama_departemen');
        $this->db->join('data_karyawan AS dk', 'rp.id_karyawan = dk.id_karyawan');
        $this->db->join('master_cabang AS mc', 'rp.id_cabang = mc.id_cabang');
        $this->db->join('master_departemen AS md', 'rp.id_departemen = md.id_departemen', 'left');
        $this->db->join('reimbursement_data AS rd', 'rd.id_pengajuan_reimbursement = rp.id');
        $this->db->join('reimbursement_jenis AS rj', 'rj.id_jenis_reimbursement = rd.id_jenis_reimbursement'); 
        $this->db->from('reimbursement_pengajuan AS rp');
        $this->db->where('rp.id_company', $this->id_company);
        $this->db->where('rp.tgl_pengajuan >= ', date_format(date_create($tanggal_mulai),"Y-m-d"));
        $this->db->where('rp.tgl_pengajuan <= ', date_format(date_create($tanggal_selesai),"Y-m-d"));
        $this->db->where('rp.status', '5');
        $this->db->group_by('rp.tgl_pengajuan');
        

        $column_search = array('rp.keterangan');
        $i = 0;

        foreach ($column_search as $item){  // looping awal
            if($_POST['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST

                if($i===0){ // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_POST['search']['value']);
                }else{
                    $this->db->or_like($item, $_POST['search']['value']);
                }

                if(count($column_search) - 1 == $i){
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array('','','dk.nik','rp.keterangan');

        if(isset($_POST['order'])){
            $this->db->order_by($column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else{
            $order_by = array("rp.tgl_pengajuan"=>"ASC","rp.no_pengajuan"=>"ASC","md.nama"=>"ASC","dk.nama"=>"ASC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
            
        }
    }

    //download
    function download($tanggal_mulai="0", $tanggal_selesai="0", $id_karyawan="0", $id_cabang="0", $id_departemen="0"){

        $cek_id_cabang = $this->db->query("SELECT id_cabang 
                                        FROM data_karyawan 
                                        WHERE id_company = '$this->id_company' 
                                        AND id_karyawan = '$this->id_karyawan'")->row()->id_cabang;

        $cek_flag_cabang = $this->db->query("SELECT flag 
                                        FROM master_cabang 
                                        WHERE id_company = '$this->id_company' 
                                        AND id_cabang = '$cek_id_cabang'")->row()->flag;

        if($id_karyawan != "0") {
            $this->db->where("dk.id_karyawan", $id_karyawan);
        }

        if($id_cabang != "0") {
            $this->db->where('dk.id_cabang', $id_cabang);
        }else{
            if($cek_flag_cabang == '2'){
                $this->db->where('dk.id_cabang', $this->id_cabang);
            }
        }

        if($id_departemen != "0") {
            $this->db->where('dk.id_departemen', $id_departemen);
        }

        $this->db->select('rp.no_pengajuan,
                            rp.keterangan,
                            rp.tgl_pengajuan,
                            rp.id as id_pengajuan,
                            rj.jenis_plafon, 
                            rj.max_nominal_plafon,
                            rd.nominal AS nominal_diajukan, 
                            rd.nominal_disetujui,
                            dk.nik,
                            dk.nama_lengkap as nama_karyawan,
                            mc.kode as kode_cabang,
                            mc.nama as nama_cabang,
                            md.kode as kode_departemen,
                            md.nama as nama_departemen');
        $this->db->join('data_karyawan AS dk', 'rp.id_karyawan = dk.id_karyawan');
        $this->db->join('master_cabang AS mc', 'rp.id_cabang = mc.id_cabang');
        $this->db->join('master_departemen AS md', 'rp.id_departemen = md.id_departemen', 'left');
        $this->db->join('reimbursement_data AS rd', 'rd.id_pengajuan_reimbursement = rp.id');
        $this->db->join('reimbursement_jenis AS rj', 'rj.id_jenis_reimbursement = rd.id_jenis_reimbursement'); 
        $this->db->from('reimbursement_pengajuan AS rp');
        $this->db->where('rp.id_company', $this->id_company);
        $this->db->where('rp.tgl_pengajuan >= ', date_format(date_create($tanggal_mulai),"Y-m-d"));
        $this->db->where('rp.tgl_pengajuan <= ', date_format(date_create($tanggal_selesai),"Y-m-d"));
        $this->db->where('rp.status', '5');
        $this->db->group_by('rp.tgl_pengajuan');
        $order_by = array("rp.tgl_pengajuan"=>"ASC","rp.no_pengajuan"=>"ASC","md.nama"=>"ASC","dk.nama"=>"ASC");
        $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        $query = $this->db->get();
        // echo $this->db->last_query();
        // die();
        return $query->result();
    }

    function nama_karyawan($id_karyawan)
    {
        return $this->db->select('nama_lengkap')
            ->where('id_karyawan', $id_karyawan)
            ->get('data_karyawan')->row()->nama_lengkap;
    }

    function nama_cabang($id_cabang)
    {
        return $this->db->select('nama')
            ->where('id_cabang', $id_cabang)
            ->get('master_cabang')->row()->nama;
    }

    function nama_departemen($id_departemen)
    {
        return $this->db->select('nama')
            ->where('id_departemen', $id_departemen)
            ->get('master_departemen')->row()->nama;
    }

    public function cek_flag_cabang()
    {
        $cek_id_cabang = $this->db->query("SELECT id_cabang 
                                        FROM data_karyawan 
                                        WHERE id_company = '$this->id_company' 
                                        AND id_karyawan = '$this->id_karyawan'")->row()->id_cabang;
        $cek_flag_cabang = $this->db->query("SELECT flag 
                                        FROM master_cabang 
                                        WHERE id_company = '$this->id_company' 
                                        AND id_cabang = '$cek_id_cabang'")->row()->flag;
        return $cek_flag_cabang;
    }
}
