<script type="text/javascript">
    $(function() {
        list_data = $('#list_data').DataTable({ 
                    'searching'   : true,
                    'paging'      : true,
                    'lengthChange': true,
                    'ordering'    : true,
                    'info'        : true,
                    'scrollX'     : true,
                    // 'scrollCollapse': true,
                    // 'fixedColumns': true,
                    'language'    :{
                                    'url'         : '<?=base_url("assets/plugins/datatables/dataTables-language-id.json")?>',
                                    'sEmptyTable' : 'Tidak ada data untuk ditampilkan',
                                    'searchPlaceholder': 'Judul Pengumuman'
                                },
                    "processing"  : true, 
                    "serverSide"  : true, 
                    "order"       : [], 
                    
                    "ajax"        : {
                                    "url": "<?= route('informasi.pengumuman.data') ?>",
                                    "type": "GET",
                                    "complete" : function(data){
                                            reconfigure(data);
                                        }
                                    },
            
                    "aoColumnDefs": [
                                        { "aTargets": [0], "bSortable": false },
                                        { "aTargets": [-1], "bSortable": false }
                                    ],
                    "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            $('td:eq(0)', nRow).css({'text-align':'center','width':'10px'});
                            $('td:eq(2)', nRow).css({'width':'300px'});
                            $('td:eq(3)', nRow).css({'text-align':'center','width':'50px'});
                    }
        
        });
        
    });

       //btn_hapus
    $(document).on('click','.btn_delete',function(){
            var id = $(this).attr('id');
            $('#modal_form_delete').modal('show');
            $(".title").text("Apakah Anda ingin menghapus data ini?");
            $(".btn_hapus").append('<i class="fa fa-trash"></i> ');
            $(".btn_hapus").append('HAPUS');
            $(".btn_hapus").removeClass("btn_hapus").addClass("btn_hapus btn btn-danger");

            //btn_delete
            $('.btn_hapus').on('click',function(){
                var loading = Ladda.create(this);
                loading.start();
                $.ajax({
                    type: 'POST',
                    url: "<?= route('informasi.pengumuman.delete') ?>",
                    data: 'id_pengumuman='+id,
                    dataType:'JSON',
                    success: function(result){
                        $("#modal_form_delete").modal('hide')
                    },
                    error:function(){
                        loading.stop();
                        $("#modal_form_delete .card-body").hide();
                        $("#modal_form_delete .card-footer").hide();
                        $("#modal_form_delete .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                    }
                });
            });
            //btn_delete
    });
    //btn_hapus
</script>
<style type="text/css">
    p {
        text-align: justify;
    }
</style>
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        </li>
                        <li class="breadcrumb-item"><a href="#">Informasi</a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <?php
                if ($this->session->userdata('level_user') == '1') {
            ?>
            <div class="float-md-right">
                <a href="<?= route("informasi.pengumuman.form.tambah")  ?>" title="Tambah Lokasi">
                <button type="button" class="btn_tambah btn btn-biru">
                    <i class="fa fa-plus"></i> Tambah Data
                </button>
            </a>
            </div>
            <?php
                }
            ?>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="table-responsive">
                <table id="list_data" class="table table-striped" style="width:100%">
                    <thead>
                        <tr>
                            <th class="text-center">NO</th>
                            <th class="text-left">PENGUMUMAN</th>
                            <th class="text-LEFT">TARGET</th>
                            <th class="text-center">AKSI</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<div id="modal_form_delete" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form" class="modal-content">
            <div class="card-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h3 class="title modal-title"></h3>
            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="col-md-7 text-left">
                        <div id="message"></div>
                    </div>
                    <div class="col-md-5 text-right">
                        <button class="btn_hapus ladda-button" id="btn_hapus" data-style="expand-left"></button>
                    </div>
                </div><!-- ./row -->
            </div>
        </div>
    </div>
</div>
<!-- END TAMPIL MODAL -->


