<script type="text/javascript">
    $(function() {
        dropdown_karyawan();
        dropdown_cabang();
        dropdown_departemen();

        tanggal()
        pickrange();

        list_data();

        $('#btn_cari').click(function(){
            var loading = Ladda.create(this);
            loading.start();

            var tgl_mulai       = (!$('#tanggal_mulai').val())?"0":$('#tanggal_mulai').val();
            var tgl_selesai     = (!$('#tanggal_selesai').val())?"0":$('#tanggal_selesai').val();
            var id_karyawan     = ($("#id_karyawan").val() == "")?"0":$("#id_karyawan").val();
            var id_cabang       = 0;
            var id_departemen   = 0;

            id_karyawan = id_karyawan.toString();
            id_karyawan = id_karyawan.replace(/,/g, '_._');
            $('#view_data').load("<?= route('pengaturan.shift.data.view') ?>"+'/'+tgl_mulai+'/'+tgl_selesai+'/'+id_karyawan+"/"+id_cabang+"/"+id_departemen, function(){
                $("#content").show();
                loading.stop();
            });
        });

        $('#btn_filter').click(function(){
            var loading = Ladda.create(this);
            loading.start();

            var level_user          = '<?= $level_user ?>';
            var multi_departemen    = '<?= $multi_departemen ?>';
            var multi_cabang        = '<?= $multi_cabang ?>';

            var tanggal_mulai   = $("#tanggal_mulai").val();
            var tanggal_selesai = $("#tanggal_selesai").val();
            var id_karyawan     = 0

            if(level_user == "1" || level_user == "4"){ // ADMIN HR DAN DIREKSI
                var id_cabang     = ($("#cabang").val() == '')?"0":$("#cabang").val();
                var id_departemen = ($("#departemen").val() == null)?"0":$("#departemen").val();
            }else if(level_user == "5"){ // KEPALA CABANG
                if(multi_cabang == '1'){
                    var id_cabang   = ($("#cabang").val() == '')?"0":$("#cabang").val();
                }else{
                    var id_cabang   = '<?= $this->id_cabang ?>';
                }
                var id_departemen   = ($("#departemen").val() == null)?"0":$("#departemen").val();
            }else if(level_user == "2"){ // KEPALA DEPARTEMEN
                var id_cabang     = '<?= $this->id_cabang ?>';
                if(multi_departemen == '1'){
                    var id_departemen   = ($("#departemen").val() == null)?"0":$("#departemen").val();
                }else{
                    var id_departemen   = '<?= $this->id_departemen ?>';
                }
            }else{
                var id_cabang       = '<?= $this->id_cabang ?>';
                var id_departemen   = '<?= $this->id_departemen ?>';
            }

            $('#view_data').load("<?= route('pengaturan.shift.data.view') ?>"+"/"+tanggal_mulai+'/'+tanggal_selesai+'/'+id_karyawan+"/"+id_cabang+"/"+id_departemen, function(){
                $("#content").show();
                loading.stop();
            });

        });
    });

    function list_data() {
        $("#content").show();
        var tgl_mulai       = (!$('#tanggal_mulai').val())?"0":$('#tanggal_mulai').val();
        var tgl_selesai     = (!$('#tanggal_selesai').val())?"0":$('#tanggal_selesai').val();
        var id_karyawan     = 0;
        var id_cabang       = 0;
        var id_departemen   = 0;

        $('#view_data').load("<?= route('pengaturan.shift.data.view') ?>"+'/'+tgl_mulai+'/'+tgl_selesai+'/'+id_karyawan+"/"+id_cabang+"/"+id_departemen);
    }


    var date_diff_indays = function(date1, date2) {
        dt1 = new Date(date1);
        dt2 = new Date(date2);
        return Math.floor((Date.UTC(dt2.getFullYear(), dt2.getMonth(), dt2.getDate()) - Date.UTC(dt1.getFullYear(), dt1.getMonth(), dt1.getDate())) / (1000 * 60 * 60 * 24));
    }

    function convert(tanggal) {
        var res = tanggal.split("/");
        return res[1] + "/" + res[0] + "/" + res[2];
    }

    function dropdown_karyawan(){
        $('#id_karyawan').select2({
            placeholder: 'Semua Karyawan',
            allowClear: true,

            ajax: {
                url: '<?= route("dropdown.karyawan") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    }

    function dropdown_cabang(){
        $('#cabang').select2({
            placeholder: 'Semua Cabang',
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.cabang") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    }

    function onchange_dropdown_cabang(){
        $("#departemen").val('').trigger('change');
        dropdown_departemen();
    }

    function dropdown_departemen(){

        var level_user          = '<?= $level_user ?>';
        var multi_cabang        = '<?= $multi_cabang ?>';

        if(level_user == "1" || level_user == "4"){ // ADMIN HR DAN DIREKSI
            var id_cabang     = (!$("#cabang").val())?"0":$("#cabang").val();
        }else{ // KEPALA CABANG
            if(multi_cabang == '1'){
                var id_cabang   = (!$("#cabang").val())?"0":$("#cabang").val();
            }else{
                var id_cabang   = '<?= $this->id_cabang ?>';
            }
        }

        $("#departemen").select2({
            placeholder: "Semua Departemen",
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.departemen.by.cabang") ?>/'+id_cabang,
                dataType: 'json',
                delay: 250,
                processResults:function(data) {
                    return {
                            results: data
                        };
                },
                cache: false
            }
        });
    }

    function tanggal() {
        var d = new Date();
        d.setDate(d.getDate()); // - 1
        $('.input-daterange input').each(function() {
            $(this).datepicker({
                orientation: "bottom",
                format: "dd-mm-yyyy",
                // endDate: d,
                autoclose: true,
            });
        });
    }

    function hide_table() {
        $("#content").hide();
    }


</script>
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Pengaturan</a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12 text-right">
            <?php
                if(in_array($this->level_user, array("1","2","5","7"))) {
            ?>
                    <a href="<?= route('pengaturan.shift.import.home') ?>">
                        <button class="btn btn-success"><i class="fa fa-upload"></i> Import Data Shift</button>
                    </a>
                    <a href="<?= route('pengaturan.shift.form').'/tambah'?>">
                        <button type="button" class="btn_tambah btn btn-biru">
                            <i class="fa fa-plus"></i> Tambah Data
                        </button>
                    </a>
            <?php } ?>
        </div>
    </div>
    <hr>
    <div id="kolom_filter" class="row">
        <div class="col-md-12">
            <div class="row">
                <div class="col-md-1">
                    <div class="form-group">
                        <label class="align-self-center">PERIODE</label>
                    </div>
                </div>
                <div class="col-md-5">
                    <div class="form-group">
                        <div class="input-group input-daterange">
                            <input type="text" class="form-control masktanggal" value="<?= $periode_awal; ?>" id="tanggal_mulai" required>
                            <div class="align-self-center">&nbsp;s/d&nbsp;</div>
                            <input type="text" class="form-control masktanggal" value="<?= $periode_akhir; ?>" id="tanggal_selesai" required>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mt-1">
                <div class="col-md-1">
                    <label>KARYAWAN</label>
                </div>
                <div class="col-md-5">
                    <select id="id_karyawan" class="form-control" multiple="multiple"></select>
                </div>
                <div class="col-md-1">
                    <button type="button" id="btn_cari" class="ladda-button btn btn-primary col-md-12" data-style="expand-left">CARI</button>
                </div>
            </div>
            <div class="row mt-1">
                <?php
                    if(in_array($level_user, array("1", "4")) || $multi_cabang == true) {
                ?>
                    <div class="col-md-1">
                        <div class="form-group">
                            <label>CABANG</label>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <select id="cabang" class="form-control" onchange="onchange_dropdown_cabang()">
                            <option></option>
                        </select>
                    </div>
                <?php } ?>

                <?php
                    if (in_array($level_user, array("1", "4", "5")) || $multi_departemen == true) {

                        if(in_array($level_user, array("1", "4"))){
                            $class = "col-md-2";
                        }else if($level_user == "5"){
                            if($multi_cabang == true){
                                $class = "col-md-2";
                            }else{
                                $class = "col-md-5";
                            }
                        }else{
                            $class = "col-md-5";
                        }
                ?>
                    <div class="col-md-1">
                        <label>DEPARTEMEN</label>
                    </div>
                    <div class="<?= $class ?>">
                        <select class="form-control" id="departemen"></select>
                    </div>
                    <div class="col-md-1">
                        <button type="button" id="btn_filter" class="ladda-button btn btn-primary col-md-12" data-style="expand-left">FILTER</button>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>
<div class="card card-rounded data_shift">
    <div class="card-content">
        <div class="card-body">
            <div class="row">
                <div id="view_data" class="col-md-12"></div>
            </div>

        </div>
    </div>
</div>