<script type="text/javascript">
    $(function() {
        // reconfigure();
        $.fn.dataTable.ext.errMode = 'throw';
        list_data = $('#list_data').DataTable({
                    'searching'   : true,
                    'searchDelay' : 1000,
                    'paging'      : true,
                    'lengthChange': true,
                    'ordering'    : true,
                    'info'        : true,
                    'scrollX'     : true,
                    'stateSave'   : true,
                    // 'scrollCollapse': true,
                    // 'fixedColumns': true,
                    'language'    :{
                                    'url'         : '<?=base_url("assets/plugins/datatables/dataTables-language-id.json")?>',
                                    'sEmptyTable' : 'Tidak ada data untuk ditampilkan',
                                    'searchPlaceholder': 'NIK/Nama Karyawan'
                                },
                    "processing"  : true,
                    "serverSide"  : true,
                    "order"       : [],

                    "ajax"        : {
                                        "url": "<?= route("payroll.master.gapok.data") ?>",
                                        "type": "POST",
                                        "complete" : function(data){
                                            reconfigure(data);
                                        }
                                    },

                    "aoColumnDefs": [
                                        { "aTargets": [0,4], "bSortable": false }
                                    ],
                    "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            $('td:eq(0)', nRow).css({'text-align':'center','width':'10px'});
                            $('td:eq(1)', nRow).css({'text-align':'left','width':'100px'});
                            $('td:eq(2)', nRow).css({'text-align':'left','width':'100px'});
                            $('td:eq(3)', nRow).css({'text-align':'right','width':'100px'});
                            $('td:eq(4)', nRow).css({'text-align':'right','width':'100px'});
                            $('td:eq(5)', nRow).css({'text-align':'center','width':'30px'});
                    }

        });

        $(document).on('click','.btn_tambah',function(){
            $('#tampil_form').load("<?= route("payroll.master.gapok.form.tambah") ?>",function(){
                $('#modal_form').modal('show');
                $(".title").text("Form Tambah Data");
                $(".btn_save").addClass("btn_save btn btn-primary");
                $(".btn_save").append('<i class="fa fa-save"></i> ');
                $(".btn_save").append('SIMPAN');
                $("#btn_new_input").hide();
            });
        });

        $(document).on('click','.btn_edit',function(){
            $('#tampil_form').load("<?= route("payroll.master.gapok.form.edit") ?>"+"/"+$(this).attr('id'),function(){
                $('#modal_form').modal('show');
                $(".title").text("Form Edit Data");
                $(".btn_save").append('<i class="fa fa-edit (alias)"></i> ');
                $(".btn_save").append('PERBARUI');
                $(".btn_save").removeClass("btn_save").addClass("btn_update btn btn-warning");
                $("#btn_new_input").hide();
            });
        });

        $(document).on('click','.btn_delete',function(){
            $('#tampil_form').load("<?= route("payroll.master.gapok.form.hapus") ?>"+"/"+$(this).attr('id'),function(){
                $('#modal_form').modal('show');
                $(".title").text("Apakah Anda ingin menghapus data ini?");
                $('#form_input input[type=text]').prop("disabled",true);
                $(".btn_save").append('<i class="fa fa-trash"></i> ');
                $(".btn_save").append('HAPUS');
                $(".btn_save").removeClass("btn_save").addClass("btn_hapus btn btn-danger");
            });
        });

        $(document).on('click','#btn_new_input', function(){
            $("#form_input #id_k").val('');
            $("#form_input #id_karyawan").val('').trigger('change');
            $('#form_input #id_karyawan').prop('disabled', false);
            $('#form_input input[type=text]').prop("disabled",false);
            $("#form_input input[type=text]").val('');

            $('.btn_save').show();
            $('#btn_new_input').hide();
            $('#message').hide();
        });

        // PROSES SAVE
        $(document).on("click",".btn_save",function(e){
            e.preventDefault();
            $('#message').html("");
            var loading = Ladda.create(this);

            var valid = formValidation();
            if (!valid) {
                return false;
            }

            loading.start();

            var param = {};
            param.id_karyawan       = $("#id_k").val();
            param.nominal_gapok     = $("#nominal_gapok").val();
            param.lembur_per_jam    = $("#lembur_per_jam").val();

            $.ajax({
                type: 'POST',
                url: "<?= route('payroll.master.gapok.save') ?>",
                data: param,
                dataType:'JSON',
                success: function(result) {
                    if(result.success == true){
                        if(result.type == 'save'){
                            $("#form_input :input").prop("disabled", true);
                            $('.btn_save').hide();
                            $('#btn_new_input').show();
                        }

                    }
                    loading.stop();
                    $('#message').show();
                    $('#message').html(result.message);
                },
                error:function(){
                    loading.stop();
                    $('#message').show();
                    $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });

        // PROSES UPDATE
        $(document).on("click",".btn_update",function(e){
            e.preventDefault();
            $('#message').html("");
            var loading = Ladda.create(this);

            var valid = formValidation();
            if (!valid) {
                return false;
            }

            loading.start();

            var param = {};
            param.id_karyawan   = $("#id_k").val();
            param.nominal_gapok = $("#nominal_gapok").val();
            param.lembur_per_jam    = $("#lembur_per_jam").val();

            $.ajax({
                type: 'POST',
                url: "<?= route('payroll.master.gapok.update') ?>",
                data: param,
                dataType:'JSON',
                success: function(result) {
                    // if(result.success == true){
                    //     if(result.type == 'update'){

                    //     }

                    // }
                    loading.stop();
                    $('#message').show();
                    $('#message').html(result.message);
                },
                error:function(){
                    loading.stop();
                    $('#message').show();
                    $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });

        // PROSES DELETE
        $(document).on('click','.btn_hapus',function(){
            var loading = Ladda.create(this);
            loading.start();

            var param = {};
            param.id_karyawan = $("#id_k").val();

            $.ajax({
                type: 'POST',
                url: "<?= route('payroll.master.gapok.delete') ?>",
                data: param,
                dataType:'JSON',
                success: function(result){
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html(result.message.replace("009900","FFFFFF"));
                },
                error:function(){
                    loading.stop();
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });

    });

    function formValidation() {
        if(($("#id_k").val()=="")){
            $('#message').show();
            $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> karyawan belum dipilih</font>");
            $("#id_karyawan").select2('open');
            return false;
        }else if($("#nominal_gapok").val() ==""){
            $('#message').show();
            $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Nominal gapok belum diiisi</font>");
            $('#nominal_gapok').focus();
            return false;
        }else{
            return true;
        }
    }
</script>
<div class="content-header mt-4">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Payroll</a></li>
                        <li class="breadcrumb-item active"><?= $judul ?></li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <?php
                if (in_array($this->level_user, array("1"))) {
            ?>
            <div class="float-md-right">
                <a href="<?= route('payroll.master.gapok.import') ?>" class="btn btn-success">
                  <i class="fa fa-upload"></i> Import Data Gapok
                </a>
                <button type="button" class="btn_tambah btn btn-biru">
                    <i class="fa fa-plus"></i> Tambah Data
                </button>
            </div>
            <?php
                }
            ?>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="table-responsive">
                <table id="list_data" class="table table-striped" style="width:100%">
                    <thead>
                        <tr>
                            <th class="text-center">NO</th>
                            <th class="text-left">NAMA KARYAWAN</th>
                            <th class="text-left">CABANG</th>
                            <th class="text-right">NOMINAL GAPOK</th>
                            <th class="text-right">LEMBUR PER JAM</th>
                            <th class="text-center">AKSI</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<div id="modal_form" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form" class="modal-content"></div>
    </div>
</div>
<!-- END TAMPIL MODAL -->
