<!-- BAGIN DATATABLE -->
<script type="text/javascript">
    $(document).ready(function() {
        $.fn.dataTableExt.sErrMode = 'none';
        list_data = $('#list_data').on('error.dt', function ( e, settings, techNote, message ) {
            if(confirm('Terjadi kesalahan saat memproses data, muat ulang halaman ?')){
                window.location.reload();
            }
        }).DataTable({
            'searching'   : false,
            'searchDelay' : 1000,
            'paging'      : true,
            'lengthChange': true,
            'ordering'    : true,
            'info'        : true,
            'scrollX'     : true,
            'fixedColumns': {
                leftColumns: 3,
                rightColumns: 1
            },
            'fixedHeader' : true,
            // 'scrollCollapse': true,
            // 'fixedColumns': true,
            'language'    :{
                            'url'         : '<?=base_url("assets/plugins/datatables/dataTables-language-id.json")?>',
                            'sEmptyTable' : 'Tidak ada data untuk ditampilkan',
                            'searchPlaceholder': 'Kode/Nama'
                        },
            "processing"  : true,
            "serverSide"  : true,
            "order"       : [],

            "ajax"        : {
                "url": "<?= route('payroll.gaji.datatable', [
                    'bulan'         => $periode,
                    'id_cabang'     => $cabang,
                    'id_departemen' => $departemen,
                    'id_karyawan'   => $karyawan
                ]) ?>",
                "type"  : "GET",
                "data"  : function (d) {
                    delete d.columns;
                },
                "complete" : function(data){
                    $(".btn_download_excel").attr("bulande",$("#filter #bulan").val());
                    reconfigure(data);
                },
            },

            "aoColumnDefs": [
                { "aTargets": "_all", "bSortable": false },
                { "targets": [1, 3, 4], "className": "align-top text-left" },
                { "targets": [0, 2, 5, -1, -2, -3, -4], "className": "align-top text-center" },
                { "targets": "_all", "className": "align-top text-right" },
            ],
            // "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
            //         $('td:eq(0)', nRow).css({'vertical-align':'top','text-align':'center','width':'50px'});
            //         $('td:eq(1)', nRow).css({'vertical-align':'top','text-align':'left','width':'150px'});
            //         $('td:eq(2)', nRow).css({'vertical-align':'top','text-align':'center','width':'100px'});
            //         $('td:eq(3)', nRow).css({'vertical-align':'top','text-align':'left','width':'150px'});
            //         $('td:eq(4)', nRow).css({'vertical-align':'top','text-align':'left','width':'200px'});
            //         $('td:eq(5)', nRow).css({'vertical-align':'top','text-align':'center','width':'200px'});
            //         $('td:eq(6)', nRow).css({'vertical-align':'top','text-align':'right','width':'100px'});
            //         $('td:eq(7)', nRow).css({'vertical-align':'top','text-align':'right','width':'100px'});
            //         $('td:eq(8)', nRow).css({'vertical-align':'top','text-align':'right','width':'100px'});
            //         $('td:eq(9)', nRow).css({'vertical-align':'top','text-align':'right','width':'100px'});
            //         $('td:eq(10)', nRow).css({'vertical-align':'top','text-align':'right','width':'100px'});
            //         $('td:eq(11)', nRow).css({'vertical-align':'top','text-align':'right','width':'100px'});
            //         $('td:eq(12)', nRow).css({'vertical-align':'top','text-align':'right','width':'100px'});
            //         $('td:eq(13)', nRow).css({'vertical-align':'top','text-align':'right','width':'100px'});
            //         $('td:eq(14)', nRow).css({'vertical-align':'top','text-align':'right','width':'100px'});
            //         $('td:eq(15)', nRow).css({'vertical-align':'top','text-align':'right','width':'100px'});
            //         $('td:eq(16)', nRow).css({'vertical-align':'top','text-align':'right','width':'100px'});
            //         $('td:eq(17)', nRow).css({'vertical-align':'top','text-align':'right','width':'100px'});
            //         $('td:eq(18)', nRow).css({'vertical-align':'top','text-align':'right','width':'100px'});
            //         $('td:eq(19)', nRow).css({'vertical-align':'top','text-align':'right','width':'100px'});
            //         $('td:eq(20)', nRow).css({'vertical-align':'top','text-align':'right','width':'100px'});
            //         $('td:eq(21)', nRow).css({'vertical-align':'top','text-align':'right','width':'100px'});
            //         $('td:eq(22)', nRow).css({'vertical-align':'top','text-align':'right','width':'100px'});
            //         $('td:eq(23)', nRow).css({'vertical-align':'top','text-align':'center','width':'100px'});
            //         $('td:eq(24)', nRow).css({'vertical-align':'top','text-align':'center','width':'100px'});
            //         $('td:eq(25)', nRow).css({'vertical-align':'top','text-align':'center','width':'100px'});
            //         $('td:eq(26)', nRow).css({'vertical-align':'top','text-align':'center','width':'100px'});
            // }
        });
    });
</script>
<!-- END DATATABLE -->
<table id="list_data" class="table table-striped table-bordered" style="width:100%">
    <thead>
        <tr class="bg-tr">
            <th rowspan="3" class="align-middle text-center" width="100">NO</th>
            <th rowspan="3" class="align-middle text-center">NAMA KARYAWAN</th>
            <th rowspan="3" class="align-middle text-center">BULAN</th>
            <th rowspan="3" class="align-middle text-center">CABANG</th>
            <th rowspan="3" class="align-middle text-center">DEPARTEMEN</th>
            <th rowspan="3" class="align-middle text-center">PERIODE</th>
            <th rowspan="3" class="align-middle text-center">GAJI POKOK</th>
            <?php
                $tunj_tetap_rows = 1;
                if (count($komponen_tunj_tetap->result()) > 0) {
                    $tunj_tetap_rows = count($komponen_tunj_tetap->result());
                }

                $tunj_tdk_tetap_rows = 1;
                if (count($komponen_tunj_tdk_tetap->result()) > 0) {
                    $tunj_tdk_tetap_rows = count($komponen_tunj_tdk_tetap->result());
                }
            ?>
            <th colspan="<?= $tunj_tetap_rows+$tunj_tdk_tetap_rows+1 ?>" class="align-middle text-center">TUNJANGAN</th>
            <th colspan="3" class="align-middle text-center">LEMBUR</th>

            <?php
                $pot_tetap_rows = 1;
                if (count($komponen_pot_tetap->result()) > 0) {
                    $pot_tetap_rows = count($komponen_pot_tetap->result());
                }
                $pot_tdk_tetap_rows = 1;
                if (count($komponen_pot_tdk_tetap->result()) > 0) {
                    $pot_tdk_tetap_rows = count($komponen_pot_tdk_tetap->result());
                }
            ?>
            <th colspan="<?= $pot_tetap_rows+$pot_tdk_tetap_rows+5 ?>" class="align-middle text-center">POTONGAN</th>
            <th rowspan="3" class="align-middle text-center">THP</th>
            <th colspan="3" class="align-middle text-center">TUNJ. DIBIAYAI PERUSAHAAN</th>
            <th colspan="3" class="align-middle text-center">PUBLISH</th>
            <th rowspan="3" class="align-middle text-center" width="150px">AKSI</th>
        </tr>
        <tr class="bg-tr">
            <!-- PENGHASILAN -->
            <th <?= 'colspan="'.$tunj_tetap_rows.'" ' ?> class="align-middle text-center">TETAP</th>
            <th <?= 'colspan="'.$tunj_tdk_tetap_rows.'" ' ?> class="align-middle text-center">TIDAK TETAP</th>
            <th rowspan="2" class="align-middle text-center">TOTAL</th>

            <th rowspan="2" class="align-middle text-center">TOTAL MENIT</th>
            <th rowspan="2" class="align-middle text-center">PER JAM</th>
            <th rowspan="2" class="align-middle text-center">TOTAL</th>

            <!-- PENGURANGAN -->
            <th <?= 'colspan="'.$pot_tetap_rows.'" ' ?> class="align-middle text-center">TETAP</th>
            <th <?= 'colspan="'.$pot_tdk_tetap_rows.'" ' ?> class="align-middle text-center">TIDAK TETAP</th>

            <th rowspan="2" class="align-middle text-center">BPJS KES.</th>
            <th rowspan="2" class="align-middle text-center">BPJS TK</th>
            <th rowspan="2" class="align-middle text-center">ABSENSI</th>
            <th rowspan="2" class="align-middle text-center">PPH 21</th>
            <th rowspan="2" class="align-middle text-center">TOTAL</th>

            <th rowspan="2" class="align-middle text-center">BPJS KES.</th>
            <th rowspan="2" class="align-middle text-center">BPJS TK</th>
            <th rowspan="2" class="align-middle text-center">TOTAL</th>

            <th rowspan="2" class="align-middle text-center">JADWAL</th>
            <th rowspan="2" class="align-middle text-center">TANGGAL</th>
            <th rowspan="2" class="align-middle text-center">STATUS</th>
        </tr>
        <tr class="bg-tr">
            <!-- PENGHASILAN -->
            <?php
                if ($tunj_tetap_rows > 1) {
                    foreach($komponen_tunj_tetap->result() as $row) {
                        echo '<th class="align-top text-center">'.strtoupper($row->nm_komponen).'</th>';
                    }
                }else{
                    echo '<th class="align-top text-center"></th>';
                }
            ?>
            <?php
                if ($tunj_tdk_tetap_rows > 1) {
                    foreach($komponen_tunj_tdk_tetap->result() as $row) {
                        echo '<th class="align-top text-center">'.strtoupper($row->nm_komponen).'</th>';
                    }
                }else{
                    echo '<th class="align-top text-center"></th>';
                }
            ?>

            <!-- PENGURANGAN -->
            <?php
                if ($pot_tetap_rows > 1) {
                    foreach($komponen_pot_tetap->result() as $row) {
                        echo '<th class="align-top text-center">'.strtoupper($row->nm_komponen).'</th>';
                    }
                }else{
                    echo '<th class="align-top text-center"></th>';
                }
            ?>
            <?php
                if ($pot_tdk_tetap_rows > 1) {
                    foreach($komponen_pot_tdk_tetap->result() as $row) {
                        echo '<th class="align-top text-center">'.strtoupper($row->nm_komponen).'</th>';
                    }
                }else{
                    echo '<th class="align-top text-center"></th>';
                }
            ?>
        </tr>
    </thead>
    <tbody>
    </tbody>
</table>
