<script type="text/javascript">
    $(function(){
        $("#form_hitung #bulan").inputmask({'alias':'datetime','inputFormat': 'mm-yyyy'});
        $("#form_hitung #periode_mulai, #periode_selesai").inputmask({'alias':'datetime','inputFormat': 'dd-mm-yyyy'});


        $("#form_hitung #periode_mulai, #periode_selesai").datepicker( {
            format: "dd-mm-yyyy",
            orientation: "bottom",
            todayHighlight: true,
            autoclose: true,
            endDate: "today"
        });


        $("#form_hitung #bulan").datepicker({
            format: "mm-yyyy",
            viewMode: "months",
            orientation: 'bottom',
            minViewMode: "months",
            autoclose: true,
            endDate: "today"
        });

        $("#form_hitung #id_cabang").select2({
            placeholder: 'Semua Cabang',
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.cabang") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            }
        });


        $("#form_hitung #id_departemen").select2({
            placeholder: "Semua Departemen",
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.departemen") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            }
        });

        $("#form_hitung #id_karyawan").select2({
            placeholder: "Semua Karyawan",
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.karyawan.encrypt") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            }
        });
    });
</script>

<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>
<div id="form_hitung" class="card-body" disabled>
    <div class="form-group">
        <label>Gaji untuk bulan <span class="text-danger">*</span></label>
        <input type="text" id="bulan" class="form-control" autocomplete="off" placeholder="mm-yyyy" spellcheck="false">
    </div>

    <div class="row mt-2 mb-2">
        <div class="col-md-6">
            <label>Periode Mulai <span class="text-danger">*</span></label>
            <input type="text" id="periode_mulai" class="form-control" autocomplete="off" placeholder="dd-mm-yyyy" spellcheck="false">
        </div>
        <div class="col-md-6">
            <label>Periode Selesai <span class="text-danger">*</span></label>
            <input type="text" id="periode_selesai" class="form-control" autocomplete="off" placeholder="dd-mm-yyyy" spellcheck="false">
        </div>
    </div>
    <div class="form-group">
        <label>Cabang</label>
        <select id="id_cabang" class="form-control" style="width: 100%;">
        </select>
    </div>

    <div class="form-group">
        <label>Departemen</label>
        <select id="id_departemen" class="form-control" style="width: 100%;">
        </select>
    </div>

    <div class="form-group">
        <label>Karyawan</label>
        <select id="id_karyawan" class="form-control" style="width: 100%;">
        </select>
    </div>
</div>
<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <button id="btn_new_input" class="btn" style="display:none">TAMBAH BARU</button>
            <button class="btn_proses_hitung ladda-button" data-style="expand-left"></button>
        </div>
    </div><!-- ./row -->
</div>
