<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/responsive/2.4.1/css/responsive.dataTables.min.css">
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        </li>
                        <li class="breadcrumb-item"><a href="#">PAYROLL</a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <ul class="nav nav-tabs">
                <li class="nav-item">
                    <a class="nav-link" href="<?= route('payroll.bpjs'); ?>">Config</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link active" href="#">Master</a>
                </li>
            </ul>
            <div id="content">
                <div class="row mt-1">
                    <div class="col-md-8">
                        <form id="filter">
                            <div class="form-group row">
                                <label for="karyawan" class="col-sm-2 col-form-label">KARYAWAN</label>
                                <div class="col-sm-8">
                                    <select id="karyawan" class="form-control" style="width: 100%;"></select>
                                </div>
                                <div class="col-sm-2">
                                    <button class="btn btn-primary" onclick="cari(); return false;">CARI</button>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="cabang" class="col-sm-2 col-form-label">CABANG</label>
                                <div class="col-sm-3">
                                    <select id="cabang" class="form-control"></select>
                                </div>
                                <label for="departemen" class="col-sm-2 col-form-label">DEPARTEMEN</label>
                                <div class="col-sm-3">
                                    <select id="departemen" class="form-control"></select>
                                </div>
                                <div class="col-sm-2">
                                    <button class="btn btn-primary" onclick="filter(); return false;">FILTER</button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-md-4 text-right">
                        <a href="<?= route('payroll.bpjs.master.import') ?>" class="btn btn-success">
                            <i class="fa fa-upload"></i> Import Data BPJS
                        </a>
                        <button class="btn btn-biru" onclick="tambah();"><i class="fa fa-plus"></i> TAMBAH DATA</button>
                    </div>
                </div>
                <div class="row">
                    <table id="list_data" class="table responsive">
                        <thead>
                            <tr>
                                <th rowspan="2" style="width: 50px;">NO</th>
                                <th rowspan="2" style="width: 150px;">KARYAWAN</th>
                                <th rowspan="2">GAJI DIDAFTARKAN</th>
                                <th colspan="4">BPJS KESEHATAN</th>
                                <th colspan="7">BPJS KETENAGAKERJAAN</th>
                                <th rowspan="2">TOTAL POT.</th>
                                <th rowspan="2">TOTAL TUNJ.</th>
                                <th rowspan="2" style="width: 50px;">AKSI</th>
                            </tr>
                            <tr>
                                <!-- bpjs kes -->
                                <th>NOMOR</th>
                                <th>JML ANAK</th>
                                <th>TUNJ. PERUS (<?= $data_bpjs_kes->tunj_perus ?> %)</th>
                                <th>POT. KRY (<?= $data_bpjs_kes->pot_kry ?> %)</th>
                                <!-- bpjs tk -->
                                <th>NOMOR</th>
                                <th>TUNJ. JHT PERUS (<?= $data_bpjs_tk->tunj_jht_perus ?> %)</th>
                                <th>POT. JHT KRY (<?= $data_bpjs_tk->pot_jht_kry ?> %)</th>
                                <th>TUNJ. JKK (<?= $data_bpjs_tk->tunj_jkk ?> %)</th>
                                <th>TUNJ. JKM (<?= $data_bpjs_tk->tunj_jkm ?> %)</th>
                                <th>TUNJ. JP PERUS (<?= $data_bpjs_tk->tunj_jp_perus ?> %)</th>
                                <th>POT. JP KRY (<?= $data_bpjs_tk->pot_jp_kry ?> %)</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- START TAMPIL MODAL -->
<div id="modal_form_bpjs_m" class="modal fade in" data-keyboard="false" data-backdrop="static" aria-hidden="true">
    <div class="modal-dialog modal-lg" style="max-width: 80%;">
        <div id="tampil_form_bpjs_m" class="modal-content"></div>
    </div>
</div>
<!-- END TAMPIL MODAL -->
<script>
    $(function() {

        list_data = $('#list_data').DataTable({
            'searching': true,
            'searchDelay': 1000,
            'paging': true,
            'lengthChange': true,
            'ordering': true,
            'info': true,
            'scrollX': true,
            'fixedColumns': {
                leftColumns: 3,
                rightColumns: 3
            },
            'language': {
                'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                'searchPlaceholder': 'NIK/Nama'
            },
            "processing": true,
            "serverSide": true,
            "order": [],
            "ajax": {
                "url": "<?= route('payroll.bpjs.master.list-data') ?>",
                "data": function(d) {
                    d.karyawan = $('#karyawan').val();
                    d.cabang = $('#cabang').val();
                    d.departemen = $('#departemen').val();
                },
                "type": "GET",
                "complete": function(data) {
                    reconfigure(data);
                }
            },

            "aoColumnDefs": [{
                    "aTargets": [0, -1],
                    "bSortable": false
                },
                {
                    targets: [0, 1],
                    className: 'text-left'
                },
                {
                    targets: '_all',
                    className: 'text-center'
                }
            ],
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(-1)', nRow).css({
                    'text-align': 'center'
                });
            }

        });

        $('#filter #karyawan').select2({
            placeholder: 'Semua Karyawan',
            allowClear: true,
            ajax: {
                url: '<?= route("laporan.absensi.dropdown.karyawan") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });

        $('#filter #cabang').select2({
            placeholder: 'Semua Cabang',
            allowClear: true,
            ajax: {
                url: '<?= route("laporan.absensi.dropdown.cabang") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });

        $('#cabang').on('change', function(e) {
            $("#filter #departemen").select2({
                placeholder: "Semua Departemen",
                allowClear: true,
                ajax: {
                    url: '<?= route("laporan.absensi.dropdown.departemen") ?>/' + $(this).val(),
                    dataType: 'json',
                    delay: 250,
                    processResults: function(data) {
                        return {
                            results: data
                        };
                    },
                    cache: false
                }
            });
        });

        $(document).on('click', '.btn_save', function() {
            $('#message').html("");

            var karyawan = $('#form_input #karyawan');
            var gaji_daftar = $('#gaji_daftar').val();

            if (karyawan.length == 1) {
                if (karyawan.val() == null) {
                    $('#message').html('<span class="text-danger"><i class="fa fa-exclamation-triangle"></i> karyawan belum dipilih</span>');
                    return false;
                }
            } else if (gaji_daftar == '') {
                $('#message').html('<span class="text-danger"><i class="fa fa-exclamation-triangle"></i> gaji yang didaftarkan belum diisi</span>');
                return false;
            }

            var loading = Ladda.create(this);
            loading.start();
            $.post('<?= route("payroll.bpjs.master.save"); ?>', $('#form_input').serialize(), function(response) {
                if (response.success == true) {
                    if (response.type == 'save') {
                        $('.btn_save').hide();
                        $('#btn_new_input').show();
                    }
                    list_data.ajax.reload();
                }
                loading.stop();
                $('#message').html(response.message);
            }, 'json');
        });

        $(document).on('click', '#btn_new_input', function() {
            $("#form_input .nominal_normal").autoNumeric('set', '0');
            $("#form_input p.nominal_text, #form_input .nominal").autoNumeric('set', '0.00');
            $("#form_input #jml_anak").val('0');
            $("#form_input #no_bpjs_kes, #form_input #no_bpjs_tk").html('');
            $('#form_input #karyawan').val(null).trigger('change');

            $('.btn_save').show();
            $('#btn_new_input').hide();
            $('#message').html('');
        });

        $(document).on('click', '.btn_hapus', function() {
            var loading = Ladda.create(this);
            loading.start();

            $.ajax({
                type: 'POST',
                url: "<?php echo route('payroll.bpjs.master.delete') ?>",
                data: $('#form_input').serialize(),
                dataType: 'JSON',
                success: function(result) {
                    $("#modal_form_bpjs_m .card-body").hide();
                    $("#modal_form_bpjs_m .card-footer").hide();
                    $("#modal_form_bpjs_m .title").html(result.message);
                    list_data.ajax.reload();
                },
                error: function() {
                    loading.stop();
                    $("#modal_form_bpjs_m .card-body").hide();
                    $("#modal_form_bpjs_m .card-footer").hide();
                    $("#modal_form_bpjs_m .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });
    });

    function cari() {
        $('#cabang, #departemen').val(null).trigger('change');
    }

    function filter() {
        $('#karyawan').val(null).trigger('change');
    }

    function initAutoNumeric() {
        $('#form_input .nominal_normal').autoNumeric('init', {
            aSep: '.',
            aDec: ',',
            vMin: '0',
            vMax: '999999999'
        });
        $('#form_input .nominal_normal_rp').autoNumeric('init', {
            aSep: '.',
            aDec: ',',
            aSign: 'Rp. ',
            vMin: '0',
            vMax: '999999999'
        });
        $('#form_input .nominal').autoNumeric('init', {
            aSep: '.',
            aDec: ','
        });
        $('#form_input .nominal_text').autoNumeric('init', {
            aSep: '.',
            aDec: ',',
            aSign: 'Rp. '
        });
    }

    function tambah() {
        $('#tampil_form_bpjs_m').load("<?= site_url('payroll/bpjs/master/form/tambah') ?>", function() {
            $('#modal_form_bpjs_m').modal('show');
            $(".title").text("Form Tambah Data");
            $(".btn_save").addClass("btn_save btn btn-primary");
            $(".btn_save").append('<i class="fa fa-save"></i> ');
            $(".btn_save").append('SIMPAN');
            $("#btn_new_input").hide();

            initAutoNumeric();

            form_select_karyawan();
            onchange_form_select_karyawan();
            on_keyup_gaji_didaftakan();
            on_key_up_jml_anak();
        });
    }

    function edit(id_karyawan) {
        $('#tampil_form_bpjs_m').load("<?= site_url('payroll/bpjs/master/form/edit') ?>/" + id_karyawan, function() {
            $('#modal_form_bpjs_m').modal('show');
            $(".title").text("Form Edit Data");
            $(".btn_save").addClass("btn_save btn btn-warning");
            $(".btn_save").append('<i class="fa fa-edit (alias)"></i> ');
            $(".btn_save").append('PERBARUI');
            $("#btn_new_input").hide();

            initAutoNumeric();

            on_keyup_gaji_didaftakan();
            on_key_up_jml_anak();
        });
    }

    function hapus(id_karyawan) {
        $('#tampil_form_bpjs_m').load("<?= site_url('payroll/bpjs/master/form/hapus') ?>/" + id_karyawan, function() {
            $('#modal_form_bpjs_m').modal('show');
            $(".title").text("Apakah Anda ingin menghapus data ini?");
            $('#form_input input:not(#id)').prop("disabled", true);
            $(".btn_save").append('<i class="fa fa-trash"></i> ');
            $(".btn_save").append('HAPUS');
            $(".btn_save").removeClass("btn_save").addClass("btn_hapus btn btn-danger");

            initAutoNumeric();
        });
    }

    function form_select_karyawan() {
        $('#form_input #karyawan').select2({
            placeholder: 'Pilih Karyawan',
            dropdownParent: $('#tampil_form_bpjs_m'),
            allowClear: true,
            ajax: {
                url: '<?= route("laporan.absensi.dropdown.karyawan") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    }

    // select2 form karyawan

    function onchange_form_select_karyawan() {
        $('#form_input #karyawan').on('change', function(e) {
            $.get('<?= route("payroll.bpjs.master.get-data"); ?>', {
                id_karyawan: $(this).val()
            }, function(response) {
                $('#form_input #gapok, #form_input #gapok_text').autoNumeric('set', response.gapok);
                $('#form_input #tunj_daftar, #form_input #tunj_daftar_text').autoNumeric('set', response.tunj_tetap);
                $('#form_input #no_bpjs_kes').html(response.no_bpjs_kes);
                $('#form_input #no_bpjs_tk').html(response.no_bpjs_tk);
                $('#form_input #jml_anak').val(response.jml_anak);
                set_gaji_didaftarkan();
                set_bpjs_kes_tunj_perus();
                set_bpjs_kes_pot_kry();
                set_bpjs_tk_tunj_jht_perus();
                set_bpjs_tk_pot_jht_kry();
                set_bpjs_tk_tunj_jkk();
                set_bpjs_tk_tunj_jkm();
                set_bpjs_tk_tunj_jp_perus();
                set_bpjs_tk_pot_jp_kry();
                set_ttl_pot_kry();
                set_ttl_dibiayai_perus();
            }, 'json');
        });
    }

    // gaji didaftarkan

    function on_keyup_gaji_didaftakan() {
        $('#form_input #gaji_daftar').on('keyup', function() {
            set_bpjs();
        });
    }

    function set_bpjs() {
        set_bpjs_kes_tunj_perus();
        set_bpjs_kes_pot_kry();
        set_bpjs_tk_tunj_jht_perus();
        set_bpjs_tk_pot_jht_kry();
        set_bpjs_tk_tunj_jkk();
        set_bpjs_tk_tunj_jkm();
        set_bpjs_tk_tunj_jp_perus();
        set_bpjs_tk_pot_jp_kry();
        set_ttl_pot_kry();
        set_ttl_dibiayai_perus();
    }

    function hitung_gaji_didaftarkan() {
        var gapok = $('#form_input #gapok_text').autoNumeric('get');
        var tunj_daftar = $('#form_input #tunj_daftar_text').autoNumeric('get');
        return gapok + tunj_daftar;
    }

    function set_gaji_didaftarkan() {
        var gaji_daftar = hitung_gaji_didaftarkan();
        $('#form_input #gaji_daftar').autoNumeric('set', gaji_daftar);
    }

    function get_gaji_didaftarkan() {
        return $('#form_input #gaji_daftar').autoNumeric('get');
    }

    // bpjs kesehatan
    function hitung_bpjs_kes_tunj_perus() {
        var bpjs_kes_flag = $('#form_input #bpjs_kes_flag').val();
        if (bpjs_kes_flag == 0) {
            return 0;
        } else {
            var gaji_daftar = aturan_maksimal_gaji_bpjs_kes(get_gaji_didaftarkan());
            var bpjs_kes_tunj_perus = $('#form_input #bpjs_kes_tunj_perus').val();
            return gaji_daftar * (bpjs_kes_tunj_perus / 100);
        }
    }

    function aturan_maksimal_gaji_bpjs_kes(gaji) {
        if (gaji > 12000000) {
            return 12000000;
        } else {
            return gaji;
        }
    }

    function set_bpjs_kes_tunj_perus() {
        var bpjs_kes_tunj_perus = hitung_bpjs_kes_tunj_perus();
        $('#form_input #bpjs_kes_tunj_perus_rp, #form_input #bpjs_kes_tunj_perus_rp_text').autoNumeric('set', bpjs_kes_tunj_perus);
    }

    function hitung_bpjs_kes_pot_kry() {
        var bpjs_kes_flag = $('#form_input #bpjs_kes_flag').val();
        if (bpjs_kes_flag == 0) {
            return 0;
        } else {
            var gaji_daftar = aturan_maksimal_gaji_bpjs_kes(get_gaji_didaftarkan());
            var bpjs_kes_pot_kry = $('#form_input #bpjs_kes_pot_kry').val();
            var jml_anak = $('#form_input #jml_anak').val();
            if (jml_anak > 3) { //jika jumlh anak lebih dari 3
                return gaji_daftar * ((jml_anak - 2) / 100);
            } else {
                return gaji_daftar * (bpjs_kes_pot_kry / 100);
            }
        }
    }

    function set_bpjs_kes_pot_kry() {
        var bpjs_kes_pot_kry = hitung_bpjs_kes_pot_kry();
        $('#form_input #bpjs_kes_pot_kry_rp, #form_input #bpjs_kes_pot_kry_rp_text').autoNumeric('set', bpjs_kes_pot_kry);
    }

    function on_key_up_jml_anak() {
        $('#form_input #jml_anak').on('keyup mouseup', function() {
            set_bpjs_kes_pot_kry();
            set_ttl_pot_kry();
            set_ttl_dibiayai_perus();
        });
    }

    // bpjs ketenagakerjaan

    function hitung_bpjs_tk_tunj_jht_perus() {
        var bpjs_tk_flag_jht = $('#form_input #bpjs_tk_flag_jht').val();
        if (bpjs_tk_flag_jht == 0) {
            return 0;
        } else {
            var gaji_daftar = get_gaji_didaftarkan();
            var bpjs_tk_tunj_jht_perus = $('#form_input #bpjs_tk_tunj_jht_perus').val();
            return gaji_daftar * (bpjs_tk_tunj_jht_perus / 100);
        }
    }

    function set_bpjs_tk_tunj_jht_perus() {
        var bpjs_tk_tunj_jht_perus = hitung_bpjs_tk_tunj_jht_perus();
        $('#form_input #bpjs_tk_tunj_jht_perus_rp, #form_input #bpjs_tk_tunj_jht_perus_rp_text').autoNumeric('set', bpjs_tk_tunj_jht_perus);
    }

    function hitung_bpjs_tk_pot_jht_kry() {
        var bpjs_tk_flag_jht = $('#form_input #bpjs_tk_flag_jht').val();
        if (bpjs_tk_flag_jht == 0) {
            return 0;
        } else {
            var gaji_daftar = get_gaji_didaftarkan();
            var bpjs_tk_pot_jht_kry = $('#form_input #bpjs_tk_pot_jht_kry').val();
            return gaji_daftar * (bpjs_tk_pot_jht_kry / 100);
        }
    }

    function set_bpjs_tk_pot_jht_kry() {
        var bpjs_tk_pot_jht_kry = hitung_bpjs_tk_pot_jht_kry();
        $('#form_input #bpjs_tk_pot_jht_kry_rp, #form_input #bpjs_tk_pot_jht_kry_rp_text').autoNumeric('set', bpjs_tk_pot_jht_kry);
    }

    function hitung_bpjs_tk_tunj_jkk() {
        var bpjs_tk_flag_jkk = $('#form_input #bpjs_tk_flag_jkk').val();
        if (bpjs_tk_flag_jkk == 0) {
            return 0;
        } else {
            var gaji_daftar = get_gaji_didaftarkan();
            var bpjs_tk_tunj_jkk = $('#form_input #bpjs_tk_tunj_jkk').val();
            return gaji_daftar * (bpjs_tk_tunj_jkk / 100);
        }
    }

    function set_bpjs_tk_tunj_jkk() {
        var bpjs_tk_tunj_jkk = hitung_bpjs_tk_tunj_jkk();
        $('#form_input #bpjs_tk_tunj_jkk_rp, #form_input #bpjs_tk_tunj_jkk_rp_text').autoNumeric('set', bpjs_tk_tunj_jkk);
    }

    function hitung_bpjs_tk_tunj_jkm() {
        var bpjs_tk_flag_jkm = $('#form_input #bpjs_tk_flag_jkm').val();
        if (bpjs_tk_flag_jkm == 0) {
            return 0;
        } else {
            var gaji_daftar = get_gaji_didaftarkan();
            var bpjs_tk_tunj_jkm = $('#form_input #bpjs_tk_tunj_jkm').val();
            return gaji_daftar * (bpjs_tk_tunj_jkm / 100);
        }
    }

    function set_bpjs_tk_tunj_jkm() {
        var bpjs_tk_tunj_jkm = hitung_bpjs_tk_tunj_jkm();
        $('#form_input #bpjs_tk_tunj_jkm_rp, #form_input #bpjs_tk_tunj_jkm_rp_text').autoNumeric('set', bpjs_tk_tunj_jkm);
    }

    function aturan_maksimal_gaji_bpjs_tk_jp(gaji) {
        if (gaji > 9559600) {
            return 9559600;
        } else {
            return gaji;
        }
    }

    function hitung_bpjs_tk_tunj_jp_perus() {
        var bpjs_tk_flag_jp = $('#form_input #bpjs_tk_flag_jp').val();
        if (bpjs_tk_flag_jp == 0) {
            return 0;
        } else {
            var gaji_daftar = aturan_maksimal_gaji_bpjs_tk_jp(get_gaji_didaftarkan());
            var bpjs_tk_tunj_jp_perus = $('#form_input #bpjs_tk_tunj_jp_perus').val();
            return gaji_daftar * (bpjs_tk_tunj_jp_perus / 100);
        }
    }

    function set_bpjs_tk_tunj_jp_perus() {
        var bpjs_tk_tunj_jp_perus = hitung_bpjs_tk_tunj_jp_perus();
        $('#form_input #bpjs_tk_tunj_jp_perus_rp, #form_input #bpjs_tk_tunj_jp_perus_rp_text').autoNumeric('set', bpjs_tk_tunj_jp_perus);
    }

    function hitung_bpjs_tk_pot_jp_kry() {
        var bpjs_tk_flag_jp = $('#form_input #bpjs_tk_flag_jp').val();
        if (bpjs_tk_flag_jp == 0) {
            return 0;
        } else {
            var gaji_daftar = aturan_maksimal_gaji_bpjs_tk_jp(get_gaji_didaftarkan());
            var bpjs_tk_pot_jp_kry = $('#form_input #bpjs_tk_pot_jp_kry').val();
            return gaji_daftar * (bpjs_tk_pot_jp_kry / 100);
        }
    }

    function set_bpjs_tk_pot_jp_kry() {
        var bpjs_tk_pot_jp_kry = hitung_bpjs_tk_pot_jp_kry();
        $('#form_input #bpjs_tk_pot_jp_kry_rp, #form_input #bpjs_tk_pot_jp_kry_rp_text').autoNumeric('set', bpjs_tk_pot_jp_kry);
    }

    function hitung_ttl_pot_kry() {
        var bpjs_kes_flag = $('#form_input #bpjs_kes_flag').val();
        var bpjs_tk_flag_jht = $('#form_input #bpjs_tk_flag_jht').val();
        var bpjs_tk_flag_jp = $('#form_input #bpjs_tk_flag_jp').val();

        var bpjs_kes_pot_kry = 0;
        var bpjs_tk_pot_jht_kry = 0;
        var bpjs_tk_pot_jp_kry = 0;

        if (bpjs_kes_flag == 1) {
            bpjs_kes_pot_kry = $('#form_input #bpjs_kes_pot_kry_rp_text').autoNumeric('get');
        }
        if (bpjs_tk_flag_jht == 1) {
            bpjs_tk_pot_jht_kry = $('#form_input #bpjs_tk_pot_jht_kry_rp_text').autoNumeric('get');
        }
        if (bpjs_tk_flag_jp == 1) {
            bpjs_tk_pot_jp_kry = $('#form_input #bpjs_tk_pot_jp_kry_rp_text').autoNumeric('get');
        }

        return bpjs_kes_pot_kry + bpjs_tk_pot_jht_kry + bpjs_tk_pot_jp_kry;
    }

    function set_ttl_pot_kry() {
        var ttl_pot_kry = hitung_ttl_pot_kry();
        $('').val();
        $('#form_input #ttl_pot_kry, #form_input #ttl_pot_kry_text').autoNumeric('set', ttl_pot_kry);
    }

    function hitung_ttl_dibiayai_perus() {
        var bpjs_kes_flag = $('#form_input #bpjs_kes_flag').val();
        var bpjs_tk_flag_jht = $('#form_input #bpjs_tk_flag_jht').val();
        var bpjs_tk_flag_jkk = $('#form_input #bpjs_tk_flag_jkk').val();
        var bpjs_tk_flag_jkm = $('#form_input #bpjs_tk_flag_jkm').val();
        var bpjs_tk_flag_jp = $('#form_input #bpjs_tk_flag_jp').val();

        var bpjs_kes_tunj_perus = 0;
        var bpjs_tk_tunj_jht_perus = 0;
        var bpjs_tk_tunj_jkk = 0;
        var bpjs_tk_tunj_jkm = 0;
        var bpjs_tk_tunj_jp_perus = 0;

        if (bpjs_kes_flag == 1) {
            bpjs_kes_tunj_perus = $('#form_input #bpjs_kes_tunj_perus_rp_text').autoNumeric('get');
        }
        if (bpjs_tk_flag_jht == 1) {
            bpjs_tk_tunj_jht_perus = $('#form_input #bpjs_tk_tunj_jht_perus_rp_text').autoNumeric('get');
        }
        if (bpjs_tk_flag_jkk == 1) {
            bpjs_tk_tunj_jkk = $('#form_input #bpjs_tk_tunj_jkk_rp_text').autoNumeric('get');
        }
        if (bpjs_tk_flag_jkm == 1) {
            bpjs_tk_tunj_jkm = $('#form_input #bpjs_tk_tunj_jkm_rp_text').autoNumeric('get');
        }
        if (bpjs_tk_flag_jp == 1) {
            bpjs_tk_tunj_jp_perus = $('#form_input #bpjs_tk_tunj_jp_perus_rp_text').autoNumeric('get');
        }

        return bpjs_kes_tunj_perus + bpjs_tk_tunj_jht_perus + bpjs_tk_tunj_jkk + bpjs_tk_tunj_jkm + bpjs_tk_tunj_jp_perus;
    }

    function set_ttl_dibiayai_perus() {
        var ttl_dibiayai_perus = hitung_ttl_dibiayai_perus();
        $('').val(ttl_dibiayai_perus);
        $('#form_input #ttl_tunj_dibiayai_perus, #form_input #ttl_tunj_dibiayai_perus_text').autoNumeric('set', ttl_dibiayai_perus);
    }
</script>
