<div class="row">
    <div class="col-md-3">
        <label>Nama Karyawan</label>
        <select id="karyawan" class="select2 form-control" style="width: 100%;">
        </select>
    </div>
    <div class="col-md-2 align-self-end">
        <button type="button" id="btn_cari_tabs_pendidikan" class="btn btn-info ladda-button" data-style="expand-left">CARI</button>
    </div>
</div>

<div class="row mt-2">
    <div class="col-md-3">
        <label>Jabatan</label>
        <select id="jabatan" class="select2 form-control" style="width: 100%;"></select>
    </div>
    <?php
        if(in_array($this->level_user, array("1", "4")) || $this->multi_cabang == true) {
    ?>
            <div class="col-md-3">
                <label>Cabang</label>
                <select id="cabang" class="select2 form-control" style="width: 100%;">
                </select>
            </div>
    <?php
        }

        if (in_array($this->level_user, array("1", "4", "5")) || $this->multi_departemen == true) {
    ?>
            <div class="col-md-3">
                <label>Departemen</label>
                <select id="departemen" class="select2 form-control" style="width: 100%;">
                </select>
            </div>
    <?php } ?>
    <div class="col-md-2">
        <label>Pendidikan Terakhir</label>
        <select id="pendidikan_terakhir" class="form-control">
            <option value="0">Semua</option>
            <option value="SD">SD/MI</option>
            <option value="SMP">SMP/MTS</option>
            <option value="SMA">SMA/SMK</option>
            <option value="D3">D3</option>
            <option value="D4">D4</option>
            <option value="S1">S1</option>
            <option value="S2">S2</option>
            <option value="S3">S3</option>
        </select>
    </div>
    <div class="col-md-1 align-self-end">
        <button type="button" id="btn_filter_tabs_pendidikan" class="btn btn-info ladda-button" data-style="expand-left">FILTER</button>
    </div>
</div>
<div class="row mt-1">
    <div class="col-md-12 table-responsive">
        <table id="list_data" class="table table-striped" style="width:100%">
            <thead>
                <tr>
                    <th>NO</th>
                    <th>FOTO</th>
                    <th width="15%" class="text-left">KARYAWAN</th>
                    <th class="text-left">CABANG</th>
                    <th class="text-left">DEPARTEMEN</th>
                    <th class="text-left">JABATAN</th>
                    <th>PENDIDIKAN TERAKHIR</th>
                    <th>AKSI</th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>
</div>
<script type="text/javascript">
    $(function() {
        var id_cabang       = ($("#cabang").val() == null)?"0":$("#cabang").val();
        var id_departemen   = ($("#departemen").val() == null)?"0":$("#departemen").val();
        var id_jabatan      = ($("#jabatan").val() == null)?"0":$("#jabatan").val();
        var pendidikan      = $("#pendidikan_terakhir").val();
        var id_karyawan     = 0;

        list_data = $('#list_data').DataTable({
                    'searching'   : false,
                    'searchDelay' : 250,
                    'paging'      : true,
                    'lengthChange': true,
                    'ordering'    : true,
                    'info'        : true,
                    'scrollX'     : true,
                    // 'scrollCollapse': true,
                    // 'fixedColumns': true,
                    'language'    :{
                                    'url'         : '<?=base_url("assets/plugins/datatables/dataTables-language-id.json")?>',
                                    'sEmptyTable' : 'Tidak ada data untuk ditampilkan'
                                },
                    "processing"  : true,
                    "serverSide"  : true,
                    "order"       : [],

                    "ajax"        : {
                                        "url": "<?= route('master.karyawan.tabs.content.pendidikan') ?>"+"/filter/"+id_cabang+"/"+id_departemen+"/"+id_jabatan+"/"+pendidikan+"/"+id_karyawan,
                                        "type": "GET",
                                        "complete" : function(data){
                                                reconfigure(data);
                                        }
                                    },

                    "aoColumnDefs": [
                                        { "aTargets": [0], "bSortable": false },
                                        { "aTargets": [1], "bSortable": false },
                                        { "aTargets": [7], "bSortable": false }
                                    ],
                    "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            $('td:eq(0)', nRow).css({'text-align':'center','width':'10px'});
                            $('td:eq(1)', nRow).css({'text-align':'center','width':'10px'});
                            $('td:eq(6)', nRow).css({'text-align':'center'});
                            $('td:eq(7)', nRow).css({'text-align':'center','width':'50'});
                    }

        });

        $('#karyawan').select2({
            placeholder: 'Semua Karyawan',
            allowClear: true,
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.karyawan.aktif")  ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return{
                        results: data
                    };
                },
                cache: false
            },
        minLength: 3
        });

        departemen();
        jabatan();

        $('#cabang').select2({
            placeholder: 'Semua Cabang',
            allowClear: true,
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.cabang")  ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return{
                        results: data
                    };
                },
                cache: false
            },
        minLength: 3
        });

        $('#cabang').change(function(){
            $('#departemen').val('0').trigger("change");
            // $('#jabatan').val('0').trigger("change");
            departemen();
        });

        // $('#departemen').change(function(){
        //     $('#jabatan').val('0').trigger("change");
        //     jabatan();
        // });

        $('#btn_cari_tabs_pendidikan').click(function(){
            var loading = Ladda.create(this);
            loading.start();

            var id_cabang       = 0;
            var id_departemen   = 0;
            var id_jabatan      = 0;
            var pendidikan      = 0;
            var id_karyawan     = ($("#karyawan").val() == null)?"0":$("#karyawan").val();

            list_data.ajax.url("<?= route('master.karyawan.tabs.content.pendidikan') ?>"+"/cari/"+id_cabang+"/"+id_departemen+"/"+id_jabatan+"/"+pendidikan+"/"+id_karyawan)
            list_data.ajax.reload(function(){
                loading.stop();
            });
        });

        $('#btn_filter_tabs_pendidikan').click(function(){
            var loading = Ladda.create(this);
            loading.start();

            var level_user          = '<?= $this->level_user ?>';
            var multi_departemen    = '<?= $this->multi_departemen ?>';
            var multi_cabang        = '<?= $this->multi_cabang ?>';

            var id_jabatan      = ($("#jabatan").val() == null)?"0":$("#jabatan").val();
            var pendidikan      = $("#pendidikan_terakhir").val();
            var id_karyawan     = 0;

            if(level_user == "3"){
                var id_karyawan = "<?= $this->id_karyawan ?>";
            }else{
                var id_karyawan = 0;
            }


            if(level_user == "1" || level_user == "4"){ // ADMIN HR DAN DIREKSI
                var id_cabang     = ($("#cabang").val() == null)?"0":$("#cabang").val();
                var id_departemen = ($("#departemen").val() == null)?"0":$("#departemen").val();
            }else if(level_user == "5"){ // KEPALA CABANG
                if(multi_cabang == '1'){
                    var id_cabang   = ($("#cabang").val() == null)?"0":$("#cabang").val();
                }else{
                    var id_cabang   = '<?= $this->id_cabang ?>';
                }
                var id_departemen   = ($("#departemen").val() == null)?"0":$("#departemen").val();
            }else if(level_user == "2"){ // KEPALA DEPARTEMEN
                var id_cabang     = '<?= $this->id_cabang ?>';
                if(multi_departemen == '1'){
                    var id_departemen   = ($("#departemen").val() == null)?"0":$("#departemen").val();
                }else{
                    var id_departemen   = '<?= $this->id_departemen ?>';
                }
            }else{
                var id_cabang       = '<?= $this->id_cabang ?>';
                var id_departemen   = '<?= $this->id_departemen ?>';
            }

            list_data.ajax.url("<?= route('master.karyawan.tabs.content.pendidikan') ?>"+"/filter/"+id_cabang+"/"+id_departemen+"/"+id_jabatan+"/"+pendidikan+"/"+id_karyawan)
            list_data.ajax.reload(function(){
                loading.stop();
            });
        });
    });

    function departemen(){
        var level_user          = '<?= $this->level_user ?>';
        var multi_cabang        = '<?= $this->multi_cabang ?>';

        if(level_user == "1" || level_user == "4"){ // ADMIN HR DAN DIREKSI
            var id_cabang     = ($("#cabang").val() == null)?"0":$("#cabang").val();
        }else{ // KEPALA CABANG
            if(multi_cabang == '1'){
                var id_cabang   = ($("#cabang").val() == null)?"0":$("#cabang").val();
            }else{
                var id_cabang   = '<?= $this->id_cabang ?>';
            }
        }
        $('#departemen').select2({
            placeholder: 'Semua Departemen',
            allowClear: true,
            ajax: {
              // type: 'POST',
                url: '<?= route("dropdown.departemen.by.cabang") ?>'+"/"+id_cabang,
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    }

    function jabatan(){
        var level_user          = '<?= $this->level_user ?>';
        var multi_cabang        = '<?= $this->multi_cabang ?>';

        if(level_user == "1" || level_user == "4"){ // ADMIN HR DAN DIREKSI
            var id_cabang     = ($("#cabang").val() == null)?"0":$("#cabang").val();
            var id_departemen     = ($("#departemen").val() == null)?"0":$("#departemen").val();
        }else{ // KEPALA CABANG
            if(multi_cabang == '1'){
                var id_cabang   = ($("#cabang").val() == null)?"0":$("#cabang").val();
                var id_departemen     = ($("#departemen").val() == null)?"0":$("#departemen").val();
            }else{
                var id_cabang       = '<?= $this->id_cabang ?>';
                var id_departemen   = '<?= $this->id_departemen ?>';
            }
        }
        $('#jabatan').select2({
            placeholder: 'Semua Jabatan',
            allowClear: true,
            ajax: {
              // type: 'POST',
                // url: '<?= route("dropdown.jabatan.by.departemen") ?>'+"/"+id_cabang+"/"+id_departemen,
                url: '<?= route("dropdown.jabatan") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    }
</script>