<script type="text/javascript">
    $(function() {
        list_data_temp();

        $(document).on('click', '#btn_import_karyawan', function(){
            var loading = Ladda.create(this);
            $('.form_import #message').html("");

            if(document.getElementById("file").files.length == "0"){
                $('.form_import #message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> File belum diupload</font>");
                $('#file').focus();
                return false;
            }

            loading.start();

            var data = new FormData();
            data.append('file',$('#file').prop('files')[0]);

            $.ajax({
                type: 'POST',
                url: "<?= route('karyawan.import.excel') ?>",
                data: data,
                contentType: false,
                processData: false,
                dataType: "json",
                success: function(result){
                    if(result.success == true){
                        list_data_temp();
                    }

                    loading.stop();
                    $('.form_import #message').show();
                    $('.form_import #message').html(result.message);
                },
                error: function(){
                    loading.stop();
                    $('.form_import #message').show();
                    $('.form_import #message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });

        });

        $(document).on('click','.btn_edit',function(){
            var id = $(this).attr('id');
            window.location.href = "<?= route('karyawan.import.form.edit') ?>"+"/"+id
        });


        $(document).on('click','.btn_form_hapus',function(){
                var id = $(this).attr('id');
                $('#modal_hapus').modal('show');
                $(".title").text("Apakah Anda ingin menghapus data ini?");
                $("#modal_hapus .card-body").show();
                $("#modal_hapus .card-footer").show();
                $(".tombol").empty();
                $(".tombol").append('<button class="btn_hapus btn btn-danger ladda-button" data-style="expand-left"><i class="fa fa-trash"></i> HAPUS</button>');

                //btn_delete
                $('.btn_hapus').on('click',function(){
                    var loading = Ladda.create(this);
                    loading.start();
                    $.ajax({
                        type: 'POST',
                        url: "<?= route('karyawan.import.delete') ?>",
                        data: 'id_temp='+id,
                        dataType:'JSON',
                        success: function(result){
                            $("#modal_hapus .card-body").hide();
                            $("#modal_hapus .card-footer").hide();
                            $("#modal_hapus .title").html(result.message);
                            loading.stop();
                        },
                        error:function(){
                            loading.stop();
                            $("#modal_hapus .card-body").hide();
                            $("#modal_hapus .card-footer").hide();
                            $("#modal_hapus .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                        }
                    });
                });
                //btn_delete
        });

        // # SIMPAN SEMUA DATA TEMPORARY
        $(document).on('click','.btn_simpan_semua',function(){
                var id = $(this).attr('id');
                $('#modal_hapus').modal('show');
                $(".title").text("Apakah anda ingin menyimpan semua data ini?");
                $("#modal_hapus .card-body").show();
                $("#modal_hapus .card-footer").show();
                $(".tombol").empty();
                $(".tombol").append('<button class="btn_save_semua btn btn-success ladda-button" data-style="expand-left"><i class="fa fa-save"></i> SIMPAN</button>');

                //btn_delete
                $('.btn_save_semua').on('click',function(){
                    var loading = Ladda.create(this);
                    loading.start();
                    $.ajax({
                        type: 'POST',
                        url: "<?= route('karyawan.import.publishall') ?>",
                        data: 'id='+id,
                        dataType:'JSON',
                        success: function(result){
                            $("#modal_hapus .card-body").hide();
                            $("#modal_hapus .card-footer").hide();
                            $("#modal_hapus .title").html(result.message);
                            loading.stop();
                        },
                        error:function(){
                            loading.stop();
                            $("#modal_hapus .card-body").hide();
                            $("#modal_hapus .card-footer").hide();
                            $("#modal_hapus .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                        }
                    });
                });
        });

        $(document).on('click','.btn_hapus_semua',function(){
                $('#modal_hapus').modal('show');
                $(".title").text("Apakah anda ingin menghapus semua data ini?");
                $("#modal_hapus .card-body").show();
                $("#modal_hapus .card-footer").show();
                $(".tombol").empty();
                $(".tombol").append('<button class="btn_delete_semua btn btn-danger ladda-button" data-style="expand-left"><i class="fa fa-trash"></i> HAPUS</button>');

                //btn_delete
                $('.btn_delete_semua').on('click',function(){
                    var loading = Ladda.create(this);
                    loading.start();
                    $.ajax({
                        type: 'DELETE',
                        url: "<?=  route('karyawan.import.deleteall') ?>",
                        dataType:'JSON',
                        success: function(result){
                            $("#modal_hapus .card-body").hide();
                            $("#modal_hapus .card-footer").hide();
                            $("#modal_hapus .title").html(result.message);
                            loading.stop();
                        },
                        error:function(){
                            loading.stop();
                            $("#modal_hapus .card-body").hide();
                            $("#modal_hapus .card-footer").hide();
                            $("#modal_hapus .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                        }
                    });
                });
                //btn_delete
        });
    });

    function list_data_temp(){
        $("#listdata").load("<?= route('karyawan.import.viewdata') ?>");
    }

</script>

<style>
    th, td {
        white-space: nowrap;
    }
    div.dataTables_wrapper {
        margin: 0 auto;
    }
</style>
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Master Data</a></li>
                        <li class="breadcrumb-item"><a href="#">Karyawan</a></li>
                        <li class="breadcrumb-item active"><?= $judul ?></li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <div class="float-md-right">
                <a href="<?= site_url('master/karyawan') ?>" class="btn btn-secondary btn-min-width">
                    <i class="fa fa-arrow-left"></i> KEMBALI
                </a>
            </div>
        </div>
    </div>
</div>

<div id="content" class="card card-rounded">
    <div class="card-content">
        <div class="card-body form_import">
            <div class="row">
                <?php if($jumlah_karyawan_aktif >= $max_karyawan){ ?>
                    <div class="col-md-12 text-danger">
                        <h4>Jumlah Karyawan Sudah Maksimal</h4> 
                    </div>
                <?php } else { ?>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Upload File <span class="text-danger">*</span></label>
                        <input type="file" name="file" id="file" class="form-control">
                    </div>
                </div>
                <div class="col-md-7 align-self-end">
                    <div class="form-group">
                        <button type="button" id="btn_import_karyawan" class="btn btn-success ladda-button" data-style="expand-left"><i class="fa fa-upload"></i> IMPORT KARYAWAN</button>
                       <a href="<?= route('karyawan.import.download.template') ?>" class="btn btn-primary"><i class="fa fa-download"></i> UNDUH TEMPLATE</a>
                        <label id="message"></label>
                    </div>
                </div>
            <?php } ?>
            </div>
        </div>
    </div>
</div>

<div id="content" class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <button class="btn btn-success btn_simpan_semua" id="simpan_all"><i class="fa fa-save"></i> SIMPAN SEMUA DATA KE MASTER KARYAWAN</button>
                    <button class="btn btn-danger btn_hapus_semua" id="hapus_all"><i class="fa fa-trash"></i> HAPUS SEMUA DRAFT</button>
                </div>
                <div class="col-md-6 text-right">
                    <button class="btn btn-warning btn-sm" title="Kode shift tidak ditemukan"></button> <span>Data sudah ada</span>
                    <button class="btn btn-danger btn-sm" title="Data Kosong"></button> <span>Data tidak lengkap</span>
                </div>
            </div>
            <div class="row mt-2">
                <div id="listdata" class="col-md-12">

                </div>
            </div>
        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<div id="modal_form" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form" class="modal-content"></div>
    </div>
</div>
<!-- END TAMPIL MODAL -->

<!-- START TAMPIL MODAL -->
<div id="modal_hapus" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_hapus" class="modal-content">
            <div class="card-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h3 class="title modal-title"></h3>
            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="col-md-7 text-left">
                        <div id="message"></div>
                    </div>
                    <div class="col-md-5 text-right tombol">
                        <!-- <button class="btn_hapus ladda-button" id="btn_hapus" data-style="expand-left"></button> -->
                    </div>
                </div><!-- ./row -->
            </div>
        </div>
    </div>
</div>
<!-- END TAMPIL MODAL -->

