<script type="text/javascript">
    $(document).ready(function() {
        datepicker();
        dropdown_supervisi();

        $("#username, #password").on({
            keydown: function(e) {
                if (e.which === 32)
                    return false;
            },
            keyup: function(){
                this.value = this.value.replace(/\s/g, "");
            }
        });

        var status = $("#status").val();
        statusKaryawan(status);

        $("#status").change(function(){
            var status = $(this).val();
            statusKaryawan(status);
        });

        $('#jabatan').select2({
            placeholder: 'Pilih Jabatan',
            allowClear: true,
            ajax: {
            // type: 'POST',
                url: '<?= route("dropdown.jabatan")  ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });


        $("#jabatan").change(function(){
            if($(this).select2('data').lenght > 0){
                var level_user = $("#jabatan option:selected").attr("leveluser");
            }else{
                var level_user = $("#jabatan").select2('data')[0].leveluser;
            }
            levelUser(level_user);
        });

        $('#cabang').select2({
            placeholder: 'Pilih Cabang',
            allowClear: true,
            ajax: {
            // type: 'POST',
                url: '<?= route("dropdown.cabang")  ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });

        $("#cabang").change(function(){
            $('#supervisi').val('0');
            dropdown_supervisi();
        });

        $('#departemen').select2({
            placeholder: 'Pilih Departemen',
            allowClear: true,
            ajax: {
            // type: 'POST',
                url: '<?= route("dropdown.departemen")  ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });

        $("#departemen").change(function(){
            $('#supervisi').val('0');
            dropdown_supervisi();
        });


        $(".btn_save_datadiri").click(function(e){
            e.preventDefault();
            $('#message').html("");
            var loading = Ladda.create(this);

            if(typeof $("#jabatan").select2('data')[0].leveluser === "undefined"){
                var level_user = $("#jabatan option:selected").attr("leveluser");
            }else{
                var level_user = $("#jabatan").select2('data')[0].leveluser;
            }
        
            if($("#no_induk_karyawan").val()==""){
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Nomor Induk Karyawan belum diisi</font>");
                $("#no_induk_karyawan").focus();
                return false;
            }else if($("#nama_lengkap").val()==""){
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Nama Lengkap belum diisi</font>");
                $("#nama_lengkap").focus();
                return false;
            }else if($("#jenis_kelamin").val() ==""){
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Jenis Kelamin belum diiisi</font>");
                $('#jenis_kelamin').focus();
                return false;
            }else if($("#jabatan").val() == null){
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Jabatan belum dipilih</font>");
                $('#jabatan').select2('open');
                return false;
            }else if(level_user == "1"){
                if($("#cabang").val() == null){
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Cabang belum dipilih</font>");
                    $('#cabang').select2('open');
                    return false;
                }
            }else if(level_user == "2"){
                if($("#cabang").val() == null){
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Cabang belum dipilih</font>");
                    $('#cabang').select2('open');
                    return false;
                }else if($("#departemen").val() == null){
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Departemen belum dipilih</font>");
                    $('#departemen').select2('open');
                    return false;
                }
            }else if(level_user == "3"){
                if($("#cabang").val() == null){
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Cabang belum dipilih</font>");
                    $('#cabang').select2('open');
                    return false;
                }else if($("#departemen").val() == null){
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Departemen belum dipilih</font>");
                    $('#departemen').select2('open');
                    return false;
                }
            }else if(level_user == "4"){
                if($("#cabang").val() == null){
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Cabang belum dipilih</font>");
                    $('#cabang').select2('open');
                    return false;
                }
            }else if(level_user == "5"){
                if($("#cabang").val() == null){
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Cabang belum dipilih</font>");
                    $('#cabang').select2('open');
                    return false;
                }
            }else if(level_user == "6"){
                if($("#cabang").val() == null){
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Cabang belum dipilih</font>");
                    $('#cabang').select2('open');
                    return false;
                }
            }else if(level_user == "7"){
                if($("#cabang").val() == null){
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Cabang belum dipilih</font>");
                    $('#cabang').select2('open');
                    return false;
                }else if($("#departemen").val() == null){
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Departemen belum dipilih</font>");
                    $('#cabang').select2('open');
                    return false;
                }
            }
            
            if($("#status").val() == ""){
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Status karyawan belum dipilih</font>");
                $('#status').focus();
                return false;
            }else if($("#status").val() == "1"){
                if($("#tgl_aktif_bekerja").val() == "" || $("#tgl_aktif_bekerja").val() == "01-01-1970"){
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Tanggal mulai kontrak belum diisi</font>");
                    $('#tgl_aktif_bekerja').focus()
                    return false;
                }else if($("#tgl_berhenti_bekerja").val() == "" || $("#tgl_berhenti_bekerja").val() == "01-01-1970"){
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Tanggal berakhir kontrak belum diisi</font>");
                    $('#tgl_berhenti_bekerja').focus();
                    return false;
                }
            }else if($("#status").val() == "2"){
                if($("#tgl_aktif_bekerja").val() == ""){
                    $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Tanggal mulai aktif belum diisi</font>");
                    $('#tgl_aktif_bekerja').focus()
                    return false;
                }
            }

            if($("#username").val() == ""){
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Username belum diisi</font>");
                $('#username').focus()
                return false;
            }else if($("#password").val() == ""){
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Password belum diisi</font>");
                $('#password').focus()
                return false;
            }
            
            loading.start();
        
            var param = new FormData();
            param.append('id_temp',$("#id_temp").val());
            param.append('no_induk_karyawan',$("#no_induk_karyawan").val());
            param.append('nama_lengkap',$("#nama_lengkap").val());
            param.append('gelar_depan',$("#gelar_depan").val());
            param.append('gelar_belakang',$("#gelar_belakang").val());
            param.append('jenis_kelamin',$("#jenis_kelamin").val());
            param.append('agama',$("#agama").val());
            param.append('tempat_lahir',$("#tempat_lahir").val());
            param.append('tgl_lahir',$("#tgl_lahir").val());
            param.append('alamat_domisili',$("#alamat_domisili").val());
            param.append('telepon',$("#telepon").val());
            param.append('email',$("#email").val());
            param.append('no_ktp',$("#no_ktp").val());
            param.append('tgl_aktif_bekerja',$("#tgl_aktif_bekerja").val());
            param.append('tgl_berhenti_bekerja',$("#tgl_berhenti_bekerja").val());
            param.append('departemen',$("#departemen").val());
            param.append('level_user',level_user);
            param.append('cabang',$("#cabang").val());
            param.append('jabatan',$("#jabatan").val());
            param.append('jatah_cuti',$("#jatah_cuti").val());
            param.append('status',$("#status").val());
            param.append('username',$('#username').val());
            param.append('password_baru',$('#password_baru').val());
                    
            $.ajax({
                type: 'POST',
                url: "<?= route('karyawan.import.save') ?>",
                data: param,
                dataType:'JSON',
                contentType: false,
                processData: false,
                cache: false,
                success: function(result) {
                    if(result.success == true){
                        if (result.type == 'update'){
                            window.location.href = '<?= route('karyawan.import.home') ?>';
                    }
                }
                    loading.stop();
                    $('#message').show();
                    $('#message').html(result.message);
                },
                error:function(){
                    loading.stop();
                    $('#message').show();
                    $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });
    });

    function statusKaryawan(status){
        if(status == '1'){
            $("#div_tgl_mulai_kerja").show();
            $("#lbl_tgl_mulai_kerja").html('Tanggal Mulai Kontrak <i class="text-danger">*</i>');
            $("#tgl_aktif_bekerja").prop("disabled",false);

            $("#div_tgl_berakhir_kerja").show();
            $("#lbl_tgl_berakhir_kerja").html('Tanggal Berakhir Kontrak <i class="text-danger">*</i>');
            $("#tgl_berhenti_bekerja").prop("disabled",false);
        }else if(status == '2'){
            $("#div_tgl_mulai_kerja").show();
            $("#lbl_tgl_mulai_kerja").html('Tanggal Aktif <i class="text-danger">*</i>');
            $("#tgl_aktif_bekerja").prop("disabled",false);

            $("#div_tgl_berakhir_kerja").hide();
        }else{

        }
    }

    function levelUser(level_user){
        if(level_user == '1'){
            $("#div_cabang").show();
            
            $("#departemen").val("").trigger("change");
            $("#div_departemen").hide();

            $("#supervisi").val("");
            $("#div_supervisi").hide();

        }else if(level_user == '2'){
            $("#div_cabang").show();
            $("#div_departemen").show();

            $("#supervisi").val("");
            $("#div_supervisi").hide();

        }else if(level_user == '3'){
            $("#div_cabang").show();
            $("#div_departemen").show();
            $("#div_supervisi").show();
            
        }else if(level_user == '4'){
            $("#div_cabang").show();

            $("#departemen").val("").trigger("change");
            $("#div_departemen").hide();

            $("#supervisi").val("");
            $("#div_supervisi").hide();

        }else if(level_user == '5'){
            $("#div_cabang").show();

            $("#departemen").val("").trigger("change");
            $("#div_departemen").hide();

            $("#supervisi").val("");
            $("#div_supervisi").hide();
        }else if(level_user == '6'){
            $("#div_cabang").show();

            $("#departemen").val("").trigger("change");
            $("#div_departemen").hide();

            $("#supervisi").val("");
            $("#div_supervisi").hide();

        }else if(level_user == '7'){
            $("#div_cabang").show();
            $("#div_departemen").show();
            $("#div_supervisi").hide();
        }else{
            $("#cabang").val("");
            $("#departemen").val("").trigger("change");
            $("#supervisi").val("");

            $("#div_cabang").hide();
            $("#div_departemen").hide();
            $("#div_supervisi").hide();
        }
    }

    function dropdown_supervisi(){
        $('#supervisi').select2({
            placeholder: 'Pilih Supervisi',
            allowClear: true,
            ajax: {
            // type: 'POST',
                url: '<?= route("dropdown.supervisi")  ?>'+'/'+$('#cabang').val() + '/' + $('#departemen').val(),
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    }
</script>
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Master Data</a>
                        </li>
                        <li class="breadcrumb-item"><a href="#">Karyawan</a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <div class="float-md-right">
                <a href="<?= route('karyawan.import.home') ?>" class="btn btn-secondary btn-min-width">
                    <i class="fa fa-arrow-left"></i> KEMBALI
                </a>
            </div>
        </div>
    </div>
</div>


<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <input type="hidden" name="id_temp" id="id_temp" value="<?= isset($data->id_temp) ? md5($data->id_temp) : '' ?>">
            <div id="form_input" class="row">
                <div class="col-md-8">
                    <div class="row">
                        <div class="col-md-12"><label class="font-weight-bold">Data Diri</label></div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <fieldset class="form-group">
                                <label>Nomor Induk karyawan <i class="text-danger">*</i></label>
                                <input type="text" id="no_induk_karyawan" class="form-control" placeholder="Nomor Induk Karyawan" value="<?= isset($data->nik) ? $data->nik : '' ?>">
                            </fieldset>
                        </div>
                        <div class="col-md-6">
                            <fieldset class="form-group">
                                <label>Nama Lengkap <i class="text-danger">*</i></label>
                                <input type="text" value="<?= isset($data->nama_lengkap) ? $data->nama_lengkap : '' ?>" class="form-control" name="nama_lengkap" id="nama_lengkap" placeholder="Nama Lengkap">
                            </fieldset>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <fieldset class="form-group">
                                <label>Gelar Depan</label>
                                <input type="text" id="gelar_depan" class="form-control" placeholder="Gelar Depan" value="<?= isset($data->gelar_depan) ? $data->gelar_depan : '' ?>" >
                            </fieldset>
                        </div>
                        <div class="col-md-6">
                            <fieldset class="form-group">
                                <label>Gelar Belakang</label>
                                <input type="text" id="gelar_belakang" class="form-control" placeholder="Gelar Belakang" value="<?= isset($data->gelar_belakang) ? $data->gelar_belakang : '' ?>">
                            </fieldset>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <fieldset class="form-group">
                                <label>Jenis Kelamin</label>
                                <select id="jenis_kelamin" class="form-control">
                                    <option value="L" <?= ((isset($data) AND $data->jenis_kelamin == 'L')?'selected':'') ?>>Laki - Laki</option>
                                    <option value="P" <?= ((isset($data) AND $data->jenis_kelamin == 'P')?'selected':'') ?>>Perempuan</option>
                                </select>
                            </fieldset>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <fieldset class="form-group">
                                <label>Tempat Lahir</label>
                                <input type="text" id="tempat_lahir" class="form-control" placeholder="Tempat Lahir" value="<?= isset($data->tempat_lahir) ? $data->tempat_lahir : '' ?>">
                            </fieldset>
                        </div>      
                        <div class="col-md-6">
                            <fieldset class="form-group">
                                <label>Tanggal Lahir</label>
                                <?php
                                    if (isset($data)) {
                                        $tanggal_lahir = date('d-m-Y', strtotime($data->tgl_lahir));
                                    }else{
                                        $tanggal_lahir = "";
                                    }
                                ?>
                                <input type="text" id="tgl_lahir" class="form-control datepicker" data-inputmask="'alias': 'datetime','inputFormat': 'dd-mm-yyyy'" placeholder="dd-mm-yyyy" value="<?= $tanggal_lahir ?>">
                            </fieldset>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <fieldset class="form-group">
                                <label>No Telepon</label>
                                <input type="text" name="telepon" value="<?= isset($data->telepon) ? $data->telepon : '' ?>" class="form-control numberbox" id="telepon" placeholder="No Telepon">
                            </fieldset>
                        </div>      
                        <div class="col-md-6">
                            <fieldset class="form-group">
                                <label>Email</label>
                                <input type="email" value="<?= isset($data->email) ? $data->email : '' ?>" name="email" class="form-control" id="email" placeholder="Email">
                            </fieldset>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <fieldset class="form-group">
                                <label>Agama</label>
                                <select id="agama" class="form-control">
                                    <option value="" <?= ((isset($data) AND $data->agama == '')?'selected':'') ?>>Pilih</option>
                                    <option value="Islam" <?= ((isset($data) AND $data->agama == 'Islam')?'selected':'') ?>>Islam</option>
                                    <option value="Kristen" <?= ((isset($data) AND $data->agama== 'Kristen')?'selected':'') ?>>Kristen</option>
                                    <option value="Hindu" <?= ((isset($data) AND $data->agama == 'Hindu')?'selected':'') ?>>Hindu</option>
                                    <option value="Budha" <?= ((isset($data) AND $data->agama== 'Budha')?'selected':'') ?>>Budha</option>
                                    <option value="Katolik" <?= ((isset($data) AND $data->agama == 'Katolik')?'selected':'') ?>>Katolik</option>
                                    <option value="Khonghucu" <?= ((isset($data) AND $data->agama== 'Khonghucu')?'selected':'') ?>>Khonghucu</option>
                                </select>
                            </fieldset>
                        </div>
                        <div class="col-md-6">
                            <fieldset class="form-group">
                                <label>Nomor Induk Kependudukan(NIK)</label>
                                <input type="text" id="no_ktp" class="form-control numberbox" placeholder="Nomor KTP" value="<?= isset($data->no_ktp) ? $data->no_ktp : '' ?>">
                            </fieldset>
                        </div>
                    </div>
                    

                    <div class="row mt-3">
                        <div class="col-md-12"><label class="font-weight-bold">Data Alamat</label></div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <fieldset class="form-group">
                                <label>Alamat Domisili</label>
                                <textarea id="alamat_domisili" class="form-control" rows="3" placeholder="Alamat Domisili"><?= isset($data->alamat_domisili) ? $data->alamat_domisili : '' ?></textarea>
                            </fieldset>
                        </div> 
                    </div>

                    <div class="row mt-3">
                        <div class="col-md-12"><label class="font-weight-bold">Data Kepegawaian</label></div>
                    </div>
                    <?php

                        if(isset($data->level_user)){
                            $level_user = $data->level_user;
                            if(in_array($level_user,array('1','4','6'))){ # Admin HR, Direksi, Admin Finance
                                $hidden_departemen = "style='display:none'";
                                $hidden_supervisi = "style='display:none'";
                            }else if($level_user == '5'){ # Kepala Cabang
                                $hidden_departemen = "style='display:none'";
                                $hidden_supervisi = "style='display:none'";
                            }else if($level_user == '2'){ # Kepala Departemen
                                $hidden_departemen = " ";
                                $hidden_supervisi = "style='display:none'";
                            }else if($level_user == '7'){ # Supervisi
                                $hidden_departemen = " ";
                                $hidden_supervisi = "style='display:none'";
                            }else{ # STaff
                                $hidden_departemen = " ";
                                $hidden_supervisi = " ";
                            }
                        }else{
                            $hidden_departemen = "";
                            $hidden_supervisi = "";
                        }
            			
            		?>
                    <div class="row">
                        <div class="col-md-6">
                            <fieldset class="form-group">
                                <label>Jabatan <i class="text-danger">*</i></label>
                                <select class="form-control" id="jabatan" class="select2 form-control" style="border-radius: 5px; width: 100%;">
                                    <?php
                                        if(isset($data->id_jabatan)){
                                            echo '<option value="'.$data->id_jabatan.'" leveluser="'.$data->level_user.'" selected>'.$data->kode_jabatan.' - '.$data->nama_jabatan.'</option>';
                                        }
                                    ?>
                                </select>
                            </fieldset>
                        </div>

                        <div id="div_cabang" class="col-md-6">
                            <fieldset class="form-group">
                                <label>Cabang <i class="text-danger">*</i></label>
                                <select id="cabang" class="select2 form-control" style="border-radius: 5px; width: 100%;">
                                    <?php
                                        if(isset($data->id_cabang)){
                                            echo '<option value="'.$data->id_cabang.'" selected>'.$data->kode_cabang.' - '.$data->nama_cabang.'</option>';
                                        }
                                    ?>
                                </select>
                            </fieldset>
                        </div>
                    </div>
                    <div class="row">
                        <div id="div_departemen" class="col-md-6" <?= $hidden_departemen ?>>
                            <fieldset class="form-group">
                                <label>Departemen <i class="text-danger">*</i></label>
                                <select id="departemen" class="select2 form-control" style="border-radius: 5px; width: 100%;">
                                    <?php
                                        if(isset($data->id_departemen)){
                                            echo '<option value="'.$data->id_departemen.'" selected>'.$data->kode_departemen.' - '.$data->nama_departemen.'</option>';
                                        }
                                    ?>
                                </select>
                            </fieldset>
                        </div>

                        <div id="div_supervisi" class="col-md-6" <?= $hidden_supervisi ?>>
                            <fieldset class="form-group">
                                <label>Supervisi </label>
                                <select id="supervisi" class="select2 form-control" style="border-radius: 5px; width: 100%;">
                                    <?php
                                        if(isset($data->id_supervisi)){
                                            echo '<option value="'.$data->id_supervisi.'" selected>'.$data->nik_supervisi.' - '.$data->nama_supervisi.'</option>';
                                        }
                                    ?>
                                </select>
                            </fieldset>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <fieldset class="form-group">
                                <label>Sisa Cuti Tahunan</label>
                                <input type="text" id="jatah_cuti" class="form-control numberbox" placeholder="Sisa Cuti Tahunan" value="<?= isset($data->jatah_cuti) ? $data->jatah_cuti : '' ?>">
                            </fieldset>
                        </div>
                        <div class="col-md-6">
                            <fieldset class="form-group">
                                <label>Status <i class="text-danger">*</i></label>
                                <select class="form-control" id="status">
                                    <option value="1" <?= ((isset($data) AND $data->status == '1')?'selected':'') ?>>Kontrak</option>
                                    <option value="2" <?= ((isset($data) AND $data->status == '2')?'selected':'') ?>>Tetap (Aktif)</option>
                                </select>
                            </fieldset>
                        </div>
                    </div>
                    <div class="row">
                        <div id="div_tgl_mulai_kerja" class="col-md-6">
                            <fieldset class="form-group">
                                <label id="lbl_tgl_mulai_kerja">Tanggal Aktif Berkerja <i class="text-danger">*</i></label>
                                <?php
                                    if (isset($data)) {
                                        if ($data->tgl_aktif_bekerja != "0000-00-00" && $data->tgl_aktif_bekerja != "1970-01-01") {
                                            $tanggal_aktif = date('d-m-Y', strtotime($data->tgl_aktif_bekerja));
                                        }else{
                                            $tanggal_aktif = "";
                                        }                            
                                    }else{
                                        $tanggal_aktif = "";
                                    }


                                ?>
                                <input type="text" id="tgl_aktif_bekerja" class="form-control datepicker" data-inputmask="'alias': 'datetime','inputFormat': 'dd-mm-yyyy'" placeholder="dd-mm-yyyy" value="<?= $tanggal_aktif ?>">
                            </fieldset>
                        </div>      
                        <div id="div_tgl_berakhir_kerja" class="col-md-6">
                            <fieldset class="form-group">
                                <label id="lbl_tgl_berakhir_kerja">Tanggal Berhenti Bekerja</label>
                                <?php
                                    if (isset($data)) {
                                        if ($data->tgl_berhenti_bekerja != "0000-00-00" && $data->tgl_berhenti_bekerja != "1970-01-01") {
                                            $tanggal_berhenti = date('d-m-Y', strtotime($data->tgl_berhenti_bekerja));
                                        }else{
                                            $tanggal_berhenti = "";
                                        }                            
                                    }else{
                                        $tanggal_berhenti = "";
                                    }
                                ?>
                                <input type="text" value="<?= $tanggal_berhenti ?>" class="form-control datepicker" id="tgl_berhenti_bekerja" data-inputmask="'alias': 'datetime','inputFormat': 'dd-mm-yyyy'" placeholder="dd-mm-yyyy">
                            </fieldset>
                        </div>
                    </div>
                    <div class="row mt-3">
                        <div class="col-md-12"><label class="font-weight-bold">Data Akun</label></div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <fieldset class="form-group">
                                <label>Username <i class="text-danger">*</i></label>
                                <input type="text" value="<?= isset($data->username) ? $data->username : '' ?>" name="username" class="form-control" id="username" placeholder="Username">
                            </fieldset>
                        </div>
                        <!-- <div class="col-md-6">
                            <fieldset class="form-group">
                                <label>Password <i class="text-danger">*</i></label>
                                <input type="text" value="<?= isset($data->password) ? '*******' : '' ?>" name="password" class="form-control" id="password" placeholder="Password">

                            </fieldset>
                        </div> -->
                    </div>
                    
                </div>
                <div class="col-md-12">
                    <div class="row">
                        <div class="col-md-7 text-left">
                            <div id="message"></div>
                        </div>
                        <div class="col-md-5 text-right">
                            <button class="btn_save_datadiri btn btn-primary btn-min-width ladda-button" data-style="expand-left"><i class="fa fa-save"></i> SIMPAN</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>