<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"><?= $title ?></h3>
</div>
<div id="form_input" class="card-body">
    <div class="table-responsive">
        <table id="list_data" class="table table-striped" style="width:100%">
            <thead>
                <tr>
                    <th class="text-center">NO</th>
                    <th class="text-center">TANGGAL</th>
                    <th class="text-left">NAMA</th>
                    <th class="text-left">JABATAN</th>
                    <th class="text-left">CABANG</th>
                    <th class="text-left">DEPARTEMEN</th>
                    <th class="text-center">DETAIL</th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>
</div>

<script type="text/javascript">
    $(function() {

        list_data = $('#list_data').DataTable({
                    'searching'   : false,
                    'searchDelay' : 1000,
                    'paging'      : true,
                    'lengthChange': true,
                    'ordering'    : false,
                    'info'        : true,
                    'scrollX'     : true,
                    // 'scrollCollapse': true,
                    // 'fixedColumns': true,
                    'language'    :{
                                    'url'         : '<?=base_url("assets/plugins/datatables/dataTables-language-id.json")?>',
                                    'sEmptyTable' : 'Tidak ada data untuk ditampilkan',
                                    'searchPlaceholder': 'Kode/Nama'
                                },
                    "processing"  : true,
                    "serverSide"  : true,
                    "order"       : [],

                    "ajax"        : {

                                        "url": "<?= $url ?>",
                                        "type": "POST",
                                        "complete" : function(data){
                                            reconfigure(data);
                                        }
                                    },
                    "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                                    $('td:eq(0)', nRow).css({'text-align':'center','width':'10px'});
                                    $('td:eq(1)', nRow).css({'text-align':'center','width':'100px'});
                                    $('td:eq(6)', nRow).css({'text-align':'center','width':'50px'});
                            }

                });
    });
</script>

