<script type="text/javascript">

    var level_user = '<?= $this->level_user ?>';
    var multi_cabang = '<?= $this->multi_cabang ?>';

    $(function() {
        if(level_user == "1" || level_user == "4" || multi_cabang == "1"){
            cabang();
        }

        tanggal();
        pickrange();

        filter();
        filter_onchange();
        diagram_pie();
        layanan();

        if(level_user == "1"){
            dropdown_karyawan_cabang();
            change_dropdown_karyawan_cabang();
            // ttlKaryawan();

            dropdown_dk_cabang();
            change_dropdown_dk_cabang();
            // updateGrafikBarDataKaryawan();

            dropdown_jt_tahun();
            dropdown_jt_cabang();
            change_dropdown_jt_cabang();
            // updateGrafikBarJoinTermination();

            dropdown_keterlambatan_cabang();
            // updateGrafikKeterlambatan();
        }
    });

    function tanggal() {
        var d = new Date();
        d.setDate(d.getDate());
        $('.input-daterange input').each(function() {
            $(this).datepicker({
                orientation: "bottom",
                format: "dd-mm-yyyy",
                endDate: d,
                autoclose: true,
            });
        });
    }

    function diagram_pie(){
        if(level_user == "1" || level_user == "4" || multi_cabang == "1"){
            var id_cabang = (!$("#ra #cabang").val())? "all":$("#ra #cabang").val();
        }else{
            var id_cabang = "<?= $this->id_cabang ?>";
        }

        var jam_kerja = (!$("#ra #jam_kerja").val())?"all":$("#ra #jam_kerja").val();
        $.ajax({
                type: 'GET',
                dataType: 'json',
                url: '<?= route("dashboard.absensi.data.diagram.pie") ?>'+'/'+id_cabang+'/'+jam_kerja,
                complete : function(data){
                        reconfigure(data);
                    },
            }).then(function (data) {
                $("#ra #hadir").html(data.absen);
                $("#ra #terlambat").html(data.terlambat);
                $("#ra #belum_absen").html(data.belum_absen);
                $("#ra #izin").html(data.izin);
                $("#ra #cuti").html(data.cuti);
                $("#ra #sakit").html(data.sakit);
                document.getElementById("chart-dashboard").innerHTML = "";
                new Morris.Donut({
                    // ID of the element in which to draw the chart.
                    element: 'chart-dashboard',
                    // Chart data records -- each entry in this array corresponds to a point on
                    // the chart.
                    data: [
                        {label: "Hadir", value: data.absen},
                        {label: "Terlambat", value: data.terlambat},
                        {label: "Belum Absen", value: data.belum_absen},
                        {label: "Cuti", value: data.cuti},
                        {label: "Izin", value: data.izin},
                        {label: "Sakit", value: data.sakit}
                    ],
                    colors: [
                        "#2883FA", //hadir
                        "#FFD700", //hadir
                        "#F63939", //Belum absen
                        "#07CF72", //Cuti
                        "#FF9900", //Izin
                        "#BA47E4" //sakit
                    ]
                });
            });
    }

    function cabang() {
        $("#ra #cabang").select2({
            placeholder: 'Semua Cabang',
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.cabang") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            }
        });
    }

    function filter() {
        if(level_user == "1" || level_user == "4" || multi_cabang == "1"){
            var id_cabang = (!$("#ra #cabang").val())? "all":$("#ra #cabang").val();
        }else{
            var id_cabang = "<?= $this->id_cabang ?>";
        }
        $("#ra #jam_kerja").select2({
            // dropdownParent: $("#pilihan"),
            placeholder: 'Semua',
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.jamkerja") ?>/'+id_cabang,
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: true
            }
        });
    }

    function filter_onchange() {
        $("#ra #jam_kerja").change(function() {
            if(level_user == "1" || level_user == "4" || multi_cabang == "1"){
                var id_cabang = (!$("#ra #cabang").val())? "all":$("#ra #cabang").val();
            }else{
                var id_cabang = "<?= $this->id_cabang ?>";
            }
            var jam_kerja = (!$("#ra #jam_kerja").val())?"all":$("#ra #jam_kerja").val();

            dropdownParent: $("#ra #pilihan"),
            $.ajax({
                type: 'GET',
                dataType: 'json',
                url: '<?= route("dashboard.absensi.data.diagram.pie") ?>'+'/'+id_cabang+'/'+jam_kerja,
                complete : function(data){
                        reconfigure(data);
                    },
            }).then(function (data) {
                $("#ra #hadir").html(data.absen);
                $("#ra #terlambat").html(data.terlambat);
                $("#ra #belum_absen").html(data.belum_absen);
                $("#ra #izin").html(data.izin);
                $("#ra #cuti").html(data.cuti);
                $("#ra #sakit").html(data.sakit);
                document.getElementById("chart-dashboard").innerHTML = "";
                new Morris.Donut({
                    // ID of the element in which to draw the chart.
                    element: 'chart-dashboard',
                    // Chart data records -- each entry in this array corresponds to a point on
                    // the chart.
                    data: [
                        {label: "Hadir", value: data.absen},
                        {label: "Terlambat", value: data.terlambat},
                        {label: "Belum Absen", value: data.belum_absen},
                        {label: "Cuti", value: data.cuti},
                        {label: "Izin", value: data.izin},
                        {label: "Sakit", value: data.sakit}
                    ],
                    colors: [
                        "#2883FA", //hadir
                        "#FFD700", //Terlambat
                        "#F63939", //Belum absen
                        "#07CF72", //Cuti
                        "#FF9900", //Izin
                        "#BA47E4" //sakit
                    ]
                });
            });
        });
    }

    function filter_list() {
        if(level_user == "1" || level_user == "4" || multi_cabang == "1"){
            var id_cabang = (!$("#ra #cabang").val())? "all":$("#ra #cabang").val();
        }else{
            var id_cabang = "<?= $this->id_cabang ?>";
        }

        $("#ra #jam_kerja").val("");

        $("#ra #jam_kerja").select2({
            // dropdownParent: $("#pilihan"),
            placeholder: 'Semua',
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.jamkerja") ?>/'+id_cabang,
                dataType: 'json',
                delay: 250,
                complete : function(data){
                        reconfigure(data);
                },
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            }
        });

        var jam_kerja = (!$("#ra #jam_kerja").val())?"all":$("#ra #jam_kerja").val();
        $.ajax({
                type: 'GET',
                dataType: 'json',
                url: '<?= route("dashboard.absensi.data.diagram.pie") ?>'+'/'+id_cabang+'/'+jam_kerja,
                complete : function(data){
                        reconfigure(data);
                    },
            }).then(function (data) {
                $("#ra #hadir").html(data.absen);
                $("#ra #terlambat").html(data.terlambat);
                $("#ra #belum_absen").html(data.belum_absen);
                $("#ra #izin").html(data.izin);
                $("#ra #cuti").html(data.cuti);
                $("#ra #sakit").html(data.sakit);
                document.getElementById("chart-dashboard").innerHTML = "";
                new Morris.Donut({
                    // ID of the element in which to draw the chart.
                    element: 'chart-dashboard',
                    // Chart data records -- each entry in this array corresponds to a point on
                    // the chart.
                    data: [
                        {label: "Hadir", value: data.absen},
                        {label: "Terlambat", value: data.terlambat},
                        {label: "Belum Absen", value: data.belum_absen},
                        {label: "Cuti", value: data.cuti},
                        {label: "Izin", value: data.izin},
                        {label: "Sakit", value: data.sakit}
                    ],
                    colors: [
                        "#2883FA", //hadir
                        "#FFD700", //Terlambat
                        "#F63939", //Belum absen
                        "#07CF72", //Cuti
                        "#FF9900", //Izin
                        "#BA47E4" //sakit
                    ]
                });
            });
    }

    function detail(){
        if(level_user == "1" || level_user == "4" || multi_cabang == "1"){
            var id_cabang = (!$("#ra #cabang").val())? "all":$("#ra #cabang").val();
        }else{
            var id_cabang = "<?= $this->id_cabang ?>";
        }
        var jam_kerja = (!$("#ra #jam_kerja").val())?"all":$("#ra #jam_kerja").val();
        window.location.href = "<?= route('dashboard.absensi.detail.data') ?>"+'/'+id_cabang+'/'+jam_kerja;
    }

    function detailRekap(jenis=""){
        if(level_user == "1" || level_user == "4" || multi_cabang == "1"){
            var id_cabang = (!$("#ra #cabang").val())? "all":$("#ra #cabang").val();
        }else{
            var id_cabang = "<?= $this->id_cabang ?>";
        }
        var jam_kerja = (!$("#ra #jam_kerja").val())?"all":$("#ra #jam_kerja").val();
        var url = "<?= route('dashboard.absensi.data.diagram.pie.detail') ?>"+"/"+jenis+"/"+id_cabang+"/"+jam_kerja;
        $('#modal_chart #tampil_form').load(url,function(){
            $('#modal_chart').modal('show');
        });
    }

    if(level_user == "1"){

        function layanan(){
            $.getJSON("<?= route('dashboard.layanan') ?>", function(result){
                $("#layanan #nm_layanan").text(result.data.nm_paket)
                $("#layanan #ttl_karyawan").text(result.data.ttl_karyawan_aktif+" dari Maksimal "+result.data.max_karyawan+" Karyawan")
                $("#layanan #ms_layanan").text(result.data.masa_layanan)
            });
        }

        function ttlKaryawan(){
            var id_cabang       = (!$("#karyawan #cabang").val())? "all":$("#karyawan #cabang").val();
            var id_departemen   = (!$("#karyawan #departemen").val())? "all":$("#karyawan #departemen").val();

            $.getJSON("<?= route('dashboard.absensi.ttl.karyawan.genre') ?>"+"/"+id_cabang+"/"+id_departemen, function(result){
                $("#karyawan #persentase_pria").html(result.data.persentase_pria)
                $("#karyawan #ttl_pria").html(result.data.ttl_pria)
                $("#karyawan #persentase_wanita").html(result.data.persentase_wanita)
                $("#karyawan #ttl_wanita").html(result.data.ttl_wanita)
                $("#karyawan #ttl_karyawan").html(result.data.ttl_karyawan)
            });
        }

        // BEGIN DROPDOWN JUMLAH KARYAWAN
        function dropdown_karyawan_cabang(){
            $("#karyawan #cabang").select2({
                placeholder: 'Semua Cabang',
                allowClear: true,
                ajax: {
                    url: '<?= route("dashboard.absensi.ttl.karyawan.dropdown.cabang") ?>',
                    dataType: 'json',
                    delay: 250,
                    processResults: function (data) {
                    return {
                            results: data
                        };
                    },
                    cache: false
                }
            });
        }

        function change_dropdown_karyawan_cabang(){
            $("#karyawan #departemen").val("");
            var id_cabang = (!$("#karyawan #cabang").val())? "all":$("#karyawan #cabang").val();
            $("#karyawan #departemen").select2({
                placeholder: 'Semua Departemen',
                allowClear: true,
                ajax: {
                    url: '<?= route("dashboard.absensi.ttl.karyawan.dropdown.departemen") ?>'+'/'+id_cabang,
                    dataType: 'json',
                    delay: 250,
                    processResults: function (data) {
                    return {
                            results: data
                        };
                    },
                    cache: false
                }
            });
            ttlKaryawan();
        }
        // END DROPDOWN JUMLAH KARYAWAN

        // BEGIN DROPDOWN GRAFIK DATA KARYAWAN
        // function dropdown_dk_cabang(){
        //     $("#dk #cabang").select2({
        //         placeholder: 'Semua Cabang',
        //         allowClear: true,
        //         ajax: {
        //             url: '<?= route("dashboard.absensi.grafik.data.karyawan.dropdown.cabang") ?>',
        //             dataType: 'json',
        //             delay: 250,
        //             processResults: function (data) {
        //             return {
        //                     results: data
        //                 };
        //             },
        //             cache: false
        //         }
        //     });
        // }

        // function change_dropdown_dk_cabang(){
        //     $("#dk #departemen").val("");
        //     var id_cabang = (!$("#dk #cabang").val())? "all":$("#dk #cabang").val();
        //     $("#dk #departemen").select2({
        //         placeholder: 'Semua Departemen',
        //         allowClear: true,
        //         ajax: {
        //             url: '<?= route("dashboard.absensi.grafik.data.karyawan.dropdown.departemen") ?>'+'/'+id_cabang,
        //             dataType: 'json',
        //             delay: 250,
        //             processResults: function (data) {
        //             return {
        //                     results: data
        //                 };
        //             },
        //             cache: false
        //         }
        //     });
        //     updateGrafikBarDataKaryawan();
        // }

        // END DROPDOWN GRAFIK DATA KARYAWAN

        // BEGIN DROPDOWN GRAFIK JOINT VS TERMINATION
        function dropdown_jt_tahun() {
            $("#jt #tahun").select2({
                placeholder: 'Tahun',
                // allowClear: true,
                minimumResultsForSearch: Infinity,
                ajax: {
                    url: '<?= route("dashboard.absensi.grafik.joint.termination.dropdown.tahun") ?>',
                    dataType: 'json',
                    delay: 250,
                    processResults: function (data) {
                    return {
                            results: data
                        };
                    },
                    cache: false
                }
            });
        }

        function dropdown_jt_cabang(){
            $("#jt #cabang").select2({
                placeholder: 'Semua Cabang',
                allowClear: true,
                ajax: {
                    url: '<?= route("dashboard.absensi.grafik.joint.termination.dropdown.cabang") ?>',
                    dataType: 'json',
                    delay: 250,
                    processResults: function (data) {
                    return {
                            results: data
                        };
                    },
                    cache: false
                }
            });
        }

        function change_dropdown_jt_cabang(){
            $("#jt #departemen").val("");
            var id_cabang = (!$("#jt #cabang").val())? "all":$("#jt #cabang").val();
            $("#jt #departemen").select2({
                placeholder: 'Semua Departemen',
                allowClear: true,
                ajax: {
                    url: '<?= route("dashboard.absensi.grafik.joint.termination.dropdown.departemen") ?>'+'/'+id_cabang,
                    dataType: 'json',
                    delay: 250,
                    processResults: function (data) {
                    return {
                            results: data
                        };
                    },
                    cache: false
                }
            });

            updateGrafikBarJoinTermination();
        }

        // BEGIN DROPDOWN KETERLAMBATAN
        function dropdown_keterlambatan_cabang(){
            $("#keterlambatan #cabang").select2({
                placeholder: 'Semua Cabang',
                allowClear: true,
                ajax: {
                    url: '<?= route("dashboard.absensi.grafik.keterlambatan.dropdown.cabang") ?>',
                    dataType: 'json',
                    delay: 250,
                    processResults: function (data) {
                    return {
                            results: data
                        };
                    },
                    cache: false
                }
            });
        }

        function modalChart(url=""){
            $('#modal_chart #tampil_form').load(url,function(){
                $('#modal_chart').modal('show');
            });
        }
    }

</script>

<?php
    if(in_array($this->level_user, ["1"])) {
?>
        <div class="row f-12">
            <div class="col-md-4">
                <div class="card card-rounded">
                    <div class="card-absenku card-header card-info-absenku">
                        <h4 class="card-title">Paket Aktif</h4>
                        <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                        <div class="heading-elements">
                            <ul class="list-inline mb-0">
                                <li>
                                    <span></span>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div id="layanan" class="card-content collpase show">
                        <div class="card-body min-h-157">
                            <div class="row">
                                <div class="col-md-6">
                                    <h6><img src="<?= base_url('assets/images/icon/Layanan.png')?>" height="25"> Layanan</h6>
                                    <label id="nm_layanan"></label>
                                </div>
                                <div class="col-md-6">
                                    <h6><img src="<?= base_url('assets/images/icon/Karyawan.png')?>" height="25"> Karyawan</h6>
                                    <label id="ttl_karyawan"></label>
                                </div>
                                <div class="col-md-6">
                                    <h6> <img src="<?= base_url('assets/images/icon/Masa aktif.png')?>" height="25" alt=""> Masa Aktif </h6>
                                    <label id="ms_layanan"></label>
                                </div>
                            </div>


                        </div>
                    </div>
                </div>
            </div>

            <div id="karyawan" class="col-md-3">
                <div class="card card-rounded">
                    <div class="card-absenku card-header card-info-absenku">
                        <h4 class="card-title">
                            Jumlah Karyawan
                            <button type="button" class="navbar-toggler pull-right" data-toggle="collapse" data-target="#navbarToggleExternalContent">
                                <i class="fa fa-bars text-dark"></i>
                            </button>
                        </h4>
                        <div class="collapse mt-2" id="navbarToggleExternalContent">
                            <div class="row">
                                <div class="col-md-12">
                                    <select id="cabang" class="form-control" onchange="change_dropdown_karyawan_cabang()" style="width:100%"></select>
                                </div>
                            </div>
                            <div class="row mt-1">
                                <div class="col-md-12">
                                    <select id="departemen" class="form-control" onchange="ttlKaryawan()" style="width:100%"></select>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="card-content collpase show">
                        <div class="card-body min-h-157">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="row">
                                        <div class="col-md-2 col-2 p-0">
                                            <img src="<?= base_url('assets/images/icon/karyawan-pria.png')?>" class="img-responsive" style="max-height: 35px; object-fit: contain;">
                                        </div>
                                        <div class="col-md-10 col-10">
                                            <label id="persentase_pria" class="d-block"></label>
                                            <label id="ttl_pria"></lab>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="row">
                                        <div class="col-md-2 col-2 p-0">
                                            <img src="<?= base_url('assets/images/icon/karyawan-wanita.png')?>" class="img-responsive" style="max-height: 35px; object-fit: contain;">
                                        </div>
                                        <div class="col-md-10 col-10">
                                            <label id="persentase_wanita" class="d-block"></label>
                                            <label id="ttl_wanita"></lab>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row mt-1">
                                <div class="col-md-6">
                                    <div class="row">
                                        <div class="col-md-2 col-2 p-0">
                                            <img src="<?= base_url('assets/images/icon/total-karyawan.png')?>" class="img-responsive" style="max-height: 35px; object-fit: contain;">
                                        </div>
                                        <div class="col-md-10 col-10">
                                            <label class="d-block"><b>Total Karyawan</b></label>
                                            <label id="ttl_karyawan"></lab>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-5">
                <div class="card card-rounded">
                    <div class="card-absenku card-header card-info-absenku">
                        <h4 class="card-title">Pengaturan</h4>
                        <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                        <div class="heading-elements">
                            <ul class="list-inline mb-0">
                                <li>
                                    <span></span>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div id="layanan" class="card-content collpase show">
                        <div class="card-body min-h-157">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <a href="<?= route('master.lokasi.tambah') ?>">
                                                <h6 class="mb-2"><img src="<?= base_url('assets/images/icon/lokasi-absensi.png')?>" width="20"> Lokasi Absensi</h6>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <a href="<?= route('pengaturan.jamkerja.home') ?>">
                                                <h6 class="mb-2"><img src="<?= base_url('assets/images/icon/pengaturan-jam-kerja.png')?>" width="20"> Jam Kerja</h6>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <a href="<?= route('master.karyawan.tambah') ?>">
                                                <h6 class=""><img src="<?= base_url('assets/images/icon/tambah-karyawan.png')?>" width="20"> Tambah Karyawan</h6>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <a href="<?= route('pengaturan.izin.home') ?>">
                                                <h6 class="mb-2"><img src="<?= base_url('assets/images/icon/approval-izin.png')?>" width="20"> Approval Izin</h6>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <a href="<?= route('pengaturan.lembur.home') ?>">
                                                <h6 class="mb-2"><img src="<?= base_url('assets/images/icon/approval-lembur.png')?>" width="20"> Approval Lembur</h6>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <h6 class="font-weight-bold">Download App Mobile</h6>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <a href="https://play.google.com/store/apps/details?id=com.desnet.absenkukaryawanmobile" target="_blank">
                                                <img src="<?= base_url('assets/images/icon/playstore.png')?>" class="img-responsive" style="max-height: 35px; object-fit: contain;">
                                            </a>
                                        </div>
                                    </div>
                                    <div class="row mt-1">
                                        <div class="col-md-12">
                                            <a href="https://apps.apple.com/id/app/absenku-profesional/id1281215021?l=id" target="_blank">
                                                <img src="<?= base_url('assets/images/icon/appstore.png')?>" class="img-responsive" style="max-height: 35px; object-fit: contain;">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
<?php
    }
?>

<div class="row">
    <div id="ra" class="col-md-7">
        <div class="card card-rounded">
            <div class="card-absenku card-header card-info-absenku">
                <h4 class="card-title">Rekap Absensi Hari Ini</h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements" id="pilihan">
                    <ul class="list-inline mb-0">
                        <li><span class="tgls"></span></li>
                        <li><a data-action="expand"><i class="ft-maximize"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="card-content collpase show">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <a href="<?= site_url('pengaturan/hari-libur') ?>">
                                <button type="button" class="btn btn-outline-primary btn-min-width mr-1 mb-1">
                                    <i class="fa fa-calendar"></i> Kalender Absensi
                                </button>
                            </a>
                            <a href="#">
                                <button type="button" class="btn btn-outline-primary btn-min-width mr-1 mb-1" onclick="detail()">
                                    <i class="fa fa-eye"></i> Lihat Semua
                                </button>
                            </a>
                        </div>
                        <div class="col-md-6">
                            <?php
                                if(in_array($this->level_user, ["1","4"]) || $this->multi_cabang == true) {
                            ?>
                                    <div class="row">
                                        <div class="col-md-4 align-self-center">
                                            <label>Cabang</label>
                                            <label class="pull-right">:</label>
                                        </div>
                                        <div class="col-md-8">
                                            <select id="cabang" class="form-control" onchange="filter_list()"></select>
                                        </div>
                                    </div>
                            <?php
                                }
                            ?>
                            <div class="row mt-1">
                                <div class="col-md-4 align-self-center">
                                    <label>Jam Kerja</label>
                                    <label class="pull-right">:</label>
                                </div>
                                <div class="col-md-8 align-self-center">
                                    <select id="jam_kerja" class="form-control">
                                        <option value="all" selected="true">Semua</option>
                                        <option value="0">Reguler</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="row mt-1">
                        <div class="col-md-6">
                            <div id="chart-dashboard" style="height: 250px;"></div>
                        </div>
                        <div class="col-md-6">
                            <div>
                                <table class="table table-striped">
                                    <tbody>
                                        <tr>
                                            <td>Hadir</td>
                                            <td class="text-center text-primary cursor-pointer" id="hadir" onclick="detailRekap('hadir')"></td>
                                            <td class="text-right"> karyawan</td>
                                        </tr>
                                        <tr>
                                            <td>Terlambat</td>
                                            <td class="text-center text-primary cursor-pointer" id="terlambat" onclick="detailRekap('terlambat')"></td>
                                            <td class="text-right"> karyawan</td>
                                        </tr>
                                        <tr>
                                            <td>Belum Absen</td>
                                            <td class="text-center text-primary cursor-pointer" id="belum_absen" onclick="detailRekap('belum_absen')"></td>
                                            <td class="text-right"> karyawan</td>
                                        </tr>
                                        <tr>
                                            <td>Cuti</td>
                                            <td class="text-center text-primary cursor-pointer" id="cuti" onclick="detailRekap('cuti')"></td>
                                            <td class="text-right"> karyawan</td>
                                        </tr>
                                        <tr>
                                            <td>Izin</td>
                                            <td class="text-center text-primary cursor-pointer" id="izin" onclick="detailRekap('izin')"></td>
                                            <td class="text-right"> karyawan</td>
                                        </tr>
                                        <tr>
                                            <td>Sakit</td>
                                            <td class="text-center text-primary cursor-pointer" id="sakit" onclick="detailRekap('sakit')"></td>
                                            <td class="text-right"> karyawan</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-2" style="font-family: 'Poppins Medium';">
                        <div class="col-6 col-md-3">
                            <i class="fa fa-stop" style="color: #2883FA"></i> Hadir
                            <br>
                            <i class="fa fa-stop" style="color: #FFD700"></i> Terlambat
                            <br>
                            <i class="fa fa-stop" style="color: #F63939"></i> Belum Absen
                        </div>
                        <div class="col-6 col-md-3">
                            <i class="fa fa-stop" style="color: #07CF72"></i> Cuti
                            <br>
                            <i class="fa fa-stop" style="color: #FF9900"></i> Izin
                            <br>
                            <i class="fa fa-stop" style="color: #BA47E4"></i> Sakit
                            <br>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-5">
        <div class="card card-rounded">
            <div class="card-absenku card-header">
                <h4 class="card-title">Daftar Pengajuan</h4>
            </div>
            <div class="card-content collpase show">
                <div class="card-body">
                    <ul class="nav nav-tabs">
                        <li class="nav-item">
                            <a onclick="loadlst('izin')" class="nav-link active" id="base-tab1" data-toggle="tab" aria-controls="tab1" href="#tab1" aria-expanded="true">Izin/Cuti/Sakit</a>
                        </li>
                        <li class="nav-item">
                            <a onclick="loadlst('lembur')" class="nav-link" id="base-tab2" data-toggle="tab" aria-controls="tab2" href="#tab2" aria-expanded="false">Lembur</a>
                        </li>
                        <!--<li class="nav-item">
                            <a class="nav-link" id="base-tab3" data-toggle="tab" aria-controls="tab3" href="#tab3" aria-expanded="false">Tukar Shift</a>
                        </li> -->
                    </ul>

                    <div class="tab-content daftar-pengajuan">
                        <div role="tabpanel" class="tab-pane active" id="tab1" aria-expanded="true" aria-labelledby="base-tab1">
                            <div class="row">
                                <div class="col-md-12 col-sm-12" id="lstizin" style="height: 355px; overflow-y: auto;">

                                </div>
                                <div class="col-md-12 col-sm-12 text-center">
                                    <a href="<?= site_url('pengajuan/izin'); ?>">
                                        <button type="button" class="btn btn-outline-biru round btn-min-width">
                                            Lihat Semua
                                        </button>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane" id="tab2" aria-labelledby="base-tab2">
                            <div class="row">
                                <div class="col-md-12 col-sm-12" id="lstlembur" style="height: 355px; overflow-y: auto;">

                                </div>
                                <div class="col-md-12 col-sm-12 text-center">
                                    <a href="<?= site_url('pengajuan/lembur'); ?>">
                                        <button type="button" class="btn btn-outline-biru round btn-min-width">
                                            Lihat Semua
                                        </button>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
    if(in_array($this->level_user, ["1"])) {
?>
        <!-- <div class="row">
            <div id="dk" class="col-md-6">
                <div class="card card-rounded">
                    <div class="card-absenku card-header card-info-absenku">
                        <h4 class="card-title">Data Karyawan</h4>
                    </div>
                    <div class="row p-2">
                        <div class="col-md-6">
                            <select id="cabang" class="form-control" onchange="change_dropdown_dk_cabang()"></select>
                        </div>
                        <div class="col-md-6">
                            <select id="departemen" class="form-control" onchange="updateGrafikBarDataKaryawan()"></select>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <canvas id="data_karyawan" class="p-1"></canvas>
                        </div>
                    </div>
                </div>
            </div>

            <div id="jt" class="col-md-6">
                <div class="card card-rounded">
                    <div class="card-absenku card-header card-info-absenku">
                        <h4 class="card-title">Join vs Termination</h4>
                    </div>
                    <div class="row p-2">
                        <div class="col-md-2">
                            <select id="tahun" class="form-control" onchange="updateGrafikBarJoinTermination()">
                                <option id="<?= date('Y') ?>"><?= date('Y') ?></option>
                            </select>
                        </div>
                        <div class="col-md-5">
                            <select id="cabang" class="form-control" onchange="change_dropdown_jt_cabang()"></select>
                        </div>
                        <div class="col-md-5">
                            <select id="departemen" class="form-control" onchange="updateGrafikBarJoinTermination()"></select>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <canvas id="join_termination" class="p-1"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    <div id="keterlambatan" class="row">
        <div class="col-md-12">
            <div class="card card-rounded">
                <div class="card-absenku card-header card-info-absenku">
                    <h4 class="card-title">Rasio Keterlambatan</h4>
                </div>
                <div class="row p-2">
                    <div class="col-md-4">
                        <select id="cabang" class="form-control" onchange="updateGrafikKeterlambatan()"></select>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <div class="input-group input-daterange">
                                <input type="text" id="tanggal_mulai" class="form-control masktanggal" value="<?= "01-".date('m-Y'); ?>" onchange="updateGrafikKeterlambatan()">
                                <div class="align-self-center">&nbsp;s/d&nbsp;</div>
                                <input type="text" id="tanggal_selesai" class="form-control masktanggal" value="<?= date('d-m-Y') ?>" onchange="updateGrafikKeterlambatan()">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12 chart-container">
                        <canvas id="grafik_keterlambatan" class="p-1" style="height: 400px"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div> -->
<?php
    }
?>

<!-- START TAMPIL MODAL -->
<div id="modal_chart" class="modal fade in">
    <div class="modal-dialog modal-xl">
        <div id="tampil_form" class="modal-content"></div>
    </div>
</div>
<!-- END TAMPIL MODAL -->


<?php
    if(in_array($this->level_user, ["1"])) {
?>

<!-- <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.4.0/Chart.min.js"></script> -->

<!-- BEGIN GRAFIK BAR DATA KARYAWAN-->
<!-- <script>
    var barOptions_dk = {
        pointLabelFontFamily: "Quadon Extra Bold",
        scaleFontFamily: "Quadon Extra Bold",
        tooltips: {
            enabled: false,
        },
        hover: {
            animationDuration: 0,
            onHover: function(e) {
                $("#data_karyawan").css("cursor", e[0] ? "pointer" : "default");
            }
        },
        scales: {

            xAxes: [
                {
                    ticks: {
                        beginAtZero: true,
                        fontFamily: "Poppins SemiBold",
                        fontSize: 11,
                    },
                    scaleLabel: {
                        display: false
                    },
                    gridLines: {
                        display: false,
                        color: "#fff",
                        zeroLineColor: "#fff",
                        zeroLineWidth: 0
                    },
                    stacked: true
                }
            ],
            yAxes: [
                {
                    gridLines: {},
                    ticks: {
                        fontFamily: "Poppins SemiBold",
                        fontSize: 11,
                        beginAtZero: true,
                        // userCallback: function(label, index, labels) {
                        //     // when the floored value is the same as the value we have a whole number
                        //     if (Math.floor(label) === label) {
                        //         return label;
                        //     }
                        // },
                        // min: -30, // minimum value
                        // max: 140
                    },
                    stacked: true
                }
            ]
        },
        legend: {
            display: false
        },
        animation: {
            onComplete: function() {
                var chartInstance = this.chart;
                var ctx = chartInstance.ctx;
                ctx.textAlign = "center";
                ctx.font = "12px";
                ctx.fillStyle = "#1C77D4";
                ctx.fontWeight = "bold";
                // ctx.fillStyle = "#fff";

                Chart.helpers.each(
                    this.data.datasets.forEach(function(dataset, i) {
                        var meta = chartInstance.controller.getDatasetMeta(i);
                        Chart.helpers.each(
                            meta.data.forEach(function(bar, index) {
                            data = dataset.data[index];
                                if(i == 0) {
                                    ctx.fillText(data, bar._model.x, bar._model.y - 10);
                                }
                            }),
                            this
                        );
                    }),
                    this
                );
            }
        },
        onClick: (event, item) => {
            var tahun           = chart_dk.getElementAtEvent(event)[0]._view['label'];
            var id_cabang       = (!$("#dk #cabang").val())?"all":$("#dk #cabang").val();
            var id_departemen   = (!$("#dk #departemen").val())?"all":$("#dk #departemen").val();

            var url = "<?= route('dashboard.absensi.grafik.data.karyawan.form') ?>"+"/"+tahun+"/"+id_cabang+"/"+id_departemen;

            return modalChart(url);
        },
    };

    var idDk = document.getElementById("data_karyawan");
    var chart_dk = new Chart(idDk, {
                    type: "bar",
                    data: {
                            labels: [],
                                datasets: [
                                        {
                                            data: [],
                                            backgroundColor: "rgb(11, 98, 164)"
                                        }
                                    ]},
                    options: barOptions_dk
                });

    function updateGrafikBarDataKaryawan(){
        var id_cabang       = (!$("#dk #cabang").val())?"all":$("#dk #cabang").val();
        var id_departemen   = (!$("#dk #departemen").val())?"all":$("#dk #departemen").val();
        $.ajax({
                type: 'GET',
                dataType: 'json',
                url: '<?= route("dashboard.absensi.grafik.data.karyawan.data") ?>'+'/'+id_cabang+'/'+id_departemen,
                success: function (result, textStatus, jqXHR){
                    // max_value =  Math.max.apply(Math,result.data.ttl_karyawan);
                    max_value =  (Math.max.apply(Math,result.data.ttl_karyawan)).toString();
                    satuan = max_value.substring((max_value.length) - 1);
                    // alert(satuan);
                    val_plus = 20 - parseInt(satuan);


                    chart_dk.data.labels = result.data.label;
                    chart_dk.data.datasets[0].data = result.data.ttl_karyawan;
                    // chart_dk.options.scales.yAxes[0].ticks.max = Math.max.apply(Math,result.data.ttl_karyawan) + val_plus;
                    chart_dk.update();
                }
            });

    }

</script> -->
<!-- END GRAFIK BAR DATA KARYAWAN-->

<!-- BEGIN GRAFIK BAR JOIN VS TERMINTAION -->
<!-- <script>
    var barOptions_jt = {
        // indexAxis: 'y',
        tooltips: {
            enabled: false,
        },
        legend: {
            display: true,
        },
        hover: {
            animationDuration: 0,
            onHover: function(e) {
                $("#join_termination").css("cursor", e[0] ? "pointer" : "default");
            }
        },

        scales: {
            xAxes: [
                {
                    ticks: {
                        beginAtZero: true,
                        fontFamily: "Poppins SemiBold",
                        fontSize: 11,
                    },
                    scaleLabel: {
                        display: false
                    },
                    gridLines: {
                        display: false,
                        color: "#fff",
                        zeroLineColor: "#fff",
                        zeroLineWidth: 0
                    },
                    stacked: true,
                }
            ],
            yAxes: [
                {
                    gridLines: {},
                    ticks: {
                        fontFamily: "Poppins SemiBold",
                        fontSize: 11,
                        beginAtZero: true,
                        userCallback: function(label, index, labels) {
                            // when the floored value is the same as the value we have a whole number
                            if (Math.floor(label) === label) {
                                return label;
                            }

                        },
                        // min: -30, // minimum value
                        // max: 10
                    },
                    stacked: true,
                }
            ]
        },

        animation: {
            onComplete: function() {
                var chartInstance = this.chart;
                var ctx = chartInstance.ctx;
                ctx.textAlign = "center";
                ctx.font = "12px";
                // ctx.fillStyle = "#fff";
                ctx.fillStyle = "#1C77D4";

                Chart.helpers.each(
                    this.data.datasets.forEach(function(dataset, i) {
                        var meta = chartInstance.controller.getDatasetMeta(i);
                        Chart.helpers.each(
                            meta.data.forEach(function(bar, index) {
                            data = dataset.data[index];
                                if(i == 0) {
                                    data = Math.abs(data);
                                    if(data != 0){
                                        ctx.fillText(data, bar._model.x, bar._model.y + 5);
                                    }
                                }else{
                                    if(data != 0){
                                        ctx.fillText(data, bar._model.x, bar._model.y - 15);
                                    }
                                }
                            }),
                            this
                        );
                    }),
                    this
                );
            }
        },
        pointLabelFontFamily: "Quadon Extra Bold",
        scaleFontFamily: "Quadon Extra Bold",
        onClick: (event, item) => {
            var jenis           = chart_jt.getElementAtEvent(event)[0]._view['datasetLabel']
            var tahun           = $("#jt #tahun").val();
            var bulan           = chart_jt.getElementAtEvent(event)[0]._view['label'];
            var id_cabang       = (!$("#jt #cabang").val())?"all":$("#jt #cabang").val();
            var id_departemen   = (!$("#jt #departemen").val())?"all":$("#jt #departemen").val();

            var url = "<?= route('dashboard.absensi.grafik.joint.termination.form') ?>"+"/"+jenis+"/"+tahun+"/"+bulan+"/"+id_cabang+"/"+id_departemen;

            return modalChart(url)
        },

    };

    var idJt = document.getElementById("join_termination");
    var chart_jt = new Chart(idJt, {
                    type: "bar",
                    data: {
                            labels: [],
                                datasets: [
                                        {
                                            label : "Termination",
                                            data: [],
                                            backgroundColor: "rgb(122, 146, 163)"
                                        },
                                        {
                                            label : "Join",
                                            data: [],
                                            backgroundColor: "rgb(11, 98, 164)"
                                        },
                                        // {
                                        //     label : "Mutasi In",
                                        //     data: [0,0,0,0,0,0,1],
                                        //     backgroundColor: "#42855B"
                                        // },
                                        // {
                                        //     label : "Mutasi Out",
                                        //     data: [0,0,0,0,0,0,-1],
                                        //     backgroundColor: "#483838"
                                        // }
                                    ]},
                    options: barOptions_jt
                });

    function updateGrafikBarJoinTermination(){
        var tahun           = $("#jt #tahun").val();
        var id_cabang       = (!$("#jt #cabang").val())?"all":$("#jt #cabang").val();
        var id_departemen   = (!$("#jt #departemen").val())?"all":$("#jt #departemen").val();
        $.ajax({
                type: 'GET',
                dataType: 'json',
                url: '<?= route("dashboard.absensi.grafik.joint.termination.data") ?>'+'/'+tahun+'/'+id_cabang+'/'+id_departemen,
                success: function (result, textStatus, jqXHR){
                    chart_jt.data.labels = result.data.label;
                    chart_jt.data.datasets[0].data = result.data.termination;
                    chart_jt.data.datasets[1].data = result.data.joint;
                    chart_jt.update();
                }
            });

    }

    function handleClick(tahun, bulan, id_cabang, id_departemen){
        alert("tahun = "+tahun+", bulan ="+bulan+", id_cabang ="+id_cabang+", id_departemen ="+id_departemen);
    }

</script> -->
<!-- END GRAFIK BAR JOIN VS TERMINATION -->


<!-- BEGIN GRAFIK BAR KETERLAMBATAN -->
<!-- <script>
    var barOptions_keterlambatan = {
        responsive: true,
        maintainAspectRatio: false,
        tooltips: {
            enabled: false,
        },
        hover: {
            animationDuration: 0
        },
        scales: {

            xAxes: [
                {
                    ticks: {
                        beginAtZero: true,
                        fontFamily: "Poppins SemiBold",
                        fontSize: 11,
                        userCallback: function(label, index, labels) {
                            // when the floored value is the same as the value we have a whole number
                            if (Math.floor(label) === label) {
                                return label;
                            }
                        },
                    },
                    scaleLabel: {
                        display: false
                    },
                    gridLines: {},
                    stacked: true,
                    scaleLabel: {
                        display: true,
                        labelString: 'Total Kehadiran'
                    }
                }
            ],
            yAxes: [
                {
                    gridLines: {
                        display: false,
                        color: "#fff",
                        zeroLineColor: "#fff",
                        zeroLineWidth: 0
                    },
                    ticks: {
                        fontFamily: "Poppins SemiBold",
                        fontSize: 11
                    },
                    stacked: true,
                    scaleLabel: {
                        display: true,
                        labelString: 'Kode Departemen'
                    }
                }
            ]
        },
        legend: {
            display: true,
            onClick: (e) => e.stopPropagation()
        },
        animation: {
            onComplete: function() {
                var chartInstance = this.chart;
                var ctx = chartInstance.ctx;
                ctx.textAlign = "center";
                ctx.font = "10px Poppins SemiBold";

                ttl = {};
                this.data.datasets[0].data.forEach(function(data, index) {
                    var total = parseInt(data) + parseInt(this.data.datasets[1].data[index]);
                    var meta = chartInstance.controller.getDatasetMeta(1);
                    var posX = meta.data[index]._model.x;
                    var posY = meta.data[index]._model.y;
                    ttl[index] = total;
                }, this);

                Chart.helpers.each(
                    this.data.datasets.forEach(function(dataset, i) {
                        var meta = chartInstance.controller.getDatasetMeta(i);
                        Chart.helpers.each(
                            meta.data.forEach(function(bar, index) {
                                data = dataset.data[index];

                                if(i == 0) {
                                    if(data == "0"){
                                        val = 0;
                                    }else{
                                        val = (Math.round((data/ttl[index]) * 100));
                                    }

                                    // console.log(data+",/ ttl = "+ttl[index]+", val = "+val);
                                    if(val == 100){
                                        ctx.fillStyle = "red";
                                        ctx.fillText(val+" % dari "+ttl[index]+" Total Karyawan", bar._model.x + 75, bar._model.y - 4);
                                    }else if(val != 0){
                                        ctx.fillStyle = "#000000";
                                        ctx.fillText(val+" %", bar._model.x + 20, bar._model.y - 4);
                                    }
                                }else{
                                    val = (Math.round((data/ttl[index]) * 100));
                                    if(val != 0){
                                        ctx.fillStyle = "#1C77D4";
                                        // ctx.fillText(ttl[index], bar._model.x + 10, bar._model.y - 4);
                                        ctx.fillText(dataset.jmlKaryawan[index]+" Karyawan", bar._model.x + 40, bar._model.y - 4);
                                    }
                                }
                            }),
                            this
                        );
                    }),
                    this
                );
            }
        },
        pointLabelFontFamily: "Quadon Extra Bold",
        scaleFontFamily: "Quadon Extra Bold"
    };

    var id_grafik_keterlambatan = document.getElementById("grafik_keterlambatan");
    var chart_keterlambatan = new Chart(id_grafik_keterlambatan, {
                                type: "horizontalBar",
                                data: {
                                        labels: [],
                                            datasets: [
                                                    {
                                                        label : "Persentase Terlambat dari Total Kehadiran",
                                                        data: [],
                                                        backgroundColor: "rgb(122, 146, 163)"
                                                    },
                                                    {
                                                        label : "Total Kehadiran",
                                                        data: [],
                                                        backgroundColor: "rgb(11, 98, 164)",
                                                        jmlKaryawan:[]
                                                    },
                                                ]},
                                options: barOptions_keterlambatan
                            });

    function updateGrafikKeterlambatan(){
        var id_cabang = (!$("#keterlambatan #cabang").val())?"all":$("#keterlambatan #cabang").val();
        var tgl_mulai = $("#keterlambatan #tanggal_mulai").val();
        var tgl_selesai = $("#keterlambatan #tanggal_selesai").val();
        $.ajax({
                type: 'GET',
                dataType: 'JSON',
                url: '<?= route("dashboard.absensi.grafik.keterlambatan.data") ?>'+'/'+id_cabang+'/'+tgl_mulai+'/'+tgl_selesai,
                success: function (result, textStatus, jqXHR){
                    chart_keterlambatan.data.labels = result.data.label;
                    chart_keterlambatan.data.datasets[0].data = result.data.terlambat;
                    chart_keterlambatan.data.datasets[1].data = result.data.tepat_waktu;
                    chart_keterlambatan.data.datasets[1].jmlKaryawan = result.data.ttl_karyawan;
                    chart_keterlambatan.update();
                }
            });

    }
</script> -->
<!-- END GRAFIK BAR KETERLAMBATAN -->

<?php
    }
?>

<script src="<?= base_url('assets/js/home_realtime_date.js') ?>"></script>
<script>
    $(document).ready(function(){
        loadlst('izin');
    });
    function loadlst(tp = '')
    {
        $('#lst'+tp).html('');
        $('#lst'+tp).load('<?php echo route('dashboard.list.data') ?>/'+tp);
    }
</script>
