<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class TidakTetap_m extends CI_Model {
    var $table = "payroll_pot_tdk_tetap_m";

    function get_datatables($id_karyawan="all", $bulan="all"){
        $this->_get_datatables_query($id_karyawan, $bulan);
        if($_POST['length'] != -1){
            $this->db->limit($_POST['length'], $_POST['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered($id_karyawan="all", $bulan="all"){
        if($id_karyawan != "all"){
            $this->db->where("md5(ptt.id_karyawan)",$id_karyawan);
        }

        if($bulan != 'all'){
            $this->db->where("ptt.periode",$bulan);
        }

        $this->db->select("id_karyawan");
        $this->db->from($this->table." AS ptt");
        $this->db->where("id_company",$this->id_company);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all($id_karyawan="all", $bulan="all"){
        if($id_karyawan != "all"){
            $this->db->where("md5(ptt.id_karyawan)",$id_karyawan);
        }

        if($bulan != 'all'){
            $this->db->where("ptt.periode",$bulan);
        }

        $this->db->select("id_karyawan");
        $this->db->from($this->table." AS ptt");
        $this->db->where("id_company",$this->id_company);
        return $this->db->count_all_results();
    }
    private function _get_datatables_query($id_karyawan="all", $bulan="all"){
        if($id_karyawan != "all"){
            $this->db->where("md5(ptt.id_karyawan)",$id_karyawan);
        }

        if($bulan != 'all'){
            $this->db->where("ptt.periode",$bulan);
        }

        $this->db->select("dk.nama_lengkap AS nm_karyawan,
                        dk.nik,
                        mc.kode AS kd_cabang,
                        mc.nama AS nm_cabang,
                        mj.nama as nm_jabatan,
                        mj.kode_jabatan as kd_jabatan,
                        md.nama as nm_departemen,
                        md.kode as kd_departemen,
                        ptt.id_item,
                        ptt.id_karyawan,
                        ptt.periode,
                        SUM(ptt.nominal_potongan) as nominal,
                        ptt.flag_persentase_gapok,
                        ptt.gapok_persen,
                        ptt.gapok_rp,
                        ptt.flag_bpjs,
                        ptt.flag_pph21,
                        ptt.flag_pot_absensi,
                        ptt.nm_potongan,
                        mg.nominal as nominal_gapok");
        $this->db->from($this->table." AS ptt");
        $this->db->join("data_karyawan AS dk","dk.id_karyawan = ptt.id_karyawan");
        $this->db->join("master_jabatan AS mj","mj.id_jabatan = dk.id_jabatan");
        $this->db->join("master_cabang AS mc","mc.id_cabang = dk.id_cabang");
        $this->db->join("master_departemen AS md","md.id_departemen = dk.id_departemen", "LEFT");
        $this->db->join("payroll_gapok_m AS mg","mg.id_karyawan = dk.id_karyawan", "LEFT");
        $this->db->where("ptt.id_company",$this->id_company);
        $this->db->group_by("ptt.id_karyawan");


        $column_search = array('');
        $i = 0;

        foreach ($column_search as $item){  // looping awal
            if($_POST['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST

                if($i===0){ // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_POST['search']['value']);
                }else{
                    $this->db->or_like($item, $_POST['search']['value']);
                }

                if(count($column_search) - 1 == $i){
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array('');

        if(isset($_POST['order'])){
            $this->db->order_by($column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else{
            // $order_by = array("ptt.bulan"=>"DESC","ptt.tgl_input"=>"DESC");
            // $this->db->order_by(key($order_by), $order_by[key($order_by)]);
            $this->db->order_by("ptt.periode DESC, ptt.tgl_input DESC");
        }
    }

    public function getDataById($key=""){
        $this->db->select("
                        ptt.id_item,
                        ptt.id_karyawan,
                        ptt.periode,
                        ptt.nm_potongan,
                        ptt.flag_persentase_gapok,
                        ptt.gapok_persen,
                        ptt.gapok_rp,
                        ptt.flag_bpjs,
                        ptt.flag_pph21,
                        ptt.flag_pot_absensi,
                        ptt.nominal_potongan");
        $this->db->from($this->table." AS ptt");
        $this->db->where("md5(ptt.id_item)",$key);
        $this->db->where("ptt.id_company",$this->id_company);
        $query = $this->db->get();
        return $query->row();
    }


    public function getDataKaryawan($id_karyawan=null){
        $this->db->select("dk.nama_lengkap AS nm_karyawan,
                        dk.nik,
                        dk.id_karyawan,
                        mc.kode AS kd_cabang,
                        mc.nama AS nm_cabang,
                        mj.nama as nm_jabatan,
                        mj.kode_jabatan as kd_jabatan,
                        md.nama as nm_departemen,
                        md.kode as kd_departemen,
                        mg.nominal as nominal_gapok");
        $this->db->from("data_karyawan AS dk");
        $this->db->join("master_jabatan AS mj","mj.id_jabatan = dk.id_jabatan", "LEFT");
        $this->db->join("master_cabang AS mc","mc.id_cabang = dk.id_cabang", "LEFT");
        $this->db->join("master_departemen AS md","md.id_departemen = dk.id_departemen", "LEFT");
        $this->db->join("payroll_gapok_m AS mg","mg.id_karyawan = dk.id_karyawan", "LEFT");
        $this->db->where("md5(dk.id_karyawan)",$id_karyawan);
        $this->db->where("dk.id_company",$this->id_company);
        $query = $this->db->get();
        return $query->result();
    }

    public function getItemTable($id_karyawan=null, $bulan=null){
        $this->db->select("dk.nama_lengkap AS nm_karyawan,
                        dk.nik,
                        ptt.id_item,
                        ptt.id_karyawan,
                        ptt.periode,
                        ptt.flag_gaji,
                        ptt.nm_potongan,
                        ptt.flag_persentase_gapok,
                        ptt.gapok_persen,
                        ptt.gapok_rp,
                        ptt.flag_bpjs,
                        ptt.flag_pph21,
                        ptt.flag_pot_absensi,
                        ptt.nominal_potongan as nominal");
        $this->db->from($this->table." AS ptt");
        $this->db->join("data_karyawan AS dk","dk.id_karyawan = ptt.id_karyawan");
        $this->db->where("md5(ptt.id_karyawan)",$id_karyawan);
        $this->db->where("ptt.periode", $bulan);
        $this->db->where("ptt.id_company",$this->id_company);
        $query = $this->db->get();
        return $query->result();
    }

    private function _getId(){
		$curent_month = date('ym');
        $select = $this->db->select('MAX(id_item) as id')
                           ->from($this->table)
                           ->where('id_company', $this->id_company)
                           ->get()
                           ->row();

        if(!empty($select->id)){
            $last_id = substr($select->id,-5);
			$next_id = $last_id+1;
			$nextid = $this->id_company.$curent_month.sprintf("%05d", $next_id);
		}else{
			$nextid = $this->id_company.$curent_month.'00001';
		}

		return $nextid;

	}


    public function save($data=null, $id_karyawan=null){
        $key = $this->input->post('key');

        $this->db->trans_start();

        $this->db->select("id_item");
        $this->db->from($this->table);
        $this->db->where("md5(id_item)", $key);
        if ($id_karyawan != null) {
            $this->db->where("id_karyawan", $id_karyawan);
        }
        $this->db->where("id_company",$this->id_company);
        $cek_data = $this->db->get()->num_rows();

        if($key != null){
            if($cek_data < 1){
                return  __response_update(false,["message"=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>GAGAL: Data tidak ditemukan</font>']);
            }else{
                $this->db->where(array(
                    'md5(id_item)'  =>$key,
                    'id_company'    =>$this->id_company
                ));

                $data["user_update"]    = $this->id_karyawan;
                $data["tgl_update"]     = date('Y-m-d H:i:s');
                $update = $this->db->update($this->table, $data);
                $response = 'update';
            }
        }else{
            $periode = $this->input->post('periode');

            if($cek_data > 0){
                return  __response_save(false,["message"=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>GAGAL: Data sudah ada</font>']);
            }else{
                $data["id_item"]        = $this->_getId();
                $data["id_karyawan"]    = $id_karyawan;
                $data["periode"]        = $periode;
                $data["id_company"]     = $this->id_company;
                $data["user_input"]     = $this->id_karyawan;
                $this->db->insert($this->table, $data);
                $response = 'save';
            }
        }
        $this->db->trans_complete();

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            if ($response == "update") {
                return  __response_update(false);
            }else if ($response == "save") {
                return  __response_save(false);
            }
        }else{
            $this->db->trans_commit();
            if ($response == "update") {
                return  __response_update(true);
            }else if ($response == "save") {
                return  __response_save(true);
            }
        }
    }

    public function delete($key=null){
            $this->db->where(array('md5(id_item)'=>$key, 'id_company' => $this->id_company));
            $delete =$this->db->delete($this->table);
            return __response_delete($delete);
    }
}
