<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Komponen_m extends CI_Model {

    public function __construct(){
		parent::__construct();
        $this->id_company  = $this->session->userdata('id_company');
        $this->id_karyawan = $this->session->userdata('id_karyawan');
        $this->nama_user   = $this->session->userdata('nama_user');
	}

    public function insert($periode) {
        // HAPUS
        $this->db->where('periode', $periode);
        $this->db->where('id_company', $this->id_company);
        $this->db->delete('payroll_komponen_trx');

        // INSERT
        $sql = "INSERT INTO payroll_komponen_trx(
                    id_item,
                    periode,
                    jenis_komponen,
                    jenis_master,
                    nm_komponen,
                    flag_persentase_gapok,
                    gapok_persen,
                    flag_bpjs,
                    flag_pph21,
                    flag_pot_absensi,
                    no_urut,
                    id_company,
                    user_input)
                SELECT
                    id_item,
                    ?,
                    jenis_komponen,
                    jenis_master,
                    nm_komponen,
                    flag_persentase_gapok,
                    gapok_persen,
                    flag_bpjs,
                    flag_pph21,
                    flag_pot_absensi,
                    no_urut,
                    id_company,
                    ?
                FROM payroll_komponen_m
                WHERE id_company = ?";
        $this->db->query($sql, [$periode, $this->id_karyawan.'-'.$this->nama_user, $this->id_company]);
    }

    private function cek($periode) {
        $this->db->from('payroll_komponen_trx');
        $this->db->where('id_company', $this->id_company);
        $this->db->where('periode', $periode);
        return $this->db->count_all_results();
    }

    public function master_trx($periode, $jenis_komponen, $jenis_master, $flag_pph21 = false) {
        if ($flag_pph21) {
            $this->db->where('flag_pph21', '1');
        }
        $this->db->select('nm_komponen');
        $this->db->from('payroll_komponen_trx');
        $this->db->where('periode', $periode);
        $this->db->where('jenis_komponen', $jenis_komponen);
        $this->db->where('jenis_master', $jenis_master);
        $this->db->where('id_company', $this->id_company);
        $this->db->order_by('no_urut', 'asc');
        $this->db->order_by('nm_komponen', 'asc');
        return $this->db->get();
    }

    public function tunj_tetap_trx($periode, $id_karyawan = null, $flag_pph21 = false) {
        if ($flag_pph21) {
            $this->db->where('komp.flag_pph21', '1');
        }
        $this->db->select('IFNULL(tunj.nominal_tunjangan, 0) as nominal_tunjangan, id_karyawan, nm_tunjangan', FALSE);
        $this->db->from('payroll_komponen_trx komp');
        if ($id_karyawan) {
            $this->db->join('payroll_tunj_tetap_trx tunj', "tunj.id_item = komp.id_item and tunj.id_karyawan = '$id_karyawan' and tunj.periode = komp.periode", 'left');
        }else{
            $this->db->join('payroll_tunj_tetap_trx tunj', "tunj.id_item = komp.id_item and tunj.periode = komp.periode", 'left');
        }
        $this->db->where('komp.id_company', $this->id_company);
        $this->db->where('komp.periode', $periode);
        $this->db->where('komp.jenis_komponen', 'tetap');
        $this->db->where('komp.jenis_master', 'pendapatan');
        $this->db->order_by('komp.no_urut', 'asc');
        $this->db->order_by('komp.nm_komponen', 'asc');

        if ($id_karyawan) {
            return $this->db->get();
        }

        $data = [];
        foreach ($this->db->get()->result() as $key) {
            $data[$key->id_karyawan][] = [
                $key->nm_tunjangan => $key->nominal_tunjangan
            ];
        }
        return json_encode($data);
    }

    public function tunj_tdk_tetap_trx($periode, $id_karyawan = null) {
        $this->db->select('IFNULL(tunj.nominal_tunjangan, 0) as nominal_tunjangan, id_karyawan, nm_tunjangan', FALSE);
        $this->db->from('payroll_komponen_trx komp');
        if ($id_karyawan) {
            $this->db->join('payroll_tunj_tdk_tetap_trx tunj', "tunj.id_item = komp.id_item and tunj.id_karyawan = '$id_karyawan' and tunj.periode = komp.periode", 'left');
        }else{
            $this->db->join('payroll_tunj_tdk_tetap_trx tunj', "tunj.id_item = komp.id_item and tunj.periode = komp.periode", 'left');
        }
        $this->db->where('komp.id_company', $this->id_company);
        $this->db->where('komp.periode', $periode);
        $this->db->where('komp.jenis_komponen', 'tidak tetap');
        $this->db->where('komp.jenis_master', 'pendapatan');
        $this->db->order_by('komp.no_urut', 'asc');
        $this->db->order_by('komp.nm_komponen', 'asc');

        if ($id_karyawan) {
            return $this->db->get();
        }

        $data = [];
        foreach ($this->db->get()->result() as $key) {
            $data[$key->id_karyawan][] = [
                $key->nm_tunjangan => $key->nominal_tunjangan
            ];
        }
        return json_encode($data);
    }

    public function pot_tetap_trx($periode, $id_karyawan = null, $flag_pph21 = false) {
        if ($flag_pph21) {
            $this->db->where('komp.flag_pph21', '1');
        }
        $this->db->select('IFNULL(pot.nominal_potongan, 0) as nominal_potongan, id_karyawan, nm_potongan', FALSE);
        $this->db->from('payroll_komponen_trx komp');
        if ($id_karyawan) {
            $this->db->join('payroll_pot_tetap_trx pot', "pot.id_item = komp.id_item and pot.id_karyawan = '$id_karyawan' and pot.periode = komp.periode", 'left');
        }else{
            $this->db->join('payroll_pot_tetap_trx pot', "pot.id_item = komp.id_item and pot.periode = komp.periode", 'left');
        }
        $this->db->where('komp.id_company', $this->id_company);
        $this->db->where('komp.periode', $periode);
        $this->db->where('komp.jenis_komponen', 'tetap');
        $this->db->where('komp.jenis_master', 'potongan');
        $this->db->order_by('komp.no_urut', 'asc');
        $this->db->order_by('komp.nm_komponen', 'asc');

        if ($id_karyawan) {
            return $this->db->get();
        }

        $data = [];
        foreach ($this->db->get()->result() as $key) {
            $data[$key->id_karyawan][] = [
                $key->nm_potongan => $key->nominal_potongan
            ];
        }
        return json_encode($data);
    }

    public function pot_tdk_tetap_trx($periode, $id_karyawan = null) {
        $this->db->select('IFNULL(pot.nominal_potongan, 0) as nominal_potongan, id_karyawan, nm_potongan', FALSE);
        $this->db->from('payroll_komponen_trx komp');
        if ($id_karyawan) {
            $this->db->join('payroll_pot_tdk_tetap_trx pot', "pot.id_item = komp.id_item and pot.id_karyawan = '$id_karyawan' and pot.periode = komp.periode", 'left');
        }else{
            $this->db->join('payroll_pot_tdk_tetap_trx pot', "pot.id_item = komp.id_item and pot.periode = komp.periode", 'left');
        }
        $this->db->where('komp.id_company', $this->id_company);
        $this->db->where('komp.periode', $periode);
        $this->db->where('komp.jenis_komponen', 'tidak tetap');
        $this->db->where('komp.jenis_master', 'potongan');
        $this->db->order_by('komp.no_urut', 'asc');
        $this->db->order_by('komp.nm_komponen', 'asc');

        if ($id_karyawan) {
            return $this->db->get();
        }

        $data = [];
        foreach ($this->db->get()->result() as $key) {
            $data[$key->id_karyawan][] = [
                $key->nm_potongan => $key->nominal_potongan
            ];
        }
        return json_encode($data);
    }

    public function count_komponen($periode) {
        $this->db->select("SUM(IF(jenis_komponen = 'tetap' AND jenis_master = 'pendapatan', 1, 0)) as tunj_tetap", FALSE);
        $this->db->select("SUM(IF(jenis_komponen = 'tidak tetap' AND jenis_master = 'pendapatan', 1, 0)) as tunj_tdk_tetap", FALSE);
        $this->db->select("SUM(IF(jenis_komponen = 'tetap' AND jenis_master = 'potongan', 1, 0)) as pot_tetap", FALSE);
        $this->db->select("SUM(IF(jenis_komponen = 'tidak tetap' AND jenis_master = 'potongan', 1, 0)) as pot_tdk_tetap", FALSE);
        $this->db->from('payroll_komponen_trx');
        $this->db->where('id_company', $this->id_company);
        $this->db->where('periode', $periode);
        $data = $this->db->get()->row();

        $count = 0;
        if($data->tunj_tetap > $count) {
            $count = $data->tunj_tetap;
        }
        if($data->tunj_tdk_tetap > $count) {
            $count = $data->tunj_tdk_tetap;
        }
        if($data->pot_tetap > $count) {
            $count = $data->pot_tetap;
        }
        if($data->pot_tdk_tetap > $count) {
            $count = $data->pot_tdk_tetap;
        }

        return $count;
    }
}
