<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Kalender_m extends CI_Model {
    var $table = 'holidays';

    function get_datatables(){
        $this->_get_datatables_query();
        if($_GET['length'] != -1){
            $this->db->limit($_GET['length'], $_GET['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }
    
    function count_filtered(){
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
    
    public function count_all(){
        $this->db->select("id")->from($this->table);
        $this->db->where("id_company",$_SESSION['id_company']);
        return $this->db->count_all_results();
    }
    
    private function _get_datatables_query(){
        $this->db->select("id,tanggal,keterangan")->from($this->table);
        $this->db->where("id_company",$_SESSION['id_company']);
        $column_search = array('keterangan');
        $i = 0;
    
        foreach ($column_search as $item){  // looping awal
            if($_GET['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST
    
                if($i===0){ // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_GET['search']['value']);
                }else{
                    $this->db->or_like($item, $_GET['search']['value']);
                }
    
                if(count($column_search) - 1 == $i){
                    $this->db->group_end();
                }
            }
            $i++;
        }
    
        $column_order = array('','tanggal','keterangan');
    
        if(isset($_GET['order'])){
            $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
        } 
        else{
            $order_by = array("tanggal"=>"DESC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function getDataById($id=null){
        $select = $this->db->query("SELECT *
                                    FROM $this->table
                                    WHERE MD5(id) = '$id'
                                    AND id_company = '".$_SESSION["id_company"]."'")->row();
        return $select;
    }

    public function save($data,$id = null){
        $id_company = $this->session->userdata('id_company');
        if($id != null){
            $tanggal = $data['tanggal'];
            $cek_tanggal = $this->db->select("id")
                                    ->from("holidays")
                                    ->where("tanggal", $tanggal)
                                    ->where("md5(id) !=",$id)
                                    ->where("id_company",$id_company)
                                    ->get();
            if ($cek_tanggal->num_rows() > 0) {
                $message = array('message'=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Tanggal sudah digunakan</font>');
                return __response_update(false, $message);
                
            }else{
                $this->db->where(array('md5(id)'=>$id, 'id_company'=>$_SESSION['id_company']));
                $update = $this->db->update($this->table,$data);
                return __response_update($update);
            }
            
        }else{
            $tanggal = $data['tanggal'];
            $cek_tanggal = $this->db->select("id")
                                    ->from("holidays")
                                    ->where("tanggal", $tanggal)
                                    ->where("id_company",$id_company)
                                    ->get();
            if ($cek_tanggal->num_rows() > 0) {
                $message = array('message'=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Tanggal sudah digunakan</font>');
                return __response_save(false,$message);
            }else{
                $save = $this->db->insert($this->table, $data);
                return __response_save($save);
            }
        }
        
    }

    public function delete($id=null){
        $this->db->where(array('md5(id)'=>$id));
        $delete =$this->db->delete($this->table);
        return  __response_delete($delete);
    }

}