<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Data_komponen extends MY_Controller{

	public function __construct(){
        parent::__construct();
        $this->load->model('payroll/data_komponen/Data_komponen_m', 'model');
    }

	public function index(){
		$data['judul'] = 'Data Komponen Tetap';
		$data['aktif'] = 'data_komponen';
        $data['menu'] = $this->load->view('main_menu', $data, true);
        $data['master'] = json_decode($this->model->master_komponen(), true);
		$data['content'] = $this->load->view('payroll/data_komponen/home', $data, true);
		$this->load->view('main_template', $data, false);
	}

	public function list_data($id_karyawan, $id_cabang, $id_departemen) {
		$list     = $this->model->get_datatables($id_karyawan, $id_cabang, $id_departemen);
		$get_pend = json_decode($this->model->tambah_pendapatan(), true);
		$get_pot  = json_decode($this->model->tambah_potongan(), true);
		$data     = array();
		$no       = $_GET['start'];
		foreach ($list as $field) {
			$no++;
            $row   = array();
            $row[] = $no;
            $row[] = $field->nama_lengkap."<br><b>".$field->nik."</b>";
            $row[] = $field->nama_cabang."<br><b>".$field->kode_cabang."</b>";
            $row[] = $field->nama_departemen."<br><b>".$field->kode_departemen."</b>";
            $row[] = $field->nama_jabatan."<br><b>".$field->kode_jabatan."</b>";

            if ($field->nominal == 0) {
                $row[] = '-';
            }else{
                $row[] = number_format($field->nominal,0,',','.');
            }
            $total_pendapatan = 0;
            if (count($get_pend[$field->id_karyawan]) > 0) {
                foreach ($get_pend[$field->id_karyawan] as $komponen) {
                    $nominalWithButton = 0;
                    $pendapatan        = 0;
                    // jika terdapat gapok
                    if ($field->nominal > 0) {
                        $pendapatan = $komponen['nominal_tunjangan'];
                        if ($komponen['flag_persentase_gapok'] == "1") {
                            if ($pendapatan > 0) {
                                $nominalWithButton = '
                                <div class="nominal-with-button">
                                    <span>'.number_format($komponen['nominal_tunjangan'],0,',','.').'</span>
                                    <button class="btn-link border-0 text-danger" data-toggle="modal" data-target="#modal-nominal" data-item="'.md5($field->id_karyawan.$komponen['id_item'].$this->id_company).'" data-komponen="pendapatan" data-btn="hapus" data-nominal="'.number_format($komponen['nominal_tunjangan'],0,',','.').'" data-nm_komponen="'.$komponen['nm_tunjangan'].'"><i class="fa fa-trash (alias) "></i></button>
                                </div>';
                            }else{
                                $nominalWithButton = '
                                <div class="nominal-with-button">
                                    <span>'.number_format($komponen['nominal_tunjangan'],0,',','.').'</span>
                                    <button class="btn-link border-0 text-primary" data-toggle="modal" data-target="#modal-nominal" data-item="'.md5($field->id_karyawan.$komponen['id_item'].$this->id_company).'" data-komponen="pendapatan" data-btn="tambah" data-persen="'.$komponen['gapok_persen'].'" data-nominal="'.number_format($komponen['nominal_tunjangan'],0,',','.').'" data-nm_komponen="'.$komponen['nm_tunjangan'].'"><i class="fa fa-plus (alias) "></i></button>
                                </div>';
                            }
                        }else{
                            $nominalWithButton = '
                            <div class="nominal-with-button">
                                <span>'.number_format($komponen['nominal_tunjangan'],0,',','.').'</span>
                                <button class="btn-link border-0 text-warning" data-toggle="modal" data-target="#modal-nominal" data-item="'.md5($field->id_karyawan.$komponen['id_item'].$this->id_company).'" data-komponen="pendapatan" data-btn="ubah" data-nominal="'.number_format($komponen['nominal_tunjangan'],0,',','.').'" data-nm_komponen="'.$komponen['nm_tunjangan'].'"><i class="fa fa-edit (alias) "></i></button>
                            </div>';
                        }
                    }
                    $row[] = $nominalWithButton;
                    $total_pendapatan += $pendapatan;
                }
                $row[] = number_format($total_pendapatan,0,',','.');
            }

            $total_potongan = 0;
            if (count($get_pot[$field->id_karyawan]) > 0) {
                foreach ($get_pot[$field->id_karyawan] as $komponen) {
                    $nominalWithButton = 0;
                    $potongan          = 0;
                    // jika terdapat gapok
                    if ($field->nominal > 0) {
                        $potongan = $komponen['nominal_potongan'];
                        if ($komponen['flag_persentase_gapok'] == "1") {
                            if ($potongan > 0) {
                                $nominalWithButton = '
                                <div class="nominal-with-button">
                                    <span>'.number_format($komponen['nominal_potongan'],0,',','.').'</span>
                                    <button class="btn-link border-0 text-danger" data-toggle="modal" data-target="#modal-nominal" data-item="'.md5($field->id_karyawan.$komponen['id_item'].$this->id_company).'" data-komponen="potongan" data-btn="hapus" data-nominal="'.number_format($komponen['nominal_potongan'],0,',','.').'" data-nm_komponen="'.$komponen['nm_potongan'].'"><i class="fa fa-trash (alias) "></i></button>
                                </div>';
                            }else{
                                $nominalWithButton = '
                                <div class="nominal-with-button">
                                    <span>'.number_format($komponen['nominal_potongan'],0,',','.').'</span>
                                    <button class="btn-link border-0 text-primary" data-toggle="modal" data-target="#modal-nominal" data-item="'.md5($field->id_karyawan.$komponen['id_item'].$this->id_company).'" data-komponen="potongan" data-btn="tambah" data-persen="'.$komponen['gapok_persen'].'" data-nominal="'.number_format($komponen['nominal_potongan'],0,',','.').'" data-nm_komponen="'.$komponen['nm_potongan'].'"><i class="fa fa-plus (alias) "></i></button>
                                </div>';
                            }
                        }else{
                            $nominalWithButton = '
                            <div class="nominal-with-button">
                                <span>'.number_format($komponen['nominal_potongan'],0,',','.').'</span>
                                <button class="btn-link border-0 text-warning" data-toggle="modal" data-target="#modal-nominal" data-item="'.md5($field->id_karyawan.$komponen['id_item'].$this->id_company).'" data-komponen="potongan" data-btn="ubah" data-nominal="'.number_format($komponen['nominal_potongan'],0,',','.').'" data-nm_komponen="'.$komponen['nm_potongan'].'"><i class="fa fa-edit (alias) "></i></button>
                            </div>';
                        }
                    }
                    $row[] = $nominalWithButton;
                    $total_potongan += $potongan;
                }
                $row[] = number_format($total_potongan,0,',','.');
            }

            if ($field->nominal > 0) {
                $row[] = number_format(($field->nominal + $total_pendapatan - $total_potongan),0,',','.');
            }else{
                $row[] = 0;
            }

			$data[] = $row;
		}

		$output = array("draw"            => $_GET['draw'],
						"recordsTotal"    => $this->model->count_all($id_karyawan, $id_cabang, $id_departemen),
						"recordsFiltered" => $this->model->count_filtered($id_karyawan, $id_cabang, $id_departemen),
						"data"            => $data);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

	public function form(){
        $this->load->view('payroll/data_komponen/form');
	}

    public function update(){
        $id_item = $this->input->post('item');
        $master_komponen = $this->input->post('komponen');
        $nominal = $this->input->post('nominal');

        if ($master_komponen == 'pendapatan') {
            $komponen = 'nominal_tunjangan';
        }else if ($master_komponen == 'potongan') {
            $komponen = 'nominal_potongan';
        }else{
            return __response_update(false);
        }

        $data = array(
            'user_update' => $this->nik_karyawan.' - '.$this->nm_karyawan,
            'tgl_update' => date('Y-m-d H:i:s'),
            $komponen => str_replace('.','',$nominal)
        );

        $this->model->update($data, $master_komponen, $id_item);
    }
}
