<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Lokasi extends MY_Controller {

    public function __construct(){
        parent::__construct();
        $this->load->model('Lokasi_m');
        $this->load->model('Db_model', 'db_model');
    }

    public function index(){
        $data['judul'] = 'Lokasi';
        $data['aktif'] = 'lokasi';
        $data['kode_paket'] = $this->Lokasi_m->get_kode_paket();
        $data['menu'] = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('lokasi/home', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function ajax_list(){
        $id_cabang = $this->input->get('id_cabang');
        $paket = $this->Lokasi_m->get_kode_paket();

        $list = $this->Lokasi_m->get_datatables($id_cabang);

        $data = array();
        $no = $_GET['start'];
        foreach ($list as $dt) {
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = $dt->nama_kantor;
            $row[] = $dt->kode." - ".$dt->nama;
            $row[] = $dt->lat_asli;
            $row[] = $dt->long_asli;
            $row[] = $dt->jarak;
            if(in_array($this->session->userdata('level_user'), array("1","5")) || in_array($this->session->userdata('level_khusus'), array("1"))) {
                if($paket == 15) {
                    $row[] = '  <a href="' . site_url("master/lokasi/edit") . '/' . md5($dt->id_kantor) . '" title="Ubah" style="color:#f0ad4e">
                                <i class="btn_edit fa fa-edit (alias) "> </i>
                                </a>';
                }else {
                    $row[] = '  <a href="' . site_url("master/lokasi/edit") . '/' . md5($dt->id_kantor) . '" title="Ubah" style="color:#f0ad4e">
                                <i class="btn_edit fa fa-edit (alias) "> </i>
                                </a>&nbsp;
                                <a href="#" class="text-danger" title="HAPUS">
                                    <i id="'.md5($dt->id_kantor).'" class="btn_delete fa fa-trash"></i>
                                </a>';
                }
            }
            $data[] = $row;
        }

        $output = array(
                "draw" => $_GET['draw'],
                "recordsTotal" => $this->Lokasi_m->count_all($id_cabang),
                "recordsFiltered" => $this->Lokasi_m->count_filtered($id_cabang),
                "data" => $data,
            );

        //output to json format
        $output = __response($this->MY_response, $output);

		echo json_encode($output);
    }

    public function maps($id_cabang = 0){
        $data_lokasi = $this->Lokasi_m->data_lokasi($id_cabang);
        $marker = [];
        $no = 0;
        foreach($data_lokasi as $row){
            $no++;

            $marker[] = array("index" => $no,
                                "lat" => $row->latitude,
                                "long" => $row->longitude,
                                "title" => $row->nama_lokasi.", ".$row->nama_cabang);

        }

        echo json_encode($marker);

    }

    function tambah(){
        $data['judul'] = 'Tambah Lokasi';
        $data['aktif'] = 'lokasi';
        $data['menu'] = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('lokasi/google/form_tambah', $tes, true);
        $this->load->view('main_template', $data, false);
    }

    function insert(){
        $json['status'] = 'gagal';
        $json['link']   = site_url('master/lokasi');
        $lat = $this->input->post('lat');
        $lon = $this->input->post('lng');
        $distance = $this->input->post('jarak') / 1000;
        $R = 6371; //constant earth radius. You can add precision here if you wish

        $maxLat = $lat + rad2deg($distance / $R);
        $minLat = $lat - rad2deg($distance / $R);
        $maxLon = $lon + rad2deg(asin($distance / $R) / cos(deg2rad($lat)));
        $minLon = $lon - rad2deg(asin($distance / $R) / cos(deg2rad($lat)));

        $nextId = $this->fungsi->getNextId('data_lokasi_kantor','id_lokasi_kantor',$_SESSION['id_company'],3);

        $data = array(
            'id_lokasi_kantor' => $nextId,
            'nama_kantor' => $this->input->post('kantor'),
            'lat_asli' => $lat,
            'lat_min' => $minLat,
            'lat_max' => $maxLat,
            'long_asli' => $lon,
            'long_min' => $maxLon,
            'long_max' => $minLon,
            'jarak' => $this->input->post('jarak'),
            'id_company' => $this->session->userdata('id_company'),
            'id_cabang' => $this->input->post('cabang'),
            'flag' => $this->input->post('flag')
        );

        $add = $this->db->insert('data_lokasi_kantor', $data);

        return __response_save($add);
    }

    public function edit($id){
        $data['judul'] = 'Ubah Lokasi';
        $data['aktif'] = 'lokasi';
        $query_data = $this->db->get_where('data_lokasi_kantor', array('md5(id_lokasi_kantor)' => $id, "id_company" => $_SESSION['id_company']))->row();
        $data['data'] = $query_data;
        if(isset($query_data->id_cabang)) {
            $nama_cabang = $this->db_model->get('master_cabang', 'nama', array('id_cabang' => $query_data->id_cabang, 'id_company' => $_SESSION['id_company']))->row()->nama;
        }else{
            $nama_cabang = '';
        }
        $data['nama_cabang'] = $nama_cabang;
        $data['menu'] = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('lokasi/google/form_edit', $tes, true);
        $this->load->view('main_template', $data, false);
    }

    public function update(){
        $json['status'] = 'gagal';
        $json['link']   = site_url('master/lokasi');
        $lat = $this->input->post('lat');
        $lon = $this->input->post('lng');
        $distance = $this->input->post('jarak') / 1000;
        $kode_lokasi = $this->input->post('kode_lokasi');
        $R = 6371; //constant earth radius. You can add precision here if you wish

        $maxLat = $lat + rad2deg($distance / $R);
        $minLat = $lat - rad2deg($distance / $R);
        $maxLon = $lon + rad2deg(asin($distance / $R) / cos(deg2rad($lat)));
        $minLon = $lon - rad2deg(asin($distance / $R) / cos(deg2rad($lat)));
        $flag = $this->input->post('flag');

        //echo $maxLat, "<br>", $minLat, "<br>", $maxLon, "<br>", $minLon;
        $data = array(
            'nama_kantor' => $this->input->post('kantor'),
            'lat_asli' => $lat,
            'lat_min' => $minLat,
            'lat_max' => $maxLat,
            'long_asli' => $lon,
            'long_min' => $maxLon,
            'long_max' => $minLon,
            'jarak' => $this->input->post('jarak'),
            'id_company' => $this->session->userdata('id_company'),
            'id_cabang' => $this->input->post('cabang'),
            'flag' => $flag
        );

        $update = $this->db->update('data_lokasi_kantor', $data, array('id_lokasi_kantor' => $this->input->post('id_lok')));
        return  __response_update($update);

    }

    public function delete(){
        $id = $this->input->post("id_lokasi");
        $this->Lokasi_m->delete($id);
    }
}
