<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Karyawan_import extends MY_Controller {

	public function __construct(){
        parent::__construct();
		$this->load->model(array('Karyawan_import_m'));
        $this->load->library(array('PHPExcel/Excel', 'PHPExcel/PHPExcel', 'Uploadfile'));
        $this->load->helper('download');
    }

	public function index(){
		$data['judul'] = 'Import Karyawan';
		$data['aktif'] = 'karyawan';

		$max_karyawan = $this->db->select("SUM(master_company.custom_jumlah_karyawan + tb_paket.max_karyawan) AS max_jml_karyawan")
                                    ->from("master_company")
                                    ->join("tb_paket","tb_paket.id_tb_paket = master_company.id_tb_paket")
                                    ->where("master_company.id_company",$this->id_company)
                                    ->get()
                                    ->row("max_jml_karyawan");
        $data['max_karyawan'] = $max_karyawan;

        $jumlah_karyawan_aktif = $this->db->select("data_karyawan.id_karyawan")
                                    ->from("data_karyawan")
                                    ->join("master_jabatan","master_jabatan.id_jabatan = data_karyawan.id_jabatan")
                                    ->where_in("data_karyawan.status",["1","2","3","4"])
                                    ->where_not_in("master_jabatan.level_user",["1","6"])
                                    ->where("data_karyawan.id_company",$this->id_company)
                                    ->get()
                                    ->num_rows();
        $data['jumlah_karyawan_aktif'] = $jumlah_karyawan_aktif;

        $data['menu'] = $this->load->view('main_menu', $data, true);
		$data['content'] = $this->load->view('karyawan/import/home', $data, true);
		$this->load->view('main_template', $data, false);
	}

	public function view_data(){
		$this->load->view('karyawan/import/list_data');
	}

	public function download_template(){
        // Load plugin PHPExcel nya
        include APPPATH.'third_party/PHPExcel/PHPExcel.php';

        // Panggil class PHPExcel nya
        $excel = new PHPExcel();
        // Settingan awal fil excel
        $excel->getProperties()->setCreator('Absenku')
                    ->setLastModifiedBy('Absenku')
                    ->setTitle("Template Import Data Karyawan")
                    ->setSubject("Template Import Data Karyawan")
                    ->setDescription("Template Import Data Karyawan Absenku Profesioanal");
        // Buat sebuah variabel untuk menampung pengaturan style dari header tabel
        $style_header = array(
            'font' => array('bold' => true), // Set font nya jadi bold
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER, // Set text jadi ditengah secara horizontal (center)
                'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER // Set text jadi di tengah secara vertical (middle)
            ),
        );
        // Buat sebuah variabel untuk menampung pengaturan style dari isi tabel
        $style_row = array(
            'alignment' => array(
                'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER // Set text jadi di tengah secara vertical (middle)
            ),
            'borders' => array(
                'top' => array('style'  => PHPExcel_Style_Border::BORDER_THIN), // Set border top dengan garis tipis
                'right' => array('style'  => PHPExcel_Style_Border::BORDER_THIN),  // Set border right dengan garis tipis
                'bottom' => array('style'  => PHPExcel_Style_Border::BORDER_THIN), // Set border bottom dengan garis tipis
                'left' => array('style'  => PHPExcel_Style_Border::BORDER_THIN) // Set border left dengan garis tipis
            )
        );

        $excel->setActiveSheetIndex(0)->setCellValue('A1', "TEMPLATE IMPORT DATA KARYAWAN"); // Set kolom A1 dengan tulisan ""
        $excel->getActiveSheet()->mergeCells('A1:V1'); // Set Merge Cell pada kolom A1 sampai E1
        $excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE); // Set bold kolom A1
        $excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(14);; // Set font size
        $excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER); // Set text center untuk kolom A1

        //header
        $excel->setActiveSheetIndex(0)->setCellValue('A3', "NO"); 
        $excel->setActiveSheetIndex(0)->setCellValue('B3', "NO INDUK KARYAWAN"); 
        $excel->setActiveSheetIndex(0)->setCellValue('C3', "NAMA KARYAWAN");
        $excel->setActiveSheetIndex(0)->setCellValue('D3', "GELAR DEPAN");
        $excel->setActiveSheetIndex(0)->setCellValue('E3', "GELAR BELAKANG");
        $excel->setActiveSheetIndex(0)->setCellValue('F3', "KODE JABATAN");
        $excel->setActiveSheetIndex(0)->setCellValue('G3', "KODE CABANG");
        $excel->setActiveSheetIndex(0)->setCellValue('H3', "KODE DEPARTEMEN");
        $excel->setActiveSheetIndex(0)->setCellValue('I3', "STATUS(KONTRAK/TETAP)"); 
        $excel->setActiveSheetIndex(0)->setCellValue('J3', "TANGGAL AKTIF BEKERJA"); 
        $excel->setActiveSheetIndex(0)->setCellValue('K3', "TANGGAL BERHENTI BEKERJA");
        $excel->setActiveSheetIndex(0)->setCellValue('L3', "USERNAME");
        $excel->setActiveSheetIndex(0)->setCellValue('M3', "PASSWORD");
        $excel->setActiveSheetIndex(0)->setCellValue('N3', "SALDO CUTI");
        $excel->setActiveSheetIndex(0)->setCellValue('O3', "JENIS KELAMIN(L/P)");  
        $excel->setActiveSheetIndex(0)->setCellValue('P3', "TEMPAT LAHIR");
        $excel->setActiveSheetIndex(0)->setCellValue('Q3', "TANGGAL LAHIR");      
        $excel->setActiveSheetIndex(0)->setCellValue('R3', "ALAMAT"); 
        $excel->setActiveSheetIndex(0)->setCellValue('S3', "AGAMA"); 
        $excel->setActiveSheetIndex(0)->setCellValue('T3', "TELEPON"); 
        $excel->setActiveSheetIndex(0)->setCellValue('U3', "EMAIL"); 
        $excel->setActiveSheetIndex(0)->setCellValue('V3', "NOMOR INDUK KEPENDUDUKAN");
        $excel->setActiveSheetIndex(0)->setCellValue('Y3', "KETERANGAN");

        //SET WIDTH
        $excel->getActiveSheet()->getColumnDimension('A')->setWidth("5");
        $excel->getActiveSheet()->getColumnDimension('B')->setWidth("25");
        $excel->getActiveSheet()->getColumnDimension('C')->setWidth("40");
        $excel->getActiveSheet()->getColumnDimension('D')->setWidth("13");
        $excel->getActiveSheet()->getColumnDimension('E')->setWidth("17");
        $excel->getActiveSheet()->getColumnDimension('F')->setWidth("15");
        $excel->getActiveSheet()->getColumnDimension('G')->setWidth("15");
        $excel->getActiveSheet()->getColumnDimension('H')->setWidth("18");
        $excel->getActiveSheet()->getColumnDimension('I')->setWidth("25");
        $excel->getActiveSheet()->getColumnDimension('J')->setWidth("23");
        $excel->getActiveSheet()->getColumnDimension('K')->setWidth("28");
        $excel->getActiveSheet()->getColumnDimension('L')->setWidth("15");
        $excel->getActiveSheet()->getColumnDimension('M')->setWidth("15");
        $excel->getActiveSheet()->getColumnDimension('N')->setWidth("11");
        $excel->getActiveSheet()->getColumnDimension('O')->setWidth("20");
        $excel->getActiveSheet()->getColumnDimension('P')->setWidth("20");
        $excel->getActiveSheet()->getColumnDimension('Q')->setWidth("20");
        $excel->getActiveSheet()->getColumnDimension('R')->setWidth("30");
        $excel->getActiveSheet()->getColumnDimension('S')->setWidth("15");
        $excel->getActiveSheet()->getColumnDimension('T')->setWidth("15");
        $excel->getActiveSheet()->getColumnDimension('U')->setWidth("20");
        $excel->getActiveSheet()->getColumnDimension('V')->setWidth("35");
        $excel->getActiveSheet()->getColumnDimension('Y')->setWidth("68");
        //header

        //style
        $excel->getActiveSheet()->getStyle('Y3')->getFont()->setBold(TRUE);
        $excel->getActiveSheet()->getStyle('Y3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $excel->getActiveSheet()->getStyle('Y3:Y6')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('ffe699');
        $excel->getActiveSheet()->getStyle('B3')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FFFF00');
        $excel->getActiveSheet()->getStyle('C3')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FFFF00');
        $excel->getActiveSheet()->getStyle('F3')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FFFF00');
        $excel->getActiveSheet()->getStyle('G3')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FFFF00');
        $excel->getActiveSheet()->getStyle('H3')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FFFF00');
        $excel->getActiveSheet()->getStyle('I3')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FFFF00');
        $excel->getActiveSheet()->getStyle('J3')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FFFF00');
        $excel->getActiveSheet()->getStyle('K3')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FFFF00');
        $excel->getActiveSheet()->getStyle('L3')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FFFF00');
        $excel->getActiveSheet()->getStyle('M3')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FFFF00');


        $excel->setActiveSheetIndex(0)->setCellValue('A4', 1);
        $excel->setActiveSheetIndex(0)->setCellValue('A5', 2);
        $excel->setActiveSheetIndex(0)->setCellValue('A6', 3);
        $excel->setActiveSheetIndex(0)->setCellValue('A7', 4);
        $excel->setActiveSheetIndex(0)->setCellValue('A8', 5);
        $excel->setActiveSheetIndex(0)->setCellValue('A9', 6);
        $excel->setActiveSheetIndex(0)->setCellValue('A10', 7);
        $excel->setActiveSheetIndex(0)->setCellValue('A11', 8);
        $excel->setActiveSheetIndex(0)->setCellValue('A12', 9);
        $excel->setActiveSheetIndex(0)->setCellValue('A13', 10);

        $excel->getActiveSheet()->getStyle('A4:A13')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        $excel->setActiveSheetIndex(0)->setCellValue('Y4', '1. Kolom warna kuning wajib diisi');
        $excel->setActiveSheetIndex(0)->setCellValue('Y5', '2. Jika status karyawan Kontrak Tanggal Aktif & Berhenti Bekerja Wajib disi');
        $excel->setActiveSheetIndex(0)->setCellValue('Y6', '3. Jika status karyawan Tetap hanya wajib mengisi Tanggal Aktif Bekerja');

        # FORMAT TEXT
        $range = 'B4:V13';
        $excel->getActiveSheet()
            ->getStyle($range)
            ->getNumberFormat()
            ->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_TEXT);

        # BORDER SEMUA KOLOM
        $excel->getActiveSheet()
            ->getStyle("A3:V3")
            ->applyFromArray($style_header);
            
        $excel->getActiveSheet()
            ->getStyle("A3:V13")
            ->applyFromArray(
                array(
                    'borders' => array(
                        'allborders' => array(
                            'style' => PHPExcel_Style_Border::BORDER_THIN
                        )
                    )
                )
            );
        $excel->getActiveSheet()
            ->getStyle("Y3:Y6")
            ->applyFromArray(
                array(
                    'borders' => array(
                        'allborders' => array(
                            'style' => PHPExcel_Style_Border::BORDER_THIN
                        )
                    )
                )
            );

        // Set height semua kolom menjadi auto (mengikuti height isi dari kolommnya, jadi otomatis)
        $excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
        // Set orientasi kertas jadi LANDSCAPE
        $excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
        // Set judul file excel nya
        $excel->getActiveSheet(0)->setTitle("TEMPLATE DATA KARYAWAN");
        $excel->setActiveSheetIndex(0);

        $filename = "TEMPLATE_IMPORT_DATA_KARYAWAN";
        // Proses file excel
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename='.$filename.'.xlsx'); // Set nama file excel nya
        header('Cache-Control: max-age=0');
        $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
        $write->save('php://output');
	}	

	public function list_data(){
        $list      = $this->Karyawan_import_m->get_datatables();
        $cek_level = $this->Karyawan_import_m->cek_level_list_data();
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $field) {
			$no++;
            $row   = array();
            $level = $cek_level[$field->id_jabatan];

            $row[] = $no;

			if ($field->nik =="" || $field->nik == NULL) {
				$class = "badge badge-danger";
				$nik = "Data Kosong";
				$row[] = "<div class='".$class."'>".$nik."</div>";
			}else{
				$cek_nik_nama = $this->db->select("nik, nama_lengkap")
                                ->from("data_karyawan")
                                ->where("nik",$field->nik)
                                ->where("id_karyawan",$field->id_karyawan)
                                ->where("id_company",$this->id_company)
                                ->get();

                if ($cek_nik_nama->num_rows() > 0) {
                	$class = "badge badge-warning";
                	$nik = "NIK <b>".$field->nik."</b> sudah sda <br> dan sudah digunakan oleh karyawan <b>".$cek_nik_nama->row()->nama_lengkap."</b>";
                	$row[] = "<div class='".$class."'>".$nik."</div>";
                }else{
                	$nik = $field->nik;
					$row[] = $nik;
                }
			}

			if ($field->nama_lengkap =="" || $field->nama_lengkap == NULL) {
				$class = "badge badge-danger";
				$nama_lengkap = "Data Kosong";
				$row[] = "<div class='".$class."'>".$nama_lengkap."</div>";
			}else{
				$nama_lengkap = $field->nama_lengkap;
				$row[] = $nama_lengkap;
			}

			$row[] = $field->gelar_depan;
			$row[] = $field->gelar_belakang;

			if ($field->kode_jabatan =="" || $field->kode_jabatan == NULL) {
				$class = "badge badge-danger";
				$kode_jabatan = "Data Kosong";
				$row[] = "<div class='".$class."'>".$kode_jabatan."</div>";
			}else{
				$kode_jabatan = $field->kode_jabatan;
				$nama_jabatan = $field->nama_jabatan;
				$row[] = $kode_jabatan." - ".$nama_jabatan;
			}

			if ($field->kode_cabang =="" || $field->kode_cabang == NULL) {
				$class = "badge badge-danger";
				$kode_cabang = "Data Kosong";
				$row[] = "<div class='".$class."'>".$kode_cabang."</div>";
			}else{
				$kode_cabang = $field->kode_cabang;
				$nama_cabang = $field->nama_cabang;
				$row[] = $kode_cabang." - ".$nama_cabang;
			}

			if ($field->kode_departemen =="" || $field->kode_departemen == NULL) {
                if(in_array($level,["5","4","6"])){
                    $class              = "";
                    $kode_departemen    = "";
                    $row[]              = $class.$kode_departemen;
                }else{
                    $class              = "badge badge-danger";
                    $kode_departemen    = "Data Kosong";
                    $row[]              = "<div class='".$class."'>".$kode_departemen."</div>";
                }
            }else{
                $kode_departemen    = $field->kode_departemen;
                $nama_departemen    = $field->nama_departemen;
                $row[]              = $kode_departemen." - ".$nama_departemen;
            }


			if ($field->status =="" || $field->status == NULL) {
				$class = "badge badge-danger";
				$status = "Data Kosong";
				$row[] = "<div class='".$class."'>".$status."</div>";
			}else if($field->status == 1){
				$status = 'Kontrak';
				$row[] = $status;

				if ($field->tgl_aktif_bekerja == '' || $field->tgl_aktif_bekerja == NULL || $field->tgl_aktif_bekerja == '1970-01-01') {
					$class = "badge badge-danger";
					$tgl_aktif_bekerja = 'Data Kosong';
					$row[] = "<div class='".$class."'>".$tgl_aktif_bekerja."</div>";
				}else{
					$tgl_aktif_bekerja = date('d-m-Y', strtotime($field->tgl_aktif_bekerja));
					$row[] = $tgl_aktif_bekerja;
				}

				if ($field->tgl_berhenti_bekerja == '' || $field->tgl_berhenti_bekerja == NULL || $field->tgl_berhenti_bekerja == '1970-01-01') {
					$class = "badge badge-danger";
					$tgl_berhenti_bekerja = 'Data Kosong';
					$row[] = "<div class='".$class."'>".$tgl_berhenti_bekerja."</div>";
				}else{
					$tgl_berhenti_bekerja = date('d-m-Y', strtotime($field->tgl_berhenti_bekerja));
					$row[] = $tgl_berhenti_bekerja;
				}
			}else if($field->status == 2){
				$status = 'Tetap';
				$row[] = $status;

				if ($field->tgl_aktif_bekerja == '' || $field->tgl_aktif_bekerja == NULL || $field->tgl_aktif_bekerja == '1970-01-01') {
					$class = "badge badge-danger";
					$tgl_aktif_bekerja = 'Data Kosong';
					$row[] = "<div class='".$class."'>".$tgl_aktif_bekerja."</div>";
				}else{
					$tgl_aktif_bekerja = date('d-m-Y', strtotime($field->tgl_aktif_bekerja));
					$row[] = $tgl_aktif_bekerja;
				}

				if ($field->tgl_berhenti_bekerja == '' || $field->tgl_berhenti_bekerja == NULL || $field->tgl_berhenti_bekerja == '1970-01-01') {
					$tgl_berhenti_bekerja = '-';
					$row[] = $tgl_berhenti_bekerja;
				}else{
					$tgl_berhenti_bekerja = date('d-m-Y', strtotime($field->tgl_berhenti_bekerja));
					$row[] = $tgl_berhenti_bekerja;
				}
			}

			if ($field->username =="" || $field->username == NULL) {
				$class = "badge badge-danger";
				$username = "Data Kosong";
				$row[] = "<div class='".$class."'>".$username."</div>";
			}else{
				$cek_username = $this->db->select("username")
                                ->from("users")
                                ->where("username",$field->username)
                                ->get()
                                ->num_rows();
                if ($cek_username > 0) {
                	$class = "badge badge-warning";
					$username = "Username ".$field->username." Sudah Ada";
					$row[] = "<div class='".$class."'>".$username."</div>";
                }else{
                	$username = $field->username;
					$row[] = $username;
                }
			}

			$row[] = $field->jatah_cuti;
			$row[] = (($field->jenis_kelamin == 'L')?"Laki-laki":"Perempuan");
			$row[] = $field->tempat_lahir;
			$row[] = date('d-m-Y', strtotime($field->tgl_lahir));
			$row[] = $field->alamat_domisili;
			$row[] = $field->agama;
			$row[] = $field->telepon;
			$row[] = $field->email;
			$row[] = $field->no_ktp;

			$btn_edit	= '<a href="'.route('karyawan.import.form.edit').'/'.md5($field->id_temp).'" id="'.md5($field->id_temp).'" class="text-warning btn_edit" title="EDIT"><i class="fa fa-edit"></i></a>';
			$btn_hapus = '<a href="#" title="Delete" class="text-danger"><i class="btn_form_hapus fa fa-trash" id="'.md5($field->id_temp).'"></i></a>';

			$row[] = $btn_edit.'&nbsp;'.$btn_hapus;
			
			$data[] = $row;
		}

		$output = array("draw"            => $_POST['draw'],
						"recordsTotal"    => $this->Karyawan_import_m->count_all(),
						"recordsFiltered" => $this->Karyawan_import_m->count_filtered(),
						"data"            => $data);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

	public function import_data_excel(){
        if(!empty($_FILES['file']['name'])) {
			$tahunbulan = date('Ym');
            $fileUpload['fname']    = 'file';
            $fileUpload['location'] = 'template_data_karyawan/'.$tahunbulan;
            $fileUpload['allowed']  = 'xls|xlsx';
            $fileUpload['compress_image']  = false;

            $upload = $this->uploadfile->doUpload($fileUpload);
			if($upload["success"] == true){
				$dir_file = $this->config->item('base_upload').$upload['url'];
			}else{
				$message = ["message"=>$upload["message"]];
				return __response_save(false,$message);
			}
        }else{
			$message = ["message"=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Data gagal import</font>'];
			return __response_save(false,["message"=>$message]);
        }

        try{
            $inputFileType = PHPExcel_IOFactory::identify($dir_file);
            $objReader = PHPExcel_IOFactory::createReader($inputFileType);
            $objPHPExcel = $objReader->load($dir_file);
        }catch(Exception $e){
			$message = ["message"=>'Error loading file "' . pathinfo($dir_file, PATHINFO_BASENAME) . '": ' . $e->getMessage()];
			return __response_save(false,["message"=>$message]);
        }

       	$row = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
        $end = sizeof($row);

		$data_insert = array();
        $data = array();

        $master_jabatan    = $this->Karyawan_import_m->masterJabatan();
        $master_cabang     = $this->Karyawan_import_m->masterCabang();
        $master_departemen = $this->Karyawan_import_m->masterDepartemen();
        $cek_username      = $this->Karyawan_import_m->cek_username();
        $cek_nik           = $this->Karyawan_import_m->cek_nik();
        $cek_level         = $this->Karyawan_import_m->cek_level();

        $id_temp = $this->fungsi->getNextId('data_karyawan_temp','id_temp',$this->id_company,5);

        if($row[3]["A"] != "NO" OR
            $row[3]["B"] != "NO INDUK KARYAWAN" OR
            $row[3]["C"] != "NAMA KARYAWAN" OR
            $row[3]["D"] != "GELAR DEPAN" OR
            $row[3]["E"] != "GELAR BELAKANG" OR
            $row[3]["F"] != "KODE JABATAN" OR
            $row[3]["G"] != "KODE CABANG" OR
            $row[3]["H"] != "KODE DEPARTEMEN" OR
            $row[3]["I"] != "STATUS(KONTRAK/TETAP)" OR
            $row[3]["J"] != "TANGGAL AKTIF BEKERJA" OR
            $row[3]["K"] != "TANGGAL BERHENTI BEKERJA" OR
            $row[3]["L"] != "USERNAME" OR
            $row[3]["M"] != "PASSWORD" OR
            $row[3]["N"] != "SALDO CUTI" OR
            $row[3]["O"] != "JENIS KELAMIN(L/P)" OR
            $row[3]["P"] != "TEMPAT LAHIR" OR
            $row[3]["Q"] != "TANGGAL LAHIR" OR
            $row[3]["R"] != "ALAMAT" OR
            $row[3]["S"] != "AGAMA" OR
            $row[3]["T"] != "TELEPON" OR
            $row[3]["U"] != "EMAIL" OR
            $row[3]["V"] != "NOMOR INDUK KEPENDUDUKAN"){
            $message = '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Data gagal diimport, Karena Format Excel Tidak Sesuai</font>';
            return __response_save(false, array('message' => $message));
            unlink($upload);
        } else {
            for ($i = 4; $i <= $end; $i++){
                // var_dump($row[$i]['AJ']);
                $nik                    = $row[$i]['B'];
                $nama_lengkap           = $row[$i]['C'];
                $gelar_depan            = (isset($row[$i]['D']) && $row[$i]['D'] != NULL) ? $row[$i]['D'] : '';
                $gelar_belakang         = (isset($row[$i]['E']) && $row[$i]['E'] != NULL) ? $row[$i]['E'] : '';
                $kode_jabatan           = $row[$i]['F'];
                $kode_cabang            = $row[$i]['G'];
                $kode_departemen        = $row[$i]['H'];
                $status_karyawan        = $row[$i]['I'];
                $tgl_aktif_bekerja      = $row[$i]['J'];
                $tgl_berhenti_bekerja   = $row[$i]['K'];
                $username               = $row[$i]['L'];
                $password               = $row[$i]['M'];
                $jatah_cuti             = (isset($row[$i]['N']) && $row[$i]['N'] != NULL) ? $row[$i]['N'] : '0';
                $jenis_kelamin          = (isset($row[$i]['O']) && $row[$i]['O'] != NULL) ? $row[$i]['O'] : '';
                $tempat_lahir           = (isset($row[$i]['P']) && $row[$i]['P'] != NULL) ? $row[$i]['P'] : '';
                $tgl_lahir              = (isset($row[$i]['Q']) && $row[$i]['Q'] != NULL) ? $row[$i]['Q'] : '';
                $alamat                 = (isset($row[$i]['R']) && $row[$i]['R'] != NULL) ? $row[$i]['R'] : '';
                $agama                  = (isset($row[$i]['S']) && $row[$i]['S'] != NULL) ? ucfirst(strtolower($row[$i]['S'])) : '';
                $telepon                = (isset($row[$i]['T']) && $row[$i]['T'] != NULL) ? $row[$i]['T'] : '';
                $email                  = (isset($row[$i]['U']) && $row[$i]['U'] != NULL) ? $row[$i]['U'] : '';
                $no_ktp                 = (isset($row[$i]['V']) && $row[$i]['V'] != NULL) ? $row[$i]['V'] : '';
                if($nik == "") {
                    // jika nik kosong lewat ke baris berikutnya
                    continue;
                }

                $id_karyawan = $this->id_company.preg_replace('/[^A-Za-z0-9\-]/', '', $nik);

                $id_jabatan    = $master_jabatan[$kode_jabatan];
                $id_cabang     = $master_cabang[$kode_cabang];
                $id_departemen = $master_departemen[$kode_departemen];
                $level         = $cek_level[$kode_jabatan];

                if ($status_karyawan == 'Kontrak' || $status_karyawan == 'kontrak' || $status_karyawan == 'KONTRAK') {
                    $status = '1';
                }else if($status_karyawan == 'Tetap' || $status_karyawan == 'tetap' || $status_karyawan == 'TETAP'){
                    $status = '2';
                }

                $tgl_lahir = date('Y-m-d', strtotime($tgl_lahir));
                $tgl_aktif_bekerja = date('Y-m-d', strtotime($tgl_aktif_bekerja));
                $tgl_berhenti_bekerja = date('Y-m-d', strtotime($tgl_berhenti_bekerja));

                //cek nik
                $c_nik = $cek_nik[$id_karyawan]; 

                //cek username
                $c_username = $cek_username[$username]; 
                
                if ($nik =="" || $nik == NULL || $c_nik !='') {
                    $flag = '2';
                }else if($nama_lengkap =="" || $nama_lengkap == NULL){
                    $flag = '2';
                }else if($kode_jabatan =="" || $kode_jabatan == NULL){
                    $flag = '2';
                }else if($kode_cabang =="" || $kode_cabang == NULL){
                    $flag = '2';
                }else if($kode_departemen =="" || $kode_departemen == NULL){
                   if(in_array($level,["5","4","6"])){ 
                        $flag = '1';
                    }else{
                        $flag = '2';
                    }
                }else if($username =="" || $username == NULL || $c_username !='') {
                    $flag = '2';
                }else if($status =="" || $status == NULL){
                    $flag = '2';
                }else if ($status == 1) {
                    if (($tgl_aktif_bekerja == "" || $tgl_aktif_bekerja == NULL || $tgl_aktif_bekerja == '1970-01-01') || ($tgl_berhenti_bekerja == "" || $tgl_berhenti_bekerja == NULL || $tgl_berhenti_bekerja == '1970-01-01')) {
                        $flag = '2';
                    }else{
                        $flag = '1';
                    }
                }else if ($status == 2) {
                    if($tgl_aktif_bekerja == "" || $tgl_aktif_bekerja == NULL || $tgl_aktif_bekerja == '1970-01-01'){
                        $flag = '2';
                    }else{
                        $flag = '1';
                    }
                }else if($password =="" || $password == NULL){
                    $flag = '2';
                }else{
                    $flag = '1';
                }


                $data = array(  'id_temp' => $id_temp,
                                'id_karyawan' => $id_karyawan,
                                'nik' => $nik,
                                'nama_lengkap' => $nama_lengkap,
                                'gelar_depan' => $gelar_depan,
                                'gelar_belakang' => $gelar_belakang,
                                'id_jabatan' => $id_jabatan,
                                'id_cabang' => $id_cabang,
                                'id_departemen' => $id_departemen,
                                'status' => $status,
                                'tgl_aktif_bekerja' => $tgl_aktif_bekerja,
                                'tgl_berhenti_bekerja' => $tgl_berhenti_bekerja,
                                'username' => $username,
                                'password' => sha1(sha1(md5($password))),
                                'jatah_cuti' => $jatah_cuti,
                                'jenis_kelamin' => $jenis_kelamin,
                                'tempat_lahir' => $tempat_lahir,
                                'tgl_lahir' => $tgl_lahir,
                                'alamat_domisili' => $alamat,
                                'telepon' => $telepon,
                                'email' => $email,
                                'no_ktp' => $no_ktp,
                                'agama' => $agama,
                                'lock_lokasi' => 1,
                                'flag' => $flag,
                                'user_input' => $this->id_karyawan,
                                'id_company' => $this->id_company);

                $data_insert[] = $data;

                $last_id = substr($id_temp,-5);
                $next_id = $last_id+1;
                $id_temp = substr($id_temp,0,-5).sprintf("%05d", $next_id);
            }

            // print_r($data_insert);
            // exit;

            $data_existing = $this->Karyawan_import_m->getDataExisting_tem();
            if ($data_existing > 0) {
                $this->db->delete('data_karyawan_temp', array('id_company' => $this->id_company));
            }

            $this->db->trans_start();

            $this->db->insert_batch('data_karyawan_temp', $data_insert);

            $this->db->trans_complete();

            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
                $message = ["message"=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Data gagal diimport</font>'];
                return __response_save(false,["message"=>$message]);
            }else{
                $this->db->trans_commit();
                $message = ["message"=>'<font color="#009900"><i class="fa fa-check-square">&nbsp;</i>Data berhasil diimport</font>'];
                return __response_save(true,["message"=>$message]);
            }
        }
    }

	public function publish_all(){
		$get_data_temp = $this->db->select('*')
								->from('data_karyawan_temp')
								->where('id_company',$this->id_company)
								->get()
								->result();
        $cek_level = $this->Karyawan_import_m->cek_level_list_data();

        $data_insert       = array();
        $data_insert_user  = array();
        $data_insert_kacab = array();
        $data_insert_kedep = array();
        $data              = array();
        $paket_payroll = $this->session->userdata('paket_payroll');
        // jika paket payroll aktif
        if($paket_payroll == '1') {
            $data_gapok      = [];
            $data_gapok_log  = [];
            $data_tunj_tetap = [];
            $data_pot_tetap  = [];
        }
        $id_user  = $this->fungsi->getNextId('users','id_user',$this->id_company,4);
        $id_kacab = $this->fungsi->getNextId('p_kacab','id',$this->id_company,3);
        $id_kedep = $this->fungsi->getNextId('p_kedep','id',$this->id_company,3);

		$jml_berahasil_simpan = 0;
		$jml_gagal_simpan = 0;

		foreach ($get_data_temp as $rows) {
			if($rows->flag == "1"){
				$data_existing = $this->Karyawan_import_m->getDataExisting($rows->id_karyawan);
				if($data_existing == 0){
					$jml_berahasil_simpan++;

                    $level = $cek_level[$rows->id_jabatan];

					$data = array('id_karyawan' => $rows->id_karyawan,
            				'nik' => $rows->nik,
							'nama_lengkap' => $rows->nama_lengkap,
							'gelar_depan' => $rows->gelar_depan,
							'gelar_belakang' => $rows->gelar_belakang,
							'id_jabatan' => $rows->id_jabatan,
							'id_cabang' => $rows->id_cabang,
							'id_departemen' => $rows->id_departemen,
							'status' => $rows->status,
							'tgl_aktif_bekerja' => $rows->tgl_aktif_bekerja,
							'tgl_berhenti_bekerja' => $rows->tgl_berhenti_bekerja,
							'jatah_cuti' => $rows->jatah_cuti,
							'jenis_kelamin' => $rows->jenis_kelamin,
							'tempat_lahir' => $rows->tempat_lahir,
							'tgl_lahir' => $rows->tgl_lahir,
							'alamat_domisili' => $rows->alamat_domisili,
							'telepon' => $rows->telepon,
							'email' => $rows->email,
							'no_ktp' => $rows->no_ktp,
							'agama' => $rows->agama,
							'lock_lokasi' => $rows->lock_lokasi,
							'id_company' => $this->id_company);

					$data_insert[] = $data;

					$data_user = array('id_user'	=>$id_user,
							'username'		=>$rows->username,
							'password'		=>$rows->password,
							'id_karyawan'	=>$rows->id_karyawan,
							'id_company'	=>$this->id_company);

                    if($level == 5){
                        $data_kacab = array("id"            => $id_kacab,
                                            "id_karyawan"   => $rows->id_karyawan,
                                            "id_cabang"     => $rows->id_cabang,
                                            "flag"          => "1",
                                            "id_company"    => $this->id_company);

                        $last_id_kacab       = substr($id_kacab,-4);
                        $next_id_kacab       = $last_id_kacab+1;
                        $id_kacab            = substr($id_kacab,0,-4).sprintf("%04d", $next_id_kacab);

                        $data_insert_kacab[] = $data_kacab;
                    }


                    if($level == 2){
                        $data_kedep = array("id"            => $id_kedep,
                                            "id_karyawan"   => $rows->id_karyawan,
                                            "id_cabang"     => $rows->id_cabang,
                                            "id_departemen" => $rows->id_departemen,
                                            "flag"          => "1",
                                            "id_company"    => $this->id_company);

                        $last_id_kedep       = substr($id_kedep,-4);
                        $next_id_kedep       = $last_id_kedep+1;
                        $id_kedep            = substr($id_kedep,0,-4).sprintf("%04d", $next_id_kedep);

                        $data_insert_kedep[] = $data_kedep;
                    }

                    if($paket_payroll == '1') {

                        $data_gapok[] = [
                            'nominal'     => 0,
                            'id_karyawan' => $rows->id_karyawan,
                            'id_company'  => $this->id_company,
                            'user_input'  => $this->nik.'-'.$this->nama_user
                        ];

                        $data_gapok_log[] = [
                            'id_company'   => $this->id_company,
                            'id_karyawan'  => $rows->id_karyawan,
                            'action'	   => 'tambah',
                            'nominal_lama' => '0',
                            'nominal_baru' => '0',
                            'user_input'   => $this->nik.'-'.$this->nama_user
                        ];

                        $tunj_tetap_kosong = $this->Karyawan_import_m->insert_tunj_tetap_kosong($rows->id_karyawan, $data_tunj_tetap);
                        $data_tunj_tetap   = $tunj_tetap_kosong['data'];
                        
                        $pot_tetap_kosong = $this->Karyawan_import_m->insert_pot_tetap_kosong($rows->id_karyawan, $data_pot_tetap);
                        $data_pot_tetap   = $pot_tetap_kosong['data'];
                    }

					$last_id = substr($id_user,-4);
					$next_id = $last_id+1;
					$id_user = substr($id_user,0,-4).sprintf("%04d", $next_id);

					$data_insert_user[] = $data_user;
				}else{
					$jml_gagal_simpan++;
				}
			}else{
				$jml_gagal_simpan++;
			}

		}

		$this->db->trans_start();

	 	$cek_limit =  $this->_cekLimitJumlahKaryawan();
	        if($cek_limit !== true){
	            return $cek_limit;
	        }

		# MEMINDAHKAN DATA DARI TEMP KE DATA KARYAWAN
		if(count($data_insert) > 0){
			$this->db->insert_batch('data_karyawan', $data_insert);
		}

		if(count($data_insert_user) > 0){
			$this->db->insert_batch('users', $data_insert_user);
		}

        # INSERT KEPALA CABANG
        if(count($data_insert_kacab) > 0){
            $this->db->insert_batch('p_kacab', $data_insert_kacab);
        }

        # INSERT KEPALA DEPARTEMEN
        if(count($data_insert_kedep) > 0){
            $this->db->insert_batch('p_kedep', $data_insert_kedep);
        }

        if($paket_payroll == '1') {
            if(count($data_gapok) > 0) {
                $this->db->insert_batch('payroll_gapok_m', $data_gapok);
            }

            if(count($data_gapok_log) > 0) {
                $this->db->insert_batch('payroll_gapok_log', $data_gapok_log);
            }

            if(count($data_tunj_tetap) > 0) {
                $this->db->insert_batch('payroll_tunj_tetap_m', $data_tunj_tetap);
            }

            if(count($data_pot_tetap) > 0) {
                $this->db->insert_batch('payroll_pot_tetap_m', $data_pot_tetap);
            }
        }

		# DELETE DATA TEMP YANG SUDAH DI PINDAH
		$this->db->where("flag","1");
		$this->db->where("id_company",$this->id_company);
		$this->db->delete("data_karyawan_temp");

		$this->db->trans_complete();

		if($this->db->trans_status() === FALSE) {
			$this->db->trans_rollback();
			$message = ["message"=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Data gagal disimpan</font>'];
			return __response_save(false,$message);
		}else{
			$this->db->trans_commit();
			$message = ["message"=>'<font color="#ffffff"><i class="fa fa-check-square">&nbsp;</i>'.$jml_berahasil_simpan.' Data berhasil disimpan dan '.$jml_gagal_simpan.' Data gagal disimpan</font>'];
			return __response_save(true,$message);
		}

    }

	public function delete_all_temp(){
		$this->db->where("id_company",$this->id_company);
		$this->db->where("user_input",$this->id_karyawan);
		$delete = $this->db->delete("data_karyawan_temp");
		return __response_delete($delete);
	}

	public function delete(){
		$id = $this->input->post("id_temp");
		$this->db->where('MD5(id_temp)',$id);
		$this->db->where('id_company',$this->id_company);
        $delete =$this->db->delete('data_karyawan_temp');
        return  __response_delete($delete);
	}

	public function form_edit($id=null){
		$data['judul'] = 'Ubah Karyawan Import';
		$data['aktif'] = 'karyawan';
		$data['data'] = $this->Karyawan_import_m->getDataById($id);
		$data['ref'] = $id;
        $data['menu'] = $this->load->view('main_menu', $data, true);
		$data['content'] = $this->load->view('karyawan/import/form', $data, true);
		$this->load->view('main_template', $data, false);
	}

	public function save(){
		$id_company = $this->id_company;
		$id_temp = $this->input->post('id_temp');
		$no_induk_karyawan = $this->input->post('no_induk_karyawan');
		$id_karyawan = $this->id_company.preg_replace('/[^A-Za-z0-9\-]/', '', $no_induk_karyawan);
		$level_user = $this->input->post('level_user');
		// $password_baru = $this->input->post('password_baru');

		// if($password_baru != "") {
		// 	$encrypt_password = sha1(sha1(md5($password_baru)));
		// }
		
		$data_pribadi = array( 'id_karyawan' 		=>$id_karyawan,
							'nik'					=>$no_induk_karyawan,
							'nama_lengkap'			=>$this->input->post('nama_lengkap'),
							'gelar_depan'			=>$this->input->post('gelar_depan'),
							'gelar_belakang'		=>$this->input->post('gelar_belakang'),
							'jenis_kelamin'			=>$this->input->post('jenis_kelamin'),
							'agama'					=>$this->input->post('agama'),
							'tempat_lahir'			=>$this->input->post('tempat_lahir'),
							'tgl_lahir'				=>date('Y-m-d', strtotime($this->input->post('tgl_lahir'))),
							'alamat_domisili'		=>$this->input->post('alamat_domisili'),
							'telepon'				=>$this->input->post('telepon'),
							'email'					=>$this->input->post('email'),
							'no_ktp'				=>$this->input->post('no_ktp'),
							'tgl_aktif_bekerja'		=>date('Y-m-d', strtotime($this->input->post('tgl_aktif_bekerja'))),
							'tgl_berhenti_bekerja'	=>date('Y-m-d', strtotime($this->input->post('tgl_berhenti_bekerja'))),
							'id_departemen'			=>(($this->input->post('departemen') == "null")?"":$this->input->post('departemen')),
							'id_cabang'				=>$this->input->post('cabang'),
							'id_jabatan'			=>$this->input->post('jabatan'),
							'jatah_cuti'			=>$this->input->post('jatah_cuti'),
							'status'				=>$this->input->post('status'),
							'username' 				=>$this->input->post('username'),
							// 'password' 				=>$encrypt_password,
							'flag' 					=>'1',
							'id_company' 			=>$this->id_company);
	
		$this->Karyawan_import_m->save($data_pribadi, $id_temp, $level_user); 
	}

	private function _cekLimitJumlahKaryawan(){
        $max_karyawan = $this->db->select("SUM(master_company.custom_jumlah_karyawan + tb_paket.max_karyawan) AS max_jml_karyawan")
                                    ->from("master_company")
                                    ->join("tb_paket","tb_paket.id_tb_paket = master_company.id_tb_paket")
                                    ->where("master_company.id_company",$this->id_company)
                                    ->get()
                                    ->row("max_jml_karyawan");

        $jumlah_karyawan_aktif = $this->db->select("data_karyawan.id_karyawan")
                                    ->from("data_karyawan")
                                    ->join("master_jabatan","master_jabatan.id_jabatan = data_karyawan.id_jabatan")
                                    ->where_in("data_karyawan.status",["1","2","3","4"])
                                    ->where_not_in("master_jabatan.level_user",["1","6"])
                                    ->where("data_karyawan.id_company",$this->id_company)
                                    ->get()
                                    ->num_rows();

        $jml_row = $this->db->where('id_company', $this->id_company)
                ->where('flag', 1)
                ->get('data_karyawan_temp')->num_rows();

        $total = $jumlah_karyawan_aktif + $jml_row;

        if($total > $max_karyawan){
            $message = ['message'=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>GAGAL, data karyawan sudah mencapai batas maksimal</font>'];
            return __response_save(false,$message);
        }else{
            return true;
        }
    }
}
