<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Jenis_plafon extends MY_Controller {

	public function __construct(){
        parent::__construct();
        $this->load->model('Jenis_plafon_m');
    }

	public function index(){
		$data['judul'] = 'Jenis Reimbursement';
		$data['aktif'] = 'jenis_plafon';
		$id_company = $this->session->userdata('id_company');
        $data['menu'] = $this->load->view('main_menu', $data, true);
		$data['content'] = $this->load->view('jenis_plafon/home', $data, true);
		$this->load->view('main_template', $data, false);
	}

	public function list_data(){
		$id_cabang = $this->input->get('id_cabang');
		$list = $this->Jenis_plafon_m->get_datatables($id_cabang);
		$data = array();
		$no = $_GET['start'];
		foreach ($list as $field) {
			$no++;
			$row = array();
			$row[] = $no;
            $row[] = $field->kode_cabang." - ".$field->nama_cabang;
            $row[] = $field->kode_plafon;
            $row[] = $field->jenis_plafon;
            $row[] = number_format($field->max_nominal_plafon,0,",",".");

            if(in_array($this->level_user, array("1"))) {

				$row[] = '<a href="#" style="color:#f0ad4e" data-target="tooltip" title="Ubah">
								<i id="'.md5($field->id_jenis_reimbursement).'" class="btn_edit fa fa-edit (alias) "> </i>
						</a>&nbsp;
						<a href="#" style="color:#d9534f" data-target="tooltip" title="Hapus">
							<i id="'.md5($field->id_jenis_reimbursement).'" class="btn_delete fa fa-trash"></i>
						</a>';
            }

			$data[] = $row;
		}

			$output = array("draw"            => $_GET['draw'],
							"recordsTotal"    => $this->Jenis_plafon_m->count_all($id_cabang),
							"recordsFiltered" => $this->Jenis_plafon_m->count_filtered($cabid_cabangang),
							"data"            => $data);

			$output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

	public function form($id=null){
		if($id == null){
			$this->load->view('jenis_plafon/form');
		}else{
			$data['data'] = $this->Jenis_plafon_m->getDataById($id);
			$this->load->view('jenis_plafon/form',$data);
		}

	}

	public function save(){
		$id_company = $this->session->userdata('id_company');
		$id = $this->input->post('id_jenis_plafon');

		$data = array('jenis_plafon'		=>$this->input->post('jenis_plafon'),
					'kode_plafon'			=>$this->input->post('kd_plafon'),
					'max_nominal_plafon'	=>str_replace(".","",$this->input->post('max_nominal_plafon')),
					'id_cabang'				=>$this->input->post('cabang'),
					'id_company' 			=>$id_company);

		$this->Jenis_plafon_m->save($data,$id);
	}

	public function delete(){
		$id = $this->input->post("id_jenis_plafon");
		$this->Jenis_plafon_m->delete($id);
	}
}
