<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Berita extends MY_Controller {

    public function __construct(){
        parent::__construct();
        $this->load->model('Berita_m');
        $this->load->library('Uploadfile');
    }

    public function index(){
        $data['judul'] = 'Berita';
        $data['aktif'] = 'berita';
        $data['menu'] = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('berita/home', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function list_data(){
        $list = $this->Berita_m->get_datatables();
        $data = array();
        $no = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();
            $row[] = $no;

            $foto = $this->config->item('base_image').'imagebiodata?_t=file&_d='.$field->gambar;
            $row[] = '<img class="img-thumbnail" src="'.$foto.'" alt="Gambar Berita" style="border-radius: 0;">';

            $tgl_berita = date_format(date_create($field->date_created),"Y-m-d");
            $jam_berita = date_format(date_create($field->date_created),"H:i:s");

            $isi_berita = "<b class='font-size-large'>".$field->judul."</b><br>";
            $isi_berita .= $this->fungsi->tgl_indo($tgl_berita)." ".$jam_berita."<br><br>";
            if (strlen($field->content) >= 1000) {
                $isi_berita .= substr($field->content,0,1000)."...... <br>";
                $isi_berita .= "<a href='".route('informasi.berita.detail')."/".md5($field->id_berita)."'>Lihat Detail</a>";
            }else{
                $isi_berita .= $field->content;
            }
            $row[] = $isi_berita;

            if ($this->level_user == '1') {
                $row[] = '<a href="'.route('informasi.berita.detail')."/".md5($field->id_berita).'" class="text-primary" title="DETAIL">
                            <i class="btn_detail fa fa-info-circle (alias) "> </i></a>&nbsp;
                        <a href="'.route('informasi.berita.form.edit')."/".md5($field->id_berita).'" class="text-warning" title="EDIT">
                            <i class="btn_edit fa fa-edit (alias) "> </i></a>&nbsp;
                        <a href="#" class="text-danger" title="HAPUS">
                            <i id="'.md5($field->id_berita).'" class="btn_delete fa fa-trash"></i>
                        </a>';
            }else{
                $row[] = '<a href="'.route('informasi.berita.detail')."/".md5($field->id_berita).'" class="text-primary" title="DETAIL">
                            <i class="btn_detail fa fa-info-circle (alias) "> </i></a>&nbsp;';
            }
    
            $data[] = $row;
        }
    
            $output = array("draw"            => $_GET['draw'],
                            "recordsTotal"    => $this->Berita_m->count_all(),
                            "recordsFiltered" => $this->Berita_m->count_filtered(),
                            "data"            => $data);

        $output = __response($this->MY_response, $output);
    
        echo json_encode($output);
    }

    public function form($id=null){
        $data['judul'] = 'Form Berita';
        $data['aktif'] = 'berita';
        if ($id != null) {
            $data['form'] = "edit";
            $data['data'] = $this->Berita_m->getDataById($id);
        }else{
            $data['form'] = "tambah";
        }

        $data['menu'] = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('berita/form', $data, true);
        $this->load->view('main_template', $data, false);       
    }

    public function detail($id=null){
        $data['judul'] = 'Detail Berita';
        $data['aktif'] = 'berita';
        $data['data'] = $this->Berita_m->getDataById($id);      
        $data['menu'] = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('berita/detail', $data, true);
        $this->load->view('main_template', $data, false);       
    }

    public function save(){
        $id          = $this->input->post('id_berita');
        $judul       = $this->input->post('judul');
        $content     = urldecode($this->input->post('content'));
        $gambar_lama = $this->input->post('gambar_lama');
        $tahunbulan  = date('Ym');
        $id_company  = $this->id_company;
        $id_karyawan = $this->id_karyawan;

        $file1 = $_FILES['gambar'];
        if($file1['name'] == ""){
            $gambar = $gambar_lama;
        }else{

            $fileUpload['fname']    = 'gambar';
            $fileUpload['location'] = 'berita/'.$tahunbulan;
            $fileUpload['allowed']  = 'jpg|png|jpeg';
            $fileUpload['compress_image']  = true;

            $upload = $this->uploadfile->doUpload($fileUpload);
            if($upload["success"] == true){
				$gambar = $upload['url'];
                if(!empty($gambar_lama)){
					if($gambar != $gambar_lama){
						$this->fungsi->delete_fileupload($gambar_lama);
					}
				}
			}else{
				$message = ["message"=>$upload["message"]];
				return __response_save(false,["params"=>$message]);
			}
        }

        $data = array('judul'       =>$judul,
                    'content'       =>$content,
                    'gambar'        =>$gambar,
                    'posting'       =>'1',
                    'creator'       =>$id_karyawan,
                    'id_company'    =>$id_company);
    
        $this->Berita_m->save($data,$id);
    }

    public function delete(){
        $id = $this->input->post("id_berita");
        $this->Berita_m->delete($id);
    }

}