<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Quick_setup_staff_m extends CI_Model{
  var $table = 'data_karyawan';
  public function __construct(){
  parent::__construct();
}

  function get_datatables(){
      $this->_get_datatables_query();
      if($_POST['length'] != -1){
          $this->db->limit($_POST['length'], $_POST['start']);
      }
      $query = $this->db->get();
      return $query->result();
  }

  function count_filtered(){
      $this->_get_datatables_query();
      $query = $this->db->get();
      return $query->num_rows();
  }

  public function count_all(){
      $this->db->select("nik")->from($this->table);
      $this->db->join("master_cabang", "data_karyawan.id_cabang = master_cabang.id_cabang");
      $this->db->join("master_jabatan", "master_jabatan.id_jabatan = data_karyawan.id_jabatan");
      $this->db->where("data_karyawan.status", "2");
      $this->db->where("master_jabatan.level_user", 3);
      $this->db->where("master_cabang.id_company",$this->id_company);
      return $this->db->count_all_results();
  }
  private function _get_datatables_query(){
      $this->db->select("nik, id_karyawan, nama_lengkap, master_cabang.nama as cabang, master_cabang.kode as kode_cabang,
        master_departemen.nama as departemen, master_departemen.kode as kode_departemen")->from($this->table);
      $this->db->join("master_departemen", "master_departemen.id_departemen = data_karyawan.id_departemen");
      $this->db->join("master_cabang", "data_karyawan.id_cabang = master_cabang.id_cabang");
      $this->db->join("master_jabatan", "master_jabatan.id_jabatan = data_karyawan.id_jabatan");
      $this->db->where("data_karyawan.status", "2");
      $this->db->where("master_jabatan.level_user", 3);
      $this->db->where("master_cabang.id_company",$this->id_company);

      $column_search = array('nik','nama_lengkap','master_cabang.nama','master_departemen.nama');
      $i = 0;

      foreach ($column_search as $item){  // looping awal
          if($_POST['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST

              if($i===0){ // looping awal
                  $this->db->group_start();
                  $this->db->like($item, $_POST['search']['value']);
              }else{
                  $this->db->or_like($item, $_POST['search']['value']);
              }

              if(count($column_search) - 1 == $i){
                  $this->db->group_end();
              }
          }
          $i++;
      }

      $column_order = array('nik','nama_lengkap','master_cabang.nama','master_departemen.nama');

      if(isset($_POST['order'])){
          $this->db->order_by($column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
      }
      else{
          $order_by = array("data_karyawan.tgl_input"=>"DESC");
          $this->db->order_by(key($order_by), $order_by[key($order_by)]);
      }
  }

  function cek_jabatan_staff() {
    $this->db->order_by('id_jabatan', 'asc');
    return $this->db->get_where('master_jabatan', array('level_user' => 3, 'id_company' => $this->id_company));
  }

  function create_jabatan_staff() {
    $id_jabatan = $this->fungsi->getNextId('master_jabatan','id_jabatan',$this->id_company,3);
    $data = array(
      'id_jabatan'    => $id_jabatan,
      'kode_jabatan'  => 'STAFF',
      'nama'          => 'Staff',
      'level_user'    => 3,
      'id_company'    => $this->id_company
    );
    $this->db->insert('master_jabatan', $data);
    return $id_jabatan;
  }
}
